/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.project.handlers.SettingHandler;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.windows.action.WindowsAction;
import com.kms.katalon.composer.windows.action.WindowsActionMapping;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.spy.WindowsInspectorController;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WindowsAppComposite {
    private static final String PREF_LAST_STARTED_APP = "lastStartedApp";
    private static final String PREF_LAST_STARTED_WINDOW_TITLE = "lastStartedWindowTitle";
    private static final String[] FILTER_FILE_NAMES = new String[]{"Windows Executable Files (*.exe)", "All Files (*.*)"};
    private static final String[] FILTER_EXTENSIONS = new String[]{"*.exe", "*.*"};
    private Text txtAppFile;
    private WindowsObjectDialog parentDialog;
    private Button btnBrowse;
    private Label lblDriverConnector;
    private ScopedPreferenceStore store;
    private Text txtApplicationTitle;
    private boolean showConfiguration = true;
    private boolean showApplicationFile = true;
    private boolean showApplicationTitle = true;
    private boolean showRemoteUrl = true;

    public Composite createComposite(Composite parent, int type, final WindowsObjectDialog parentDialog) {
        this.parentDialog = parentDialog;
        Composite composite = new Composite(parent, 0);
        GridLayout glComposite = new GridLayout(2, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        glComposite.horizontalSpacing = 10;
        composite.setLayout((Layout)glComposite);
        Label lblConfiguration = new Label(composite, 0);
        GridData gdLabelConfiguration = new GridData(16384, 0x1000000, false, false);
        gdLabelConfiguration.exclude = !this.showConfiguration;
        lblConfiguration.setLayoutData((Object)gdLabelConfiguration);
        lblConfiguration.setText("Configuration");
        lblConfiguration.setVisible(this.showConfiguration);
        Composite configurationComposite = new Composite(composite, 0);
        GridData gdConfiguration = new GridData(4, 0x1000000, true, false);
        gdConfiguration.exclude = !this.showConfiguration;
        configurationComposite.setLayoutData((Object)gdConfiguration);
        GridLayout glConfigurationComposite = new GridLayout(2, false);
        glConfigurationComposite.marginWidth = 0;
        glConfigurationComposite.marginHeight = 0;
        configurationComposite.setLayout((Layout)glConfigurationComposite);
        configurationComposite.setVisible(this.showConfiguration);
        this.lblDriverConnector = new Label(configurationComposite, 0);
        this.lblDriverConnector.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button btnEditConfiguration = new Button(configurationComposite, 8);
        btnEditConfiguration.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        btnEditConfiguration.setText(GlobalStringConstants.EDIT);
        btnEditConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingHandler settingHander = SettingHandler.getInstance();
                settingHander.openSettingsPage((Object)"com.kms.katalon.composer.execution.settings.default.5");
                try {
                    WindowsAppComposite.this.updateRunConfigurationDetails();
                    parentDialog.refreshButtonsState();
                }
                catch (IOException ex) {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)GlobalStringConstants.ERROR, (String)"Unable to reload Windows desired capabilities");
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
        Label lblAppFile = new Label(composite, 0);
        GridData gdAppFile = new GridData(16384, 128, false, false);
        gdAppFile.exclude = !this.showApplicationFile;
        lblAppFile.setLayoutData((Object)gdAppFile);
        lblAppFile.setText("Application File");
        lblAppFile.setVisible(this.showApplicationFile);
        Composite appFileChooserComposite = new Composite(composite, 0);
        GridData gdFileChooser = new GridData(4, 0x1000000, true, false);
        gdFileChooser.exclude = !this.showApplicationFile;
        appFileChooserComposite.setLayoutData((Object)gdFileChooser);
        GridLayout glFileChooser = new GridLayout(2, false);
        glFileChooser.marginWidth = 0;
        glFileChooser.marginHeight = 0;
        appFileChooserComposite.setLayout((Layout)glFileChooser);
        appFileChooserComposite.setVisible(this.showApplicationFile);
        this.txtAppFile = new Text(appFileChooserComposite, 2048);
        this.txtAppFile.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtAppFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WindowsAppComposite.this.txtAppFile.setToolTipText(WindowsAppComposite.this.txtAppFile.getText());
                parentDialog.refreshButtonsState();
            }
        });
        this.btnBrowse = new Button(appFileChooserComposite, 8);
        GridData btnBrowserGridData = new GridData(131072, 0x1000000, false, false);
        this.btnBrowse.setLayoutData((Object)btnBrowserGridData);
        this.btnBrowse.setText(GlobalStringConstants.BROWSE);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WindowsAppComposite.this.btnBrowse.getShell());
                dialog.setFilterNames(FILTER_FILE_NAMES);
                dialog.setFilterExtensions(FILTER_EXTENSIONS);
                String absolutePath = dialog.open();
                if (StringUtils.isEmpty((CharSequence)absolutePath)) {
                    return;
                }
                WindowsAppComposite.this.txtAppFile.setText(absolutePath);
            }
        });
        this.txtAppFile.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    WindowsAppComposite.this.store.save();
                }
                catch (IOException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
        Label lblWindowTitle = new Label(composite, 0);
        GridData gdWindowTitle = new GridData(16384, 128, false, false);
        gdWindowTitle.exclude = !this.showApplicationTitle;
        lblWindowTitle.setLayoutData((Object)gdWindowTitle);
        lblWindowTitle.setText("Application Title");
        lblWindowTitle.setToolTipText("Title of the main application main window");
        lblWindowTitle.setVisible(this.showApplicationTitle);
        this.txtApplicationTitle = new Text(composite, 2048);
        GridData ApplicationTitle = new GridData(4, 128, true, false);
        ApplicationTitle.exclude = !this.showApplicationTitle;
        this.txtApplicationTitle.setLayoutData((Object)ApplicationTitle);
        this.txtApplicationTitle.setVisible(this.showApplicationTitle);
        return composite;
    }

    private void updateRunConfigurationDetails() throws IOException {
        WindowsDriverConnector driverConnector = WindowsDriverConnector.getInstance((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        String url = driverConnector.getWinAppDriverUrl();
        String desiredCapabilities = JsonUtil.toJson((Object)driverConnector.getDesiredCapabilities(), (boolean)false);
        String text = this.showRemoteUrl ? String.format("%s, %s", url, desiredCapabilities) : desiredCapabilities;
        this.lblDriverConnector.setText(text);
        String toolTipText = String.format("WinAppDriver URL: %s, Capabilities: %s", url, desiredCapabilities);
        this.lblDriverConnector.setToolTipText(toolTipText);
    }

    public boolean validateSetting() {
        return true;
    }

    public void saveSettings() throws IOException {
        StringBuilder appFile = new StringBuilder();
        StringBuilder appTitle = new StringBuilder();
        UISynchronizeService.syncExec(() -> {
            appFile.append(this.txtAppFile.getText());
            appTitle.append(this.txtApplicationTitle.getText());
        });
        this.store.setValue(PREF_LAST_STARTED_APP, appFile.toString());
        this.store.setValue(PREF_LAST_STARTED_WINDOW_TITLE, appTitle.toString());
        this.store.save();
    }

    public WindowsActionMapping startApp(final WindowsInspectorController controller, final AppiumMonitorDialog progressDlg) throws InvocationTargetException, InterruptedException {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        final WindowsDriverConnector driverConnector = this.getDriverConnector(projectDir);
        final String appFile = this.txtAppFile.getText();
        final String appTitle = this.txtApplicationTitle.getText();
        IRunnableWithProgress processToRun = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_LBL_STATUS_APP_STARTING, -1);
                progressDlg.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        controller.startApplication(driverConnector, appFile, appTitle);
                        WindowsAppComposite.this.saveSettings();
                        return null;
                    }
                });
                monitor.done();
            }
        };
        progressDlg.run(true, true, processToRun);
        WindowsActionMapping actionMapping = new WindowsActionMapping(WindowsAction.StartApplicationWithTitle, null);
        actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)appFile));
        actionMapping.getData()[1].setValue(new ConstantExpressionWrapper((Object)appTitle));
        return actionMapping;
    }

    private WindowsDriverConnector getDriverConnector(String projectDir) throws InvocationTargetException {
        try {
            return WindowsDriverConnector.getInstance((String)projectDir);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void setInput() throws InvocationTargetException, InterruptedException {
        try {
            this.store = PreferenceStoreManager.getPreferenceStore(WindowsAppComposite.class);
            String appPath = this.store.getString(PREF_LAST_STARTED_APP);
            this.txtAppFile.setText(StringUtils.defaultString((String)appPath));
            String windowTitle = this.store.getString(PREF_LAST_STARTED_WINDOW_TITLE);
            this.txtApplicationTitle.setText(StringUtils.defaultString((String)windowTitle));
            this.updateRunConfigurationDetails();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public String getAppFile() {
        return this.txtAppFile.getText();
    }

    public String getAppName() {
        return FilenameUtils.getBaseName((String)this.txtAppFile.getText());
    }

    public boolean isAbleToStart() {
        return StringUtils.isNotEmpty((CharSequence)this.txtAppFile.getText());
    }

    public WindowsObjectDialog getParentDialog() {
        return this.parentDialog;
    }

    public boolean isShowConfiguration() {
        return this.showConfiguration;
    }

    public void setShowConfiguration(boolean showConfiguration) {
        this.showConfiguration = showConfiguration;
    }

    public boolean isShowApplicationFile() {
        return this.showApplicationFile;
    }

    public void setShowApplicationFile(boolean showApplicationFile) {
        this.showApplicationFile = showApplicationFile;
    }

    public boolean isShowApplicationTitle() {
        return this.showApplicationTitle;
    }

    public void setShowApplicationTitle(boolean showApplicationTitle) {
        this.showApplicationTitle = showApplicationTitle;
    }

    public boolean isShowRemoteUrl() {
        return this.showRemoteUrl;
    }

    public void setShowRemoteUrl(boolean showRemoteUrl) {
        this.showRemoteUrl = showRemoteUrl;
    }
}

