/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.dialog;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumStreamHandler;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileDeviceDialog;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.windows.action.WindowsAction;
import com.kms.katalon.composer.windows.action.WindowsActionButtonWrapper;
import com.kms.katalon.composer.windows.action.WindowsActionHandler;
import com.kms.katalon.composer.windows.action.WindowsActionMapping;
import com.kms.katalon.composer.windows.dialog.WindowsAppComposite;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.dialog.WindowsScreenView;
import com.kms.katalon.composer.windows.element.BasicWindowsElement;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.element.SnapshotWindowsElement;
import com.kms.katalon.composer.windows.element.TreeWindowsElement;
import com.kms.katalon.composer.windows.exception.WindowsComposerException;
import com.kms.katalon.composer.windows.record.RecordedWindowsElementLabelProvider;
import com.kms.katalon.composer.windows.record.RecordedWindowsElementTableViewer;
import com.kms.katalon.composer.windows.spy.HighlightElementComposite;
import com.kms.katalon.composer.windows.spy.WindowsElementLabelProvider;
import com.kms.katalon.composer.windows.spy.WindowsElementPropertiesComposite;
import com.kms.katalon.composer.windows.spy.WindowsElementTreeContentProvider;
import com.kms.katalon.composer.windows.spy.WindowsInspectorController;
import com.kms.katalon.composer.windows.spy.WindowsRecordedStepsView;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.windows.driver.WindowsSession;
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriverException;

public class WindowsRecorderDialog
extends AbstractDialog
implements WindowsObjectDialog {
    private FolderTreeEntity targetFolderEntity;
    private List<WindowsActionButtonWrapper> actionButtons = new ArrayList<WindowsActionButtonWrapper>();
    private ToolItem btnStart;
    private ToolItem btnCapture;
    private ToolItem btnStop;
    private TreeViewer allElementTreeViewer;
    private WindowsScreenView screenComposite;
    private TreeWindowsElement appRootElement;
    private WindowsInspectorController inspectorController = new WindowsInspectorController();
    private Composite container;
    private WindowsElementPropertiesComposite propertiesComposite;
    private HighlightElementComposite highlightElementComposite;
    private Composite appsComposite;
    private WindowsAppComposite mobileComposite;
    private RecordedWindowsElementTableViewer capturedObjectsTableViewer;
    private WindowsRecordedStepsView stepView;
    private RecordActionResult recordActionResult;
    private boolean okPressed = false;

    @Override
    public WindowsInspectorController getInspectorController() {
        return this.inspectorController;
    }

    public WindowsRecorderDialog(Shell parentShell, WindowsAppComposite appComposite) {
        super(parentShell);
        this.mobileComposite = appComposite;
    }

    public boolean close() {
        this.stopObjectInspectorAction();
        if (this.okPressed) {
            int recordedActionCount = this.stepView.getNodes().size();
            Trackings.trackCloseWindowsRecordByOk((int)recordedActionCount);
        } else {
            Trackings.trackCloseWindowsRecordByCancel();
        }
        boolean result = super.close();
        return result;
    }

    public void create() {
        super.create();
        this.initializeData();
        this.validateToEnableStartButton();
        this.targetElementChanged(null);
        this.updateActionButtonsVisibility(null);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(1200, 800);
    }

    protected int getShellStyle() {
        return 3312;
    }

    public int open() {
        Trackings.trackOpenWindowsRecord();
        return super.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Windows Action Recorder");
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)this.createNoMarginGridLayout());
        this.container.setBackground(ColorUtil.getCompositeBackgroundColorForDialog());
        SashForm sashForm = this.createMainSashForm(this.container);
        sashForm.setBackground(ColorUtil.getCompositeBackgroundColorForSashform());
        this.populateSashForm(sashForm);
        sashForm.setWeights(this.getSashFormChildsWeights());
        return this.container;
    }

    protected Control createButtonBar(Composite parent) {
        Control[] children;
        Control buttonBar = super.createButtonBar(parent);
        Control[] controlArray = children = ((Composite)buttonBar).getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof HelpCompositeForDialog) {
                Composite helpComposite = (Composite)child;
                helpComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
                GridLayout layout = (GridLayout)helpComposite.getLayout();
                layout.marginBottom = 0;
                layout.marginRight = 0;
                helpComposite.getParent().layout(true, true);
                break;
            }
            ++n2;
        }
        return buttonBar;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
        this.stepView.setCapturedElementsTableViewer(this.capturedObjectsTableViewer);
    }

    protected boolean hasDocumentation() {
        return true;
    }

    protected String getDocumentationUrl() {
        return DocumentationMessageConstants.DIALOG_WINDOWS_RECORDER;
    }

    protected void okPressed() {
        this.recordActionResult = new RecordActionResult(this.stepView.getWrapper(), this.capturedObjectsTableViewer.getCapturedElements());
        this.okPressed = true;
        super.okPressed();
    }

    public FolderTreeEntity getTargetFolderEntity() {
        return this.targetFolderEntity;
    }

    protected GridLayout createNoMarginGridLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected int[] getSashFormChildsWeights() {
        return new int[]{5, 4, 6};
    }

    protected SashForm createMainSashForm(Composite container) {
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setSashWidth(3);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        return sashForm;
    }

    protected void populateSashForm(SashForm sashForm) {
        this.createContentComposite(sashForm);
        this.createMiddlePaneComposite(sashForm);
        this.screenComposite = new WindowsScreenView(this);
        this.screenComposite.createControls((Composite)sashForm);
    }

    private void createMiddlePaneComposite(SashForm sashForm) {
        Composite middlePane = new Composite((Composite)sashForm, 0);
        middlePane.setLayout((Layout)this.createNoMarginGridLayout());
        SashForm hSashForm = new SashForm(middlePane, 512);
        hSashForm.setSashWidth(3);
        hSashForm.setBackground(ColorUtil.getCompositeBackgroundColorForSashform());
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createActionListComposite(hSashForm);
        this.createMiddleBottomComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{3, 7});
    }

    private void createMiddleBottomComposite(Composite parent) {
        this.createAllObjectsComposite(parent);
    }

    private Control createPropertiesComposite(Composite parent) {
        this.propertiesComposite = new WindowsElementPropertiesComposite(this);
        Composite control = this.propertiesComposite.createObjectPropertiesComposite(parent);
        return control;
    }

    private Control createHighlightElementComposite(Composite parent) {
        this.highlightElementComposite = new HighlightElementComposite(this);
        Composite control = this.highlightElementComposite.createComposite(parent);
        return control;
    }

    private Composite createCapturedObjectsComposite(Composite parent) {
        Composite capturedObjectsComposite = new Composite(parent, 0);
        capturedObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblRecordedActions = new Label(capturedObjectsComposite, 0);
        lblRecordedActions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblRecordedActions.setFont(this.getFontBold(lblRecordedActions));
        lblRecordedActions.setText("CAPTURED OBJECTS");
        Composite capturedObjectTableComposite = new Composite(capturedObjectsComposite, 0);
        capturedObjectTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tbclCapturedObjects = new TableColumnLayout();
        capturedObjectTableComposite.setLayout((Layout)tbclCapturedObjects);
        this.capturedObjectsTableViewer = new RecordedWindowsElementTableViewer(capturedObjectTableComposite, 68354);
        Table capturedObjectsTable = this.capturedObjectsTableViewer.getTable();
        capturedObjectsTable.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        capturedObjectsTable.setHeaderVisible(true);
        capturedObjectsTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)capturedObjectsTable.getDisplay()));
        TableViewerColumn tableViewerColumnCapturedObjects = new TableViewerColumn((TableViewer)this.capturedObjectsTableViewer, 0);
        TableColumn tblclmnCapturedObjects = tableViewerColumnCapturedObjects.getColumn();
        tblclmnCapturedObjects.setText(GlobalStringConstants.NAME);
        tableViewerColumnCapturedObjects.setLabelProvider((CellLabelProvider)new RecordedWindowsElementLabelProvider());
        tbclCapturedObjects.setColumnData((Widget)tblclmnCapturedObjects, (ColumnLayoutData)new ColumnWeightData(98, 100));
        this.capturedObjectsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.capturedObjectsTableViewer.setCaptureElements(new ArrayList<CapturedWindowsElement>());
        capturedObjectsTable.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.capturedObjectsTableViewer);
        this.capturedObjectsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CapturedWindowsElement firstElement = (CapturedWindowsElement)selection.getFirstElement();
                WindowsRecorderDialog.this.propertiesComposite.setEditingElement(firstElement);
                WindowsRecorderDialog.this.highlightElementComposite.setEditingElement(firstElement);
            }
        });
        return capturedObjectsComposite;
    }

    private Composite createRecordedActionComposite(Composite parent) {
        this.stepView = new WindowsRecordedStepsView();
        Composite compositeStepView = this.stepView.createContent(parent);
        return compositeStepView;
    }

    private void createActionListComposite(SashForm sashForm) {
        Composite actionListComposite = new Composite((Composite)sashForm, 0);
        actionListComposite.setLayout((Layout)new GridLayout());
        Label lblRecordedActions = new Label(actionListComposite, 0);
        lblRecordedActions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        lblRecordedActions.setFont(this.getFontBold(lblRecordedActions));
        lblRecordedActions.setText("POSSIBLE ACTIONS");
        Composite buttonsComposite = new Composite(actionListComposite, 0);
        RowLayout layout = new RowLayout();
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.actionButtons.addAll(Arrays.asList(WindowsAction.values()).stream().filter(action -> action.isUserInputAction()).map(action -> new WindowsActionButtonWrapper(buttonsComposite, (WindowsAction)action, event -> {
            try {
                WindowsActionMapping actionMapping;
                SnapshotWindowsElement element;
                SnapshotWindowsElement snapshotWindowsElement = element = !this.allElementTreeViewer.getStructuredSelection().isEmpty() ? (SnapshotWindowsElement)this.allElementTreeViewer.getStructuredSelection().getFirstElement() : null;
                if (WindowsAction.ClickElementOffset.equals(action) || WindowsAction.RightClickElementOffset.equals(action)) {
                    Trackings.trackCoordinateActionUsed((String)action.getName());
                }
                if ((actionMapping = this.performAction((WindowsAction)action, element)) == null || actionMapping.getAction().isCanceled()) {
                    return;
                }
                if (actionMapping.getTargetElement() != null) {
                    CapturedWindowsElement targetElement = this.capturedObjectsTableViewer.addCapturedObject(actionMapping.getTargetElement());
                    actionMapping.setTargetElement(targetElement);
                }
                this.stepView.addNode(actionMapping);
                this.targetElementChanged(null);
                this.allElementTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                if (this.isApplicationOpened()) {
                    this.captureObjectAction();
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Information", (String)"Application closed");
                    this.stopObjectInspectorAction();
                }
            }
            catch (WindowsComposerException | StepFailedException | ClassNotFoundException e) {
                MultiStatusErrorDialog.showErrorDialog((String)("Unable to perform action: " + action.getReadableName()), (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
                LoggerSingleton.logError((Throwable)e);
            }
        })).collect(Collectors.toList()));
    }

    private boolean isApplicationOpened() {
        try {
            this.inspectorController.getDriver().getWindowHandle();
            return true;
        }
        catch (NoSuchWindowException noSuchWindowException) {
            return false;
        }
    }

    private WindowsActionMapping performAction(WindowsAction action, SnapshotWindowsElement element) throws WindowsComposerException {
        WindowsActionHandler actionHandler = new WindowsActionHandler(this.inspectorController.getWindowsSession(), action);
        return actionHandler.perform(element, this.getShell());
    }

    private void targetElementChanged(CapturedWindowsElement basicWindowsElement) {
        this.updateActionButtonsVisibility(basicWindowsElement);
    }

    public void updateActionButtonsVisibility(BasicWindowsElement basicWindowsElement) {
        UISynchronizeService.syncExec(() -> this.actionButtons.stream().forEach(actionButton -> {
            WindowsAction action = actionButton.getWindowsAction();
            actionButton.setEnabledButton(this.inspectorController.getDriver() != null && (!action.hasElement() || basicWindowsElement != null));
        }));
    }

    private void createContentComposite(SashForm sashForm) {
        Composite contentComposite = new Composite((Composite)sashForm, 0);
        contentComposite.setLayout((Layout)this.createNoMarginGridLayout());
        this.addStartStopToolbar(contentComposite);
        this.createSettingComposite(contentComposite);
        CTabFolder leftBottomTabFolder = new CTabFolder(contentComposite, 0);
        leftBottomTabFolder.setLayoutData((Object)new GridData(1808));
        CTabItem recordedActionTabItem = new CTabItem(leftBottomTabFolder, 0);
        recordedActionTabItem.setText("Recorded Actions");
        Composite recordedActionControl = this.createRecordedActionComposite((Composite)leftBottomTabFolder);
        recordedActionTabItem.setControl((Control)recordedActionControl);
        CTabItem capturedObjectsTabItem = new CTabItem(leftBottomTabFolder, 0);
        SashForm hSashForm = new SashForm((Composite)leftBottomTabFolder, 512);
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createCapturedObjectsComposite((Composite)hSashForm);
        this.createPropertiesComposite((Composite)hSashForm);
        this.createHighlightElementComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{4, 6, 1});
        capturedObjectsTabItem.setControl((Control)hSashForm);
        capturedObjectsTabItem.setText("Captured Objects");
        leftBottomTabFolder.setSelection(recordedActionTabItem);
    }

    private void createSettingComposite(Composite parent) {
        Composite settingComposite = new Composite(parent, 0);
        settingComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glSettingComposite = new GridLayout(2, false);
        glSettingComposite.horizontalSpacing = 10;
        settingComposite.setLayout((Layout)glSettingComposite);
        Label lblConfiguration = new Label(settingComposite, 0);
        lblConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lblConfiguration.setFont(this.getFontBold(lblConfiguration));
        lblConfiguration.setText("CONFIGURATIONS");
        this.appsComposite = new Composite(settingComposite, 0);
        this.appsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.appsComposite.setLayout((Layout)new FillLayout());
        this.mobileComposite.createComposite(this.appsComposite, 0, this);
    }

    @Override
    public void refreshButtonsState() {
        this.validateToEnableStartButton();
    }

    public void initializeData() {
        UISynchronizeService.asyncExec(() -> {
            try {
                try {
                    this.mobileComposite.setInput();
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    LoggerSingleton.logError((Throwable)targetException);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)"Error", (String)targetException.getClass().getSimpleName());
                    this.validateToEnableStartButton();
                }
                catch (InterruptedException interruptedException) {
                    this.validateToEnableStartButton();
                }
            }
            finally {
                this.validateToEnableStartButton();
            }
        });
    }

    private void startObjectInspectorAction() {
        this.btnStart.setEnabled(false);
        AppiumMonitorDialog progressDlg = new AppiumMonitorDialog(this.getShell()){

            public void cancelPressed() {
                super.cancelPressed();
                this.finishedRun();
                this.getProgressMonitor().done();
                WindowsRecorderDialog.this.setStartStopButtonsState(true);
            }
        };
        this.inspectorController.setStreamHandler((AppiumStreamHandler)progressDlg);
        try {
            try {
                WindowsActionMapping actionMapping = this.mobileComposite.startApp(this.inspectorController, progressDlg);
                try {
                    if (!progressDlg.getProgressMonitor().isCanceled()) {
                        this.captureObjectAction();
                        this.setStartStopButtonsState(false);
                        this.getButton(0).setEnabled(true);
                        this.stepView.refreshTree();
                        this.stepView.addNode(actionMapping);
                    } else {
                        this.stopObjectInspectorAction();
                        this.setStartStopButtonsState(true);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new InvocationTargetException(e);
                }
                this.targetElementChanged(null);
                Trackings.trackWindowsRecord();
            }
            catch (Exception ex) {
                if (ex instanceof InvocationTargetException) {
                    LoggerSingleton.logError((Throwable)ex);
                    Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                    String message = targetException instanceof ExecutionException ? targetException.getCause().getMessage() : targetException.getMessage();
                    UISynchronizeService.syncExec(() -> MultiStatusErrorDialog.showErrorDialog((String)"Unable to start application", (String)message, (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)targetException)));
                }
                this.setStartStopButtonsState(true);
                this.inspectorController.setStreamHandler(null);
            }
        }
        finally {
            this.inspectorController.setStreamHandler(null);
        }
    }

    private void setStartStopButtonsState(boolean isReadyToStart) {
        if (isReadyToStart) {
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
        } else {
            this.btnStart.setEnabled(false);
            this.btnStop.setEnabled(true);
            this.btnCapture.setEnabled(true);
        }
    }

    public String getAppName() {
        return this.mobileComposite.getAppName();
    }

    private void captureObjectAction() {
        final ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Capturing Windows objects", -1);
                TreeWindowsElement newAppRootElement = (TreeWindowsElement)dialog.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        TreeWindowsElement appRootElement = (this).WindowsRecorderDialog.this.inspectorController.getWindowsObjectRoot();
                        return appRootElement;
                    }
                });
                WindowsRecorderDialog.this.checkMonitorCanceled(monitor);
                this.refreshTreeElements(dialog, newAppRootElement);
                WindowsRecorderDialog.this.updateActionButtonsVisibility(null);
                String imgPath = this.captureImage();
                WindowsRecorderDialog.this.checkMonitorCanceled(monitor);
                this.refreshDeviceView(imgPath, newAppRootElement);
                WindowsRecorderDialog.this.appRootElement = newAppRootElement;
                monitor.done();
            }

            private void refreshTreeElements(ProgressMonitorDialogWithThread dialog2, final TreeWindowsElement newAppRootElement) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).WindowsRecorderDialog.this.allElementTreeViewer.setInput((Object)new Object[]{newAppRootElement});
                        (this).WindowsRecorderDialog.this.allElementTreeViewer.refresh();
                        (this).WindowsRecorderDialog.this.allElementTreeViewer.expandAll();
                    }
                });
            }

            private void refreshDeviceView(String imgPath, TreeWindowsElement newAppRootElement) {
                File imgFile = new File(imgPath);
                if (imgFile.exists()) {
                    WindowsRecorderDialog.this.screenComposite.refreshDialog(imgFile);
                }
            }

            private String captureImage() throws InvocationTargetException {
                try {
                    return WindowsRecorderDialog.this.inspectorController.captureScreenshot();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.btnCapture.setEnabled(false);
                dialog.run(true, false, runnable);
            }
            catch (InterruptedException interruptedException) {
                this.validateToEnableStartButton();
            }
            catch (InvocationTargetException e) {
                if (!this.isApplicationOpened()) {
                    this.stopObjectInspectorAction();
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Information", (String)"Application closed");
                } else {
                    LoggerSingleton.logError((Throwable)e);
                    Throwable exception = e.getTargetException();
                    MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)"Could not capture Windows element", (String)exception.getClass().getSimpleName());
                }
                this.validateToEnableStartButton();
            }
        }
        finally {
            this.validateToEnableStartButton();
        }
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException("Operation has been canceled");
        }
    }

    private void stopObjectInspectorAction() {
        try {
            WindowsSession appSession = this.inspectorController.getWindowsSession();
            if (appSession != null) {
                WindowsActionHelper actionHelper = new WindowsActionHelper(appSession);
                actionHelper.closeApp();
            }
        }
        catch (WebDriverException webDriverException) {}
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (WindowsRecorderDialog.this.inspectorController.getDriver() != null) {
                    WindowsRecorderDialog.this.inspectorController.getDriver().quit();
                }
            }
        });
        thread.start();
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.inspectorController.resetDriver();
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
            this.allElementTreeViewer.setInput((Object)new Object[0]);
            this.allElementTreeViewer.refresh();
            this.targetElementChanged(null);
            try {
                this.stepView.refreshTree();
            }
            catch (InterruptedException | InvocationTargetException exception) {}
            this.screenComposite.refreshDialog(null);
        }
    }

    private void validateToEnableStartButton() {
        boolean ableToStart = this.mobileComposite.isAbleToStart();
        this.btnStart.setEnabled(ableToStart && this.inspectorController.getDriver() == null);
        this.btnStop.setEnabled(this.inspectorController.getDriver() != null);
        this.btnCapture.setEnabled(this.inspectorController.getDriver() != null);
    }

    private void addStartStopToolbar(Composite contentComposite) {
        Composite toolbarComposite = new Composite(contentComposite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(2, false));
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar contentToolbar = new ToolBar(toolbarComposite, 0x820000);
        contentToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        contentToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.btnCapture = new ToolItem(contentToolbar, 0);
        this.btnCapture.setImage(ImageManager.getImage((String)"refresh_24.png"));
        this.btnCapture.setDisabledImage(ImageManager.getImage((String)"refresh_disabled_24.png"));
        this.btnCapture.setText("Refresh Screen");
        this.btnCapture.setToolTipText("Refresh Screen");
        this.btnCapture.setEnabled(false);
        this.btnCapture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsRecorderDialog.this.captureObjectAction();
            }
        });
        this.btnStart = new ToolItem(contentToolbar, 0);
        this.btnStart.setImage(ImageManager.getImage((String)"toolbar/play_24.png"));
        this.btnStart.setDisabledImage(ImageManager.getImage((String)"toolbar/play_disabled_24.png"));
        this.btnStart.setText("Start");
        this.btnStart.setToolTipText("Start");
        this.btnStart.setEnabled(false);
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WindowsRecorderDialog.this.validateAppSetting()) {
                    WindowsRecorderDialog.this.startObjectInspectorAction();
                }
            }
        });
        this.btnStop = new ToolItem(contentToolbar, 0);
        this.btnStop.setImage(ImageManager.getImage((String)"toolbar/stop_24.png"));
        this.btnStop.setDisabledImage(ImageManager.getImage((String)"toolbar/stop_disabled_24.png"));
        this.btnStop.setText(GlobalStringConstants.STOP);
        this.btnStop.setToolTipText(GlobalStringConstants.STOP);
        this.btnStop.setEnabled(false);
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsRecorderDialog.this.addStopAction();
                WindowsRecorderDialog.this.stopObjectInspectorAction();
            }
        });
    }

    private void addStopAction() {
        WindowsActionMapping stopAction = new WindowsActionMapping(WindowsAction.CloseApplication, null);
        try {
            this.stepView.addNode(stopAction);
        }
        catch (ClassNotFoundException exception) {
            LoggerSingleton.logError((Throwable)exception);
        }
    }

    private boolean validateAppSetting() {
        return this.mobileComposite.validateSetting();
    }

    private Composite createAllObjectsComposite(Composite parentComposite) {
        Composite allObjectsComposite = new Composite(parentComposite, 0);
        allObjectsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        allObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblRecordedActions = new Label(allObjectsComposite, 0);
        lblRecordedActions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblRecordedActions.setFont(this.getFontBold(lblRecordedActions));
        lblRecordedActions.setText("SCREEN OBJECTS");
        Composite allObjectsTreeComposite = new Composite(allObjectsComposite, 0);
        allObjectsTreeComposite.setLayoutData((Object)new GridData(1808));
        allObjectsTreeComposite.setLayout((Layout)new FillLayout());
        this.allElementTreeViewer = new CTreeViewer(allObjectsTreeComposite, 68356);
        this.allElementTreeViewer.setLabelProvider((IBaseLabelProvider)new WindowsElementLabelProvider());
        this.allElementTreeViewer.setContentProvider((IContentProvider)new WindowsElementTreeContentProvider());
        this.allElementTreeViewer.getTree().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.allElementTreeViewer, (int)2);
        this.allElementTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (WindowsRecorderDialog.this.allElementTreeViewer.getStructuredSelection().isEmpty()) {
                    WindowsRecorderDialog.this.updateActionButtonsVisibility(null);
                } else {
                    BasicWindowsElement element = (BasicWindowsElement)WindowsRecorderDialog.this.allElementTreeViewer.getStructuredSelection().getFirstElement();
                    WindowsRecorderDialog.this.highlightObject(element);
                    WindowsRecorderDialog.this.updateActionButtonsVisibility(element);
                }
            }
        });
        Tree tree = (Tree)this.allElementTreeViewer.getControl();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeColumns;
                        int n = treeColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeColumn = treeColumnArray[n2];
                            treeColumn.pack();
                            ++n2;
                        }
                    }
                });
            }
        };
        tree.addListener(17, listener);
        return allObjectsComposite;
    }

    private void highlightObject(BasicWindowsElement selectedElement) {
        if (selectedElement == null || this.screenComposite == null || this.screenComposite.isDisposed()) {
            return;
        }
        this.screenComposite.highlightElement(selectedElement);
    }

    @Override
    public void highlightElementRects(List<Rectangle> rects) {
        this.screenComposite.highlightRects(rects);
    }

    private Font getFontBold(Label label) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        return boldDescriptor.createFont((Device)label.getDisplay());
    }

    @Override
    public void setSelectedElementByLocation(int x, int y) {
        if (this.appRootElement == null) {
            return;
        }
        final TreeWindowsElement foundElement = this.recursivelyFindElementByLocation(this.appRootElement, x, y);
        if (foundElement == null) {
            return;
        }
        this.highlightObject(foundElement);
        this.computeAndStoreElementOffsets(x, y, foundElement);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                WindowsRecorderDialog.this.getShell().setFocus();
                WindowsRecorderDialog.this.allElementTreeViewer.getTree().setFocus();
                WindowsRecorderDialog.this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)foundElement));
            }
        });
    }

    private void computeAndStoreElementOffsets(int x, int y, TreeWindowsElement foundElement) {
        Rectangle elementRectangle = (Rectangle)foundElement.getMetaData().get("elementRectangle");
        if (elementRectangle != null) {
            int offsetX = Math.abs(x - elementRectangle.x);
            int offsetY = Math.abs(y - elementRectangle.y);
            foundElement.getMetaData().put("elementOffsets", new int[]{offsetX, offsetY});
        }
    }

    private TreeWindowsElement recursivelyFindElementByLocation(TreeWindowsElement currentElement, int x, int y) {
        if (!this.screenComposite.isElementOnScreen(Double.valueOf(x), Double.valueOf(y), 1.0, 1.0)) {
            return null;
        }
        for (TreeWindowsElement treeWindowsElement : currentElement.getChildren()) {
            Map<String, String> attributes = treeWindowsElement.getProperties();
            Double elementX = Double.parseDouble(attributes.get("x"));
            Double elementY = Double.parseDouble(attributes.get("y"));
            Double elementWidth = Double.parseDouble(attributes.get("width"));
            Double elementHeight = Double.parseDouble(attributes.get("height"));
            Rectangle rectangle = new Rectangle(MobileDeviceDialog.safeRoundDouble((double)elementX), MobileDeviceDialog.safeRoundDouble((double)elementY), MobileDeviceDialog.safeRoundDouble((double)elementWidth), MobileDeviceDialog.safeRoundDouble((double)elementHeight));
            treeWindowsElement.getMetaData().put("elementRectangle", rectangle);
            if (!rectangle.contains(x, y)) continue;
            return this.recursivelyFindElementByLocation(treeWindowsElement, x, y);
        }
        return currentElement;
    }

    @Override
    public void updateSelectedElement(CapturedWindowsElement selectedElement) {
        this.capturedObjectsTableViewer.refresh(selectedElement);
        try {
            this.stepView.refreshTree();
        }
        catch (InterruptedException | InvocationTargetException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, GlobalMessageConstants.DIA_SAVE_RECORDING, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public RecordActionResult getRecordActionResult() {
        return this.recordActionResult;
    }

    public class RecordActionResult {
        private final List<CapturedWindowsElement> windowsElements;
        private final ScriptNodeWrapper script;

        public RecordActionResult(ScriptNodeWrapper script, List<CapturedWindowsElement> windowsElements) {
            this.script = script;
            this.windowsElements = windowsElements;
        }

        public List<CapturedWindowsElement> getWindowsElements() {
            return this.windowsElements;
        }

        public ScriptNodeWrapper getScript() {
            return this.script;
        }
    }
}

