/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.windows.action.WindowsAction;
import com.kms.katalon.composer.windows.action.WindowsActionMapping;
import com.kms.katalon.composer.windows.constant.ComposerWindowsMessage;
import com.kms.katalon.composer.windows.dialog.WindowsAppComposite;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.nativerecorder.NativeRecorderDriver;
import com.kms.katalon.composer.windows.record.RecordedWindowsElementLabelProvider;
import com.kms.katalon.composer.windows.record.RecordedWindowsElementTableViewer;
import com.kms.katalon.composer.windows.socket.WindowsServerSocketMessage;
import com.kms.katalon.composer.windows.socket.WindowsSocketMessageUtil;
import com.kms.katalon.composer.windows.socket.WindowsSocketServer;
import com.kms.katalon.composer.windows.socket.WindowsStartRecordingPayload;
import com.kms.katalon.composer.windows.socket.WindowsStopRecordingPayload;
import com.kms.katalon.composer.windows.spy.WindowsElementPropertiesComposite;
import com.kms.katalon.composer.windows.spy.WindowsInspectorController;
import com.kms.katalon.composer.windows.spy.WindowsRecordedStepsView;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WindowsRecorderDialogV2
extends AbstractDialog
implements WindowsObjectDialog {
    private ToolItem btnStart;
    private ToolItem btnStop;
    private boolean isStarting = false;
    private Composite container;
    private WindowsAppComposite mobileComposite = new WindowsAppComposite();
    private RecordedWindowsElementTableViewer capturedObjectsTableViewer;
    private WindowsRecordedStepsView stepView;
    private WindowsElementPropertiesComposite propertiesComposite;
    private WindowsSocketServer socketServer = new WindowsSocketServer(this);
    private NativeRecorderDriver nativeRecorderDriver = new NativeRecorderDriver();
    private RecordActionResult recordActionResult;
    private boolean okPressed = false;
    private boolean isCoordinateBasedRecordingEnabled = false;

    public WindowsRecorderDialogV2(Shell parentShell) {
        super(parentShell);
        this.socketServer.start();
        this.startNativeRecorderDriver();
    }

    public String getDialogTitle() {
        return ComposerWindowsMessage.DLG_TITLE_KATALON_NATIVE_RECORDER;
    }

    public int open() {
        Trackings.trackOpenWindowsNativeRecord();
        return super.open();
    }

    public boolean close() {
        this.socketServer.close();
        if (this.okPressed) {
            int recordedActionCount = this.stepView.getNodes().size();
            Trackings.trackCloseWindowsNativeRecordByOk((int)recordedActionCount);
        } else {
            Trackings.trackCloseWindowsNativeRecordByCancel();
        }
        return super.close();
    }

    protected void okPressed() {
        this.recordActionResult = new RecordActionResult(this.stepView.getWrapper(), this.capturedObjectsTableViewer.getCapturedElements());
        this.okPressed = true;
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    protected Point getInitialLocation(Point initialSize) {
        Shell parentShell = Display.getCurrent().getActiveShell();
        Rectangle parentSize = parentShell.getBounds();
        int locationX = (parentSize.width - initialSize.x) / 2 + parentSize.x;
        int locationY = (parentSize.height - initialSize.y) / 2 + parentSize.y;
        return new Point(locationX, locationY);
    }

    protected int getShellStyle() {
        if (!"linux".equals(Platform.getOS())) {
            return 1264;
        }
        return 16778480;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
        this.setButtonStates();
        this.stepView.setCapturedElementsTableViewer(this.capturedObjectsTableViewer);
        try {
            this.mobileComposite.setInput();
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)this.createNoMarginGridLayout());
        this.container.setBackground(ColorUtil.getCompositeBackgroundColorForDialog());
        SashForm sashForm = this.createMainSashForm(this.container);
        sashForm.setBackground(ColorUtil.getCompositeBackgroundColorForSashform());
        this.populateSashForm(sashForm);
        return this.container;
    }

    protected void populateSashForm(SashForm sashForm) {
        Composite contentComposite = new Composite((Composite)sashForm, 0);
        contentComposite.setLayout((Layout)this.createNoMarginGridLayout());
        this.addStartStopToolbar(contentComposite);
        this.createSettingComposite(contentComposite);
        CTabFolder leftBottomTabFolder = new CTabFolder(contentComposite, 0);
        leftBottomTabFolder.setLayoutData((Object)new GridData(1808));
        CTabItem recordedActionTabItem = new CTabItem(leftBottomTabFolder, 0);
        recordedActionTabItem.setText("Recorded Actions");
        Composite recordedActionControl = this.createRecordedActionComposite((Composite)leftBottomTabFolder);
        recordedActionTabItem.setControl((Control)recordedActionControl);
        CTabItem capturedObjectsTabItem = new CTabItem(leftBottomTabFolder, 0);
        SashForm hSashForm = new SashForm((Composite)leftBottomTabFolder, 512);
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createCapturedObjectsComposite((Composite)hSashForm);
        this.createPropertiesComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{4, 6});
        capturedObjectsTabItem.setControl((Control)hSashForm);
        capturedObjectsTabItem.setText("Captured Objects");
        leftBottomTabFolder.setSelection(recordedActionTabItem);
    }

    private Composite createRecordedActionComposite(Composite parent) {
        this.stepView = new WindowsRecordedStepsView();
        Composite compositeStepView = this.stepView.createContent(parent);
        return compositeStepView;
    }

    private Composite createCapturedObjectsComposite(Composite parent) {
        Composite capturedObjectsComposite = new Composite(parent, 0);
        capturedObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblRecordedActions = new Label(capturedObjectsComposite, 0);
        lblRecordedActions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblRecordedActions.setFont(this.getFontBold(lblRecordedActions));
        lblRecordedActions.setText("CAPTURED OBJECTS");
        Composite capturedObjectTableComposite = new Composite(capturedObjectsComposite, 0);
        capturedObjectTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tbclCapturedObjects = new TableColumnLayout();
        capturedObjectTableComposite.setLayout((Layout)tbclCapturedObjects);
        this.capturedObjectsTableViewer = new RecordedWindowsElementTableViewer(capturedObjectTableComposite, 68354);
        Table capturedObjectsTable = this.capturedObjectsTableViewer.getTable();
        capturedObjectsTable.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        capturedObjectsTable.setHeaderVisible(true);
        capturedObjectsTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)capturedObjectsTable.getDisplay()));
        TableViewerColumn tableViewerColumnCapturedObjects = new TableViewerColumn((TableViewer)this.capturedObjectsTableViewer, 0);
        TableColumn tblclmnCapturedObjects = tableViewerColumnCapturedObjects.getColumn();
        tblclmnCapturedObjects.setText(GlobalStringConstants.NAME);
        tableViewerColumnCapturedObjects.setLabelProvider((CellLabelProvider)new RecordedWindowsElementLabelProvider());
        tbclCapturedObjects.setColumnData((Widget)tblclmnCapturedObjects, (ColumnLayoutData)new ColumnWeightData(98, 100));
        this.capturedObjectsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.capturedObjectsTableViewer.setCaptureElements(new ArrayList<CapturedWindowsElement>());
        capturedObjectsTable.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.capturedObjectsTableViewer);
        this.capturedObjectsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CapturedWindowsElement firstElement = (CapturedWindowsElement)selection.getFirstElement();
                WindowsRecorderDialogV2.this.propertiesComposite.setEditingElement(firstElement);
            }
        });
        return capturedObjectsComposite;
    }

    private Control createPropertiesComposite(Composite parent) {
        this.propertiesComposite = new WindowsElementPropertiesComposite(this);
        Composite control = this.propertiesComposite.createObjectPropertiesComposite(parent);
        return control;
    }

    private void addStartStopToolbar(Composite contentComposite) {
        Composite toolbarComposite = new Composite(contentComposite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(2, false));
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar contentToolbar = new ToolBar(toolbarComposite, 0x820000);
        contentToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        contentToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.btnStart = new ToolItem(contentToolbar, 0);
        this.btnStart.setImage(ImageManager.getImage((String)"toolbar/play_24.png"));
        this.btnStart.setDisabledImage(ImageManager.getImage((String)"toolbar/play_disabled_24.png"));
        this.btnStart.setText("Start");
        this.btnStart.setToolTipText("Start");
        this.btnStart.setEnabled(false);
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsRecorderDialogV2.this.isStarting = true;
                WindowsRecorderDialogV2.this.setButtonStates();
                try {
                    WindowsRecorderDialogV2.this.mobileComposite.saveSettings();
                    WindowsRecorderDialogV2.this.startRecording();
                }
                catch (Exception exception) {
                    WindowsRecorderDialogV2.this.isStarting = false;
                    WindowsRecorderDialogV2.this.setButtonStates();
                }
            }
        });
        this.btnStop = new ToolItem(contentToolbar, 0);
        this.btnStop.setImage(ImageManager.getImage((String)"toolbar/stop_24.png"));
        this.btnStop.setDisabledImage(ImageManager.getImage((String)"toolbar/stop_disabled_24.png"));
        this.btnStop.setText(GlobalStringConstants.STOP);
        this.btnStop.setToolTipText(GlobalStringConstants.STOP);
        this.btnStop.setEnabled(false);
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WindowsRecorderDialogV2.this.isStarting = false;
                    WindowsRecorderDialogV2.this.setButtonStates();
                    WindowsRecorderDialogV2.this.closeApplication();
                    WindowsRecorderDialogV2.this.stopRecordind();
                }
                catch (Exception exception) {}
            }
        });
    }

    private Font getFontBold(Label label) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        return boldDescriptor.createFont((Device)label.getDisplay());
    }

    private void createSettingComposite(Composite parent) {
        Composite settingComposite = new Composite(parent, 0);
        settingComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glSettingComposite = new GridLayout(2, false);
        glSettingComposite.horizontalSpacing = 10;
        settingComposite.setLayout((Layout)glSettingComposite);
        Label lblConfiguration = new Label(settingComposite, 0);
        lblConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lblConfiguration.setFont(this.getFontBold(lblConfiguration));
        lblConfiguration.setText("CONFIGURATIONS");
        final Button chckRecordCoordinate = new Button(settingComposite, 32);
        chckRecordCoordinate.setText("Enable coordinate-based recording");
        chckRecordCoordinate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WindowsRecorderDialogV2.this.isCoordinateBasedRecordingEnabled = chckRecordCoordinate.getSelection();
                Trackings.trackEnableCoordinatesBasedRecording((boolean)WindowsRecorderDialogV2.this.isCoordinateBasedRecordingEnabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite appsComposite = new Composite(settingComposite, 0);
        appsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        appsComposite.setLayout((Layout)new FillLayout());
        this.mobileComposite.setShowConfiguration(true);
        this.mobileComposite.setShowRemoteUrl(false);
        this.mobileComposite.setShowApplicationTitle(false);
        this.mobileComposite.createComposite(appsComposite, 0, this);
    }

    protected SashForm createMainSashForm(Composite container) {
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setSashWidth(3);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        return sashForm;
    }

    protected GridLayout createNoMarginGridLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    private void startRecording() throws Exception {
        Trackings.trackWindowsNativeRecord();
        this.startNativeRecorderDriver();
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        WindowsDriverConnector driverConnector = WindowsDriverConnector.getInstance((String)projectDir);
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(driverConnector.getDesiredCapabilities());
        WindowsStartRecordingPayload message = WindowsSocketMessageUtil.createStartRecordingPayload(this.mobileComposite.getAppFile(), desiredCapabilities);
        String data = JsonUtil.toJson((Object)message);
        this.socketServer.sendMessage(WindowsSocketMessageUtil.createServerMessage(WindowsServerSocketMessage.ServerMessageType.START_RECORDING, data));
    }

    private void stopRecordind() throws Exception {
        this.socketServer.sendMessage(WindowsSocketMessageUtil.createServerMessage(WindowsServerSocketMessage.ServerMessageType.STOP_RECORDING, ""));
    }

    private void closeApplication() throws IOException, ClassNotFoundException {
        WindowsActionMapping stopAction = new WindowsActionMapping(WindowsAction.CloseApplication, null);
        this.stepView.addNode(stopAction);
        WindowsStopRecordingPayload message = WindowsSocketMessageUtil.createStopRecordingPayload(this.mobileComposite.getAppFile());
        String data = JsonUtil.toJson((Object)message);
        this.socketServer.sendMessage(WindowsSocketMessageUtil.createServerMessage(WindowsServerSocketMessage.ServerMessageType.CLOSE_APPLICATION, data));
    }

    private void startNativeRecorderDriver() {
        try {
            boolean shouldStartANewClient = !this.socketServer.isClientConnected();
            this.nativeRecorderDriver.start(shouldStartANewClient);
        }
        catch (IOException exception) {
            LoggerSingleton.logError((Throwable)exception);
        }
    }

    private void setButtonStates() {
        this.btnStart.setEnabled(!this.isStarting);
        this.btnStop.setEnabled(this.isStarting);
    }

    @Override
    public void refreshButtonsState() {
        this.setButtonStates();
    }

    @Override
    public void setSelectedElementByLocation(int x, int y) {
    }

    @Override
    public void updateSelectedElement(CapturedWindowsElement editingElement) {
        this.capturedObjectsTableViewer.refresh(editingElement);
        try {
            this.stepView.refreshTree();
        }
        catch (InterruptedException | InvocationTargetException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    @Override
    public WindowsInspectorController getInspectorController() {
        return null;
    }

    @Override
    public void highlightElementRects(List<Rectangle> rects) {
    }

    public boolean isStarting() {
        return this.isStarting;
    }

    public void setStarting(boolean isStarting) {
        this.isStarting = isStarting;
    }

    public ToolItem getBtnStart() {
        return this.btnStart;
    }

    public ToolItem getBtnStop() {
        return this.btnStop;
    }

    public WindowsAppComposite getMobileComposite() {
        return this.mobileComposite;
    }

    public WindowsRecordedStepsView getStepView() {
        return this.stepView;
    }

    public RecordedWindowsElementTableViewer getCapturedObjectsTableViewer() {
        return this.capturedObjectsTableViewer;
    }

    public WindowsElementPropertiesComposite getPropertiesComposite() {
        return this.propertiesComposite;
    }

    public void addActionMapping(WindowsActionMapping actionMapping) {
        UISynchronizeService.syncExec(() -> {
            try {
                if (actionMapping.getTargetElement() != null) {
                    CapturedWindowsElement finalCapturedElement = this.capturedObjectsTableViewer.addCapturedObject(actionMapping.getTargetElement());
                    actionMapping.setTargetElement(finalCapturedElement);
                }
                this.stepView.refreshTree();
                this.stepView.addNode(actionMapping);
            }
            catch (ClassNotFoundException | InterruptedException | InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        });
    }

    public RecordActionResult getRecordActionResult() {
        return this.recordActionResult;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, GlobalMessageConstants.DIA_SAVE_RECORDING, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean isCoordinateBasedRecordingEnabled() {
        return this.isCoordinateBasedRecordingEnabled;
    }

    public class RecordActionResult {
        private final List<CapturedWindowsElement> windowsElements;
        private final ScriptNodeWrapper script;

        public RecordActionResult(ScriptNodeWrapper script, List<CapturedWindowsElement> windowsElements) {
            this.script = script;
            this.windowsElements = windowsElements;
        }

        public List<CapturedWindowsElement> getWindowsElements() {
            return this.windowsElements;
        }

        public ScriptNodeWrapper getScript() {
            return this.script;
        }
    }
}

