/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.dialog;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.constant.ImageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumStreamHandler;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.windows.dialog.WindowsAppComposite;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.dialog.WindowsScreenView;
import com.kms.katalon.composer.windows.element.BasicWindowsElement;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.element.CapturedWindowsElementConverter;
import com.kms.katalon.composer.windows.element.TreeWindowsElement;
import com.kms.katalon.composer.windows.spy.CapturedWindowsElementLabelProvider;
import com.kms.katalon.composer.windows.spy.CapturedWindowsObjectTableViewer;
import com.kms.katalon.composer.windows.spy.HighlightElementComposite;
import com.kms.katalon.composer.windows.spy.SelectableWindowsElementEditingSupport;
import com.kms.katalon.composer.windows.spy.WindowsElementLabelProvider;
import com.kms.katalon.composer.windows.spy.WindowsElementPropertiesComposite;
import com.kms.katalon.composer.windows.spy.WindowsElementTreeContentProvider;
import com.kms.katalon.composer.windows.spy.WindowsInspectorController;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class WindowsSpyObjectDialog
extends Dialog
implements WindowsObjectDialog {
    public static final Point DIALOG_SIZE = new Point(1200, 800);
    private static final String DIALOG_TITLE = "Spy Windows Objects";
    private CheckboxTreeViewer allElementTreeViewer;
    private ToolItem btnStart;
    private ToolItem btnCapture;
    private ToolItem btnAdd;
    private ToolItem btnStop;
    private TreeWindowsElement appRootElement;
    private boolean disposed;
    private WindowsInspectorController inspectorController;
    private Composite container;
    private boolean canceledBeforeOpening;
    private CapturedWindowsObjectTableViewer capturedObjectsTableViewer;
    private TableColumn tblclmnCapturedObjectsSelection;
    private WindowsElementPropertiesComposite propertiesComposite;
    private Composite appsComposite;
    private WindowsAppComposite mobileComposite;
    private HighlightElementComposite highlightElementComposite;
    private WindowsScreenView screenComposite;
    private boolean okPressed = false;
    private static WindowsSpyObjectDialog instance;

    @Override
    public WindowsInspectorController getInspectorController() {
        return this.inspectorController;
    }

    public boolean isCanceledBeforeOpening() {
        return this.canceledBeforeOpening;
    }

    public WindowsSpyObjectDialog(Shell parentShell, WindowsAppComposite mobileComposite) {
        super(parentShell);
        this.setShellStyle(16778480);
        this.disposed = false;
        this.inspectorController = new WindowsInspectorController();
        this.mobileComposite = mobileComposite;
        instance = this;
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(this.container, 0);
        sashForm.setSashWidth(3);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite leftSashForm = new ScrolledComposite((Composite)sashForm, 768);
        leftSashForm.setExpandHorizontal(true);
        leftSashForm.setExpandVertical(true);
        leftSashForm.setMinSize(180, 400);
        Composite explorerComposite = new Composite((Composite)leftSashForm, 2048);
        explorerComposite.setLayout((Layout)layout);
        this.addElementTreeToolbar(explorerComposite);
        SashForm hSashForm = new SashForm(explorerComposite, 512);
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createCapturedObjectsComposite(hSashForm);
        this.propertiesComposite = new WindowsElementPropertiesComposite(this);
        this.propertiesComposite.createObjectPropertiesComposite((Composite)hSashForm);
        this.createHighlightElementComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{4, 6, 1});
        leftSashForm.setContent((Control)explorerComposite);
        ScrolledComposite middleSashForm = new ScrolledComposite((Composite)sashForm, 768);
        middleSashForm.setExpandHorizontal(true);
        middleSashForm.setExpandVertical(true);
        Composite contentComposite = new Composite((Composite)middleSashForm, 2048);
        contentComposite.setLayout((Layout)layout);
        this.addStartStopToolbar(contentComposite);
        this.createSettingComposite(contentComposite);
        this.createAllObjectsComposite(contentComposite);
        middleSashForm.setContent((Control)contentComposite);
        this.createScreenViewComposite((Composite)sashForm);
        sashForm.setWeights(new int[]{5, 5, 6});
        new HelpCompositeForDialog(this.container, DocumentationMessageConstants.DIALOG_WINDOWS_SPY);
        return this.container;
    }

    private void createCapturedObjectsComposite(SashForm hSashForm) {
        Composite capturedObjectsComposite = new Composite((Composite)hSashForm, 0);
        capturedObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblCapturedObjects = new Label(capturedObjectsComposite, 0);
        lblCapturedObjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblCapturedObjects.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_CAPTURED_OBJECTS);
        ControlUtils.setFontToBeBold((Control)lblCapturedObjects);
        Composite capturedObjectTableComposite = new Composite(capturedObjectsComposite, 0);
        capturedObjectTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tbclCapturedObjects = new TableColumnLayout();
        capturedObjectTableComposite.setLayout((Layout)tbclCapturedObjects);
        this.capturedObjectsTableViewer = new CapturedWindowsObjectTableViewer(capturedObjectTableComposite, 68354, this);
        Table capturedObjectsTable = this.capturedObjectsTableViewer.getTable();
        capturedObjectsTable.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        capturedObjectsTable.setHeaderVisible(true);
        capturedObjectsTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)capturedObjectsTable.getDisplay()));
        TableViewerColumn tbvclCapturedObjectsSelection = new TableViewerColumn((TableViewer)this.capturedObjectsTableViewer, 0);
        this.tblclmnCapturedObjectsSelection = tbvclCapturedObjectsSelection.getColumn();
        tbvclCapturedObjectsSelection.setLabelProvider((CellLabelProvider)new CapturedWindowsElementLabelProvider(0));
        tbvclCapturedObjectsSelection.setEditingSupport((EditingSupport)new SelectableWindowsElementEditingSupport((ColumnViewer)this.capturedObjectsTableViewer));
        TableViewerColumn tableViewerColumnCapturedObjects = new TableViewerColumn((TableViewer)this.capturedObjectsTableViewer, 0);
        TableColumn tblclmnCapturedObjects = tableViewerColumnCapturedObjects.getColumn();
        tblclmnCapturedObjects.setText(GlobalStringConstants.NAME);
        tableViewerColumnCapturedObjects.setLabelProvider((CellLabelProvider)new CapturedWindowsElementLabelProvider(1));
        this.capturedObjectsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        int selectionColMinWidth = "macosx".equals(Platform.getOS()) ? 21 : 30;
        tbclCapturedObjects.setColumnData((Widget)this.tblclmnCapturedObjectsSelection, (ColumnLayoutData)new ColumnWeightData(0, selectionColMinWidth, false));
        tbclCapturedObjects.setColumnData((Widget)tblclmnCapturedObjects, (ColumnLayoutData)new ColumnWeightData(60, 250 - selectionColMinWidth));
        capturedObjectsTable.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.capturedObjectsTableViewer);
        this.capturedObjectsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CapturedWindowsElement firstElement = (CapturedWindowsElement)selection.getFirstElement();
                WindowsSpyObjectDialog.this.propertiesComposite.setEditingElement(firstElement);
                WindowsSpyObjectDialog.this.highlightElementComposite.setEditingElement(firstElement);
            }
        });
        capturedObjectsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CapturedWindowsElement[] elements = WindowsSpyObjectDialog.this.capturedObjectsTableViewer.getSelectedElements();
                if (elements == null || elements.length == 0) {
                    return;
                }
                switch (e.keyCode) {
                    case 127: {
                        WindowsSpyObjectDialog.this.removeSelectedCapturedElements(elements);
                        break;
                    }
                    case 0x100000E: {
                        WindowsSpyObjectDialog.this.verifyCapturedElementsStates(elements);
                        break;
                    }
                    case 0x100000B: {
                        if (elements.length != 1) break;
                        WindowsSpyObjectDialog.this.propertiesComposite.focusAndEditCapturedElementName();
                    }
                }
            }
        });
        this.capturedObjectsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CapturedWindowsElement mobileElement = WindowsSpyObjectDialog.this.capturedObjectsTableViewer.getSelectedElement();
                TreeWindowsElement link = mobileElement.getLink();
                if (link != null) {
                    WindowsSpyObjectDialog.this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)link));
                    WindowsSpyObjectDialog.this.allElementTreeViewer.getTree().setFocus();
                }
            }
        });
        this.tblclmnCapturedObjectsSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsSpyObjectDialog.this.capturedObjectsTableViewer.checkAllElements(!WindowsSpyObjectDialog.this.capturedObjectsTableViewer.isAllElementChecked());
            }
        });
    }

    public void updateCapturedElementSelectingColumnHeader() {
        this.tblclmnCapturedObjectsSelection.setImage(this.capturedObjectsTableViewer.isAllElementChecked() ? ImageConstants.IMG_16_CHECKED : ImageConstants.IMG_16_UNCHECKED);
        this.btnAdd.setEnabled(this.capturedObjectsTableViewer.isAnyElementChecked());
    }

    private void verifyCapturedElementsStates(CapturedWindowsElement[] elements) {
        this.clearAllObjectState(elements);
        if (this.appRootElement != null) {
            CapturedWindowsElement[] capturedWindowsElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                CapturedWindowsElement needToVerify = capturedWindowsElementArray[n2];
                TreeWindowsElement foundElement = this.appRootElement.findBestMatch(needToVerify);
                if (foundElement != null) {
                    needToVerify.setLink(foundElement);
                    foundElement.setCapturedElement(needToVerify);
                    this.allElementTreeViewer.setChecked((Object)foundElement, true);
                }
                ++n2;
            }
        }
        this.allElementTreeViewer.refresh();
        this.capturedObjectsTableViewer.refresh();
    }

    private void removeSelectedCapturedElements(CapturedWindowsElement[] elements) {
        this.clearAllObjectState(elements);
        this.allElementTreeViewer.refresh();
        this.capturedObjectsTableViewer.removeCapturedElements(Arrays.asList(elements));
        this.propertiesComposite.setEditingElement(null);
        this.highlightElementComposite.setEditingElement(null);
    }

    private void clearAllObjectState(CapturedWindowsElement[] elements) {
        CapturedWindowsElement[] capturedWindowsElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            CapturedWindowsElement captured = capturedWindowsElementArray[n2];
            TreeWindowsElement treeElementLink = captured.getLink();
            if (treeElementLink != null) {
                treeElementLink.setCapturedElement(null);
                captured.setLink(null);
                Tree elementTree = this.allElementTreeViewer.getTree();
                if (elementTree != null && !elementTree.isDisposed() && this.allElementTreeViewer.getChecked((Object)treeElementLink)) {
                    this.allElementTreeViewer.setChecked((Object)treeElementLink, false);
                }
            }
            ++n2;
        }
    }

    private void createAllObjectsComposite(Composite parentComposite) {
        Composite allObjectsComposite = new Composite(parentComposite, 0);
        allObjectsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        allObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblAllObjects = new Label(allObjectsComposite, 0);
        lblAllObjects.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        ControlUtils.setFontToBeBold((Control)lblAllObjects);
        lblAllObjects.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_ALL_OBJECTS);
        this.allElementTreeViewer = new CheckboxTreeViewer(allObjectsComposite, 68354){

            public boolean setSubtreeChecked(Object element, boolean state) {
                Widget widget = this.internalExpand(element, false);
                if (widget instanceof TreeItem) {
                    TreeItem item = (TreeItem)widget;
                    item.setChecked(state);
                    return true;
                }
                return false;
            }
        };
        final Tree tree = this.allElementTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.allElementTreeViewer.setLabelProvider((IBaseLabelProvider)new WindowsElementLabelProvider());
        this.allElementTreeViewer.setContentProvider((IContentProvider)new WindowsElementTreeContentProvider());
        tree.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.allElementTreeViewer, (int)2);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TreeItem item = tree.getItem(pt);
                if (item != null) {
                    WindowsSpyObjectDialog.this.highlightObject((TreeWindowsElement)item.getData());
                }
            }
        });
        this.allElementTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TreeWindowsElement selectedElement = (TreeWindowsElement)event.getElement();
                if (event.getChecked()) {
                    WindowsSpyObjectDialog.this.captureWindowsElement(selectedElement);
                    return;
                }
                CapturedWindowsElement capturedElement = selectedElement.getCapturedElement();
                if (WindowsSpyObjectDialog.this.capturedObjectsTableViewer.contains(capturedElement)) {
                    WindowsSpyObjectDialog.this.capturedObjectsTableViewer.removeCapturedElement(capturedElement);
                    selectedElement.setCapturedElement(null);
                    WindowsSpyObjectDialog.this.propertiesComposite.setEditingElement(null);
                    WindowsSpyObjectDialog.this.highlightElementComposite.setEditingElement(null);
                }
                WindowsSpyObjectDialog.this.allElementTreeViewer.refresh((Object)selectedElement);
            }
        });
    }

    private void captureWindowsElement(final TreeWindowsElement selectedElement) {
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Capturing Windows element", 3);
                        ArrayList<CapturedWindowsElement> mobileElements = new ArrayList<CapturedWindowsElement>();
                        mobileElements.add(selectedElement.newCapturedElement(WindowsSpyObjectDialog.this.inspectorController.getDriver()));
                        monitor.worked(2);
                        UISynchronizeService.syncExec(() -> {
                            WindowsSpyObjectDialog.this.capturedObjectsTableViewer.addWindowsElements(mobileElements);
                            WindowsSpyObjectDialog.this.propertiesComposite.focusAndEditCapturedElementName();
                            WindowsSpyObjectDialog.this.allElementTreeViewer.refresh((Object)selectedElement);
                        });
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Error", (String)"Unable to capture object");
        }
    }

    private void createSettingComposite(Composite parent) {
        Composite settingComposite = new Composite(parent, 0);
        settingComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glSettingComposite = new GridLayout(2, false);
        glSettingComposite.horizontalSpacing = 10;
        settingComposite.setLayout((Layout)glSettingComposite);
        Label lblConfiguration = new Label(settingComposite, 0);
        lblConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ControlUtils.setFontToBeBold((Control)lblConfiguration);
        lblConfiguration.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_CONFIGURATIONS);
        this.appsComposite = new Composite(settingComposite, 0);
        this.appsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.appsComposite.setLayout((Layout)new FillLayout());
        this.mobileComposite.createComposite(this.appsComposite, 0, this);
    }

    private Control createHighlightElementComposite(Composite parent) {
        this.highlightElementComposite = new HighlightElementComposite(this);
        Composite control = this.highlightElementComposite.createComposite(parent);
        return control;
    }

    private Control createScreenViewComposite(Composite parent) {
        this.screenComposite = new WindowsScreenView(this);
        return this.screenComposite.createControls(parent);
    }

    @Override
    public void updateSelectedElement(CapturedWindowsElement selectedElement) {
        this.capturedObjectsTableViewer.refresh(selectedElement, true);
        TreeWindowsElement element = selectedElement.getLink();
        if (element != null) {
            this.allElementTreeViewer.refresh((Object)element);
            this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    @Override
    public void refreshButtonsState() {
        this.btnStart.setEnabled(this.mobileComposite.isAbleToStart());
    }

    public void create() {
        super.create();
        this.initializeData();
        this.refreshButtonsState();
        this.capturedObjectsTableViewer.setCapturedElements(new ArrayList<CapturedWindowsElement>());
    }

    private void initializeData() {
        UISynchronizeService.asyncExec(() -> {
            try {
                try {
                    this.mobileComposite.setInput();
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    LoggerSingleton.logError((Throwable)targetException);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)"Error", (String)targetException.getClass().getSimpleName());
                    this.refreshButtonsState();
                }
                catch (InterruptedException interruptedException) {
                    this.refreshButtonsState();
                }
            }
            finally {
                this.refreshButtonsState();
            }
        });
    }

    public int open() {
        try {
            this.canceledBeforeOpening = false;
            Trackings.trackOpenWindowsSpy();
            int n = super.open();
            return n;
        }
        finally {
            if (this.canceledBeforeOpening) {
                this.close();
            }
        }
    }

    private void addElementTreeToolbar(Composite explorerComposite) {
        ToolBar elementTreeToolbar = new ToolBar(explorerComposite, 0x820000);
        elementTreeToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        GridData layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.horizontalIndent = 2;
        layoutData.minimumWidth = 180;
        elementTreeToolbar.setLayoutData((Object)layoutData);
        this.btnAdd = new ToolItem(elementTreeToolbar, 0);
        this.btnAdd.setImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY);
        this.btnAdd.setDisabledImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY_DISABLED);
        this.btnAdd.setText(ComposerMobileObjectspyMessageConstants.DIA_TIP_ADD);
        this.btnAdd.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TIP_ADD);
        this.btnAdd.setEnabled(false);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsSpyObjectDialog.this.saveCapturedObjectsToObjectRepository();
            }
        });
    }

    private void addStartStopToolbar(Composite contentComposite) {
        Composite toolbarComposite = new Composite(contentComposite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(2, false));
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar contentToolbar = new ToolBar(toolbarComposite, 0x820000);
        contentToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        contentToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.btnCapture = new ToolItem(contentToolbar, 0);
        this.btnCapture.setImage(ImageManager.getImage((String)"refresh_24.png"));
        this.btnCapture.setDisabledImage(ImageManager.getImage((String)"refresh_disabled_24.png"));
        this.btnCapture.setText("Refresh Screen");
        this.btnCapture.setEnabled(false);
        this.btnCapture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsSpyObjectDialog.this.captureObjectAction();
            }
        });
        this.btnStart = new ToolItem(contentToolbar, 0);
        this.btnStart.setImage(ImageManager.getImage((String)"toolbar/play_24.png"));
        this.btnStart.setDisabledImage(ImageManager.getImage((String)"toolbar/play_disabled_24.png"));
        this.btnStart.setText(ComposerMobileObjectspyMessageConstants.DIA_TIP_START_APP);
        this.btnStart.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TIP_START_APP);
        this.btnStart.setEnabled(false);
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WindowsSpyObjectDialog.this.validateAppSetting()) {
                    WindowsSpyObjectDialog.this.startObjectInspectorAction();
                }
            }
        });
        this.btnStop = new ToolItem(contentToolbar, 0);
        this.btnStop.setImage(ImageManager.getImage((String)"toolbar/stop_24.png"));
        this.btnStop.setDisabledImage(ImageManager.getImage((String)"toolbar/stop_disabled_24.png"));
        this.btnStop.setText(GlobalStringConstants.STOP);
        this.btnStop.setToolTipText(GlobalStringConstants.STOP);
        this.btnStop.setEnabled(false);
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsSpyObjectDialog.this.stopObjectInspectorAction();
            }
        });
    }

    protected void okPressed() {
        this.saveCapturedObjectsToObjectRepository();
        this.okPressed = true;
        super.okPressed();
    }

    private void saveCapturedObjectsToObjectRepository() {
        if (this.capturedObjectsTableViewer.getAllCheckedElements().size() > 0) {
            try {
                AddElementToObjectRepositoryDialog dialog = new AddElementToObjectRepositoryDialog(this.getParentShell());
                if (dialog.open() != 0) {
                    return;
                }
                FolderTreeEntity folderTreeEntity = dialog.getSelectedFolderTreeEntity();
                FolderEntity folder = folderTreeEntity.getObject();
                List<ITreeEntity> newTreeEntities = this.addElementsToRepository(folderTreeEntity, folder);
                Trackings.trackSaveWindowsSpy((int)newTreeEntities.size());
                this.removeSelectedCapturedElements(this.capturedObjectsTableViewer.getAllCheckedElements().toArray(new CapturedWindowsElement[0]));
                this.updateExplorerState(folderTreeEntity, newTreeEntities);
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                MessageDialog.openError((Shell)this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)ex.getMessage());
            }
        }
    }

    private void updateExplorerState(FolderTreeEntity folderTreeEntity, List<ITreeEntity> newTreeEntities) {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)folderTreeEntity);
        eventBroker.send("EXPLORER/SET_SELECTED_ITEMS", (Object)newTreeEntities.toArray());
    }

    private List<ITreeEntity> addElementsToRepository(FolderTreeEntity folderTreeEntity, FolderEntity folder) throws Exception {
        CapturedWindowsElementConverter converter = new CapturedWindowsElementConverter();
        ArrayList<ITreeEntity> newTreeEntities = new ArrayList<ITreeEntity>();
        WindowsElementController objectRepositoryController = WindowsElementController.getInstance();
        for (CapturedWindowsElement mobileElement : this.capturedObjectsTableViewer.getAllCheckedElements()) {
            WindowsElementEntity testObject = converter.convert(mobileElement);
            testObject.setParentFolder(folder);
            testObject.setProject(folder.getProject());
            objectRepositoryController.updateWindowsElementEntity(testObject);
            newTreeEntities.add((ITreeEntity)new WindowsElementTreeEntity(testObject, folderTreeEntity));
        }
        return newTreeEntities;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.dispose();
    }

    public void dispose() {
        this.disposed = true;
    }

    protected Point getInitialSize() {
        return DIALOG_SIZE;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setMinimumSize(500, 500);
    }

    private void highlightObject(BasicWindowsElement selectedElement) {
        if (selectedElement == null || this.screenComposite == null || this.screenComposite.isDisposed()) {
            return;
        }
        this.screenComposite.highlightElement(selectedElement);
    }

    @Override
    public void highlightElementRects(List<Rectangle> rects) {
        this.screenComposite.highlightRects(rects);
    }

    private int calculateObjectSpyDialogStartX(Rectangle displayBounds, Point dialogSize) {
        int dialogsWidth = dialogSize.x + 400;
        int startX = (displayBounds.width - dialogsWidth) / 2 + displayBounds.x;
        return Math.max(startX, 0);
    }

    private int calculateObjectSpyDialogStartY(Rectangle displayBounds, Point dialogSize) {
        int startY = displayBounds.height - dialogSize.y;
        return Math.max(startY, 0) / 2;
    }

    @Override
    public void setSelectedElementByLocation(int x, int y) {
        if (this.appRootElement == null) {
            return;
        }
        final TreeWindowsElement foundElement = this.recursivelyFindElementByLocation(this.appRootElement, x, y);
        if (foundElement == null) {
            return;
        }
        this.highlightObject(foundElement);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                WindowsSpyObjectDialog.this.getShell().setFocus();
                WindowsSpyObjectDialog.this.allElementTreeViewer.getTree().setFocus();
                WindowsSpyObjectDialog.this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)foundElement));
            }
        });
    }

    private TreeWindowsElement recursivelyFindElementByLocation(TreeWindowsElement currentElement, int x, int y) {
        for (TreeWindowsElement treeWindowsElement : currentElement.getChildren()) {
            Map<String, String> attributes = treeWindowsElement.getProperties();
            Double elementX = Double.parseDouble(attributes.get("x"));
            Double elementY = Double.parseDouble(attributes.get("y"));
            Double elementWidth = Double.parseDouble(attributes.get("width"));
            Double elementHeight = Double.parseDouble(attributes.get("height"));
            Rectangle rectangle = new Rectangle(WindowsSpyObjectDialog.safeRoundDouble(elementX), WindowsSpyObjectDialog.safeRoundDouble(elementY), WindowsSpyObjectDialog.safeRoundDouble(elementWidth), WindowsSpyObjectDialog.safeRoundDouble(elementHeight));
            if (!rectangle.contains(x, y)) continue;
            return this.recursivelyFindElementByLocation(treeWindowsElement, x, y);
        }
        return currentElement;
    }

    private void captureObjectAction() {
        final ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_JOB_TASK_CAPTURING_OBJECTS, -1);
                dialog.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        (this).WindowsSpyObjectDialog.this.appRootElement = (this).WindowsSpyObjectDialog.this.inspectorController.getWindowsObjectRoot();
                        return null;
                    }
                });
                WindowsSpyObjectDialog.this.checkMonitorCanceled(monitor);
                this.refreshTreeElements(dialog);
                String imgPath = this.captureImage();
                WindowsSpyObjectDialog.this.checkMonitorCanceled(monitor);
                this.refreshDeviceView(imgPath);
                monitor.done();
            }

            private void refreshTreeElements(final ProgressMonitorDialogWithThread dialog2) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        dialog2.setCancelable(false);
                        if ((this).WindowsSpyObjectDialog.this.appRootElement != null) {
                            (this).WindowsSpyObjectDialog.this.allElementTreeViewer.setInput((Object)new Object[]{(this).WindowsSpyObjectDialog.this.appRootElement});
                            (this).WindowsSpyObjectDialog.this.allElementTreeViewer.refresh();
                            (this).WindowsSpyObjectDialog.this.allElementTreeViewer.expandAll();
                            WindowsSpyObjectDialog.this.verifyCapturedElementsStates((this).WindowsSpyObjectDialog.this.capturedObjectsTableViewer.getCapturedElements().toArray(new CapturedWindowsElement[0]));
                        }
                        dialog2.setCancelable(true);
                    }
                });
            }

            private void refreshDeviceView(String imgPath) {
                File imgFile = new File(imgPath);
                if (imgFile.exists()) {
                    WindowsSpyObjectDialog.this.screenComposite.refreshDialog(imgFile);
                }
            }

            private String captureImage() throws InvocationTargetException {
                try {
                    return WindowsSpyObjectDialog.this.inspectorController.captureScreenshot();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.btnCapture.setEnabled(false);
                dialog.run(true, true, runnable);
            }
            catch (InterruptedException interruptedException) {
                this.btnCapture.setEnabled(true);
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable exception = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerMobileObjectspyMessageConstants.DIA_ERROR_UNABLE_TO_CAPTURE_OBJECTS, (String)exception.getClass().getSimpleName());
                this.btnCapture.setEnabled(true);
            }
        }
        finally {
            this.btnCapture.setEnabled(true);
        }
    }

    public String getAppName() {
        return this.mobileComposite.getAppName();
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void startObjectInspectorAction() {
        this.btnStart.setEnabled(false);
        AppiumMonitorDialog progressDlg = new AppiumMonitorDialog(this.getShell()){

            public void cancelPressed() {
                super.cancelPressed();
                this.finishedRun();
                this.getProgressMonitor().done();
                WindowsSpyObjectDialog.this.btnStart.setEnabled(true);
                WindowsSpyObjectDialog.this.btnStop.setEnabled(false);
                WindowsSpyObjectDialog.this.btnCapture.setEnabled(false);
            }
        };
        try {
            this.inspectorController.setStreamHandler((AppiumStreamHandler)progressDlg);
            this.mobileComposite.startApp(this.inspectorController, progressDlg);
            this.captureObjectAction();
            this.btnCapture.setEnabled(true);
            this.btnStop.setEnabled(true);
            Trackings.trackWindowsSpy();
        }
        catch (InterruptedException | InvocationTargetException ex) {
            if (ex instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                String message = targetException instanceof ExecutionException ? targetException.getCause().getMessage() : targetException.getMessage();
                UISynchronizeService.syncExec(() -> MultiStatusErrorDialog.showErrorDialog((String)"Unable to start application", (String)message, (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)targetException)));
                LoggerSingleton.logError((Throwable)targetException);
            }
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
        }
    }

    private void stopObjectInspectorAction() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                WindowsSpyObjectDialog.this.inspectorController.closeApp();
            }
        });
        thread.start();
        if (!this.getShell().isDisposed()) {
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
            if (this.allElementTreeViewer != null) {
                this.allElementTreeViewer.setInput((Object)new Object[0]);
                this.allElementTreeViewer.refresh();
            }
        }
        if (this.screenComposite != null) {
            this.screenComposite.refreshDialog(null);
        }
        this.dispose();
    }

    private boolean validateAppSetting() {
        return this.mobileComposite.validateSetting();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x40 | 0x800 | 0x20);
        this.setBlockOnOpen(false);
    }

    public boolean close() {
        this.stopObjectInspectorAction();
        Trackings.trackCloseWindowsSpy((!this.okPressed ? 1 : 0) != 0);
        boolean result = super.close();
        instance = null;
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle displayBounds = this.getShell().getMonitor().getBounds();
        return new Point(this.calculateObjectSpyDialogStartX(displayBounds, initialSize), this.calculateObjectSpyDialogStartY(displayBounds, initialSize));
    }

    public void addElements(List<WindowsElementEntity> webElements) {
        if (webElements == null) {
            return;
        }
        CapturedWindowsElementConverter converter = new CapturedWindowsElementConverter();
        ArrayList<CapturedWindowsElement> newWindowsElements = new ArrayList<CapturedWindowsElement>();
        for (WindowsElementEntity webElement : webElements) {
            newWindowsElements.add(converter.revert(webElement));
        }
        this.capturedObjectsTableViewer.addWindowsElements(newWindowsElements);
        this.verifyCapturedElementsStates(this.capturedObjectsTableViewer.getSelectedElements());
    }

    public static WindowsSpyObjectDialog getInstance() {
        return instance;
    }

    public static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

