/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.element;

import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.element.TreeWindowsElement;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import io.appium.java_client.windows.WindowsDriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SnapshotWindowsElement
implements TreeWindowsElement {
    public static final String ELEMENT_RECTANGLE = "elementRectangle";
    public static final String ELEMENT_OFFSETS = "elementOffsets";
    private SnapshotWindowsElement parent;
    private List<TreeWindowsElement> children = new ArrayList<TreeWindowsElement>();
    private String name;
    private String tagName;
    private Map<String, String> properties = new HashMap<String, String>();
    private CapturedWindowsElement capturedWindowsElement;
    private String locator;
    private WindowsElementEntity.LocatorStrategy locatorStrategy;
    private String xpath = "";
    private boolean isXpathBuilt;
    private String optionalName = "";
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public SnapshotWindowsElement() {
        this(null);
    }

    public SnapshotWindowsElement(SnapshotWindowsElement parent) {
        this.parent = parent;
    }

    public void render(Element xmlElement) {
        if (xmlElement == null) {
            return;
        }
        this.convertXMLElementToWindowsElement(xmlElement);
        if (!xmlElement.hasChildNodes()) {
            return;
        }
        NodeList childElementNodes = xmlElement.getChildNodes();
        int count = childElementNodes.getLength();
        int i = 0;
        while (i < count) {
            Node node = childElementNodes.item(i);
            if (node instanceof Element) {
                SnapshotWindowsElement childNode = new SnapshotWindowsElement(this);
                this.getChildren().add(childNode);
                childNode.render((Element)node);
            }
            ++i;
        }
    }

    private void convertXMLElementToWindowsElement(Element xmlElement) {
        this.name = this.tagName = xmlElement.getTagName();
        int i = 0;
        while (i < xmlElement.getAttributes().getLength()) {
            Node node = xmlElement.getAttributes().item(i);
            this.properties.put(node.getNodeName(), node.getNodeValue());
            ++i;
        }
        this.optionalName = this.getPropertyValue("Name");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public TreeWindowsElement getParent() {
        return this.parent;
    }

    public List<TreeWindowsElement> getChildren() {
        return this.children;
    }

    @Override
    public CapturedWindowsElement getCapturedElement() {
        return this.capturedWindowsElement;
    }

    @Override
    public CapturedWindowsElement newCapturedElement(WindowsDriver<WebElement> windowsDriver) {
        this.capturedWindowsElement = new CapturedWindowsElement();
        this.capturedWindowsElement.setLink(this);
        this.capturedWindowsElement.setChecked(true);
        this.capturedWindowsElement.setName(this.name);
        this.capturedWindowsElement.setTagName(this.tagName);
        this.capturedWindowsElement.setProperties(new HashMap<String, String>(this.properties));
        this.capturedWindowsElement.setSnapshotWindowsElement(this);
        this.buildLocator(windowsDriver);
        this.capturedWindowsElement.setLocator(this.locator);
        this.capturedWindowsElement.setLocatorStrategy(this.locatorStrategy);
        return this.capturedWindowsElement;
    }

    private void buildLocator(WindowsDriver<WebElement> windowsDriver) {
        List elements;
        List elements2;
        List elements3;
        String name = this.getPropertyValue("Name");
        if (StringUtils.isNotEmpty((CharSequence)name) && (elements3 = windowsDriver.findElementsByName(name)) != null && elements3.size() == 1) {
            this.locator = name;
            this.locatorStrategy = WindowsElementEntity.LocatorStrategy.NAME;
            return;
        }
        String className = this.getPropertyValue("ClassName");
        if (StringUtils.isNotEmpty((CharSequence)className) && (elements2 = windowsDriver.findElementsByClassName(className)) != null && elements2.size() == 1) {
            this.locator = className;
            this.locatorStrategy = WindowsElementEntity.LocatorStrategy.CLASS_NAME;
            return;
        }
        String tagName = this.name;
        if (StringUtils.isNotEmpty((CharSequence)tagName) && (elements = windowsDriver.findElementsByTagName(tagName)) != null && elements.size() == 1) {
            this.locator = tagName;
            this.locatorStrategy = WindowsElementEntity.LocatorStrategy.TAG_NAME;
            return;
        }
        this.locator = this.getXPath();
        this.locatorStrategy = WindowsElementEntity.LocatorStrategy.XPATH;
    }

    public String getXPath() {
        if (this.isXpathBuilt) {
            return this.xpath;
        }
        this.xpath = this.makeXPath();
        this.isXpathBuilt = true;
        return this.xpath;
    }

    private String makeXPath() {
        String xpath;
        int index = this.getIndexPropertyForElement(this.tagName);
        String string = xpath = StringUtils.isEmpty((CharSequence)this.tagName) ? "//*" : "/" + this.tagName;
        if (index > 0) {
            xpath = String.valueOf(xpath) + "[" + index + "]";
        }
        if (this.parent == null) {
            xpath = "/" + xpath;
            return xpath;
        }
        String parentXpath = this.parent.getXPath();
        xpath = String.valueOf(StringUtils.isEmpty((CharSequence)parentXpath) ? "//*" : parentXpath) + xpath;
        return xpath;
    }

    private int getIndexPropertyForElement(String tagName) {
        if (StringUtils.isEmpty((CharSequence)tagName) || this.parent == null) {
            return 0;
        }
        int index = 1;
        for (TreeWindowsElement sibling : this.parent.getChildren()) {
            if (sibling == this) break;
            if (!tagName.equals(sibling.getName())) continue;
            ++index;
        }
        return index;
    }

    public String getPropertyValue(String propertyName) {
        Optional<String> optProperty = this.properties.entrySet().stream().filter(e -> ((String)e.getKey()).equals(propertyName)).map(e -> (String)e.getValue()).findFirst();
        return optProperty.isPresent() ? optProperty.get() : "";
    }

    @Override
    public void setCapturedElement(CapturedWindowsElement object) {
        this.capturedWindowsElement = object;
    }

    @Override
    public TreeWindowsElement findBestMatch(CapturedWindowsElement needToVerify) {
        return null;
    }

    public void setParent(SnapshotWindowsElement parent) {
        this.parent = parent;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String getOptinalName() {
        return this.optionalName;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metadata;
    }
}

