/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.handler;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.windows.part.WindowsObjectPart;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenWindowsElementHandler {
    private static final String WINDOWS_OBJECT_PART_URI = "bundleclass://com.kms.katalon.composer.windows/" + WindowsObjectPart.class.getName();
    private static OpenWindowsElementHandler instance;
    @Inject
    private MApplication application;
    @Inject
    private static EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;

    @PostConstruct
    public void onCreated() {
        instance = this;
    }

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof WindowsElementEntity) {
                    OpenWindowsElementHandler.this.openWindowsElement((WindowsElementEntity)object);
                }
            }
        });
    }

    public static OpenWindowsElementHandler getInstance() {
        return instance;
    }

    @Inject
    @Optional
    private void getNotifications(@UIEventTopic(value="WINDOWS_TEST_OBJECT/OPEN") WindowsElementEntity entity) {
        this.openWindowsElement(entity);
    }

    public void openWindowsElement(WindowsElementEntity windowsElementEntity) {
        try {
            if (windowsElementEntity != null) {
                String partId = EntityPartUtil.getWindowsTestObjectPartId((String)windowsElementEntity.getId());
                MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
                MPart mPart = (MPart)modelService.find(partId, (MUIElement)this.application);
                if (mPart == null) {
                    mPart = (MPart)modelService.createModelElement(MPart.class);
                    mPart.setElementId(partId);
                    mPart.setLabel(windowsElementEntity.getName());
                    mPart.setContributionURI(WINDOWS_OBJECT_PART_URI);
                    mPart.setIconURI(ImageManager.getImageURLString((String)"windows_application_16.png"));
                    mPart.setCloseable(true);
                    mPart.setTooltip(windowsElementEntity.getIdForDisplay());
                    stack.getChildren().add(mPart);
                }
                if (mPart.getObject() == null) {
                    mPart.setObject((Object)windowsElementEntity);
                }
                this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
                stack.setSelectedElement((MUIElement)mPart);
                Trackings.trackOpenObject((String)"windowsObject");
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

