/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.preferences;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.components.DriverPropertyMapComposite;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.ImportDesiredCapabilitiesDialog;
import com.kms.katalon.composer.windows.constant.ComposerWindowsMessage;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.inject.Named;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WindowsExecutionSettingPage
extends PreferencePage {
    private DriverPropertyMapComposite driverPropertyMapComposite;
    private WindowsDriverConnector windowsDriverConnector;
    private Text txtUrl;
    private Button btnImport;
    private Button btnExport;
    @Named(value="activeShell")
    private Shell parentShell;

    public WindowsExecutionSettingPage() {
        this.initilize();
    }

    private void initilize() {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            this.windowsDriverConnector = new WindowsDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected Control createContents(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        Composite driverUrlCompsite = new Composite(mainComposite, 0);
        driverUrlCompsite.setLayoutData((Object)new GridData(4, 128, true, false));
        driverUrlCompsite.setLayout((Layout)new GridLayout(2, false));
        Label lblUrl = new Label(driverUrlCompsite, 0);
        lblUrl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblUrl.setText(ComposerWindowsMessage.LBL_WIN_APP_URL);
        this.txtUrl = new Text(driverUrlCompsite, 2048);
        this.txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite desiredCapabilitiesComposite = new Composite(mainComposite, 0);
        desiredCapabilitiesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        desiredCapabilitiesComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblDesiredCapabilities = new Label(desiredCapabilitiesComposite, 0);
        lblDesiredCapabilities.setText(ComposerWindowsMessage.LBL_DESIRED_CAPABILITIES);
        ControlUtils.setFontToBeBold((Control)lblDesiredCapabilities);
        this.driverPropertyMapComposite = new DriverPropertyMapComposite(desiredCapabilitiesComposite);
        this.updatePropertiesToUI();
        return mainComposite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite buttonBar = this.getApplyButton().getParent();
        GridLayout buttonBarLayout = (GridLayout)buttonBar.getLayout();
        buttonBarLayout.numColumns += 2;
        this.btnImport = new Button(buttonBar, 0x1000000);
        this.btnImport.setText(ComposerExecutionMessageConstants.BTN_IMPORT);
        this.setButtonLayoutData(this.btnImport);
        this.btnImport.moveAbove((Control)this.getDefaultsButton());
        this.btnExport = new Button(buttonBar, 0x1000000);
        this.btnExport.setText(ComposerExecutionMessageConstants.BTN_EXPORT);
        this.setButtonLayoutData(this.btnExport);
        this.btnExport.moveAbove((Control)this.getDefaultsButton());
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!WindowsExecutionSettingPage.this.canUseImportExportDesiredCapabilities()) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                ImportDesiredCapabilitiesDialog importDialog = new ImportDesiredCapabilitiesDialog(WindowsExecutionSettingPage.this.getShell());
                if (importDialog.open() == 0) {
                    WindowsExecutionSettingPage.this.importPropertiesFromFile(importDialog.getFilePath(), importDialog.isOverridingExistingProperties());
                }
            }
        });
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!WindowsExecutionSettingPage.this.canUseImportExportDesiredCapabilities()) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                FileDialog exportFileDialog = new FileDialog(WindowsExecutionSettingPage.this.getShell(), 8192);
                exportFileDialog.setFilterNames(StringConstants.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_NAMES);
                exportFileDialog.setFilterExtensions(StringConstants.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_EXTS);
                exportFileDialog.setOverwrite(true);
                exportFileDialog.setFileName(String.valueOf(WindowsExecutionSettingPage.this.windowsDriverConnector.getDriverType().getName().toLowerCase()) + "_caps.json");
                String exportFilePath = exportFileDialog.open();
                if (exportFilePath != null) {
                    WindowsExecutionSettingPage.this.exportPropertiesToFile(exportFilePath);
                }
            }
        });
    }

    private void updatePropertiesToUI() {
        String driverUrl = this.windowsDriverConnector.getWinAppDriverUrl();
        if (driverUrl == null) {
            driverUrl = "";
        }
        this.txtUrl.setText(driverUrl);
        this.driverPropertyMapComposite.setInput(new HashMap(this.windowsDriverConnector.getDesiredCapabilities()));
    }

    private void updateInputToDriverConnector() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("winAppDriverUrl", this.txtUrl.getText());
        properties.put("desiredCapabilities", this.driverPropertyMapComposite.getDriverProperties());
        this.windowsDriverConnector.setUserConfigProperties(properties);
    }

    private void importPropertiesFromFile(String importFilePath, boolean isOverridingExistingProperties) {
        try {
            this.updateInputToDriverConnector();
            this.windowsDriverConnector.importConfigProperties(importFilePath, isOverridingExistingProperties);
            this.updatePropertiesToUI();
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_CANNOT_IMPORT_DESIRED_CAPABILITIES, importFilePath), (String)exception.getMessage());
        }
    }

    private void exportPropertiesToFile(String exportFilePath) {
        try {
            this.updateInputToDriverConnector();
            this.windowsDriverConnector.exportConfigProperties(exportFilePath);
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_CANNOT_EXPORT_DESIRED_CAPABILITIES, exportFilePath), (String)exception.getMessage());
        }
    }

    private boolean canUseImportExportDesiredCapabilities() {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        return featureService.canUse(KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return true;
        }
        this.updateInputToDriverConnector();
        try {
            this.windowsDriverConnector.saveUserConfigProperties();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)GlobalStringConstants.ERROR, (String)ComposerWindowsMessage.MSG_CANNOT_SAVE_WINDOWS_DESIRED_CAPABILITIES_SETTINGS);
        }
        return true;
    }
}

