/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.socket;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.windows.action.WindowsAction;
import com.kms.katalon.composer.windows.action.WindowsActionMapping;
import com.kms.katalon.composer.windows.constant.ComposerWindowsMessage;
import com.kms.katalon.composer.windows.dialog.WindowsRecorderDialogV2;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.record.model.RecordedElementLocatorHelper;
import com.kms.katalon.composer.windows.record.model.WindowsAppClosedPayload;
import com.kms.katalon.composer.windows.record.model.WindowsRecordedPayload;
import com.kms.katalon.composer.windows.record.model.WindowsStartAppPayload;
import com.kms.katalon.composer.windows.socket.WindowsClientSocketMessage;
import com.kms.katalon.composer.windows.socket.WindowsServerSocketMessage;
import com.kms.katalon.composer.windows.socket.WindowsSocketMessageUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.swt.widgets.Shell;

public class WindowsSocketServer {
    private ServerSocket server;
    private Socket socket;
    private boolean shouldReturn = false;
    private WindowsRecorderDialogV2 recorderDialog;
    private boolean isClientConnected = false;

    public WindowsSocketServer(WindowsRecorderDialogV2 recorderDialog) {
        this.recorderDialog = recorderDialog;
    }

    public void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block37: {
                    try {
                        try {
                            if (WindowsSocketServer.this.server == null) {
                                WindowsSocketServer.this.server = new ServerSocket(50005);
                            }
                            while (!WindowsSocketServer.this.shouldReturn) {
                                System.out.println("Waiting for the client request");
                                try {
                                    WindowsSocketServer.this.socket = WindowsSocketServer.this.server.accept();
                                    Throwable throwable = null;
                                    Object var2_5 = null;
                                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(WindowsSocketServer.this.socket.getInputStream(), "UTF8"));){
                                        String line = null;
                                        while ((line = reader.readLine()) != null) {
                                            WindowsSocketServer.this.analyseMessage(line);
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException ex) {
                                    LoggerSingleton.logError((Throwable)ex);
                                    WindowsSocketServer.this.isClientConnected = false;
                                }
                            }
                        }
                        catch (Exception exception) {
                            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerWindowsMessage.MSG_KATALON_NATIVE_RECORDER_SERVER_EXCEPTION, (String)exception.getMessage(), (Shell)WindowsSocketServer.this.recorderDialog.getShell());
                            LoggerSingleton.logError((Throwable)exception);
                            if (WindowsSocketServer.this.socket != null && !WindowsSocketServer.this.socket.isClosed()) {
                                try {
                                    WindowsSocketServer.this.socket.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (WindowsSocketServer.this.server != null && !WindowsSocketServer.this.server.isClosed()) {
                                try {
                                    WindowsSocketServer.this.server.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        if (WindowsSocketServer.this.socket != null && !WindowsSocketServer.this.socket.isClosed()) {
                            try {
                                WindowsSocketServer.this.socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (WindowsSocketServer.this.server != null && !WindowsSocketServer.this.server.isClosed()) {
                            try {
                                WindowsSocketServer.this.server.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (WindowsSocketServer.this.socket != null && !WindowsSocketServer.this.socket.isClosed()) {
                        try {
                            WindowsSocketServer.this.socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (WindowsSocketServer.this.server != null && !WindowsSocketServer.this.server.isClosed()) {
                        try {
                            WindowsSocketServer.this.server.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
        thread.start();
    }

    private void analyseMessage(String message) {
        WindowsClientSocketMessage clientMessage = WindowsSocketMessageUtil.parseClientMessage(message);
        switch (clientMessage.getType()) {
            case CONNECT: {
                this.isClientConnected = true;
                return;
            }
            case APP_INFO: {
                WindowsStartAppPayload payload = (WindowsStartAppPayload)JsonUtil.fromJson((String)clientMessage.getData(), WindowsStartAppPayload.class);
                if (payload.isSuccess()) {
                    WindowsActionMapping actionMapping = new WindowsActionMapping(WindowsAction.StartApplicationWithTitle, null);
                    actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)payload.getAppPath()));
                    actionMapping.getData()[1].setValue(new ConstantExpressionWrapper((Object)payload.getAppTitle()));
                    this.recorderDialog.addActionMapping(actionMapping);
                } else {
                    UISynchronizeService.asyncExec(() -> {
                        this.recorderDialog.setStarting(false);
                        this.recorderDialog.refreshButtonsState();
                        LoggerSingleton.logError((String)payload.getMessage());
                        MultiStatusErrorDialog.showErrorDialog((String)ComposerWindowsMessage.MSG_FAILED_START_APPLICATION, (String)payload.getMessage(), (String)payload.getAppPath(), (Shell)this.recorderDialog.getShell());
                    });
                }
                return;
            }
            case APP_CLOSED_UNEXPECTEDLY: {
                WindowsAppClosedPayload payload = (WindowsAppClosedPayload)JsonUtil.fromJson((String)clientMessage.getData(), WindowsAppClosedPayload.class);
                UISynchronizeService.asyncExec(() -> {
                    this.recorderDialog.setStarting(false);
                    this.recorderDialog.refreshButtonsState();
                    if (payload.isUnexpectedly()) {
                        LoggerSingleton.logError((String)payload.getMessage());
                        MultiStatusErrorDialog.showErrorDialog((String)ComposerWindowsMessage.MSG_APP_CLOSED_UNEXPECTEDLY, (String)payload.getMessage(), (String)payload.getAppPath(), (Shell)this.recorderDialog.getShell());
                    }
                });
                break;
            }
            case RECORDING_ACTION: {
                try {
                    WindowsRecordedPayload payload = (WindowsRecordedPayload)JsonUtil.fromJson((String)clientMessage.getData(), WindowsRecordedPayload.class);
                    RecordedElementLocatorHelper locatorHelper = new RecordedElementLocatorHelper(payload);
                    CapturedWindowsElement element = locatorHelper.getCapturedElement();
                    WindowsActionMapping actionMapping = null;
                    switch (payload.getActionName()) {
                        case "click": {
                            if (this.recorderDialog.isCoordinateBasedRecordingEnabled()) {
                                actionMapping = new WindowsActionMapping(WindowsAction.ClickElementOffset, element);
                                actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)payload.getOffsetX()));
                                actionMapping.getData()[1].setValue(new ConstantExpressionWrapper((Object)payload.getOffsetY()));
                                break;
                            }
                            actionMapping = new WindowsActionMapping(WindowsAction.Click, element);
                            break;
                        }
                        case "rightClick": {
                            if (this.recorderDialog.isCoordinateBasedRecordingEnabled()) {
                                actionMapping = new WindowsActionMapping(WindowsAction.RightClickElementOffset, element);
                                actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)payload.getOffsetX()));
                                actionMapping.getData()[1].setValue(new ConstantExpressionWrapper((Object)payload.getOffsetY()));
                                break;
                            }
                            actionMapping = new WindowsActionMapping(WindowsAction.RightClick, element);
                            break;
                        }
                        case "setText": {
                            actionMapping = new WindowsActionMapping(WindowsAction.SetText, element);
                            actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)payload.getActionData()));
                        }
                    }
                    actionMapping.setRecordedTime(payload.getRecordedTime());
                    this.recorderDialog.addActionMapping(actionMapping);
                    break;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
    }

    public void sendMessage(String message) throws IOException {
        OutputStream os = this.socket.getOutputStream();
        os.write(message.getBytes());
    }

    public void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.sendMessage(WindowsSocketMessageUtil.createServerMessage(WindowsServerSocketMessage.ServerMessageType.EXIT, ""));
            }
            catch (IOException iOException) {}
        }
        try {
            if (this.server != null && !this.server.isClosed()) {
                this.server.close();
            }
        }
        catch (IOException iOException) {}
        this.shouldReturn = true;
    }

    public boolean isClientConnected() {
        return this.isClientConnected;
    }
}

