/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.spy;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.helper.WindowsElementHelper;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.dal.fileservice.dataprovider.EntityNameFileServiceDataProvider;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WindowsElementPropertiesComposite {
    private static final int DF_LABEL_WIDTH_HINT = 120;
    private Text txtObjectName;
    private CapturedWindowsElement editingElement;
    private TableViewer attributesTableViewer;
    private WindowsObjectDialog dialog;
    private Combo cbbLocatorStrategy;
    private StyledText txtLocator;
    private static String[] strategies = WindowsElementEntity.LocatorStrategy.getStrategies();

    public WindowsElementPropertiesComposite(WindowsObjectDialog dialog) {
        this.dialog = dialog;
    }

    public void setEditingElement(CapturedWindowsElement editingElement) {
        this.editingElement = editingElement;
        this.refreshAttributesTable();
    }

    public Composite createObjectPropertiesComposite(Composite parent) {
        Composite objectPropertiesComposite = new Composite(parent, 0);
        GridLayout glObjectPropertiesComposite = new GridLayout(2, false);
        objectPropertiesComposite.setLayout((Layout)glObjectPropertiesComposite);
        Label lblObjectProperties = new Label(objectPropertiesComposite, 0);
        lblObjectProperties.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ControlUtils.setFontToBeBold((Control)lblObjectProperties);
        lblObjectProperties.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_OBJECT_PROPERTIES);
        Label objectNameLabel = new Label(objectPropertiesComposite, 0);
        GridData gdObjectNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdObjectNameLabel.widthHint = 120;
        objectNameLabel.setLayoutData((Object)gdObjectNameLabel);
        objectNameLabel.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_OBJECT_NAME);
        this.txtObjectName = new Text(objectPropertiesComposite, 2048);
        this.txtObjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtObjectName.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TOOLTIP_OBJECT_NAME);
        Composite locatorComposite = new Composite(objectPropertiesComposite, 0);
        GridLayout glLocatorComposite = new GridLayout(2, false);
        glLocatorComposite.marginWidth = 0;
        glLocatorComposite.marginHeight = 0;
        locatorComposite.setLayout((Layout)glLocatorComposite);
        locatorComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label lblLocatorStrategy = new Label(locatorComposite, 0);
        lblLocatorStrategy.setText("Locator Strategy");
        GridData gdLocatorStrategy = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLocatorStrategy.widthHint = 120;
        lblLocatorStrategy.setLayoutData((Object)gdLocatorStrategy);
        Composite locatorStrategyComposite = new Composite(locatorComposite, 0);
        GridLayout glLocatorStrategyComposite = new GridLayout(2, false);
        glLocatorStrategyComposite.marginWidth = 0;
        glLocatorStrategyComposite.marginHeight = 0;
        locatorStrategyComposite.setLayout((Layout)glLocatorStrategyComposite);
        locatorStrategyComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.cbbLocatorStrategy = new Combo(locatorStrategyComposite, 8);
        this.cbbLocatorStrategy.setItems(strategies);
        Button btnGenerateLocator = new Button(locatorStrategyComposite, 8);
        btnGenerateLocator.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        btnGenerateLocator.setText(ComposerMobileObjectspyMessageConstants.DIA_BTN_GENERATE);
        btnGenerateLocator.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TOOLTIP_GENERATE_LOCATOR);
        btnGenerateLocator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsElementPropertiesComposite.this.setLocatorByLocatorStrategy();
            }
        });
        Label lblLocator = new Label(locatorComposite, 0);
        GridData gdLocator = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLocator.widthHint = 120;
        lblLocator.setLayoutData((Object)gdLocator);
        lblLocator.setText("Locator");
        this.txtLocator = new StyledText(locatorComposite, 2624);
        GridData gdTxtEditor = new GridData(4, 4, true, false);
        gdTxtEditor.heightHint = 50;
        this.txtLocator.setLayoutData((Object)gdTxtEditor);
        Composite attributesTableComposite = new Composite(objectPropertiesComposite, 0);
        attributesTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        attributesTableComposite.setLayout((Layout)tableColumnLayout);
        this.attributesTableViewer = new CTableViewer(attributesTableComposite, 68354);
        this.createColumns(this.attributesTableViewer, tableColumnLayout);
        Table attributesTable = this.attributesTableViewer.getTable();
        attributesTable.setHeaderVisible(true);
        attributesTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)attributesTable.getDisplay()));
        this.attributesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.attributesTableViewer.setInput(Collections.emptyList());
        this.registerControlModifyListeners();
        return objectPropertiesComposite;
    }

    private void commitEditingName() {
        if (this.editingElement == null || this.txtObjectName.isDisposed()) {
            return;
        }
        String objectName = this.txtObjectName.getText();
        if (StringUtils.isNotBlank((CharSequence)objectName) && !StringUtils.equals((CharSequence)this.editingElement.getName(), (CharSequence)objectName)) {
            this.editingElement.setName(objectName);
            this.dialog.updateSelectedElement(this.editingElement);
        }
    }

    private void registerControlModifyListeners() {
        this.txtLocator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (WindowsElementPropertiesComposite.this.editingElement != null) {
                    WindowsElementPropertiesComposite.this.editingElement.setLocator(WindowsElementPropertiesComposite.this.txtLocator.getText());
                }
            }
        });
        this.cbbLocatorStrategy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WindowsElementPropertiesComposite.this.editingElement == null) {
                    return;
                }
                int index = WindowsElementPropertiesComposite.this.cbbLocatorStrategy.getSelectionIndex();
                WindowsElementPropertiesComposite.this.editingElement.setLocatorStrategy(WindowsElementEntity.LocatorStrategy.valueOfStrategy((String)strategies[index]));
            }
        });
        this.txtObjectName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text source = (Text)e.widget;
                String oldS = source.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                if (WindowsElementPropertiesComposite.this.editingElement != null) {
                    try {
                        new EntityNameFileServiceDataProvider().validateName(newS);
                    }
                    catch (Exception invalidName) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Invalid name", (String)invalidName.getMessage());
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.txtObjectName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WindowsElementPropertiesComposite.this.commitEditingName();
            }
        });
        this.txtObjectName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (WindowsElementPropertiesComposite.this.editingElement == null) {
                    return;
                }
                int keyCode = e.keyCode;
                switch (keyCode) {
                    case 13: 
                    case 0x1000050: {
                        WindowsElementPropertiesComposite.this.commitEditingName();
                    }
                }
            }
        });
        this.attributesTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection selection = (StructuredSelection)WindowsElementPropertiesComposite.this.attributesTableViewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                if (e.keyCode == 127) {
                    Map<String, String> allAttributes = WindowsElementPropertiesComposite.this.editingElement.getLink().getProperties();
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectedEntry = objectArray[n2];
                        allAttributes.remove(((Map.Entry)selectedEntry).getKey());
                        ++n2;
                    }
                    WindowsElementPropertiesComposite.this.refreshAttributesTable();
                }
            }
        });
    }

    private void setLocatorByLocatorStrategy() {
        WindowsElementEntity.LocatorStrategy locatorStrategy = this.editingElement.getLocatorStrategy();
        String locator = WindowsElementHelper.getLocatorByStrategy(locatorStrategy, this.editingElement);
        this.editingElement.setLocator(locator);
        this.txtLocator.setText(StringUtils.defaultString((String)locator));
    }

    private void createColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn keyColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        keyColumn.getColumn().setText(GlobalStringConstants.NAME);
        keyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return WindowsElementPropertiesComposite.this.getTextForEntryKey(element);
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        valueColumn.getColumn().setText(GlobalStringConstants.VALUE);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return WindowsElementPropertiesComposite.this.getTextForEntryValue(element);
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.attributesTableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof Map.Entry && value instanceof String) {
                    Map.Entry entry = (Map.Entry)element;
                    entry.setValue(String.valueOf(value));
                    WindowsElementPropertiesComposite.this.attributesTableViewer.refresh(element);
                }
            }

            protected Object getValue(Object element) {
                return WindowsElementPropertiesComposite.this.getTextForEntryValue(element);
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof Map.Entry) {
                    return new TextCellEditor((Composite)WindowsElementPropertiesComposite.this.attributesTableViewer.getTable());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Map.Entry;
            }
        });
        tableColumnLayout.setColumnData((Widget)keyColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 150, true));
        tableColumnLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 150, true));
    }

    private String getTextForEntryKey(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryKey = (String)entry.getKey();
        if (entryKey != null) {
            return entryKey.toString();
        }
        return "";
    }

    private String getTextForEntryValue(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryValue = (String)entry.getValue();
        if (entryValue != null) {
            return entryValue.toString();
        }
        return "";
    }

    private void refreshAttributesTable() {
        if (this.attributesTableViewer == null || this.attributesTableViewer.getTable().isDisposed()) {
            return;
        }
        if (this.editingElement != null) {
            this.txtObjectName.setText(this.editingElement.getName());
            this.txtLocator.setText(StringUtils.defaultString((String)this.editingElement.getLocator()));
            int selectedIndex = Arrays.asList(strategies).indexOf(this.editingElement.getLocatorStrategy().getLocatorStrategy());
            this.cbbLocatorStrategy.select(selectedIndex);
            this.attributesTableViewer.setInput(new ArrayList<Map.Entry<String, String>>(this.editingElement.getProperties().entrySet()));
        } else {
            this.txtObjectName.setText("");
            this.attributesTableViewer.setInput(Collections.emptyList());
            this.txtLocator.setText("");
        }
        this.attributesTableViewer.refresh();
        if (OSUtil.isMacBigSurOrLater()) {
            this.attributesTableViewer.getTable().redraw();
        }
    }

    public void focusAndEditCapturedElementName() {
        this.txtObjectName.setFocus();
        this.txtObjectName.selectAll();
    }

    public CapturedWindowsElement getEditingElement() {
        return this.editingElement;
    }
}

