/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.utils;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.git.components.utils.CheckoutLocalBranchSourceSelectionDialog;
import com.kms.katalon.composer.integration.git.components.utils.CustomBranchProjectTracker;
import com.kms.katalon.composer.integration.git.components.utils.CustomMultiBranchOperationResultDialog;
import com.kms.katalon.composer.integration.git.components.utils.CustomProjectTrackerMemento;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CustomBranchOperationUI {
    private final Repository[] repositories;
    private String target;
    private boolean isSingleRepositoryOperation;
    private final boolean showQuestionsBeforeCheckout;

    public static CustomBranchOperationUI prepareCheckout(Repository[] repositories, String target) {
        return new CustomBranchOperationUI(repositories, target, true);
    }

    public static CustomBranchOperationUI prepareCheckout(Repository repository, String target) {
        return CustomBranchOperationUI.prepareCheckout(repository, target, true);
    }

    public static CustomBranchOperationUI prepareCheckout(Repository repository) {
        return CustomBranchOperationUI.prepareCheckout(repository, null, true);
    }

    public static CustomBranchOperationUI prepareCheckout(Repository repository, String target, boolean showQuestionsBeforeCheckout) {
        return new CustomBranchOperationUI(new Repository[]{repository}, target, showQuestionsBeforeCheckout);
    }

    public static boolean checkoutWillShowQuestionDialog(String refName) {
        return CustomBranchOperationUI.shouldShowCheckoutRemoteTrackingDialog(refName);
    }

    private CustomBranchOperationUI(Repository[] repositories, String target, boolean showQuestionsBeforeCheckout) {
        this.repositories = repositories;
        this.target = target;
        this.isSingleRepositoryOperation = repositories.length == 1;
        this.showQuestionsBeforeCheckout = this.isSingleRepositoryOperation ? showQuestionsBeforeCheckout : false;
    }

    private String confirmTarget(IProgressMonitor monitor) {
        Optional<Repository> invalidRepo = Stream.of(this.repositories).filter(r -> !r.getRepositoryState().canCheckout()).findFirst();
        if (invalidRepo.isPresent()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.showRepositoryInInvalidStateForCheckout((Repository)invalidRepo.get()));
            return null;
        }
        List<Repository> repos = Arrays.asList(this.repositories);
        if (LaunchFinder.shouldCancelBecauseOfRunningLaunches(repos, (IProgressMonitor)monitor)) {
            return null;
        }
        this.askForTargetIfNecessary();
        return this.target;
    }

    private void showRepositoryInInvalidStateForCheckout(Repository repo) {
        String repoName = RepositoryUtil.INSTANCE.getRepositoryName(repo);
        String description = repo.getRepositoryState().getDescription();
        String message = NLS.bind((String)UIText.BranchAction_repositoryState, (Object)repoName, (Object)description);
        MessageDialog.openError((Shell)this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)message);
    }

    private void doCheckout(BranchOperation bop, boolean restore, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(restore ? 10 : 1));
        if (!restore) {
            bop.execute((IProgressMonitor)progress.newChild(1));
        } else {
            final CustomBranchProjectTracker tracker = new CustomBranchProjectTracker(this.repositories);
            CustomProjectTrackerMemento snapshot = tracker.snapshot();
            bop.execute((IProgressMonitor)progress.newChild(7));
            tracker.save(snapshot);
            IWorkspaceRunnable action = new IWorkspaceRunnable(){

                public void run(IProgressMonitor innerMonitor) throws CoreException {
                    tracker.restore(innerMonitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(action, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)progress.newChild(3));
        }
    }

    public void startCheckout() {
        this.target = this.confirmTarget((IProgressMonitor)new NullProgressMonitor());
        if (this.target == null) {
            return;
        }
        String jobname = CustomBranchOperationUI.getJobName(this.repositories, this.target);
        boolean restore = Activator.getDefault().getPreferenceStore().getBoolean("restore_projects_on_checkout");
        final CheckoutJob job = new CheckoutJob(jobname, restore);
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                CustomBranchOperationUI.this.show(job.getCheckoutResult());
            }
        });
        job.schedule();
    }

    private static String getJobName(Repository[] repos, String target) {
        if (repos.length > 1) {
            return NLS.bind((String)UIText.BranchAction_checkingOutMultiple, (Object)target);
        }
        String repoName = RepositoryUtil.INSTANCE.getRepositoryName(repos[0]);
        return NLS.bind((String)UIText.BranchAction_checkingOut, (Object)repoName, (Object)target);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.target = this.confirmTarget((IProgressMonitor)progress.newChild(20));
        if (this.target == null) {
            return;
        }
        boolean restore = Activator.getDefault().getPreferenceStore().getBoolean("restore_projects_on_checkout");
        BranchOperation bop = new BranchOperation(this.repositories, this.target, !restore);
        this.doCheckout(bop, restore, (IProgressMonitor)progress.newChild(80));
        this.show(bop.getResults());
    }

    private void askForTargetIfNecessary() {
        if (this.target == null) {
            this.target = this.getGitBranchRefName();
        }
        if (this.target == null || !this.showQuestionsBeforeCheckout || !CustomBranchOperationUI.shouldShowCheckoutRemoteTrackingDialog(this.target)) {
            return;
        }
        this.target = this.getTargetWithCheckoutRemoteTrackingDialog(this.repositories[0]);
    }

    private String getGitBranchRefName() {
        CheckoutLocalBranchSourceSelectionDialog dialog;
        try {
            dialog = new CheckoutLocalBranchSourceSelectionDialog(this.getShell(), this.repositories[0], this.repositories[0].getFullBranch());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getRefName();
    }

    private static boolean shouldShowCheckoutRemoteTrackingDialog(String refName) {
        boolean isRemoteTrackingBranch;
        boolean bl = isRemoteTrackingBranch = refName != null && refName.startsWith("refs/remotes/");
        if (isRemoteTrackingBranch) {
            boolean showDetachedHeadWarning = Activator.getDefault().getPreferenceStore().getBoolean("show_detached_head_warning");
            return showDetachedHeadWarning;
        }
        return false;
    }

    private String getTargetWithCheckoutRemoteTrackingDialog(Repository repo) {
        String[] dialogResult = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            String string = this.getTargetWithCheckoutRemoteTrackingDialogInUI(repo);
        });
        return dialogResult[0];
    }

    private String getTargetWithCheckoutRemoteTrackingDialogInUI(Repository repo) {
        String[] buttons = new String[]{UIText.BranchOperationUI_CheckoutRemoteTrackingAsLocal, UIText.BranchOperationUI_CheckoutRemoteTrackingCommit, IDialogConstants.CANCEL_LABEL};
        MessageDialog questionDialog = new MessageDialog(this.getShell(), UIText.BranchOperationUI_CheckoutRemoteTrackingTitle, null, UIText.BranchOperationUI_CheckoutRemoteTrackingQuestion, 3, buttons, 0);
        int result = questionDialog.open();
        if (result == 0) {
            CreateBranchWizard wizard = new CreateBranchWizard(repo, this.target);
            WizardDialog createBranchDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            createBranchDialog.open();
            return null;
        }
        if (result == 1) {
            return this.target;
        }
        return null;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    private void show(@NonNull Map<Repository, CheckoutResult> results) {
        if (this.allBranchOperationsSucceeded(results)) {
            if (this.anyRepositoryIsInDetachedHeadState(results)) {
                this.showDetachedHeadWarning();
            }
            return;
        }
        if (this.isSingleRepositoryOperation) {
            Repository repo = this.repositories[0];
            CheckoutResult result = results.get(repo);
            CustomBranchOperationUI.handleSingleRepositoryCheckoutOperationResult(repo, result, this.target);
        } else {
            this.handleMultipleRepositoryCheckoutError(results);
        }
    }

    private boolean allBranchOperationsSucceeded(@NonNull Map<Repository, CheckoutResult> results) {
        return results.values().stream().allMatch(r -> r.getStatus() == CheckoutResult.Status.OK);
    }

    private boolean anyRepositoryIsInDetachedHeadState(@NonNull Map<Repository, CheckoutResult> results) {
        return results.keySet().stream().anyMatch(RepositoryUtil::isDetachedHead);
    }

    public static void handleSingleRepositoryCheckoutOperationResult(Repository repository, CheckoutResult result, String target) {
        switch (result.getStatus()) {
            case CONFLICTS: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    if (UIRepositoryUtils.showCleanupDialog((Repository)repository, (List)result.getConflictList(), (String)UIText.BranchResultDialog_CheckoutConflictsTitle, (Shell)shell)) {
                        CustomBranchOperationUI.prepareCheckout(repository, target, false).startCheckout();
                    }
                });
                break;
            }
            case NONDELETED: {
                boolean show = false;
                List pathList = result.getUndeletedList();
                for (String path : pathList) {
                    if (!new File(repository.getWorkTree(), path).exists()) continue;
                    show = true;
                    break;
                }
                if (!show) {
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new NonDeletedFilesDialog(shell, repository, result.getUndeletedList()).open();
                });
                break;
            }
            case OK: {
                return;
            }
            case NOT_TRIED: 
            case ERROR: {
                String repoName = RepositoryUtil.INSTANCE.getRepositoryName(repository);
                String message = NLS.bind((String)UIText.BranchOperationUI_CheckoutError_DialogMessage, (Object)repoName, (Object)target);
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openError((Shell)shell, (String)UIText.BranchOperationUI_CheckoutError_DialogTitle, (String)message);
                });
            }
        }
    }

    private void handleMultipleRepositoryCheckoutError(Map<Repository, CheckoutResult> results) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new CustomMultiBranchOperationResultDialog(shell, results).open();
        });
    }

    private void showDetachedHeadWarning() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            if (store.getBoolean("show_detached_head_warning")) {
                String toggleMessage = UIText.BranchResultDialog_DetachedHeadWarningDontShowAgain;
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), UIText.BranchOperationUI_DetachedHeadTitle, null, UIText.BranchOperationUI_DetachedHeadMessage, 2, new String[]{IDialogConstants.CLOSE_LABEL}, 0, toggleMessage, false);
                dialog.open();
                if (dialog.getToggleState()) {
                    store.setValue("show_detached_head_warning", false);
                }
            }
        });
    }

    private class CheckoutJob
    extends Job {
        private BranchOperation bop;
        private final boolean restore;

        public CheckoutJob(String jobName, boolean restore) {
            super(jobName);
            this.restore = restore;
        }

        public IStatus run(IProgressMonitor monitor) {
            this.bop = new BranchOperation(CustomBranchOperationUI.this.repositories, CustomBranchOperationUI.this.target, !this.restore);
            try {
                try {
                    CustomBranchOperationUI.this.doCheckout(this.bop, this.restore, monitor);
                }
                catch (CoreException e) {
                    block9: {
                        if (!CustomBranchOperationUI.this.isSingleRepositoryOperation) {
                            IStatus iStatus = Status.OK_STATUS;
                            GitLightweightDecorator.refresh();
                            monitor.done();
                            return iStatus;
                        }
                        CheckoutResult result = this.bop.getResult(CustomBranchOperationUI.this.repositories[0]);
                        if (result.getStatus() != CheckoutResult.Status.CONFLICTS && result.getStatus() != CheckoutResult.Status.NONDELETED) break block9;
                        IStatus iStatus = Status.OK_STATUS;
                        GitLightweightDecorator.refresh();
                        monitor.done();
                        return iStatus;
                    }
                    IStatus iStatus = Activator.createErrorStatus((String)UIText.BranchAction_branchFailed, (Throwable)e);
                    GitLightweightDecorator.refresh();
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                GitLightweightDecorator.refresh();
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return JobFamilies.CHECKOUT.equals(family) || super.belongsTo(family);
        }

        @NonNull
        public Map<Repository, CheckoutResult> getCheckoutResult() {
            return this.bop.getResults();
        }
    }
}

