/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.git.components.utils.Protocol;
import com.kms.katalon.composer.integration.git.components.wizards.CustomPullWizardPage;
import com.kms.katalon.composer.integration.git.components.wizards.CustomRepositorySelectionPage;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.pull.PullOperationUI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class CustomPullWizard
extends Wizard {
    private final Repository repository;
    private CustomPullWizardPage page;
    private CustomRepositorySelectionPage addRemotePage;

    public CustomPullWizard(Repository repo) {
        this.repository = repo;
        this.setWindowTitle(UIText.PullWizardPage_PageTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        try {
            final List remotes = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
            if (remotes.isEmpty()) {
                this.addRemotePage = new CustomRepositorySelectionPage();
                this.addPage((IWizardPage)this.addRemotePage);
            }
            this.page = new CustomPullWizardPage(this.repository){

                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    if (!visible) {
                        return;
                    }
                    try {
                        RemoteConfig rc;
                        if (CustomPullWizard.this.addRemotePage != null) {
                            rc = new RemoteConfig((Config)CustomPullWizard.this.repository.getConfig(), "origin");
                            rc.addURI(CustomPullWizard.this.addRemotePage.getSelection().getURI());
                        } else {
                            rc = (RemoteConfig)remotes.get(0);
                        }
                        this.setSelectedRemote(rc);
                    }
                    catch (URISyntaxException e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            };
            this.addPage((IWizardPage)this.page);
        }
        catch (URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean performFinish() {
        try {
            if (this.addRemotePage != null) {
                this.storeCredentials(this.addRemotePage);
                URIish uri = this.addRemotePage.getSelection().getURI();
                this.configureNewRemote(uri);
            }
            this.configureUpstream();
            this.startPull();
            return true;
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (URISyntaxException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void storeCredentials(CustomRepositorySelectionPage remotePage) {
        if (!remotePage.getStoreInSecureStore()) {
            return;
        }
        URIish uri = remotePage.getSelection().getURI();
        if (uri != null) {
            SecureStoreUtils.storeCredentials((UserPasswordCredentials)remotePage.getCredentials(), (URIish)uri);
        }
    }

    private void configureNewRemote(URIish uri) throws URISyntaxException, IOException {
        StoredConfig config = this.repository.getConfig();
        String remoteName = this.page.getRemoteConfig().getName();
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, remoteName);
        remoteConfig.addURI(uri);
        RefSpec defaultFetchSpec = new RefSpec().setForceUpdate(true).setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
        remoteConfig.addFetchRefSpec(defaultFetchSpec);
        remoteConfig.update((Config)config);
        config.save();
    }

    private void configureUpstream() throws IOException {
        String fullBranch = this.repository.getFullBranch();
        if (fullBranch == null || !fullBranch.startsWith("refs/heads/")) {
            return;
        }
        String remoteName = this.page.getRemoteConfig().getName();
        String fullRemoteBranchName = this.page.getFullRemoteReference();
        String localBranchName = this.repository.getBranch();
        StoredConfig config = this.repository.getConfig();
        config.setString("branch", localBranchName, "remote", remoteName);
        config.setString("branch", localBranchName, "merge", fullRemoteBranchName);
        if (this.page.isRebaseSelected()) {
            config.setBoolean("branch", localBranchName, "rebase", true);
        } else {
            config.unset("branch", localBranchName, "rebase");
        }
        config.save();
    }

    private void startPull() {
        HashMap<Repository, PullOperation.PullReferenceConfig> repos = new HashMap<Repository, PullOperation.PullReferenceConfig>(1);
        PullOperation.PullReferenceConfig config = new PullOperation.PullReferenceConfig(this.page.getRemoteConfig().getName(), this.page.getFullRemoteReference(), this.page.getUpstreamConfig());
        repos.put(this.repository, config);
        PullOperationUI pullOperationUI = new PullOperationUI(repos);
        pullOperationUI.start();
        this.trackPullOperation();
    }

    private void trackPullOperation() {
        try {
            URIish uri = (URIish)this.page.getRemoteConfig().getURIs().get(0);
            String protocol = Protocol.fromUri(uri).getDefaultScheme();
            Trackings.trackGitOperation((String)"pull", (String)protocol);
        }
        catch (Exception exception) {}
    }
}

