/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.CachedCheckboxTreeViewer;
import org.eclipse.egit.ui.internal.components.FilteredCheckboxTree;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.dialogs.SourceBranchFailureDialog;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class CustomSourceBranchPage
extends WizardPage {
    private RepositorySelection validatedRepoSelection;
    private Ref head;
    private final List<Ref> availableRefs = new ArrayList<Ref>();
    private Label label;
    private String transportError;
    private Button selectB;
    private Button unselectB;
    private TagOpt tagOption = TagOpt.AUTO_FOLLOW;
    private CachedCheckboxTreeViewer refsViewer;
    private UserPasswordCredentials credentials;
    private String helpContext = null;

    public CustomSourceBranchPage() {
        super(CustomSourceBranchPage.class.getName());
        this.setTitle(UIText.SourceBranchPage_title);
        this.setDescription(UIText.SourceBranchPage_description);
    }

    public List<Ref> getSelectedBranches() {
        Object[] checkedElements = this.refsViewer.getCheckedElements();
        Ref[] checkedRefs = new Ref[checkedElements.length];
        System.arraycopy(checkedElements, 0, checkedRefs, 0, checkedElements.length);
        return Arrays.asList(checkedRefs);
    }

    TagOpt getTagOption() {
        return this.tagOption;
    }

    public List<Ref> getAvailableBranches() {
        return this.availableRefs;
    }

    public Ref getHEAD() {
        return this.head;
    }

    public boolean isSourceRepoEmpty() {
        return this.availableRefs.isEmpty();
    }

    public boolean isAllSelected() {
        return this.availableRefs.size() == this.refsViewer.getCheckedElements().length;
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.label = new Label(panel, 0);
        this.label.setLayoutData((Object)new GridData(4, 128, true, false));
        FilteredCheckboxTree fTree = new FilteredCheckboxTree(panel, null, 0, new PatternFilter()){

            protected WorkbenchJob doCreateRefreshJob() {
                WorkbenchJob refreshJob = super.doCreateRefreshJob();
                refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            this.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CustomSourceBranchPage.this.checkPage();
                                }
                            });
                        }
                    }
                });
                return refreshJob;
            }
        };
        UIUtils.associateLabel((Control)fTree.getFilterControl(), (Label)this.label);
        this.refsViewer = fTree.getCheckboxTreeViewer();
        ITreeContentProvider provider = new ITreeContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object input) {
                return ((List)input).toArray();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        };
        this.refsViewer.setContentProvider((IContentProvider)provider);
        this.refsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (((Ref)element).getName().startsWith("refs/heads/")) {
                    return ((Ref)element).getName().substring("refs/heads/".length());
                }
                return ((Ref)element).getName();
            }

            public Image getImage(Object element) {
                return UIIcons.getImage((ResourceManager)Activator.getDefault().getResourceManager(), (ImageDescriptor)RepositoryTreeNodeType.REF.getIcon());
            }
        });
        this.refsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CustomSourceBranchPage.this.checkPage();
            }
        });
        Composite bPanel = new Composite(panel, 0);
        bPanel.setLayout((Layout)new RowLayout());
        this.selectB = new Button(bPanel, 8);
        this.selectB.setText(UIText.SourceBranchPage_selectAll);
        this.selectB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomSourceBranchPage.this.refsViewer.setAllChecked(true);
                CustomSourceBranchPage.this.checkPage();
            }
        });
        this.unselectB = new Button(bPanel, 8);
        this.unselectB.setText(UIText.SourceBranchPage_selectNone);
        this.unselectB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomSourceBranchPage.this.refsViewer.setAllChecked(false);
                CustomSourceBranchPage.this.checkPage();
            }
        });
        this.createTagOptionGroup(panel);
        bPanel.setLayoutData((Object)new GridData(4, 128, true, false));
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    private void createTagOptionGroup(Composite parent) {
        Group tagsGroup = new Group(parent, 0);
        tagsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        tagsGroup.setText(UIText.TagOptions_groupName);
        tagsGroup.setLayout((Layout)new GridLayout());
        this.createTagOptionButton(tagsGroup, TagOpt.AUTO_FOLLOW, UIText.TagOptions_autoFollow);
        this.createTagOptionButton(tagsGroup, TagOpt.FETCH_TAGS, UIText.TagOptions_fetchTags);
        this.createTagOptionButton(tagsGroup, TagOpt.NO_TAGS, UIText.TagOptions_noTags);
    }

    private void createTagOptionButton(Group tagsGroup, final TagOpt option, String text) {
        Button button = new Button((Composite)tagsGroup, 16);
        button.setText(text);
        button.setSelection(option == this.tagOption);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomSourceBranchPage.this.tagOption = option;
            }
        });
    }

    public void setSelection(@NonNull RepositorySelection selection) {
        this.revalidate(selection);
    }

    public void setCredentials(UserPasswordCredentials credentials) {
        this.credentials = credentials;
    }

    public void setHelpContext(String id) {
        this.helpContext = id;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
    }

    private void checkPage() {
        this.setMessage(null);
        int checkedElementCount = this.refsViewer.getCheckedElements().length;
        this.selectB.setEnabled(checkedElementCount != this.availableRefs.size());
        this.unselectB.setEnabled(checkedElementCount != 0);
        if (this.transportError != null) {
            this.setErrorMessage(this.transportError);
            this.setPageComplete(false);
            return;
        }
        if (this.getSelectedBranches().isEmpty()) {
            this.setErrorMessage(UIText.SourceBranchPage_errorBranchRequired);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void checkForEmptyRepo() {
        if (this.isSourceRepoEmpty()) {
            this.setErrorMessage(null);
            this.setMessage(UIText.SourceBranchPage_repoEmpty, 2);
            this.setPageComplete(true);
        }
    }

    private void revalidate(final @NonNull RepositorySelection newRepoSelection) {
        if (newRepoSelection.equals((Object)this.validatedRepoSelection)) {
            this.checkPage();
            return;
        }
        this.label.setText(NLS.bind((String)UIText.SourceBranchPage_branchList, (Object)newRepoSelection.getURI().toString()));
        this.label.getParent().layout();
        this.validatedRepoSelection = null;
        this.transportError = null;
        this.head = null;
        this.availableRefs.clear();
        this.refsViewer.setInput(null);
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.label.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CustomSourceBranchPage.this.revalidateImpl(newRepoSelection);
            }
        });
    }

    private void revalidateImpl(RepositorySelection newRepoSelection) {
        ListRemoteOperation listRemoteOp;
        if (this.label.isDisposed() || !this.isCurrentPage()) {
            return;
        }
        URIish uri = newRepoSelection.getURI();
        try {
            listRemoteOp = new ListRemoteOperation(uri, GitSettings.getRemoteConnectionTimeout());
            if (this.credentials != null) {
                listRemoteOp.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(this.credentials.getUser(), this.credentials.getPassword()));
            }
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    listRemoteOp.run(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable why = e.getCause();
            this.transportError(why);
            if (this.showDetailedFailureDialog()) {
                SourceBranchFailureDialog.show((Shell)this.getShell(), (URIish)uri);
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.transportError(UIText.SourceBranchPage_remoteListingCancelled);
            return;
        }
        Ref idHEAD = listRemoteOp.getRemoteRef("HEAD");
        this.head = null;
        boolean headIsMaster = false;
        for (Ref r : listRemoteOp.getRemoteRefs()) {
            ObjectId objectId;
            String n = r.getName();
            if (!n.startsWith("refs/heads/")) continue;
            this.availableRefs.add(r);
            if (idHEAD == null || headIsMaster || (objectId = r.getObjectId()) == null || !objectId.equals((AnyObjectId)idHEAD.getObjectId())) continue;
            headIsMaster = "refs/heads/master".equals(r.getName());
            if (this.head != null && !headIsMaster) continue;
            this.head = r;
        }
        Collections.sort(this.availableRefs, CommonUtils.REF_ASCENDING_COMPARATOR);
        if (idHEAD != null && this.head == null) {
            this.head = idHEAD;
            this.availableRefs.add(0, idHEAD);
        }
        this.validatedRepoSelection = newRepoSelection;
        this.refsViewer.setInput(this.availableRefs);
        this.refsViewer.setAllChecked(true);
        this.checkPage();
        this.checkForEmptyRepo();
    }

    private void transportError(Throwable why) {
        Activator.logError((String)why.getMessage(), (Throwable)why);
        Throwable cause = why.getCause();
        if (why instanceof TransportException && cause != null) {
            this.transportError(NLS.bind((String)this.getMessage(why), (Object)why.getMessage(), (Object)cause.getMessage()));
        } else {
            this.transportError(why.getMessage());
        }
    }

    private String getMessage(Throwable why) {
        if (why.getMessage().endsWith("Auth fail")) {
            return UIText.SourceBranchPage_AuthFailMessage;
        }
        return UIText.SourceBranchPage_CompositeTransportErrorMessage;
    }

    private void transportError(String msg) {
        this.transportError = msg;
        this.checkPage();
    }

    private boolean showDetailedFailureDialog() {
        return Activator.getDefault().getPreferenceStore().getBoolean("CloneWizard_ShowDetailedFailureDialog");
    }
}

