/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.handlers;

import com.kms.katalon.composer.components.impl.handler.WorkbenchUtilizer;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IEvaluationService;

public abstract class AbstractGitProjectHandler
extends WorkbenchUtilizer {
    protected ExecutionEvent createExecutionEventForCommand(String id) {
        IProject groovyProject = this.getCurrentIProject();
        if (groovyProject == null) {
            return null;
        }
        IEvaluationContext currentState = ((IEvaluationService)AbstractGitProjectHandler.getService(IEvaluationService.class)).getCurrentState();
        currentState.addVariable("activeMenuSelection", (Object)new StructuredSelection((Object)groovyProject));
        Command command = ((ICommandService)AbstractGitProjectHandler.getService(ICommandService.class)).getCommand(id);
        return new ExecutionEvent(command, new HashMap(), null, (Object)currentState);
    }

    @CanExecute
    public boolean canExecute() {
        return this.getCurrentProject() != null && this.getHandler().isEnabled();
    }

    protected IProject getCurrentIProject() {
        return GroovyUtil.getGroovyProject((ProjectEntity)this.getCurrentProject());
    }

    protected ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    @Execute
    public void execute() {
        ExecutionEvent executionEvent = this.createExecutionEventForCommand(this.getEgitCommandId());
        if (executionEvent == null) {
            return;
        }
        try {
            this.getHandler().execute(executionEvent);
        }
        catch (ExecutionException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected IStructuredSelection createIProjectSelection() {
        return new StructuredSelection((Object)this.getCurrentIProject());
    }

    public abstract String getEgitCommandId();

    public abstract AbstractHandler getHandler();

    protected Repository getRepository() {
        return SelectionUtils.getRepository((IStructuredSelection)this.createIProjectSelection());
    }
}

