/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.dialogs;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class FieldEditorPreferencePageWithHelp
extends PreferencePageWithHelp
implements IPropertyChangeListener {
    public static final int FLAT = 0;
    public static final int GRID = 1;
    protected static final int VERTICAL_SPACING = 10;
    protected static final int MARGIN_WIDTH = 0;
    protected static final int MARGIN_HEIGHT = 0;
    private List<FieldEditor> fields = null;
    private int style;
    private FieldEditor invalidFieldEditor = null;
    private Composite fieldEditorParent;

    public FieldEditorPreferencePageWithHelp() {
        this(0);
    }

    protected FieldEditorPreferencePageWithHelp(int style) {
        this.style = style;
    }

    protected FieldEditorPreferencePageWithHelp(String title, int style) {
        super(title);
        this.style = style;
    }

    protected FieldEditorPreferencePageWithHelp(String title, ImageDescriptor image, int style) {
        super(title, image);
        this.style = style;
    }

    protected void addField(FieldEditor editor) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldEditor>();
        }
        this.fields.add(editor);
    }

    protected void adjustGridLayout() {
        int numColumns;
        ((GridLayout)this.fieldEditorParent.getLayout()).numColumns = numColumns = this.calcNumberOfColumns();
        if (this.fields != null) {
            int i = 0;
            while (i < this.fields.size()) {
                FieldEditor fieldEditor = this.fields.get(i);
                this.callUnPublicMethod(fieldEditor, "adjustForNumColumns", numColumns);
                ++i;
            }
        }
    }

    private void callUnPublicMethod(Object object, String methodName, Object ... params) {
        Method method;
        try {
            method = object.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return;
        }
        method.setAccessible(true);
        try {
            method.invoke(object, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LoggerSingleton.logError(e);
        }
    }

    protected void applyFont() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                this.callUnPublicMethod(pe, "applyFont", new Object[0]);
            }
        }
    }

    private int calcNumberOfColumns() {
        int result = 0;
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                result = Math.max(result, pe.getNumberOfControls());
            }
        }
        return result;
    }

    protected void checkState() {
        boolean valid = true;
        this.invalidFieldEditor = null;
        if (this.fields != null) {
            int size = this.fields.size();
            int i = 0;
            while (i < size) {
                FieldEditor editor = this.fields.get(i);
                boolean bl = valid = valid && editor.isValid();
                if (!valid) {
                    this.invalidFieldEditor = editor;
                    break;
                }
                ++i;
            }
        }
        this.setValid(valid);
    }

    protected Control createContents(Composite parent) {
        this.fieldEditorParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fieldEditorParent.setLayout((Layout)layout);
        this.fieldEditorParent.setFont(parent.getFont());
        this.createFieldEditors();
        if (this.style == 1) {
            this.adjustGridLayout();
        }
        this.initialize();
        this.checkState();
        return this.fieldEditorParent;
    }

    protected abstract void createFieldEditors();

    public void dispose() {
        super.dispose();
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.setPage(null);
                pe.setPropertyChangeListener(null);
                pe.setPreferenceStore(null);
            }
        }
    }

    protected Composite getFieldEditorParent() {
        if (this.style == 0) {
            Composite parent = new Composite(this.fieldEditorParent, 0);
            parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            return parent;
        }
        return this.fieldEditorParent;
    }

    protected void initialize() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.setPage((DialogPage)this);
                pe.setPropertyChangeListener((IPropertyChangeListener)this);
                pe.setPreferenceStore(this.getPreferenceStore());
                pe.load();
            }
        }
    }

    protected void performDefaults() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.loadDefault();
            }
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.store();
                this.callUnPublicMethod(pe, "setPresentsDefaultValue", false);
            }
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.invalidFieldEditor = (FieldEditor)event.getSource();
                this.setValid(newValue);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.invalidFieldEditor != null) {
            this.invalidFieldEditor.setFocus();
        }
    }
}

