/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ComponentEventUtil {
    static final long STOP_PROPAGATION_WAIT_TIME = 300L;

    private ComponentEventUtil() {
    }

    public static void handleDropdownClick(Menu menu, Event event, Runnable onClick) {
        if (ControlUtil.isDisposed((Widget)menu)) {
            return;
        }
        if (event.detail == 4) {
            Timer dropdownTimer = (Timer)event.widget.getData("control.data.dropdownTimer");
            if (dropdownTimer != null) {
                dropdownTimer.cancel();
            }
            dropdownTimer = UITimeUtil.waitFor(timer -> {
                List<MenuItem> options = ComponentFinder.findAllByType((Widget)menu, MenuItem.class);
                if (options.isEmpty()) {
                    ((ToolItem)event.widget).notifyListeners(event.type, event);
                    options = ComponentFinder.findAllByType((Widget)menu, MenuItem.class);
                }
                options.forEach(option -> ComponentEventUtil.replaceClickAction((Widget)option, event1 -> {
                    timer.cancel();
                    ComponentEventUtil.trigger(onClick);
                }));
                return menu != null && ControlUtil.isDisposed((Widget)menu);
            }, 0L, 100L);
            event.widget.setData("control.data.dropdownTimer", (Object)dropdownTimer);
        } else {
            ComponentEventUtil.trigger(onClick);
        }
    }

    public static void replaceClickAction(Widget control, Listener onClick) {
        ComponentEventUtil.replaceEventListener(control, onClick, 13, 14);
    }

    public static void restoreClickAction(Widget control) {
        ComponentEventUtil.restoreEventListeners(control, 13, 14);
    }

    public static void replaceEventListener(Widget control, Listener listener, int ... eventTypes) {
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        ComponentEventUtil.restoreEventListeners(control, eventTypes);
        Listener[] originListeners = ComponentEventUtil.getEventListeners(control, eventTypes);
        ComponentEventUtil.storeEventListeners(control, originListeners, eventTypes);
        Listener clickWrapper = event -> {
            ComponentEventUtil.trigger(listener, event);
            if (event.type == 0x1000008) {
                return;
            }
            ComponentEventUtil.dispatchEvent(originListeners, event);
            if (!event.doit) {
                return;
            }
            UITimeUtil.setTimeout(() -> ComponentEventUtil.restoreEventListeners(control, eventTypes), 500L);
        };
        ComponentEventUtil.removeAllListeners(control, eventTypes);
        ComponentEventUtil.addListeners(control, clickWrapper, eventTypes);
    }

    public static void onClick(Widget control, Listener onClick) {
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        if (!(control instanceof Text) && ComponentEventUtil.hasCustomSelection(control)) {
            ComponentEventUtil.onSelection(control, onClick);
        } else if (control instanceof Control) {
            ComponentEventUtil.onMouseClick((Control)control, onClick);
        } else {
            ComponentEventUtil.onSelection(control, onClick);
        }
    }

    public static boolean hasCustomSelection(Widget control) {
        return ObjectUtil.hasMethod((Object)control, (String)"addSelectionListener", (Class[])new Class[]{SelectionListener.class});
    }

    public static Listener onSelection(Widget control, Listener onSelection) {
        return ComponentEventUtil.onSelection(control, onSelection, true);
    }

    public static Listener onSelection(final Widget control, final Listener onSelection, boolean wrap) {
        if (ControlUtil.isDisposed(control)) {
            return null;
        }
        if (!wrap) {
            control.addListener(13, onSelection);
            control.addListener(14, onSelection);
            return onSelection;
        }
        if (ComponentEventUtil.hasCustomSelection(control)) {
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (ComponentEventUtil.isPropagationStopped(control)) {
                        return;
                    }
                    Event event = (Event)ObjectUtil.clone((Object)selectionEvent, (Object)new Event());
                    event.type = 13;
                    ComponentEventUtil.trigger(onSelection, event);
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    if (ComponentEventUtil.isPropagationStopped(control)) {
                        return;
                    }
                    Event event = (Event)ObjectUtil.clone((Object)selectionEvent, (Object)new Event());
                    event.type = 14;
                    ComponentEventUtil.trigger(onSelection, event);
                }
            };
            ObjectUtil.invokeSet((Object)control, (String)"addSelectionListener", (Object)selectionListener, SelectionListener.class);
            return null;
        }
        Listener selectionListener = event -> {
            if (ComponentEventUtil.isPropagationStopped(control)) {
                return;
            }
            ComponentEventUtil.trigger(onSelection, event);
        };
        control.addListener(13, selectionListener);
        control.addListener(14, selectionListener);
        return selectionListener;
    }

    public static void autoSelect(Control control) {
        if (control instanceof Text) {
            ComponentEventUtil.onClick((Widget)control, event -> {
                if (((Text)control).getSelectionCount() <= 0) {
                    ((Text)control).selectAll();
                }
            });
            ComponentEventUtil.onFocus(control, event -> {
                if (((Text)control).getSelectionCount() == ((Text)control).getText().length()) {
                    ((Text)control).clearSelection();
                }
            });
        }
    }

    public static void onFocus(Control control, FocusEventListener onFocus) {
        ComponentEventUtil.onFocus(control, onFocus, null);
    }

    public static void onBlur(Control control, FocusEventListener onBlur) {
        ComponentEventUtil.onFocus(control, null, onBlur);
    }

    public static void onFocus(Control control, final FocusEventListener onFocus, final FocusEventListener onBlur) {
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                if (onFocus != null) {
                    onFocus.dispatch(event);
                }
            }

            public void focusLost(FocusEvent event) {
                if (onBlur != null) {
                    onBlur.dispatch(event);
                }
            }
        });
    }

    public static void switchToNextControl(Control control) {
        Control nextControl = ComponentDataUtil.findNextTabControl(control);
        nextControl.setFocus();
    }

    public static void switchOnTab(final Control control) {
        control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 16) {
                    ComponentEventUtil.switchToNextControl(control);
                }
            }
        });
    }

    public static void onSubmit(Control control, Listener onSubmit) {
        if (onSubmit == null || ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        control.addListener(24, onSubmit);
    }

    public static void triggerSubmitEvent(Control control) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        Composite parent = control.getParent();
        Event event = ComponentEventUtil.generateEvent((Widget)parent, 24);
        while (parent != null && !parent.isDisposed()) {
            if (parent.isListening(24)) {
                parent.notifyListeners(24, event);
                if (!event.doit) break;
            }
            if (parent.isDisposed()) break;
            parent = parent.getParent();
        }
    }

    public static void submitOnClick(Control control) {
        ComponentEventUtil.onClick((Widget)control, event -> ComponentEventUtil.triggerSubmitEvent(control));
    }

    public static void submitOnEnter(final Control control) {
        control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 4) {
                    ComponentEventUtil.triggerSubmitEvent(control);
                }
            }
        });
    }

    public static void onChange(Control control, Listener onChange) {
        if (onChange == null || ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        control.addListener(24, onChange);
    }

    public static void removeOnChange(Widget control, Listener onChange) {
        if (onChange == null || ControlUtil.isDisposed(control)) {
            return;
        }
        control.removeListener(24, onChange);
    }

    public static void removeSelection(Widget control, Listener listener) {
        ObjectUtil.invokeSet((Object)control, (String)"removeSelectionListener", (Object)listener, Listener.class);
    }

    public static void onOptionChange(Control control, OptionChangeHandler onOptionChange) {
        Listener listener = event -> {
            if (control instanceof Button) {
                Button button = (Button)control;
                if ((button.getStyle() & 0x10) != 0 || button.getSelection()) {
                    onOptionChange.call((Control)button, button.getData() != null ? button.getData() : button.getText());
                }
            } else {
                onOptionChange.call(control, control.getData() != null ? control.getData() : ComponentDataUtil.getText((Widget)control));
            }
        };
        if (control instanceof Composite) {
            ComponentEventUtil.onSelection((Widget)control, listener);
        } else {
            ComponentEventUtil.onClick((Widget)control, listener);
        }
    }

    public static void onMouseEnter(Control control, MouseEventListener listener) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        Display display = control.getDisplay();
        Boolean isTracked = (Boolean)display.getData("TRACKING_MOUSE_ENTER");
        if (isTracked == null) {
            display.setData("TRACKING_MOUSE_ENTER", (Object)Boolean.TRUE);
            display.addFilter(6, event -> {
                MouseEvent mouseEvent = new MouseEvent(event);
                Map<Control, Map<String, List<MouseEventListener>>> trackedControls = ComponentEventUtil.getTrackedControls(display);
                Set<Control> hoveringControls = ComponentEventUtil.getHoveringControls(display);
                HashMap<Control, Map> trackedControlsImage = new HashMap<Control, Map>();
                trackedControlsImage.putAll(trackedControls);
                trackedControlsImage.forEach((controlI, ltenerSetI) -> {
                    if (ComponentEventUtil.isMouseOverControl(controlI, mouseEvent) && !hoveringControls.contains(controlI) && ControlUtil.isVisible(controlI)) {
                        hoveringControls.add((Control)controlI);
                        List<MouseEventListener> enterListeners = ComponentEventUtil.getMouseListeners(controlI, "ENTER_LISTENERS");
                        if (enterListeners != null) {
                            enterListeners.forEach(listenerI -> listenerI.dispatch(mouseEvent));
                        }
                    }
                });
            });
        }
        ComponentEventUtil.addMouseListener(control, "ENTER_LISTENERS", listener);
    }

    public static void onMouseLeave(Control control, MouseEventListener listener) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        Display display = control.getDisplay();
        Boolean isTracked = (Boolean)display.getData("TRACKING_MOUSE_LEAVE");
        if (isTracked == null) {
            display.setData("TRACKING_MOUSE_LEAVE", (Object)Boolean.TRUE);
            display.addFilter(7, event -> {
                MouseEvent mouseEvent = new MouseEvent(event);
                Set<Control> hoveringControls = ComponentEventUtil.getHoveringControls(display);
                HashSet leftControls = new HashSet();
                HashSet<Control> hoveringControlsImage = new HashSet<Control>();
                hoveringControlsImage.addAll(hoveringControls);
                hoveringControlsImage.forEach(controlI -> {
                    if (!ControlUtil.isVisible(controlI)) {
                        leftControls.add(controlI);
                        return;
                    }
                    if (!ComponentEventUtil.isMouseOverControl(controlI, mouseEvent)) {
                        leftControls.add(controlI);
                        List<MouseEventListener> leaveListeners = ComponentEventUtil.getMouseListeners(controlI, "LEAVE_LISTENERS");
                        if (leaveListeners != null) {
                            leaveListeners.forEach(listenerI -> listenerI.dispatch(mouseEvent));
                        }
                    }
                });
                hoveringControls.removeAll(leftControls);
            });
        }
        ComponentEventUtil.addMouseListener(control, "LEAVE_LISTENERS", listener);
    }

    private static Map<Control, Map<String, List<MouseEventListener>>> getTrackedControls(Control control) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return new HashMap<Control, Map<String, List<MouseEventListener>>>();
        }
        return ComponentEventUtil.getTrackedControls(control.getDisplay());
    }

    private static Map<Control, Map<String, List<MouseEventListener>>> getTrackedControls(Display display) {
        HashMap trackedControls = (HashMap)display.getData("TRACKED_CONTROLS");
        if (trackedControls == null) {
            trackedControls = new HashMap();
            display.setData("TRACKED_CONTROLS", trackedControls);
        }
        return trackedControls;
    }

    private static Set<Control> getHoveringControls(Display display) {
        HashSet hoveringControls = (HashSet)display.getData("HOVERING_CONTROLS");
        if (hoveringControls == null) {
            hoveringControls = new HashSet();
            display.setData("HOVERING_CONTROLS", hoveringControls);
        }
        return hoveringControls;
    }

    private static List<MouseEventListener> getMouseListeners(Control control, String listenerType) {
        Map<Control, Map<String, List<MouseEventListener>>> trackedControls = ComponentEventUtil.getTrackedControls(control);
        Map<String, List<MouseEventListener>> controlListeners = trackedControls.get(control);
        if (controlListeners == null) {
            return null;
        }
        return controlListeners.get(listenerType);
    }

    private static void addMouseListener(Control control, String listenerType, MouseEventListener listener) {
        List<MouseEventListener> listeners;
        Map<Control, Map<String, List<MouseEventListener>>> trackedControls = ComponentEventUtil.getTrackedControls(control);
        Map<String, List<MouseEventListener>> controlListeners = trackedControls.get(control);
        if (controlListeners == null) {
            controlListeners = new HashMap<String, List<MouseEventListener>>();
            trackedControls.put(control, controlListeners);
        }
        if ((listeners = controlListeners.get(listenerType)) == null) {
            listeners = new ArrayList<MouseEventListener>();
            controlListeners.put(listenerType, listeners);
        }
        listeners.add(listener);
        HashSet disposedControls = new HashSet();
        trackedControls.forEach((controlI, listenerSetI) -> {
            if (ControlUtil.isDisposed((Widget)controlI)) {
                disposedControls.add(controlI);
            }
        });
        disposedControls.forEach(controlI -> trackedControls.remove(controlI));
    }

    public static void onMouseClick(Control control, Listener onClick) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        control.addListener(13, onClick);
        if (ComponentDataUtil.getBoolean((Widget)control, "control.mouse.tracked")) {
            return;
        }
        ComponentDataUtil.set((Widget)control, "control.mouse.tracked", true);
        ComponentEventUtil.onMouseAction(control, event -> ComponentDataUtil.set((Widget)control, "control.mouse.down", true), event -> {
            if (ComponentDataUtil.getBoolean((Widget)control, "control.mouse.down")) {
                ComponentDataUtil.set((Widget)control, "control.mouse.down", false);
                ComponentEventUtil.trigger((Widget)control, 13, event);
            }
        }, null);
    }

    public static MouseListener onMouseAction(final Control control, final Listener onMouseDown, final Listener onMouseUp, final Listener onMouseDoubleClick) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return null;
        }
        MouseListener mouseListener = new MouseListener(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (ControlUtil.isDisposed((Widget)control) || ComponentEventUtil.isPropagationStopped((Widget)control)) {
                    return;
                }
                if (ComponentEventUtil.isMouseOverControl(control, mouseEvent)) {
                    Event event = (Event)ObjectUtil.clone((Object)mouseEvent, (Object)new Event());
                    ComponentEventUtil.trigger(onMouseDown, event);
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (ControlUtil.isDisposed((Widget)control) || ComponentEventUtil.isPropagationStopped((Widget)control)) {
                    return;
                }
                if (ComponentEventUtil.isMouseOverControl(control, mouseEvent)) {
                    Event event = (Event)ObjectUtil.clone((Object)mouseEvent, (Object)new Event());
                    ComponentEventUtil.trigger(onMouseUp, event);
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (ControlUtil.isDisposed((Widget)control) || ComponentEventUtil.isPropagationStopped((Widget)control)) {
                    return;
                }
                if (ComponentEventUtil.isMouseOverControl(control, mouseEvent)) {
                    Event event = (Event)ObjectUtil.clone((Object)mouseEvent, (Object)new Event());
                    ComponentEventUtil.trigger(onMouseDoubleClick, event);
                }
            }
        };
        control.addMouseListener(mouseListener);
        return mouseListener;
    }

    public static MouseListener onMouseUp(final Control control, final Listener onClick) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return null;
        }
        MouseListener mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (ControlUtil.isDisposed((Widget)control) || ComponentEventUtil.isPropagationStopped((Widget)control)) {
                    return;
                }
                if (ComponentEventUtil.isMouseOverControl(control, mouseEvent)) {
                    Event event = (Event)ObjectUtil.clone((Object)mouseEvent, (Object)new Event());
                    ComponentEventUtil.trigger(onClick, event);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        control.addMouseListener(mouseListener);
        return mouseListener;
    }

    public static boolean isMouseOverControl(Control control, MouseEvent event) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return false;
        }
        if (control == event.widget) {
            Rectangle bounds = control.getBounds();
            if (bounds == null) {
                return false;
            }
            bounds.x = 0;
            bounds.y = 0;
            return bounds.intersects(event.x, event.y, 1, 1);
        }
        Point cursorLocation = control.getDisplay().getCursorLocation();
        Rectangle bounds = ComponentUtil.getScreenArea((Widget)control);
        return bounds.intersects(cursorLocation.x, cursorLocation.y, 1, 1);
    }

    public static void trackMouseState(final Control control) {
        MouseListener mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ControlUtil.setStateHover(control);
            }

            public void mouseDown(MouseEvent e) {
                ControlUtil.setStateActive(control);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        control.addMouseListener(mouseListener);
        ComponentEventUtil.onMouseEnter(control, event -> {
            if (!ControlUtil.isAcivating(control)) {
                ControlUtil.setStateHover(control);
            }
        });
        ComponentEventUtil.onMouseLeave(control, event -> ControlUtil.setStateNormal(control));
    }

    public static void stopPropagation(Widget control) {
        ComponentUtil.setData(control, "control.event.lastPreventDefaultTime", System.currentTimeMillis());
    }

    public static boolean isPropagationStopped(Widget control) {
        if (ComponentDataUtil.has(control, "control.event.lastPreventDefaultTime")) {
            long lastPreventDefaultTime = ComponentDataUtil.get(control, "control.event.lastPreventDefaultTime", 0L);
            if (System.currentTimeMillis() - lastPreventDefaultTime < 300L) {
                return true;
            }
        }
        return false;
    }

    public static void stopPropagationOnSelection(Widget control) {
        ComponentEventUtil.onSelection(control, event -> ComponentEventUtil.stopPropagation(control));
    }

    public static void dispatchEvent(Collection<Listener> listeners, Event event) {
        ComponentEventUtil.dispatchEvent(listeners.toArray(new Listener[0]), event);
    }

    public static void dispatchEvent(Listener[] listeners, Event event) {
        Listener[] listenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            try {
                ComponentEventUtil.trigger(listener, event);
            }
            catch (Exception error) {
                LoggerSingleton.logError(error);
            }
            ++n2;
        }
    }

    public static void triggerModifyEvent(Widget control, String text) {
        Event modifyEvent = ComponentEventUtil.generateModifyEvent(control);
        modifyEvent.text = text;
        ObjectUtil.invokeSet((Object)control, (String)"setText", (Object)text, String.class);
        control.notifyListeners(24, modifyEvent);
    }

    public static void triggerSelectionEvent(Widget control) {
        ComponentEventUtil.triggerSelectionEvent(control, true);
    }

    public static void triggerSelectionEvent(Widget control, boolean selection) {
        Event selectionEvent = ComponentEventUtil.generateSelectionEvent(control);
        ObjectUtil.invokeSet((Object)control, (String)"setSelection", (Object)selection, Boolean.TYPE);
        control.notifyListeners(13, selectionEvent);
    }

    public static void trigger(Widget control, int eventType, Event event) {
        control.notifyListeners(eventType, event);
    }

    public static void trigger(Listener listener, Event event) {
        if (!(listener == null || event.widget != null && event.widget.isDisposed())) {
            listener.handleEvent(event);
        }
    }

    public static void trigger(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    public static void addListeners(Widget control, Listener listener, int ... eventTypes) {
        ComponentEventUtil.addListeners(control, new Listener[]{listener}, eventTypes);
    }

    public static void addListeners(Widget control, Listener[] listeners, int ... eventTypes) {
        if (ControlUtil.isDisposed(control) || listeners == null) {
            return;
        }
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            Listener[] listenerArray = listeners;
            int n3 = listeners.length;
            int n4 = 0;
            while (n4 < n3) {
                Listener listener = listenerArray[n4];
                control.removeListener(eventType, listener);
                control.addListener(eventType, listener);
                ++n4;
            }
            ++n2;
        }
    }

    public static Listener[] getEventListeners(Widget control, int ... eventTypes) {
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            Object[] listeners = control.getListeners(eventType);
            if (ArrayUtils.isNotEmpty((Object[])listeners)) {
                return listeners;
            }
            ++n2;
        }
        return new Listener[0];
    }

    public static void removeAllListeners(Widget control, Listener[] listeners, int ... eventTypes) {
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            Listener[] listenerArray = listeners;
            int n3 = listeners.length;
            int n4 = 0;
            while (n4 < n3) {
                Listener listener = listenerArray[n4];
                control.removeListener(eventType, listener);
                ++n4;
            }
            ++n2;
        }
    }

    public static void removeAllListeners(Widget control, int ... eventTypes) {
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            Listener[] listeners = control.getListeners(eventType);
            ComponentEventUtil.removeAllListeners(control, listeners, eventType);
            ++n2;
        }
    }

    public static boolean hasStoredEventListeners(Widget control, int ... eventTypes) {
        if (ControlUtil.isDisposed(control)) {
            return false;
        }
        Map<Integer, Listener[]> listenerMap = ComponentEventUtil.getStoredListenerMap(control);
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            Object[] listeners = listenerMap.get(eventType);
            if (ArrayUtils.isNotEmpty((Object[])listeners)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void storeEventListeners(Widget control, Listener[] listeners, int ... eventTypes) {
        Map<Integer, Listener[]> listenerMap = ComponentEventUtil.getStoredListenerMap(control);
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            listenerMap.put(eventType, listeners);
            ++n2;
        }
        ComponentEventUtil.setStoredListenerMap(control, listenerMap);
    }

    public static void restoreEventListeners(Widget control, int ... eventTypes) {
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        Map<Integer, Listener[]> storedListenerMap = ComponentEventUtil.getStoredListenerMap(control);
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            Object[] listeners = storedListenerMap.get(eventType);
            if (ArrayUtils.isNotEmpty((Object[])listeners)) {
                ComponentEventUtil.removeAllListeners(control, eventType);
                ComponentEventUtil.addListeners(control, (Listener[])listeners, eventType);
            }
            ++n2;
        }
        ComponentEventUtil.storeEventListeners(control, null, eventTypes);
    }

    public static Map<Integer, Listener[]> getStoredListenerMap(Widget control) {
        HashMap listenerMap = (HashMap)control.getData("STORED_LISTENERS");
        if (listenerMap == null) {
            listenerMap = new HashMap();
        }
        return listenerMap;
    }

    public static void setStoredListenerMap(Widget control, Map<Integer, Listener[]> listenerMap) {
        control.setData("STORED_LISTENERS", listenerMap);
    }

    public static Event generateModifyEvent(Widget control) {
        return ComponentEventUtil.generateEvent(control, 24);
    }

    public static Event generateSelectionEvent(Widget control) {
        return ComponentEventUtil.generateEvent(control, 13);
    }

    public static Event generateEvent(Widget control, int eventType) {
        Event event = new Event();
        event.widget = control;
        event.type = eventType;
        event.display = control.getDisplay();
        event.doit = true;
        event.time = (int)(System.currentTimeMillis() / 1000L);
        return event;
    }

    public static interface ControlHandler {
        public void call(Control var1);
    }

    public static interface FocusEventListener {
        public void dispatch(FocusEvent var1);
    }

    public static interface MouseEventListener {
        public void dispatch(MouseEvent var1);
    }

    public static interface OptionChangeHandler {
        public void call(Control var1, Object var2);
    }

    public static interface PaintHandler {
        public void call(PaintEvent var1, GC var2, Control var3);
    }
}

