/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.constants.ComponentSize;
import com.kms.katalon.composer.components.controls.FileInput;
import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.controls.SimpleComboBox;
import com.kms.katalon.composer.components.controls.SimpleTextField;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentRole;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.composer.components.util.StyleUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.core.util.ArrayUtil;
import com.kms.katalon.core.util.ObjectUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ComponentUtil {
    private static final int TITLE_BAR_HEIGHT = 100;
    private static final int DPI_ZOOM_100 = 96;
    private static Map<Integer, Cursor> savedCursors = new HashMap<Integer, Cursor>();

    public static Image getSWTImage(int imageID) {
        Display display = Display.getCurrent();
        Image[] image = new Image[1];
        display.syncExec(() -> {
            Image image = display.getSystemImage(imageID);
        });
        return image[0];
    }

    public static double getZoom() {
        int dpi = Display.getDefault().getDPI().x;
        double zoom = (double)dpi / 96.0;
        return zoom;
    }

    public static int applyZoom(int size) {
        return (int)Math.round((double)size * ComponentUtil.getZoom());
    }

    public static int getSize(ComponentSize size, Map<ComponentSize, Integer> sizeMap) {
        return sizeMap.get((Object)size);
    }

    public static int getTabNavHeight() {
        return ComponentUtil.applyZoom(SystemUtils.IS_OS_MAC ? 37 : 22);
    }

    public static int getGroupAdjustingHeight() {
        return ComponentUtil.applyZoom(SystemUtils.IS_OS_MAC ? 37 : 18);
    }

    public static int getGroupAdjustingWidth() {
        return ComponentUtil.applyZoom(SystemUtils.IS_OS_MAC ? 20 : 2);
    }

    public static Composite createMenuContainer(Composite parent) {
        return ComponentUtil.createMenuContainer(parent, 1);
    }

    public static Composite createMenuContainer(Composite parent, int numCols) {
        return ComponentUtil.createMenuContainer(parent, numCols, 0);
    }

    public static Composite createMenuContainer(Composite parent, int numCols, int style) {
        return ComponentUtil.createMenuContainer(parent, numCols, false, style);
    }

    public static Composite createMenuContainer(Composite parent, int numCols, boolean equalWidth, int style) {
        Composite container = new Composite(parent, style);
        ComponentUtil.appendGridLayout(container, numCols, equalWidth);
        ComponentUtil.setGridVerticalSpacing(container, 0);
        StyleContext.style((Control)container);
        return container;
    }

    public static CTabFolder createTabFolder(Composite parent) {
        return ComponentUtil.createTabFolder(parent, 0);
    }

    public static CTabFolder createTabFolder(Composite parent, int style) {
        return new CTabFolder(parent, style);
    }

    public static SashForm createSashForm(Composite parent) {
        return ComponentUtil.createSashForm(parent, 0);
    }

    public static SashForm createSashForm(Composite parent, int style) {
        return new SashForm(parent, style);
    }

    public static Control setSashWidth(Control parent, int width) {
        if (parent instanceof SashForm) {
            ((SashForm)parent).setSashWidth(width);
        }
        return parent;
    }

    public static Composite createGridContainer(Composite parent) {
        return ComponentUtil.createGridContainer(parent, 1);
    }

    public static Composite createGridContainer(Composite parent, int numCols) {
        return ComponentUtil.createGridContainer(parent, numCols, 0);
    }

    public static Composite createGridContainer(Composite parent, int numCols, int style) {
        return ComponentUtil.createGridContainer(parent, numCols, false, style);
    }

    public static Composite createGridContainer(Composite parent, int numCols, boolean equalWidth) {
        return ComponentUtil.createGridContainer(parent, numCols, equalWidth, 0);
    }

    public static Composite createGridContainer(Composite parent, int numCols, boolean equalWidth, int style) {
        Composite container = new Composite(parent, style);
        ComponentUtil.appendGridLayout(container, numCols, equalWidth);
        StyleContext.style((Control)container);
        return container;
    }

    public static Composite appendGridLayout(Composite container) {
        return ComponentUtil.appendGridLayout(container, 1, false);
    }

    public static Composite appendGridLayout(Composite container, int numCols) {
        return ComponentUtil.appendGridLayout(container, numCols, false);
    }

    public static Composite appendGridLayout(Composite container, int numCols, boolean equalWidth) {
        GridLayout layout = new GridLayout(numCols, equalWidth);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        container.setLayout((Layout)layout);
        return container;
    }

    public static Composite createRowContainer(Composite parent) {
        return ComponentUtil.createRowContainer(parent, 0, 256);
    }

    public static Composite createRowContainer(Composite parent, int style) {
        return ComponentUtil.createRowContainer(parent, style, 256);
    }

    public static Composite createRowContainer(Composite parent, int style, int type) {
        Composite container = new Composite(parent, style);
        RowLayout layout = new RowLayout(type);
        layout.spacing = 0;
        layout.wrap = true;
        container.setLayout((Layout)layout);
        ComponentUtil.setMargin(container, 0);
        StyleContext.style((Control)container);
        return container;
    }

    public static Composite createStackContainer(Composite parent) {
        return ComponentUtil.createStackContainer(parent, 0);
    }

    public static Composite createStackContainer(Composite parent, int style) {
        Composite container = new Composite(parent, style);
        StackLayout layout = new StackLayout();
        container.setLayout((Layout)layout);
        ComponentUtil.setMargin(container, 0);
        StyleContext.style((Control)container);
        return container;
    }

    public static SashForm createSplitVerticalContainer(Composite parent) {
        return ComponentUtil.createSplitContainer(parent, 512);
    }

    public static SashForm createSplitVerticalContainer(Composite parent, int style) {
        return ComponentUtil.createSplitContainer(parent, style | 0x200);
    }

    public static SashForm createSplitHorizontalContainer(Composite parent) {
        return ComponentUtil.createSplitContainer(parent, 256);
    }

    public static SashForm createSplitHorizontalContainer(Composite parent, int style) {
        return ComponentUtil.createSplitContainer(parent, style | 0x100);
    }

    public static SashForm createSplitContainer(Composite parent) {
        return ComponentUtil.createSplitContainer(parent, 0);
    }

    public static SashForm createSplitContainer(Composite parent, int style) {
        SashForm container = new SashForm(parent, style);
        StyleContext.style((Control)container);
        return container;
    }

    public static Composite createFillContainer(Composite parent) {
        return ComponentUtil.createFillContainer(parent, 0);
    }

    public static Composite createFillContainer(Composite parent, int style) {
        return ComponentUtil.createFillContainer(parent, style, 512);
    }

    public static Composite createFillContainer(Composite parent, int style, int type) {
        Composite container = new Composite(parent, style);
        FillLayout layout = new FillLayout(type);
        container.setLayout((Layout)layout);
        ComponentUtil.setMargin(container, 0);
        StyleContext.style((Control)container);
        return container;
    }

    public static Group createGroup(Composite parent) {
        return ComponentUtil.createGroup(parent, 0);
    }

    public static Group createGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        return group;
    }

    public static Label createSeparator(Composite parent) {
        return ComponentUtil.createSeparator(parent, 0);
    }

    public static Label createSeparator(Composite parent, int style) {
        Label separator = new Label(parent, 0x102 | style);
        ComponentUtil.gridFillHorizontal((Control)separator);
        return separator;
    }

    public static Canvas createEmptyCell(Composite parent) {
        Canvas emptyCell = ComponentUtil.createCanvas(parent);
        ComponentUtil.setHeight((Control)emptyCell, 0);
        return emptyCell;
    }

    public static Label createLabel(Composite parent) {
        return ComponentUtil.createLabel(parent, 0);
    }

    public static Label createLabel(Composite parent, int style) {
        Label label = new Label(parent, style | 0x40 | 0x40000000);
        StyleContext.style((Control)label);
        return label;
    }

    public static Text createText(Composite parent) {
        return ComponentUtil.createText(parent, 0);
    }

    public static Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        StyleContext.style((Control)text);
        return text;
    }

    public static TextField createTextField(Composite parent) {
        return ComponentUtil.createTextField(parent, 0);
    }

    public static TextField createTextField(Composite parent, int style) {
        TextField textField = new TextField(parent, style);
        StyleContext.style((Control)textField);
        return textField;
    }

    public static SimpleTextField createSimpleTextField(Composite parent) {
        return ComponentUtil.createSimpleTextField(parent, 0);
    }

    public static SimpleTextField createSimpleTextField(Composite parent, int style) {
        SimpleTextField textField = new SimpleTextField(parent, style);
        StyleContext.style((Control)textField);
        return textField;
    }

    public static FileInput createFileInput(Composite parent) {
        return ComponentUtil.createFileInput(parent, 0);
    }

    public static FileInput createFileInput(Composite parent, int style) {
        FileInput text = new FileInput(parent, style);
        StyleContext.style((Control)text);
        return text;
    }

    public static Text createTextArea(Composite parent) {
        return ComponentUtil.createTextArea(parent, 0);
    }

    public static Text createTextArea(Composite parent, int style) {
        Text label = new Text(parent, style | 2 | 0x40 | 0x200);
        StyleContext.style((Control)label);
        return label;
    }

    public static Button createButton(Composite parent) {
        return ComponentUtil.createButton(parent, 0);
    }

    public static Button createButton(Composite parent, int style) {
        Button button = new Button(parent, style | 0x100000 | 0x20000000);
        StyleContext.style((Control)button);
        if (ControlUtil.checkStyle(style, 16)) {
            ComponentEventUtil.onClick((Widget)button, event -> {
                Button button1 = (Button)event.widget;
                if (button1.getSelection()) {
                    Composite parent1 = button1.getParent();
                    ComponentEventUtil.triggerModifyEvent((Widget)parent1, button1.getText());
                    parent1.setData(button1.getData() != null ? button1.getData() : button1.getText());
                    ComponentEventUtil.triggerSelectionEvent((Widget)parent1);
                }
            });
        }
        return button;
    }

    public static Canvas createIconButton(Composite parent) {
        return ComponentUtil.createIconButton(parent, "");
    }

    public static Canvas createIconButton(Composite parent, String imageKey) {
        return ComponentUtil.createIconButton(parent, imageKey, ComponentUtil.applyZoom(24));
    }

    public static Canvas createIconButton(Composite parent, String imageKey, int size) {
        return ComponentUtil.createIconButton(parent, imageKey, size, size);
    }

    public static Canvas createIconButton(Composite parent, String imageKey, int width, int height) {
        Image image = ImageManager.getImage((String)imageKey);
        return ComponentUtil.createIconButton(parent, image, width, height);
    }

    public static Canvas createIconButton(Composite parent, Image image) {
        return ComponentUtil.createIconButton(parent, image, ComponentUtil.applyZoom(24));
    }

    public static Canvas createIconButton(Composite parent, Image image, int size) {
        return ComponentUtil.createIconButton(parent, image, size, size);
    }

    public static Canvas createIconButton(Composite parent, Image image, int width, int height) {
        Canvas button = ComponentUtil.createCanvas(parent, null, width, height);
        Color hoverBackground = ColorUtil.themeColor("#ccc", "#777");
        Color activeBackground = ColorUtil.themeColor("#bbb", "#666");
        ComponentUtil.setImage((Widget)button, image, 0x1000000);
        ComponentUtil.setImageSize((Control)button, width, height);
        ComponentUtil.setImageScale((Control)button, 0.7f);
        ComponentUtil.setBorderRadius((Control)button, height);
        ComponentUtil.setHoverBackground((Control)button, hoverBackground);
        ComponentUtil.setActiveBackground((Control)button, activeBackground);
        ComponentUtil.setCursorPointer((Control)button);
        StyleUtil.customRender((Control)button);
        StyleContext.style((Control)button);
        return button;
    }

    public static Canvas createMenuItem(Composite parent) {
        Canvas menuItem = ComponentUtil.createCanvas(parent);
        ComponentUtil.setContentAlign((Control)menuItem, 16384);
        ComponentUtil.setCursorPointer((Control)menuItem);
        ComponentUtil.setHoverBackground((Control)menuItem, ColorUtil.getCompositeBackgroundColorForHoverMenuItem());
        ComponentUtil.autoSizeMD((Control)menuItem);
        int minWidth = SystemUtils.IS_OS_WINDOWS ? 154 : 186;
        int defaultHeight = SystemUtils.IS_OS_WINDOWS ? 25 : 32;
        int defaultImageSize = SystemUtils.IS_OS_WINDOWS ? 20 : 26;
        ComponentUtil.setMinWidth((Control)menuItem, ComponentUtil.applyZoom(minWidth));
        ComponentUtil.setHeight((Control)menuItem, ComponentUtil.applyZoom(defaultHeight));
        int imageSize = ComponentUtil.applyZoom(defaultImageSize);
        ComponentUtil.setImageSize((Control)menuItem, imageSize, imageSize);
        return menuItem;
    }

    public static HelpComposite createHelpButton(Composite parent, String docUrl) {
        return ComponentUtil.createHelpButton(parent, docUrl, 0);
    }

    public static HelpComposite createHelpButton(Composite parent, String docUrl, int style) {
        HelpComposite button = new HelpComposite(parent, docUrl, style);
        StyleContext.style((Control)button);
        return button;
    }

    public static Combo createComboBox(Composite parent) {
        return ComponentUtil.createComboBox(parent, 0);
    }

    public static Combo createComboBox(Composite parent, int style) {
        Combo button = new Combo(parent, style | 4);
        StyleContext.style((Control)button);
        return button;
    }

    public static CCombo createCustomComboBox(Composite parent) {
        return ComponentUtil.createCustomComboBox(parent, 0);
    }

    public static CCombo createCustomComboBox(Composite parent, int style) {
        CCombo combo = new CCombo(parent, style | 4);
        ComponentUtil.setHeight((Control)combo, SystemUtils.IS_OS_MAC ? ComponentUtil.applyZoom(24) : -1);
        StyleContext.style((Control)combo);
        return combo;
    }

    public static SimpleComboBox createSimpleComboBox(Composite parent) {
        return ComponentUtil.createSimpleComboBox(parent, 0);
    }

    public static SimpleComboBox createSimpleComboBox(Composite parent, int style) {
        SimpleComboBox combo = new SimpleComboBox(parent, style);
        StyleContext.style((Control)combo);
        return combo;
    }

    public static Link createLink(Composite parent) {
        return ComponentUtil.createLink(parent, 0);
    }

    public static Link createLink(Composite parent, int style) {
        Link link = new Link(parent, style | 0x40);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComponentUtil.triggerLink(event.text);
            }
        });
        StyleContext.style((Control)link);
        return link;
    }

    public static void triggerLink(String url) {
        if (StringUtils.isBlank((String)url) || StringUtils.equals((String)url, (String)"#")) {
            return;
        }
        if (url.startsWith("mailto")) {
            try {
                Desktop.getDesktop().mail(URI.create(url));
            }
            catch (IOException exception) {
                LoggerSingleton.logError(exception);
            }
            return;
        }
        Program.launch((String)url);
    }

    public static void preventDefaultInternalUrls(Browser browser) {
        ComponentUtil.preventUrls(browser, "^https?://localhost.*", "^https?://127.0.0.1.*", ".*embed.*", "about:blank", "res://.*");
    }

    public static void preventUrls(final Browser browser, String ... patterns) {
        HashSet<String> savedPatterns = (HashSet<String>)browser.getData("control.data.internalUrls");
        if (savedPatterns != null) {
            savedPatterns.addAll(Arrays.asList(patterns));
            return;
        }
        savedPatterns = new HashSet<String>();
        browser.setData("control.data.internalUrls", savedPatterns);
        savedPatterns.addAll(Arrays.asList(patterns));
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                Set internalUrlPatterns = (Set)browser.getData("control.data.internalUrls");
                String location = event.location;
                boolean isMatched = internalUrlPatterns.stream().anyMatch(pattern -> location.matches((String)pattern));
                if (!isMatched) {
                    event.doit = false;
                    ComponentUtil.triggerLink(event.location);
                }
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    public static void interceptURLs(Browser browser, final LocationChangingListener listener, final String ... patterns) {
        if (listener == null) {
            return;
        }
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String location = event.location;
                boolean isMatched = Arrays.stream(patterns).anyMatch(pattern -> location.matches((String)pattern));
                if (isMatched) {
                    listener.call(event);
                }
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    public static BrowserFunction defineBrowserFunction(Browser browser, String functionName, final BrowserFunctionHandler function) {
        return new BrowserFunction(browser, functionName){

            public Object function(Object[] arguments) {
                Object[] result = new Object[1];
                Executors.newFixedThreadPool(1).submit(() -> UISynchronizeService.syncExec(() -> {
                    objectArray[0] = function.call(arguments);
                }));
                return result[0];
            }
        };
    }

    public static String wrapLinkButton(String label) {
        return ComponentUtil.wrapLink(label, "#");
    }

    public static String wrapLink(String url) {
        return ComponentUtil.wrapLink(url, url);
    }

    public static String wrapLink(String label, String url) {
        return MessageFormat.format("<a href=\"{0}\">{1}</a>", url, StringUtils.defaultString((String)label, (String)url));
    }

    public static String autoWrapLinks(String text) {
        String regex = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String newText = StringUtils.defaultString((String)text).replaceAll(regex, "<a href=\"$0\">$0</a>");
        return newText;
    }

    public static boolean containsLink(String text) {
        return text.matches(".*?<a.+?href=.*?>.*?</a>.*?");
    }

    public static void linkTo(Widget control, String url) {
        ComponentUtil.linkTo(control, null, url);
    }

    public static void linkTo(Widget control, String label, String url) {
        if (control instanceof Link) {
            ComponentUtil.setText(control, ComponentUtil.wrapLink(label, url));
        } else {
            if (label != null) {
                ComponentUtil.setText(control, label);
            }
            ComponentEventUtil.onClick(control, event -> ComponentUtil.triggerLink(url));
        }
    }

    public static Canvas createCanvasImage(Composite parent, String imageKey) {
        Image image = ImageManager.getImage((String)imageKey);
        return ComponentUtil.createCanvas(parent, image);
    }

    public static Canvas createCanvasImage(Composite parent, String imageKey, int maxHeight) {
        Image image = ImageManager.getImage((String)imageKey);
        int height = Math.min(maxHeight, image.getBounds().height);
        int width = (int)((float)image.getBounds().width * (float)height / (float)image.getBounds().height);
        return ComponentUtil.createCanvas(parent, image, width, height);
    }

    public static Canvas createCanvasImage(Composite parent, String imageKey, int width, int height) {
        Image image = ImageManager.getImage((String)imageKey);
        return ComponentUtil.createCanvas(parent, image, width, height);
    }

    public static Canvas createCanvas(Composite parent) {
        return ComponentUtil.createCanvas(parent, null);
    }

    public static Canvas createAnimatedCanvas(Composite parent, ImageLoader loader) {
        Canvas canvas = ComponentUtil.createCanvas(parent, new Image((Device)parent.getDisplay(), loader.data[0]));
        ComponentUtil.setData((Widget)canvas, "control.data.currentFrame", 0);
        ComponentUtil.delayToNextFrame(canvas, loader);
        return canvas;
    }

    private static void delayToNextFrame(Canvas canvas, ImageLoader loader) {
        if (loader.data.length <= 1) {
            return;
        }
        int curFrameIndex = (Integer)canvas.getData("control.data.currentFrame");
        ImageData curFrameData = loader.data[curFrameIndex];
        UITimeUtil.setTimeout(() -> {
            if (canvas.isDisposed() || !canvas.isVisible()) {
                return;
            }
            int nextFrameIndex = ((Integer)canvas.getData("control.data.currentFrame") + 1) % imageLoader.data.length;
            canvas.setData("control.data.currentFrame", (Object)nextFrameIndex);
            Image nextFrame = new Image((Device)canvas.getDisplay(), imageLoader.data[nextFrameIndex]);
            canvas.getBackgroundImage().dispose();
            canvas.setBackgroundImage(nextFrame);
            ComponentUtil.delayToNextFrame(canvas, loader);
        }, curFrameData.delayTime * 10);
    }

    public static Canvas createCanvas(Composite parent, Image image) {
        return ComponentUtil.createCanvas(parent, image, -1, -1);
    }

    public static Canvas createCanvas(Composite parent, Image image, int width, int height) {
        final Canvas canvas = new Canvas(parent, 1611923456);
        canvas.setBackground(null);
        canvas.setForeground(null);
        if (image != null) {
            canvas.setBackgroundImage(image);
            canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    GC gc = StyleUtil.setupGC(event.gc);
                    Rectangle canvasBounds = canvas.getBounds();
                    Image currentImage = canvas.getBackgroundImage();
                    if (ControlUtil.isDisposed((Resource)currentImage)) {
                        return;
                    }
                    float imageScale = 0.8f;
                    Rectangle imageBounds = currentImage.getBounds();
                    int width = Math.min(Math.round((float)imageBounds.width * imageScale), canvasBounds.width);
                    int height = Math.min(Math.round((float)imageBounds.height * imageScale), canvasBounds.height);
                    canvas.setBackgroundImage(currentImage);
                    int left = Math.max((canvasBounds.width - imageBounds.width) / 2, 0);
                    int top = Math.max((canvasBounds.height - imageBounds.height) / 2, 0);
                    boolean isDisabled = !canvas.getEnabled();
                    Image finalImage = isDisabled ? new Image((Device)canvas.getDisplay(), currentImage, 1) : currentImage;
                    gc.drawImage(finalImage, 0, 0, imageBounds.width, imageBounds.height, left, top, width, height);
                    if (finalImage != currentImage) {
                        finalImage.dispose();
                    }
                    gc.dispose();
                }
            });
        }
        if (width != -1 && height != -1) {
            ComponentUtil.setSize((Control)canvas, width, height);
        }
        StyleContext.style((Control)canvas);
        return canvas;
    }

    public static Browser createBrowser(Composite parent) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return ComponentUtil.createBrowser(parent, 262144);
        }
        return ComponentUtil.createBrowser(parent, 0);
    }

    public static Browser createBrowser(Composite parent, int style) {
        Browser browser = new Browser(parent, style);
        StyleContext.style((Control)browser);
        return browser;
    }

    public static ToolBar createToolBar(Composite parent) {
        return ComponentUtil.createToolBar(parent, 0);
    }

    public static ToolBar createToolBar(Composite parent, int style) {
        ToolBar toolbar = new ToolBar(parent, style | 0x800000);
        return toolbar;
    }

    public static ToolItem createToolItem(Composite parent) {
        return ComponentUtil.createToolItem(parent, 0);
    }

    public static ToolItem createToolItem(Composite parent, int style) {
        ToolItem toolItem = new ToolItem((ToolBar)parent, style | 0x800000);
        return toolItem;
    }

    public static void setGridLayout(Control container) {
        if (container instanceof Composite) {
            ((Composite)container).setLayout((Layout)new GridLayout());
        }
    }

    public static void setGridLayout(Control container, int numCols) {
        if (container instanceof Composite) {
            ((Composite)container).setLayout((Layout)new GridLayout(numCols, false));
        }
    }

    public static void setGridLayout(Control container, int numCols, boolean equalWidth) {
        if (container instanceof Composite) {
            ((Composite)container).setLayout((Layout)new GridLayout(numCols, equalWidth));
        }
    }

    public static void setGridLayoutData(Control control, int colSpan, int rowSpan) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = colSpan;
        gridData.verticalSpan = rowSpan;
        control.setLayoutData((Object)gridData);
    }

    public static void setGridColSpan(Control control, int colSpan) {
        GridData gridData = ComponentUtil.getGridData(control);
        gridData.horizontalSpan = colSpan;
        control.setLayoutData((Object)gridData);
    }

    public static void setGridRowSpan(Control control, int rowSpan) {
        GridData gridData = ComponentUtil.getGridData(control);
        gridData.verticalSpan = rowSpan;
        control.setLayoutData((Object)gridData);
    }

    public static void setFillLayout(Control container, int type) {
        if (container instanceof Composite) {
            ((Composite)container).setLayout((Layout)new FillLayout(type));
        }
    }

    public static void setFillLayout(Control container) {
        ComponentUtil.setFillLayout(container, 256);
    }

    public static void setMargin(Composite container, int margin) {
        ComponentUtil.setMargin(container, margin, margin);
    }

    public static void setMargin(Composite container, int width, int height) {
        ComponentUtil.setMargin(container, height, width, height);
    }

    public static void setMargin(Composite container, int top, int width, int bottom) {
        ComponentUtil.setMargin(container, top, width, bottom, width);
    }

    public static void setMargin(Composite container, int top, int right, int bottom, int left) {
        ComponentUtil.setMarginTop(container, top);
        ComponentUtil.setMarginRight(container, right);
        ComponentUtil.setMarginBottom(container, bottom);
        ComponentUtil.setMarginLeft(container, left);
    }

    public static void setMarginHorizontal(Composite container, int margin) {
        ComponentUtil.setLayoutField(container, "marginWidth", margin);
    }

    public static void setMarginVertical(Composite container, int margin) {
        ComponentUtil.setLayoutField(container, "marginHeight", margin);
    }

    public static void setMarginTop(Composite container, int margin) {
        if (ObjectUtil.hasField((Object)ComponentUtil.getLayout((Control)container), (String)"marginTop")) {
            ComponentUtil.setLayoutField(container, "marginTop", margin);
        } else {
            ComponentUtil.setMarginVertical(container, margin);
        }
    }

    public static void setMarginRight(Composite container, int margin) {
        if (ObjectUtil.hasField((Object)ComponentUtil.getLayout((Control)container), (String)"marginRight")) {
            ComponentUtil.setLayoutField(container, "marginRight", margin);
        } else {
            ComponentUtil.setMarginHorizontal(container, margin);
        }
    }

    public static void setMarginBottom(Composite container, int margin) {
        if (ObjectUtil.hasField((Object)ComponentUtil.getLayout((Control)container), (String)"marginBottom")) {
            ComponentUtil.setLayoutField(container, "marginBottom", margin);
        } else {
            ComponentUtil.setMarginVertical(container, margin);
        }
    }

    public static void setMarginLeft(Composite container, int margin) {
        if (ObjectUtil.hasField((Object)ComponentUtil.getLayout((Control)container), (String)"marginLeft")) {
            ComponentUtil.setLayoutField(container, "marginLeft", margin);
        } else {
            ComponentUtil.setMarginHorizontal(container, margin);
        }
    }

    public static void setGroupIndent(Control control) {
        ComponentUtil.setGroupIndent(control, 1);
    }

    public static void setGroupIndent(Control control, int level) {
        ComponentUtil.setHorizontalIndent(control, level * 22);
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        if (ObjectUtil.hasField((Object)ComponentUtil.getLayoutData(control), (String)"horizontalIndent")) {
            ComponentUtil.setLayoutDataField(control, "horizontalIndent", horizontalIndent);
        } else if (control instanceof Composite) {
            ComponentUtil.setMarginLeft((Composite)control, horizontalIndent);
        }
    }

    public static void setVerticalIndent(Control control, int verticalIndent) {
        if (ObjectUtil.hasField((Object)ComponentUtil.getLayoutData(control), (String)"verticalIndent")) {
            ComponentUtil.setLayoutDataField(control, "verticalIndent", verticalIndent);
        } else if (control instanceof Composite) {
            ComponentUtil.setMarginTop((Composite)control, verticalIndent);
        }
    }

    public static void setLayoutField(Composite container, String fieldName, Object value) {
        Layout layout = ComponentUtil.getLayout((Control)container);
        if (layout == null) {
            layout = ComponentUtil.getGridLayout(container);
        }
        ObjectUtil.setField((Object)layout, (String)fieldName, (Object)value);
        container.setLayout(layout);
    }

    public static void setLayoutDataField(Control control, String fieldName, Object value) {
        Object layoutData = ComponentUtil.getLayoutData(control);
        if (layoutData == null) {
            layoutData = ComponentUtil.getGridData(control);
        }
        ObjectUtil.setField((Object)layoutData, (String)fieldName, (Object)value);
        control.setLayoutData(layoutData);
    }

    public static void setSpacing(Composite container, int spacing) {
        ComponentUtil.setSpacing(container, spacing, spacing);
    }

    public static void setSpacing(Composite container, int verticalSpacing, int horizontalSpacing) {
        ComponentUtil.setGridVerticalSpacing(container, verticalSpacing);
        ComponentUtil.setHorizontalSpacing(container, horizontalSpacing);
        ComponentUtil.setLayoutField(container, "spacing", Math.max(horizontalSpacing, verticalSpacing));
    }

    public static void setGridVerticalSpacing(Composite container, int verticalSpacing) {
        ComponentUtil.setLayoutField(container, "verticalSpacing", verticalSpacing);
        ComponentUtil.setLayoutField(container, "spacing", verticalSpacing);
    }

    public static void setHorizontalSpacing(Composite container, int horizontalSpacing) {
        ComponentUtil.setLayoutField(container, "horizontalSpacing", horizontalSpacing);
        ComponentUtil.setLayoutField(container, "spacing", horizontalSpacing);
    }

    public static void gridAlignCenter(Control control) {
        ComponentUtil.gridAlign(control, 0x1000000);
    }

    public static void gridAlignLeft(Control control) {
        ComponentUtil.gridAlign(control, 16384);
    }

    public static void gridAlignRight(Control control) {
        ComponentUtil.gridAlign(control, 131072);
    }

    public static void gridAlign(Control control, int align) {
        GridData gridData = ComponentUtil.getGridData(control);
        gridData.horizontalAlignment = align;
        gridData.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)gridData);
    }

    public static void textCenter(Control control) {
        ComponentUtil.textAlign(control, 0x1000000);
    }

    public static void textLeft(Control control) {
        ComponentUtil.textAlign(control, 16384);
    }

    public static void textRight(Control control) {
        ComponentUtil.textAlign(control, 131072);
    }

    public static void textAlign(Control control, int align) {
        try {
            Method setAlignment = control.getClass().getMethod("setAlignment", Integer.TYPE);
            if (setAlignment != null) {
                setAlignment.invoke((Object)control, align);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
    }

    public static void gridAlignTop(Control control) {
        ComponentUtil.gridVerticalAlign(control, 128);
    }

    public static void gridAlignBottom(Control control) {
        ComponentUtil.gridVerticalAlign(control, 1024);
    }

    public static void gridAlignMiddle(Control control) {
        ComponentUtil.gridVerticalAlign(control, 0x1000000);
    }

    public static void gridVerticalAlign(Control control, int align) {
        Object layoutData = ComponentUtil.getLayoutData(control);
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).verticalAlignment = align;
            ((GridData)layoutData).grabExcessVerticalSpace = true;
        }
        if (layoutData instanceof RowData) {
            RowLayout layout = (RowLayout)ComponentUtil.getLayout((Control)control.getParent());
            if (align == 0x1000000) {
                layout.center = true;
            }
        }
        control.setLayoutData(layoutData);
    }

    public static void gridFillHorizontal(Control control) {
        ComponentUtil.gridFillHorizontal(control, true);
    }

    public static void gridFillHorizontal(Control control, boolean fill) {
        GridData gridData = ComponentUtil.getGridData(control);
        gridData.horizontalAlignment = fill ? 4 : 1;
        gridData.grabExcessHorizontalSpace = fill;
        control.setLayoutData((Object)gridData);
    }

    public static void gridFillVertical(Control control) {
        ComponentUtil.gridFillVertical(control, true);
    }

    public static void gridFillVertical(Control control, boolean fill) {
        GridData gridData = ComponentUtil.getGridData(control);
        gridData.verticalAlignment = fill ? 4 : 0x1000000;
        gridData.grabExcessVerticalSpace = fill;
        control.setLayoutData((Object)gridData);
    }

    public static void gridFill(Control control) {
        ComponentUtil.gridFill(control, true);
    }

    public static void gridFill(Control control, boolean fill) {
        ComponentUtil.gridFillHorizontal(control, fill);
        ComponentUtil.gridFillVertical(control, fill);
    }

    public static void setNumCols(Control control, int numColumns) {
        if (!(control instanceof Composite)) {
            return;
        }
        GridLayout layout = ComponentUtil.getGridLayout((Composite)control);
        if (layout instanceof GridLayout) {
            layout.numColumns = numColumns;
        }
        ((Composite)control).setLayout((Layout)layout);
    }

    public static int findMaxWidthInChildren(Composite parent) {
        if (parent == null) {
            return 0;
        }
        return ComponentUtil.findMaxWidthInChildren(parent.getChildren());
    }

    public static int findMaxWidthInChildren(Control[] children) {
        int maxWidth = 0;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            maxWidth = Math.max(ComponentDataUtil.getWidth(child), maxWidth);
            ++n2;
        }
        return maxWidth;
    }

    public static void setChildrenWidth(Composite parent, int width) {
        if (parent == null) {
            return;
        }
        ComponentUtil.setChildrenWidth(parent.getChildren(), width);
    }

    public static void setChildrenBackgroundColor(Composite parent, Color color) {
        if (parent == null || color == null) {
            return;
        }
        ComponentUtil.recursivelySetBackgroundColor(parent.getChildren(), color);
    }

    private static void recursivelySetBackgroundColor(Control[] children, Color color) {
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(color);
            if (child instanceof Composite) {
                Composite comp = (Composite)child;
                ComponentUtil.recursivelySetBackgroundColor(comp.getChildren(), color);
            }
            ++n2;
        }
    }

    public static void setChildrenWidth(Control[] children, int width) {
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            ComponentUtil.setWidth(child, width);
            ++n2;
        }
        Control firstChild = children[0];
        if (firstChild != null) {
            firstChild.redraw();
        }
    }

    public static void removeChildrenWidth(Composite parent) {
        if (ControlUtil.isDisposed((Widget)parent)) {
            return;
        }
        ComponentUtil.removeChildrenWidth(parent.getChildren());
    }

    public static void removeChildrenWidth(Control[] children) {
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            ComponentUtil.setWidth(child, -1);
            ++n2;
        }
    }

    public static void adjustChildrenWidth(Composite parent) {
        ComponentUtil.adjustChildrenWidth(parent, true);
    }

    public static void adjustChildrenWidth(Composite parent, boolean discardChildrenWidth) {
        if (ControlUtil.isDisposed((Widget)parent)) {
            return;
        }
        ComponentUtil.adjustChildrenWidth(parent.getChildren(), discardChildrenWidth);
    }

    public static void adjustChildrenWidth(Control[] children) {
        ComponentUtil.adjustChildrenWidth(children, true);
    }

    public static void adjustChildrenWidth(Control[] children, boolean discardChildrenWidth) {
        int maxWidth;
        if (children == null || children.length <= 1) {
            return;
        }
        if (discardChildrenWidth) {
            ComponentUtil.removeChildrenWidth(children);
        }
        if ((maxWidth = ComponentUtil.findMaxWidthInChildren(children)) == 0) {
            maxWidth = children[0].getParent().getSize().x;
        }
        ComponentUtil.setChildrenWidth(children, maxWidth);
    }

    public static void setWidth(Control control, int width) {
        Object layoutData = ComponentUtil.getLayoutData(control);
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).widthHint = width;
        }
        if (layoutData instanceof RowData) {
            ((RowData)layoutData).width = width;
        }
        control.setLayoutData(layoutData);
        control.redraw();
    }

    public static void setHeight(Control control, int height) {
        Object layoutData = ComponentUtil.getLayoutData(control);
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).heightHint = height;
        }
        if (layoutData instanceof RowData) {
            ((RowData)layoutData).height = height;
        }
        control.setLayoutData(layoutData);
        control.redraw();
    }

    public static void setRows(Control control, int numRows) {
        if (control instanceof Text) {
            GC gc = new GC((Drawable)control);
            try {
                gc.setFont(control.getFont());
                FontMetrics fontMetrics = gc.getFontMetrics();
                ComponentUtil.setHeight(control, numRows * fontMetrics.getHeight());
            }
            finally {
                ControlUtil.dispose((Resource)gc);
            }
        }
    }

    public static void setSize(Control control, int size) {
        ComponentUtil.setSize(control, size, size);
    }

    public static void setSize(Control control, int width, int height) {
        ComponentUtil.setWidth(control, width);
        ComponentUtil.setHeight(control, height);
    }

    public static void autoSize(Control control, int width, int height) {
        ComponentUtil.setSize(control, width, height);
        ComponentUtil.applyZoom(control);
    }

    public static void autoSize(Control control, int size) {
        ComponentUtil.setSize(control, size);
        ComponentUtil.applyZoom(control);
    }

    public static void sizeXS(Control control) {
        ComponentUtil.setHeight(control, 20);
    }

    public static void sizeXS(Control control, int width) {
        ComponentUtil.setSize(control, width, 20);
    }

    public static void autoSizeXS(Control control, int width) {
        ComponentUtil.sizeXS(control, width);
        ComponentUtil.applyZoom(control);
    }

    public static void sizeSM(Control control) {
        ComponentUtil.setHeight(control, 25);
    }

    public static void sizeSM(Control control, int width) {
        ComponentUtil.setSize(control, width, 25);
    }

    public static void autoSizeSM(Control control) {
        ComponentUtil.autoSizeSM(control, -1);
        ComponentUtil.enableAutoWidth(control);
    }

    public static void autoSizeSM(Control control, int width) {
        ComponentUtil.sizeSM(control, width);
        ComponentUtil.applyZoom(control);
    }

    public static void sizeMD(Control control) {
        ComponentUtil.fontSize(control, 12);
        ComponentUtil.setHeight(control, 30);
    }

    public static void sizeMD(Control control, int width) {
        ComponentUtil.fontSize(control, 12);
        ComponentUtil.setSize(control, width, 30);
    }

    public static void autoSizeMD(Control control) {
        ComponentUtil.autoSizeMD(control, -1);
        ComponentUtil.enableAutoWidth(control);
    }

    public static void autoSizeMD(Control control, int width) {
        ComponentUtil.sizeMD(control, width);
        ComponentUtil.applyZoom(control);
    }

    public static void sizeLG(Control control) {
        ComponentUtil.fontSize(control, 14);
        ComponentUtil.setHeight(control, 35);
    }

    public static void sizeLG(Control control, int width) {
        ComponentUtil.fontSize(control, 14);
        ComponentUtil.setSize(control, width, 35);
    }

    public static void autoSizeLG(Control control) {
        ComponentUtil.autoSizeLG(control, -1);
        ComponentUtil.enableAutoWidth(control);
    }

    public static void autoSizeLG(Control control, int width) {
        ComponentUtil.sizeLG(control, width);
        ComponentUtil.applyZoom(control);
    }

    public static void sizeXL(Control control) {
        ComponentUtil.fontSize(control, 14);
        ComponentUtil.setHeight(control, 45);
    }

    public static void sizeXL(Control control, int width) {
        ComponentUtil.fontSize(control, 14);
        ComponentUtil.setSize(control, width, 45);
    }

    public static void autoSizeXL(Control control) {
        ComponentUtil.autoSizeXL(control, -1);
        ComponentUtil.enableAutoWidth(control);
    }

    public static void autoSizeXL(Control control, int width) {
        ComponentUtil.sizeXL(control, width);
        ComponentUtil.applyZoom(control);
    }

    public static void autoSizeCanvas(Control control) {
        boolean isDefineSize;
        if (!(control instanceof Canvas)) {
            return;
        }
        int width = ComponentDataUtil.getWidth(control);
        int height = ComponentDataUtil.getHeight((Widget)control);
        boolean bl = isDefineSize = width != -1 || height != -1;
        if (((Canvas)control).getBackgroundImage() != null) {
            Image backgroundImage = ((Canvas)control).getBackgroundImage();
            Rectangle imageBounds = backgroundImage.getBounds();
            if (width > 0 && height > 0) {
                height = (int)Math.round((double)imageBounds.height * ((double)width / (double)imageBounds.width));
                ComponentUtil.setSize(control, width, height);
                return;
            }
        }
        if (!isDefineSize) {
            Point size = control.computeSize(-1, -1);
            ComponentUtil.setSize(control, size.x + 15, size.y + 15);
        }
    }

    public static void disableAutoWidth(Control control) {
        ComponentUtil.setAutoWidth(control, false);
    }

    public static void enableAutoWidth(Control control) {
        ComponentUtil.setAutoWidth(control, true);
    }

    public static boolean isEnableAutoWidth(Control control) {
        return ComponentDataUtil.getBoolean((Widget)control, "control.autoWidth", false);
    }

    public static void setAutoWidth(Control control, boolean autoWidth) {
        ComponentDataUtil.set((Widget)control, "control.autoWidth", autoWidth);
    }

    public static void applyAutoWidth(Control control) {
        GC gc = new GC((Drawable)control);
        String text = StringUtils.defaultString((String)ComponentDataUtil.getText((Widget)control));
        Point textSize = gc.textExtent(text);
        Image image = ComponentDataUtil.getImage((Widget)control, "control.image");
        int imageWidth = image != null ? image.getBounds().width : 0;
        int spacing = imageWidth > 0 ? 5 : 0;
        int fontHeight = control.getFont().getFontData()[0].getHeight();
        int padding = (int)Math.floor((double)fontHeight * 1.0);
        int width = textSize.x + imageWidth + spacing + padding;
        ComponentUtil.setWidth(control, width);
    }

    public static void setRegion(Control control, Region region) {
        Region oldRegion = control.getRegion();
        control.setRegion(region);
        ControlUtil.dispose((Resource)oldRegion);
        ControlUtil.dispose((Resource)region);
    }

    public static void applyZoom(Control control) {
        int width = ComponentUtil.applyZoom(ComponentDataUtil.getWidth(control));
        int height = ComponentUtil.applyZoom(ComponentDataUtil.getHeight((Widget)control));
        ComponentUtil.setSize(control, width, height);
    }

    public static void setMinWidth(Control control, int minWidth) {
        Object layoutData = ComponentUtil.getLayoutData(control);
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).minimumWidth = minWidth;
        }
        control.setLayoutData(layoutData);
    }

    public static void setMinHeight(Control control, int minHeight) {
        Object layoutData = ComponentUtil.getLayoutData(control);
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).minimumHeight = minHeight;
        }
        control.setLayoutData(layoutData);
    }

    public static void setMinSize(Control control, int minSize) {
        ComponentUtil.setSize(control, minSize, minSize);
    }

    public static void setMinSize(Control control, int minWidth, int minHeight) {
        ComponentUtil.setMinWidth(control, minWidth);
        ComponentUtil.setMinHeight(control, minHeight);
    }

    public static void setRowSpacing(Composite container, int spacing) {
        RowLayout rowLayout = ComponentUtil.getRowLayout(container);
        rowLayout.spacing = spacing;
        container.setLayout((Layout)rowLayout);
    }

    public static void setRowJustify(Composite container, boolean justify) {
        RowLayout rowLayout = ComponentUtil.getRowLayout(container);
        rowLayout.justify = justify;
        container.setLayout((Layout)rowLayout);
    }

    public static void fontSize(Control control, int fontSize) {
        Font currentFont = control.getFont() != null ? control.getFont() : StyleContext.getFont();
        control.setFont(FontUtil.size(currentFont, fontSize));
    }

    public static void fontStyle(Control control, int fontStyle) {
        Font currentFont = control.getFont() != null ? control.getFont() : StyleContext.getFont();
        control.setFont(FontUtil.style(currentFont, fontStyle));
    }

    public static void fontFamily(Control control, String fontFamily) {
        Font currentFont = control.getFont() != null ? control.getFont() : StyleContext.getFont();
        control.setFont(FontUtil.family(currentFont, fontFamily));
    }

    public static void setContentAlign(Control control, int align) {
        ComponentUtil.setData((Widget)control, "control.content.align", align);
    }

    public static void setText(Widget control, String text) {
        ComponentDataUtil.setText(control, text);
        try {
            ((Control)control).requestLayout();
            if (StringUtils.isNotBlank((String)text)) {
                ObjectUtil.invokeSet((Object)control, (String)"setSelection", (Object)text.length(), Integer.TYPE);
            }
        }
        catch (Exception exception) {}
    }

    public static void setTitle(Control control, String title) {
        ComponentDataUtil.setTitle((Widget)control, title);
        try {
            control.requestLayout();
        }
        catch (Exception exception) {}
    }

    public static void setLimit(Control control, int maxLength) {
        ComponentDataUtil.setLimit((Widget)control, maxLength);
        try {
            control.requestLayout();
        }
        catch (Exception exception) {}
    }

    public static <T> void setOptions(Control control, Map<String, T> options) {
        ComponentUtil.clearOptions(control);
        List<String> keys = options.entrySet().stream().map(item -> (String)item.getKey()).collect(Collectors.toList());
        ComponentUtil.setOptions(control, keys.toArray(new String[0]));
        ComponentDataUtil.set((Widget)control, "control.data.options", options);
        Listener onChange = event -> {
            String selection = ComponentDataUtil.getText(event.widget);
            if (options.containsKey(selection)) {
                ComponentDataUtil.set((Widget)control, options.get(selection));
            } else {
                ComponentDataUtil.set((Widget)control, null);
            }
        };
        ComponentUtil.setComboOnchangeListener(control, onChange);
    }

    public static <T> void setOptions(Control control, T ... options) {
        ComponentUtil.clearOptions(control);
        ComponentDataUtil.set((Widget)control, "control.data.options", options);
        T[] TArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            T option = TArray[n2];
            ObjectUtil.invokeSet((Object)control, (String)"add", (Object)option.toString(), String.class);
            ++n2;
        }
        Listener onChange = event -> {
            String selection = ComponentDataUtil.getText(event.widget);
            Object selectedItem = Arrays.stream(options).filter(item -> StringUtils.equals((String)item.toString(), (String)selection)).findFirst().orElse(null);
            ComponentDataUtil.set((Widget)control, selectedItem);
        };
        ComponentUtil.setComboOnchangeListener(control, onChange);
    }

    public static void clearOptions(Control control) {
        ObjectUtil.safeInvoke((Object)control, (String)"removeAll");
        ComponentDataUtil.set((Widget)control, "control.data.options", null);
    }

    private static void setComboOnchangeListener(Control control, Listener onChange) {
        ComponentUtil.clearComboOnChangeListener(control);
        ComponentDataUtil.set((Widget)control, "control.data.comboOnChangeListener", onChange);
        ComponentEventUtil.onChange(control, onChange);
    }

    private static void clearComboOnChangeListener(Control control) {
        Listener oldListener = ComponentDataUtil.get((Widget)control, "control.data.comboOnChangeListener", null);
        ComponentEventUtil.removeOnChange((Widget)control, oldListener);
        ComponentDataUtil.set((Widget)control, "control.data.comboOnChangeListener", null);
    }

    public static void select(Widget control, String option) {
        Object[] items;
        int index;
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        if (ObjectUtil.hasMethod((Object)control, (String)"getItems", (Class[])new Class[0]) && (index = ArrayUtil.findIndex((Object[])(items = (String[])ObjectUtil.invokeGet((Object)control, (String)"getItems")), itemI -> StringUtils.equals((String)itemI, (String)option))) >= 0) {
            ComponentUtil.select(control, index);
        }
    }

    public static void select(Widget control) {
        ComponentUtil.select(control, 0);
    }

    public static void select(Widget control, int index) {
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        if (ObjectUtil.hasMethod((Object)control, (String)"select", (Class[])new Class[]{Integer.TYPE})) {
            Object selection;
            ObjectUtil.invokeSet((Object)control, (String)"select", (Object)index);
            control.setData((Object)ComponentDataUtil.getText(control));
            Object options = ComponentDataUtil.get(control, "control.data.options", null);
            if (options == null) {
                return;
            }
            if (options instanceof Map && index >= 0 && index < ((Map)options).size()) {
                selection = (Map.Entry)((Map)options).entrySet().toArray()[index];
                control.setData(selection.getValue());
            }
            if (options.getClass().isArray() && index >= 0 && index < ((Object[])options).length) {
                selection = ((Object[])options)[index];
                control.setData(selection);
            }
        }
    }

    public static void setRadioOption(Composite wrapper, Object option) {
        Control[] children;
        wrapper.setData(option);
        Control[] controlArray = children = wrapper.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control childI = controlArray[n2];
            if (childI instanceof Button) {
                Button button = (Button)childI;
                Object valueI = ComponentDataUtil.getRadioValue((Widget)button);
                button.setSelection(ObjectUtil.equals((Object)valueI, (Object)option));
            }
            ++n2;
        }
    }

    public static void setMessage(Widget control, String message) {
        ObjectUtil.invokeSet((Object)control, (String)"setMessage", (Object)message, String.class);
    }

    public static String getMessage(Widget control) {
        return (String)ObjectUtil.invokeGet((Object)control, (String)"getMessage", (Object)"");
    }

    public static void setPlaceholder(Widget control, String message) {
        ComponentUtil.setMessage(control, message);
    }

    public static String getPlaceholder(Widget control) {
        return ComponentUtil.getMessage(control);
    }

    public static void maskPassword(Widget control) {
        ComponentUtil.setPasswordMaskCharacter(control, '\u2022');
    }

    public static void setPasswordMaskCharacter(Widget control, char maskCharacter) {
        ObjectUtil.invokeSet((Object)control, (String)"setEchoChar", (Object)Character.valueOf(maskCharacter), Character.TYPE);
    }

    public static void removePasswordMask(Widget control) {
        ComponentUtil.setPasswordMaskCharacter(control, '\u0000');
    }

    public static void check(Widget control) {
        ComponentUtil.toggle(control, true);
    }

    public static boolean isChecked(Widget control) {
        return (Boolean)ObjectUtil.invokeGet((Object)control, (String)"getSelection", (Object)false);
    }

    public static void uncheck(Widget control) {
        ComponentUtil.toggle(control, false);
    }

    public static boolean toggle(Widget control) {
        boolean isChecked = ComponentUtil.isChecked(control);
        return ComponentUtil.toggle(control, !isChecked);
    }

    public static boolean toggle(Widget control, boolean state) {
        ObjectUtil.invokeSet((Object)control, (String)"setSelection", (Object)state, Boolean.TYPE);
        return state;
    }

    public static void setImage(Widget control, Image image) {
        ComponentUtil.setImage(control, image, 16384);
    }

    public static void setImage(Widget control, Image image, int align) {
        ObjectUtil.invokeSet((Object)control, (String)"setImage", (Object)image, Image.class);
        control.setData("control.image", (Object)image);
        control.setData("control.image.align", (Object)align);
    }

    public static void setDisabledImage(Widget control, Image image) {
        ComponentUtil.setImage(control, image, 16384);
    }

    public static void setDisabledImage(Widget control, Image image, int align) {
        ObjectUtil.invokeSet((Object)control, (String)"setDisabledImage", (Object)image, Image.class);
    }

    public static void setImageSize(Control control, int width, int height) {
        ComponentDataUtil.setImageSize(control, width, height);
    }

    public static void setImageScale(Control control, float scale) {
        ComponentDataUtil.setImageScale((Widget)control, scale);
    }

    public static void setColor(Control control, Color color) {
        control.setForeground(color);
        ComponentDataUtil.set((Widget)control, "control.color", control.getForeground());
    }

    public static void setForeground(Control control, Color foreground) {
        control.setForeground(foreground);
    }

    public static void setBackground(Control control, Color background) {
        control.setBackground(background);
        ComponentDataUtil.set((Widget)control, "control.background", control.getBackground());
    }

    public static void setHoverColor(Control control, Color color) {
        ComponentUtil.setData((Widget)control, "control.hover.color", color);
    }

    public static void setHoverBackground(Control control, Color background) {
        ComponentUtil.setData((Widget)control, "control.hover.background", background);
    }

    public static void setHoverBorderColor(Control control, Color color) {
        ComponentUtil.setData((Widget)control, "control.hover.border.color", color);
    }

    public static void setActiveColor(Control control, Color color) {
        ComponentUtil.setData((Widget)control, "control.active.color", color);
    }

    public static void setActiveBackground(Control control, Color background) {
        ComponentUtil.setData((Widget)control, "control.active.background", background);
    }

    public static void setActiveBorderColor(Control control, Color color) {
        ComponentUtil.setData((Widget)control, "control.active.border.color", color);
    }

    public static void setDisabledColor(Control control, Color color) {
        ComponentUtil.setData((Widget)control, "control.disabled.color", color);
    }

    public static void setDisabledBackground(Control control, Color background) {
        ComponentUtil.setData((Widget)control, "control.disabled.background", background);
    }

    public static void setDisabledBorderColor(Control control, Color color) {
        ComponentUtil.setData((Widget)control, "control.disabled.border.color", color);
    }

    public static void setBackgroundImage(Control control, Image image) {
        control.setBackgroundImage(image);
    }

    public static void setBackgroundMode(Control control, int mode) {
        if (control instanceof Composite) {
            ((Composite)control).setBackgroundMode(mode);
        }
    }

    public static void setBorder(Control control) {
        ComponentUtil.setBorder(control, 1);
    }

    public static void setBorder(Control control, int borderWidth) {
        ComponentUtil.setBorderWidth(control, borderWidth);
    }

    public static void setBorder(Control control, Color color) {
        ComponentUtil.setBorderColor(control, color);
    }

    public static void setBorder(Control control, int borderWidth, Color color) {
        ComponentUtil.setBorderWidth(control, borderWidth);
        ComponentUtil.setBorderColor(control, color);
    }

    public static void setBorderWidth(Control control, int borderWidth) {
        ComponentUtil.setData((Widget)control, "control.border.width", borderWidth);
    }

    public static void setBorderColor(Control control, Color color) {
        ComponentUtil.setData((Widget)control, "control.border.color", color);
    }

    public static void setBorderRadius(Control control) {
        ComponentUtil.setBorderRadius(control, 8);
    }

    public static void setBorderRadius(Control control, int borderRadius) {
        ComponentUtil.setData((Widget)control, "control.border.radius", borderRadius);
    }

    public static void setUnderline(Control control, boolean enableUnderline) {
        ComponentUtil.setData((Widget)control, "control.underline", enableUnderline);
    }

    public static void setHoverUnderline(Control control, boolean enableUnderline) {
        ComponentUtil.setData((Widget)control, "control.hover.underline", enableUnderline);
    }

    public static Cursor getCursor(int cursorType) {
        if (cursorType == -1 || cursorType == 0) {
            return null;
        }
        Cursor existingCursor = savedCursors.get(cursorType);
        if (existingCursor != null) {
            return existingCursor;
        }
        Cursor newCursor = new Cursor((Device)Display.getCurrent(), cursorType);
        savedCursors.put(cursorType, newCursor);
        return newCursor;
    }

    public static void setCursorPointer(Control control) {
        ComponentUtil.setCursor(control, 21);
    }

    public static void setCursorDefault(Control control) {
        ComponentUtil.setCursor(control, -1);
    }

    public static void setCursor(Control control, int cursorType) {
        Cursor cursor = ComponentUtil.getCursor(cursorType);
        control.setCursor(cursor);
    }

    public static boolean hasRole(Control control, ComponentRole ... roles) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return false;
        }
        Set<ComponentRole> allRoles = ComponentUtil.getRoles(control);
        return Arrays.asList(roles).stream().allMatch(roleI -> allRoles.contains(roleI));
    }

    public static void addRole(Control control, ComponentRole ... roles) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        Set<ComponentRole> allRoles = ComponentUtil.getRoles(control);
        allRoles.addAll(Arrays.asList(roles));
        ComponentDataUtil.set((Widget)control, "control.role", allRoles);
    }

    public static void removeRole(Control control, ComponentRole ... roles) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        Set<ComponentRole> allRoles = ComponentUtil.getRoles(control);
        allRoles.removeAll(Arrays.asList(roles));
        ComponentDataUtil.set((Widget)control, "control.role", allRoles);
    }

    public static Set<ComponentRole> getRoles(Control control) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return null;
        }
        return ComponentDataUtil.get((Widget)control, "control.role", new HashSet());
    }

    public static void setRoles(Control control, Set<ComponentRole> roles) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        ComponentDataUtil.set((Widget)control, "control.role", roles);
    }

    public static void clearRoles(Control control) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        ComponentDataUtil.set((Widget)control, "control.role", new ArrayList());
    }

    public static void setData(Widget control, Object data) {
        control.setData(data);
    }

    public static void setData(Widget control, String key, Object value) {
        control.setData(key, value);
    }

    public static void setClassName(Widget control, String className) {
        control.setData("org.eclipse.e4.ui.css.CssClassName", (Object)className);
    }

    public static void setClasses(Widget control, String ... classes) {
        control.setData("org.eclipse.e4.ui.css.CssClassName", (Object)StringUtils.join((Object[])classes, (String)" "));
    }

    public static void setId(Widget control, String id) {
        control.setData("org.eclipse.e4.ui.css.id", (Object)id);
    }

    public static void setTabIndex(Control control) {
        ComponentUtil.setTabIndex(control, 0);
    }

    public static void setTabIndex(Control control, int tabIndex) {
        ComponentDataUtil.setTabIndex(control, tabIndex);
        ComponentEventUtil.switchOnTab(control);
    }

    public static Map<String, Object> addStateAutoKey(Control control, String text) {
        return ComponentUtil.addState(control, text, null);
    }

    public static Map<String, Object> addStateAutoKey(Control control, String text, Image image) {
        return ComponentUtil.addState(control, ComponentUtil.getStates(control).size(), text, image);
    }

    public static Map<String, Object> addState(Control control, Object stateKey, String text) {
        return ComponentUtil.addState(control, stateKey, text, null);
    }

    public static Map<String, Object> addState(Control control, Object stateKey, String text, Image image) {
        LinkedHashMap<Object, Map<String, Object>> states = ComponentUtil.getStates(control);
        LinkedHashMap<String, Object> newState = new LinkedHashMap<String, Object>();
        if (text != null) {
            newState.put("control.text", text);
        }
        if (image != null) {
            newState.put("control.image", image);
        }
        states.put(stateKey, newState);
        Object currentKey = control.getData("control.data.currentState");
        if (currentKey == null) {
            control.setData("control.data.currentState", stateKey);
        }
        return newState;
    }

    public static Object switchState(Control control) {
        LinkedHashMap<Object, Map<String, Object>> states = ComponentUtil.getStates(control);
        Object[] keys = states.keySet().toArray();
        Object currentKey = ComponentUtil.getCurrentStateKey(control);
        int i = 0;
        while (i < keys.length) {
            if (currentKey.equals(keys[i])) {
                int nextStateIndex = (i + 1) % keys.length;
                Object nextStateKey = keys[nextStateIndex];
                ComponentUtil.switchState(control, nextStateKey);
                return nextStateKey;
            }
            ++i;
        }
        return null;
    }

    public static Map<String, Object> switchState(Control control, Object stateKey) {
        Image image;
        Map<String, Object> state = ComponentUtil.getState(control, stateKey);
        if (state == null) {
            return null;
        }
        String text = (String)state.get("control.text");
        if (text != null) {
            ComponentUtil.setText((Widget)control, text);
        }
        if ((image = (Image)state.get("control.image")) != null) {
            ComponentUtil.setImage((Widget)control, image);
        }
        control.setData("control.data.currentState", stateKey);
        return state;
    }

    public static Map<String, Object> getCurrentState(Control control) {
        Object currentStateKey = ComponentUtil.getCurrentStateKey(control);
        return ComponentUtil.getState(control, currentStateKey);
    }

    public static Object getCurrentStateKey(Control control) {
        return control.getData("control.data.currentState");
    }

    public static Map<String, Object> getState(Control control, Object stateKey) {
        LinkedHashMap<Object, Map<String, Object>> states = ComponentUtil.getStates(control);
        return states.get(stateKey);
    }

    public static LinkedHashMap<Object, Map<String, Object>> getStates(Control control) {
        LinkedHashMap states = (LinkedHashMap)control.getData("control.data.states");
        if (states == null) {
            states = new LinkedHashMap();
            control.setData("control.data.states", states);
        }
        return states;
    }

    public static Region createRectangleRegion(Rectangle rect, Rectangle targetRect) {
        boolean isCaretInCorner;
        int targetCenterX = targetRect.x + targetRect.width / 2;
        int targetCenteYX = targetRect.y + targetRect.height / 2;
        Point targetCenter = new Point(targetCenterX, targetCenteYX);
        int size = 8;
        int caretOffset = size + 8;
        Rectangle innerRect = new Rectangle(rect.x + size, rect.y + size, rect.width - size, rect.height - size);
        Rectangle localInnerRect = new Rectangle(size, size, rect.width - size, rect.height - size);
        int minX = innerRect.x;
        int minY = innerRect.y;
        int maxX = innerRect.x + innerRect.width;
        int maxY = innerRect.y + innerRect.height;
        int x = Math.min(Math.max(targetCenter.x, minX), maxX);
        int y = Math.min(Math.max(targetCenter.y, minY), maxY);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(targetRect.x, targetRect.y));
        targetPoints.add(new Point(targetRect.x + targetRect.width, targetRect.y));
        targetPoints.add(new Point(targetRect.x, targetRect.y + targetRect.height));
        targetPoints.add(new Point(targetRect.x + targetRect.width, targetRect.y + targetRect.height));
        Integer[] sides = new Integer[]{0, 0, 0, 0};
        for (Point point : targetPoints) {
            sides[0] = sides[0] + (point.y <= minY ? 1 : 0);
            sides[1] = sides[1] + (point.x >= maxX ? 1 : 0);
            sides[2] = sides[2] + (point.y >= maxY ? 1 : 0);
            sides[3] = sides[3] + (point.x <= minX ? 1 : 0);
        }
        List<Integer> sideList = Arrays.asList(sides);
        boolean isOnTheSide = Collections.max(sideList) == 4;
        int sideIndex = sideList.indexOf(Collections.max(sideList));
        boolean bl = isCaretInCorner = x - minX < caretOffset && y - minY < caretOffset || maxX - x < caretOffset && y - minY < caretOffset || maxX - x < caretOffset && maxY - y < caretOffset || x - minX < caretOffset && maxY - y < caretOffset;
        if (!isOnTheSide) {
            return ComponentUtil.createRectangleRegion(localInnerRect);
        }
        if (isCaretInCorner) {
            if (sideIndex == 0 || sideIndex == 2) {
                x = innerRect.x + innerRect.width / 2;
                int n = y = sideIndex == 0 ? innerRect.y : innerRect.y + innerRect.height;
            }
            if (sideIndex == 1 || sideIndex == 3) {
                y = innerRect.y + innerRect.height / 2;
                x = sideIndex == 1 ? innerRect.x + innerRect.width : innerRect.x;
            }
        }
        Region region = ComponentUtil.createRectangleRegion(localInnerRect);
        region.add(new int[]{x -= rect.x, (y -= rect.y) - size, x + size, y, x, y + size, x - size, y});
        return region;
    }

    public static Region createRectangleRegion(Rectangle rect) {
        return ComponentUtil.createRectangleRegion(rect, 4);
    }

    public static Region createRectangleRegion(Rectangle rect, int radius) {
        if (rect == null || rect.width < 0 || rect.height < 0) {
            return null;
        }
        return ComponentUtil.createRectangleRegion(rect.x, rect.y, rect.width, rect.height, radius);
    }

    public static Region createRectangleRegion(int x, int y, int width, int height) {
        return ComponentUtil.createRectangleRegion(x, y, width, height, 4);
    }

    public static Region createRectangleRegion(int x, int y, int width, int height, int radius) {
        Region region = new Region();
        try {
            int d = 2 * radius;
            region.add(ComponentUtil.createCircleRegion(x + radius, y + radius, radius));
            region.add(ComponentUtil.createCircleRegion(x + width - radius, y + radius, radius));
            region.add(ComponentUtil.createCircleRegion(x + width - radius, y + height - radius, radius));
            region.add(ComponentUtil.createCircleRegion(x + radius, y + height - radius, radius));
            region.add(x + radius, y, width - d, height);
            region.add(x, y + radius, width, height - d);
            return region;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            region.dispose();
            return null;
        }
    }

    public static int[] createCircleRegion(int x, int y, int r) {
        int[] polygon = new int[8 * r + 4 + 16];
        int i = 0;
        while (i < 2 * r + 1) {
            int xI = i - r;
            int yI = (int)Math.sqrt(r * r - xI * xI);
            polygon[2 * i] = x + xI;
            polygon[2 * i + 1] = y + yI;
            polygon[8 * r - 2 * i - 2] = x + xI;
            polygon[8 * r - 2 * i - 1] = y - yI;
            ++i;
        }
        return polygon;
    }

    public static Rectangle getScreenArea(Widget control) {
        return ComponentUtil.getScreenArea(control, null);
    }

    public static Rectangle getScreenArea(Widget control, Control targetArea) {
        Rectangle clientArea = ComponentUtil.getClientArea(control);
        if (clientArea == null) {
            return null;
        }
        boolean startFromControl = control instanceof Control;
        Control parent1 = startFromControl ? (Control)control : (Control)ControlUtil.getParent(control);
        Control parent2 = (Control)ControlUtil.getParent((Widget)parent1);
        if (startFromControl) {
            clientArea.x = 0;
            clientArea.y = 0;
        }
        if (control instanceof TreeItem) {
            clientArea.x = 0;
        }
        if (control instanceof Text) {
            clientArea.x -= 2;
            clientArea.y -= 2;
        }
        if (control instanceof CTabFolder) {
            clientArea.y += ComponentUtil.getTabNavHeight();
        }
        if (control instanceof ToolItem) {
            if (ComponentUtil.getScreenArea((Widget)parent2).height == 0) {
                clientArea.y = ComponentBundleActivator.isDarkTheme(ShellManager.getMainShell().getDisplay()) ? clientArea.y - (SystemUtils.IS_OS_MAC ? 13 : 17) : clientArea.y - (SystemUtils.IS_OS_MAC ? 19 : 22);
            } else if (ComponentUtil.getScreenArea((Widget)parent2).height == ComponentUtil.getScreenArea((Widget)parent1).height && ComponentUtil.getScreenArea((Widget)parent2).height != 0 && ComponentUtil.getScreenArea((Widget)parent2).height < 30) {
                clientArea.y -= 25;
            }
        }
        Rectangle screenArea = clientArea;
        while (parent2 != null) {
            screenArea = ComponentUtil.mapCoordinates(screenArea, parent1, parent2);
            parent1 = parent2;
            parent2 = (Control)ControlUtil.getParent((Widget)parent2);
        }
        screenArea = ComponentUtil.mapCoordinates(screenArea, parent1 instanceof Shell ? parent1 : parent2, targetArea);
        return screenArea;
    }

    public static Rectangle getClientArea(Widget control) {
        boolean shouldUseBounds;
        if (control == null) {
            return null;
        }
        Rectangle clientArea = (Rectangle)ObjectUtil.invokeGet((Object)control, (String)"getClientArea");
        boolean bl = shouldUseBounds = clientArea == null || !(control instanceof Control);
        if (shouldUseBounds) {
            clientArea = (Rectangle)ObjectUtil.invokeGet((Object)control, (String)"getBounds");
        }
        if (clientArea == null) {
            return null;
        }
        if (!(control instanceof CTabFolder)) {
            boolean cfr_ignored_0 = control instanceof Group;
        }
        if (control instanceof TreeItem) {
            clientArea.width = ((TreeItem)control).getParent().getSize().x - ComponentUtil.applyZoom(10);
        }
        if (control instanceof Text) {
            clientArea.width += 4;
            clientArea.height += 4;
        }
        if (control instanceof Group) {
            clientArea.width += ComponentUtil.getGroupAdjustingWidth();
            clientArea.height += ComponentUtil.getGroupAdjustingHeight();
        }
        return clientArea;
    }

    public static Rectangle mapCoordinates(Rectangle rect, Control from, Control to) {
        if (rect == null || from == null && to == null) {
            return null;
        }
        Display display = (Display)ArrayUtil.getAnyNotNull((Object[])new Display[]{from != null ? from.getDisplay() : null, to != null ? to.getDisplay() : null});
        return display.map(from, to, rect);
    }

    public static void show(Control control) {
        ComponentUtil.setVisible(control, true);
    }

    public static void hide(Control control) {
        ComponentUtil.setVisible(control, false);
    }

    public static boolean toggleVisible(Control control) {
        return ComponentUtil.setVisible(control, !control.getVisible());
    }

    public static boolean setVisible(Control control, boolean visible) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return false;
        }
        control.setVisible(visible);
        Object layoutData = ComponentUtil.getLayoutData(control);
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = !visible;
            control.setLayoutData(layoutData);
        }
        control.requestLayout();
        return visible;
    }

    public static void removeToolItemMenu(Widget control) {
        Object menu = control.getData();
        if (menu instanceof Menu) {
            ControlUtil.dispose((Widget)((Menu)menu));
        }
    }

    public static void applyPrimaryBadgeStyle(Control control) {
        ComponentUtil.setBorderRadius(control);
        ComponentUtil.setColor(control, ColorUtil.getTextWhiteColor());
        ComponentUtil.setBackground(control, ColorUtil.PRIMARY_COLOR);
    }

    public static void applyPrimaryButtonStyle(Control control) {
        ComponentUtil.setCursorPointer(control);
        ComponentUtil.applyPrimaryBadgeStyle(control);
        ComponentUtil.setHoverColor(control, ColorUtil.getTextWhiteColor());
        ComponentUtil.setHoverBackground(control, ColorUtil.PRIMARY_HOVER_COLOR);
        ComponentUtil.setActiveColor(control, ColorUtil.getTextWhiteColor());
        ComponentUtil.setActiveBackground(control, ColorUtil.PRIMARY_ACTIVE_COLOR);
        ComponentUtil.setDisabledColor(control, ColorUtil.getTextWhiteColor());
        ComponentUtil.setDisabledBackground(control, ColorUtil.GRAY_DARK_COLOR);
    }

    public static void applyPrimaryButtonStyle2(Control control) {
        ComponentUtil.setCursorPointer(control);
        ComponentUtil.applyPrimaryBadgeStyle(control);
    }

    public static void applyPrimaryButtonStyle3(Control control) {
        Color disabledColor = ColorUtil.themeColor(ColorUtil.getColor("#838587"), ColorUtil.getColor("#919299"));
        Color disabledBackgroundColor = ColorUtil.themeColor("#f0f2f5", "#46474D");
        ComponentUtil.applyPrimaryButtonStyle3WithCustomDisableColors(control, disabledColor, disabledBackgroundColor, ColorUtil.themeColor("#dadcdf", "#414247"));
    }

    public static void applyPrimaryButtonStyle3WithCustomDisableColors(Control control, Color disabledColor, Color disabledBackgroundColor, Color disabledBorderColor) {
        ComponentUtil.fontStyle(control, 1);
        ComponentUtil.setCursorPointer(control);
        ComponentUtil.setBorderRadius(control);
        ComponentUtil.setBorder(control, ComponentUtil.applyZoom(1), ColorUtil.themeColor("#2133D1", "#2133D1"));
        ComponentUtil.setDisabledBorderColor(control, disabledBorderColor);
        ComponentUtil.setColor(control, ColorUtil.getColor("#ffffff"));
        ComponentUtil.setBackground(control, ColorUtil.getColor("#2236E5"));
        ComponentUtil.setHoverColor(control, ColorUtil.getTextWhiteColor());
        ComponentUtil.setHoverBackground(control, ColorUtil.getColor("#1E30CC"));
        ComponentUtil.setActiveColor(control, ColorUtil.getTextWhiteColor());
        ComponentUtil.setActiveBackground(control, ColorUtil.getColor("#1A2AB2"));
        ComponentUtil.setDisabledColor(control, disabledColor);
        ComponentUtil.setDisabledBackground(control, disabledBackgroundColor);
    }

    public static void applySecondaryButtonStyle(Control control) {
        ComponentUtil.applySecondaryButtonStyleWithCustomDisabledColor(control, ColorUtil.getColor("#919299"), ColorUtil.getColor("#CACACA"));
    }

    public static void applySecondaryButtonStyleWithCustomDisabledColor(Control control, Color disabledColor, Color disabledBackgroundColor) {
        Color color = ColorUtil.themeColor(ColorUtil.getTextBlackColor(), ColorUtil.getTextWhiteColor());
        Color hoverColor = ColorUtil.themeColor(ColorUtil.getColor("#1E30CC"), ColorUtil.getColor("#000"));
        Color activeColor = ColorUtil.themeColor(ColorUtil.getColor("#18181A"), ColorUtil.getColor("#3c7be1"));
        Color borderColor = ColorUtil.themeColor(ColorUtil.getColor("#E8E8E8"), ColorUtil.getColor("#46474D"));
        Color backgroundColor = ColorUtil.themeColor(ColorUtil.getWhiteBackgroundColor(), ColorUtil.getColor("#525658"));
        ComponentUtil.setCursorPointer(control);
        ComponentUtil.setBorderRadius(control);
        ComponentUtil.setBorder(control, ComponentUtil.applyZoom(1), borderColor);
        ComponentUtil.setColor(control, color);
        ComponentUtil.setBackground(control, backgroundColor);
        ComponentUtil.setHoverColor(control, hoverColor);
        ComponentUtil.setHoverBackground(control, ColorUtil.getColor("#F2F3FA"));
        ComponentUtil.setHoverBorderColor(control, ColorUtil.getColor("#B9BCDD"));
        ComponentUtil.setActiveColor(control, activeColor);
        ComponentUtil.setActiveBackground(control, ColorUtil.getColor("#E9E8F0"));
        ComponentUtil.setDisabledColor(control, disabledColor);
        ComponentUtil.setDisabledBackground(control, disabledBackgroundColor);
    }

    public static void applyGrayBadgeStyle(Control control) {
        ComponentUtil.setBorderRadius(control);
        ComponentUtil.setColor(control, ColorUtil.GRAY_BADGE_COLOR);
        ComponentUtil.setBackground(control, ColorUtil.GRAY_BADGE_BACKGROUND);
    }

    public static void applyGrayButtonStyle(Control control) {
        ComponentUtil.setCursorPointer(control);
        ComponentUtil.applyGrayBadgeStyle(control);
        ComponentUtil.setHoverColor(control, ColorUtil.GRAY_BADGE_COLOR);
        ComponentUtil.setHoverBackground(control, ColorUtil.GRAY_BADGE_HOVER_COLOR);
        ComponentUtil.setActiveColor(control, ColorUtil.GRAY_BADGE_COLOR);
        ComponentUtil.setActiveBackground(control, ColorUtil.GRAY_BADGE_ACTIVE_COLOR);
        ComponentUtil.setDisabledColor(control, ColorUtil.getTextWhiteColor());
        ComponentUtil.setDisabledBackground(control, ColorUtil.GRAY_DARK_COLOR);
    }

    public static void applyLinkButtonStyle(Control control) {
        ComponentUtil.applyLinkButtonStyleWithCustomDisabledColor(control, ColorUtil.getTextWhiteColor());
    }

    public static void applyLinkButtonStyleWithCustomDisabledColor(Control control, Color disabledColor) {
        Color color = ColorUtil.themeColor(ColorUtil.getTextBlackColor(), ColorUtil.getTextWhiteColor());
        Color hoverColor = ColorUtil.themeColor("#1E30CC", "#8ab4f8");
        Color activeColor = ColorUtil.themeColor(ColorUtil.GRAY_BADGE_ACTIVE_COLOR, "#3c7be1");
        ComponentUtil.setCursorPointer(control);
        ComponentUtil.setDisabledColor(control, disabledColor);
        ComponentUtil.setColor(control, color);
        ComponentUtil.setHoverColor(control, hoverColor);
        ComponentUtil.setActiveColor(control, activeColor);
        ComponentUtil.setUnderline(control, ControlUtil.checkStyle(control.getStyle(), 4));
        ComponentUtil.setHoverUnderline(control, true);
    }

    public static void appendGridChild(Composite container, Control child) {
        child.setParent(container);
        ++ComponentUtil.getGridLayout((Composite)container).numColumns;
    }

    public static void disableButton(Control control) {
        ComponentUtil.setCursorDefault(control);
        control.setEnabled(false);
        control.redraw();
    }

    public static void enableButton(Control control) {
        control.setEnabled(true);
        control.redraw();
        ComponentUtil.setCursorPointer(control);
    }

    public static void setEnabledButton(Control control, boolean enabled) {
        if (enabled) {
            ComponentUtil.enableButton(control);
        } else {
            ComponentUtil.disableButton(control);
        }
    }

    public static GridLayout getGridLayout(Composite container) {
        Layout layout = container.getLayout();
        return layout != null && layout instanceof GridLayout ? (GridLayout)layout : new GridLayout();
    }

    public static GridData getGridData(Control control) {
        Object layoutData = control.getLayoutData();
        return layoutData != null && layoutData instanceof GridData ? (GridData)layoutData : new GridData();
    }

    public static Layout getLayout(Control container) {
        if (!(container instanceof Composite)) {
            return null;
        }
        return ((Composite)container).getLayout();
    }

    public static Object getLayoutData(Control control) {
        Object layoutData = control.getLayoutData();
        if (layoutData == null) {
            Layout layout = control.getParent().getLayout();
            if (layout instanceof GridLayout) {
                return new GridData();
            }
            if (layout instanceof RowLayout) {
                return new RowData();
            }
            if (layout instanceof StackLayout) {
                return new GridData();
            }
        }
        return layoutData;
    }

    public static boolean hasGridData(Control control) {
        return control.getLayoutData() instanceof GridData;
    }

    public static RowLayout getRowLayout(Composite container) {
        RowLayout rowLayout = (RowLayout)container.getLayout();
        return rowLayout != null ? rowLayout : new RowLayout(256);
    }

    public static RowData getRowData(Control control) {
        RowData gridData = (RowData)control.getLayoutData();
        return gridData != null ? gridData : new RowData();
    }

    public static boolean hasRowData(Control control) {
        return control.getLayoutData() instanceof RowData;
    }

    public static void showError(Control control, String message) {
        ComponentUtil.showError(control, message, false);
    }

    public static void showError(Control control, String message, boolean packShell) {
        ComponentUtil.showMessage(control, message, ColorUtil.getTextErrorColor(), packShell);
    }

    public static void showWarning(Control control, String message) {
        ComponentUtil.showWarning(control, message, false);
    }

    public static void showWarning(Control control, String message, boolean packShell) {
        ComponentUtil.showMessage(control, message, ColorUtil.getTextWarningColor(), packShell);
    }

    public static void showWaiting(Control control, String message) {
        ComponentUtil.showWaiting(control, message, false);
    }

    public static void showWaiting(Control control, String message, boolean packShell) {
        ComponentUtil.showMessage(control, message, ColorUtil.getTextWarningColor(), packShell);
    }

    public static void showSuccess(Control control, String message) {
        ComponentUtil.showSuccess(control, message, false);
    }

    public static void showSuccess(Control control, String message, boolean packShell) {
        ComponentUtil.showMessage(control, message, ColorUtil.getTextSuccessfulColor(), packShell);
    }

    public static void showMessage(Control control, String message) {
        ComponentUtil.showMessage(control, message, false);
    }

    public static void showMessage(Control control, String message, boolean packShell) {
        ComponentUtil.showMessage(control, message, ColorUtil.getTextBlackColor(), packShell);
    }

    public static void showMessage(Control control, String message, Color color) {
        ComponentUtil.showMessage(control, message, color, false);
    }

    public static void showMessage(Control control, String message, Color color, boolean packShell) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        ComponentUtil.setText((Widget)control, message);
        control.setForeground(color);
        ComponentUtil.setHeight(control, StringUtils.isNotBlank((String)message) ? -1 : 0);
        ComponentUtil.requestLayout(control, packShell);
    }

    public static void requestLayout(Control control, boolean packShell) {
        control.requestLayout();
        Shell shell = control.getShell();
        Composite shellParent = shell != null ? shell.getParent() : null;
        boolean isDialogShell = shellParent != null && shellParent.getShell() != null && control.getShell() != shellParent.getShell();
        control.getParent().pack();
        if (isDialogShell && packShell && !shell.getMaximized() && !shell.getMinimized()) {
            Point currentSize = shell.getSize();
            shell.pack();
            Point newSize = shell.getSize();
            if (newSize.y < 100) {
                Widget[] children;
                shell.setSize(currentSize);
                Widget[] widgetArray = children = ControlUtil.getChildren((Widget)control.getShell());
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Widget childI = widgetArray[n2];
                    if (childI instanceof Composite) {
                        ((Composite)childI).pack();
                    }
                    ++n2;
                }
            }
        }
    }

    public static void clearMessage(Control control) {
        ComponentUtil.setText((Widget)control, "");
        control.requestLayout();
    }

    public static void stretchBackground(Control control) {
        Image curBackground = control.getBackgroundImage();
        Image stretchedBackground = ComponentUtil.resize(curBackground, control.getSize().x, control.getSize().y);
        control.setBackgroundImage(stretchedBackground);
    }

    public static Image resize(Image image, int width, int height) {
        return ComponentUtil.resize(image, width, height, true);
    }

    public static Image resize(Image image, int width, int height, boolean disposeImage) {
        if (image == null || image.isDisposed()) {
            return null;
        }
        Device device = image.getDevice();
        Image scaled = new Image(device, width, height);
        GC gc = StyleUtil.setupGC(new GC((Drawable)scaled));
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        if (disposeImage) {
            image.dispose();
        }
        return scaled;
    }

    public static ToolBar createToolbar(Composite parent, int style) {
        return new ToolBar(parent, style);
    }

    public static void traverseToTop(Control control, ComponentEventUtil.ControlHandler callback) {
        if (control == null) {
            return;
        }
        callback.call(control);
        Composite parent = control.getParent();
        while (parent != null) {
            callback.call((Control)parent);
            if (parent instanceof Shell) break;
            parent = parent.getParent();
        }
    }

    public static void removeAllChildren(Composite parent) {
        Control[] children;
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control childI = controlArray[n2];
            childI.dispose();
            ++n2;
        }
    }

    public static interface BrowserFunctionHandler {
        public Object call(Object[] var1);
    }

    public static interface ComponentProvider<ComponentType extends Widget> {
        public ComponentType render(Composite var1);
    }

    public static interface CompositeProvider
    extends ComponentProvider<Composite> {
        @Override
        public Composite render(Composite var1);
    }

    public static interface ControlProvider
    extends ComponentProvider<Control> {
        @Override
        public Control render(Composite var1);
    }

    public static interface LocationChangingListener {
        public void call(LocationEvent var1);
    }

    public static interface WidgetProvider
    extends ComponentProvider<Widget> {
        @Override
        public Widget render(Composite var1);
    }
}

