/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.report.integration.ReportComposerIntegrationFactory;
import com.kms.katalon.composer.report.platform.ExportReportProviderPlugin;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.report.ReportEntity;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.net.URLClassLoader;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportHTMLReportHandler {
    @CanExecute
    public static boolean canExecute(ESelectionService selectionService) {
        return true;
    }

    @Execute
    public static void execute(ESelectionService selectionService, Shell shell) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        String exportPath = directoryDialog.open();
        if (exportPath == null) {
            return;
        }
        File exportDirectory = new File(exportPath);
        if (exportDirectory != null && exportDirectory.exists() && exportDirectory.isDirectory()) {
            Object[] selectedObjects;
            Object[] objectArray = selectedObjects = (Object[])selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                try {
                    if (selectedObject instanceof ReportTreeEntity && ((ReportTreeEntity)selectedObject).getObject() instanceof ReportEntity) {
                        ReportEntity report = ((ReportTreeEntity)selectedObject).getObject();
                        File exportedFile = new File(exportDirectory, String.valueOf(report.getDisplayName()) + ".html");
                        URLClassLoader projectClassLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
                        Binding binding = new Binding();
                        ExportReportProviderPlugin exportReportProviderPlugin = ReportComposerIntegrationFactory.getInstance().getExportReportPluginProviders().get(0);
                        binding.setVariable("exportProvider", exportReportProviderPlugin.getProvider());
                        binding.setVariable("fileLocation", (Object)exportedFile);
                        binding.setVariable("reportId", (Object)report.getId());
                        binding.setVariable("formatType", (Object)"HTML");
                        GroovyShell groovyShell = new GroovyShell((ClassLoader)projectClassLoader, binding);
                        groovyShell.evaluate("exportProvider.exportTestSuite(fileLocation, reportId, formatType)");
                        Program.launch((String)exportedFile.toURI().toString());
                    }
                }
                catch (Throwable e) {
                    LoggerSingleton.logError((Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("Unable to export html report (" + e.getMessage() + ")"));
                }
                ++n2;
            }
        }
    }
}

