/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.SelectionServiceSingleton;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.entity.report.ReportEntity;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportJUnitReportHandler {
    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute(Shell shell) {
        DirectoryDialog dirDialog = new DirectoryDialog(shell);
        String exportPath = dirDialog.open();
        if (exportPath == null) {
            return;
        }
        File destDir = new File(exportPath);
        if (destDir == null || !destDir.exists() || !destDir.isDirectory()) {
            return;
        }
        Object[] selectedReports = this.getSelectedReports();
        ArrayList<String> exceptions = new ArrayList<String>();
        Object[] objectArray = selectedReports;
        int n = selectedReports.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            try {
                ReportEntity report;
                if (selectedObject instanceof ReportTreeEntity && (report = ((ReportTreeEntity)selectedObject).getObject()) != null) {
                    File junitFile = new File(report.getJUnitFile());
                    if (!junitFile.exists()) {
                        ReportUtil.writeLogRecordToJUnitFile((String)report.getLocation());
                    }
                    String destReportName = "JUnit_Report.xml";
                    if (selectedReports.length > 1) {
                        destReportName = String.valueOf(report.getName()) + File.separator + destReportName;
                    }
                    FileUtils.copyFile((File)junitFile, (File)new File(destDir, destReportName));
                    Program.launch((String)destDir.toURI().toString());
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                exceptions.add(e.getMessage());
            }
            ++n2;
        }
        if (exceptions.isEmpty()) {
            return;
        }
        String errorMsgDetails = StringUtils.join(exceptions, (String)"\n");
        MultiStatusErrorDialog.showErrorDialog((String)"Unable to export JUnit report", (String)errorMsgDetails, (String)errorMsgDetails);
    }

    public Object[] getSelectedReports() {
        Object o = SelectionServiceSingleton.getInstance().getSelectionService().getSelection("com.kms.katalon.composer.part.explorer");
        if (o == null || !o.getClass().isArray()) {
            return new Object[0];
        }
        return (Object[])o;
    }
}

