/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.report.menu.ExportReportMenuItemObject;
import com.kms.katalon.composer.report.platform.ExportReportProviderPlugin;
import com.kms.katalon.composer.report.platform.ExportReportProviderReflection;
import com.kms.katalon.entity.report.ReportEntity;
import java.io.File;
import java.net.MalformedURLException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportTestSuiteReportHandler {
    @Inject
    ESelectionService selectionService;

    @Execute
    public void execute(@Optional MDirectMenuItem directMenuItem, final Shell shell) {
        if (directMenuItem == null) {
            return;
        }
        final ExportReportMenuItemObject menuItemObject = (ExportReportMenuItemObject)directMenuItem.getTransientData().get("menuItemObject");
        final ExportReportProviderPlugin exportReportProviderPlugin = menuItemObject.getExportReportPlugin();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        String exportPath = directoryDialog.open();
        if (exportPath == null) {
            return;
        }
        File exportDirectory = new File(exportPath);
        if (exportDirectory != null && exportDirectory.exists() && exportDirectory.isDirectory()) {
            Object[] selectedObjects;
            Object[] objectArray = selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                try {
                    if (selectedObject instanceof ReportTreeEntity && ((ReportTreeEntity)selectedObject).getObject() instanceof ReportEntity) {
                        final ReportEntity report = ((ReportTreeEntity)selectedObject).getObject();
                        final File exportedFile = new File(exportDirectory, String.valueOf(report.getDisplayName()) + this.getExtension(menuItemObject.getFormatType()));
                        Job job = new Job("Export test suite report"){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    monitor.beginTask("Exporting report to " + menuItemObject.getFormatType() + " format...", -1);
                                    ExportReportProviderReflection reflection = new ExportReportProviderReflection(exportReportProviderPlugin);
                                    reflection.exportTestSuite(report, menuItemObject.getFormatType(), exportedFile);
                                    UISynchronizeService.syncExec(() -> {
                                        boolean bl = Program.launch((String)exportedFile.toURI().toString());
                                    });
                                    IStatus iStatus = Status.OK_STATUS;
                                    return iStatus;
                                }
                                catch (ReflectiveOperationException | MalformedURLException | CoreException e) {
                                    LoggerSingleton.logError((Throwable)e);
                                    UISynchronizeService.syncExec(() -> 1.lambda$1(shell, (Exception)e));
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                finally {
                                    monitor.done();
                                }
                            }

                            private static /* synthetic */ void lambda$1(Shell shell2, Exception exception) {
                                MessageDialog.openError((Shell)shell2, (String)"Error", (String)("Unable to export report (" + exception.getMessage() + ")"));
                            }
                        };
                        job.setUser(true);
                        job.schedule();
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                ++n2;
            }
        }
    }

    private String getExtension(String formatType) {
        if (StringUtils.containsIgnoreCase((CharSequence)formatType, (CharSequence)"html")) {
            return ".html";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)formatType, (CharSequence)"csv")) {
            return ".csv";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)formatType, (CharSequence)"pdf")) {
            return ".pdf";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)formatType, (CharSequence)"junit")) {
            return ".xml";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)formatType, (CharSequence)"xml")) {
            return ".xml";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)formatType, (CharSequence)"json")) {
            return ".json";
        }
        return "";
    }
}

