/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.lookup;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.controller.LogRecordController;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.report.ReportEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LogRecordLookup
implements EventHandler {
    private static LogRecordLookup _instance;

    private LogRecordLookup() {
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("REPORT/DELETED", (EventHandler)this);
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("PROJECT/OPENED", (EventHandler)this);
    }

    public static LogRecordLookup getInstance() {
        if (_instance == null) {
            _instance = new LogRecordLookup();
        }
        return _instance;
    }

    public TestSuiteLogRecord getTestSuiteLogRecord(String reportId) {
        return LogRecordController.getInstance().getTestSuiteLogRecord(reportId);
    }

    public TestSuiteLogRecord getTestSuiteLogRecordByFullPath(String reportFullpath) {
        return LogRecordController.getInstance().getTestSuiteLogRecordByFullPath(reportFullpath);
    }

    public synchronized TestSuiteLogRecord getTestSuiteLogRecord(ReportEntity reportEntity) {
        return LogRecordController.getInstance().getTestSuiteLogRecord(reportEntity);
    }

    public synchronized TestSuiteLogRecord getTestSuiteLogRecord(ReportEntity reportEntity, IProgressMonitor progressMonitor) {
        return LogRecordController.getInstance().getTestSuiteLogRecord(reportEntity, progressMonitor);
    }

    public void refreshLogRecord(ReportEntity reportEntity) {
        LogRecordController.getInstance().refreshLogRecord(reportEntity);
    }

    public void handleEvent(Event event) {
        String topic;
        switch (topic = event.getTopic()) {
            case "REPORT/UPDATED": {
                Object[] objects = (Object[])event.getProperty("org.eclipse.e4.data");
                if (objects == null || objects.length != 2) {
                    return;
                }
                String updatedReportId = (String)objects[0];
                LogRecordController.getInstance().deleteReport(updatedReportId);
                break;
            }
            case "REPORT/DELETED": {
                String reportId = (String)event.getProperty("org.eclipse.e4.data");
                LogRecordController.getInstance().deleteReport(reportId);
                break;
            }
            case "PROJECT/OPENED": {
                LogRecordController.getInstance().clear();
            }
        }
    }
}

