/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide.format;

import com.kms.katalon.selenium.ide.format.Formatter;
import com.kms.katalon.selenium.ide.model.Command;
import com.kms.katalon.selenium.ide.util.ClazzUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StoreFormatter
implements Formatter {
    private static final String ACTION = "store";

    @Override
    public String format(Command command) {
        String formatted = "";
        try {
            formatted = this.checked(command);
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.whether(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.notChecked(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.present(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.normal(command);
            }
        }
        catch (Exception exception) {
            formatted = String.format("Method %s is not found", command.getCommand());
        }
        return String.valueOf(formatted) + "\n";
    }

    public String normal(Command command) throws Exception {
        StringBuffer formatted = new StringBuffer();
        Pattern pattern = Pattern.compile("(store)(.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String commandTail = matcher.group(2);
            if (StringUtils.isNotBlank((CharSequence)commandTail)) {
                String cleanedMethod = this.getCleanCommandTail(commandTail);
                if (StringUtils.isNotBlank((CharSequence)cleanedMethod)) {
                    Object returnedType = ClazzUtils.getReturnedType("get" + cleanedMethod);
                    String paramName = this.getParamName("get" + cleanedMethod, command.getTarget(), command.getValue());
                    String method = this.getNormalMethod(cleanedMethod, command.getTarget());
                    formatted.append(returnedType + " " + paramName + " = " + method);
                } else {
                    formatted.append("String " + command.getValue() + " = " + this.valueOf(command.getTarget()));
                }
            } else {
                formatted.append("String " + command.getValue() + " = " + this.valueOf(command.getTarget()));
            }
            String wait = this.getWaitIfHas(command.getCommand());
            if (StringUtils.isNotBlank((CharSequence)wait)) {
                formatted.append(wait);
            }
        }
        return formatted.toString();
    }

    public String present(Command command) throws Exception {
        StringBuffer formatted = new StringBuffer();
        Pattern pattern = Pattern.compile("(store)(.*?)(Present)");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String paramName = this.getParamName("is" + matcher.group(2) + "Present", command.getTarget(), command.getValue());
            String method = this.getBoolMethod(matcher.group(2), command.getTarget());
            formatted.append("boolean " + paramName + " = " + method);
        }
        return formatted.toString();
    }

    public String checked(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(store)(Checked|Editable|Ordered|Visible|SomethingSelected)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String paramName = this.getParamName("is" + matcher.group(2), command.getTarget(), command.getValue());
            String method = this.getBoolCheckedMethod(matcher.group(2), command.getTarget());
            return "boolean " + paramName + " = " + method;
        }
        return "";
    }

    public String notChecked(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(store)(Not)(Checked|Editable|Ordered|Visible|SomethingSelected)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolCheckedMethod(matcher.group(3), command.getTarget());
            return "storeFalse(" + method + ")";
        }
        return "";
    }

    public String whether(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(store)(Whether.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolWhetherMethod(matcher.group(2), command.getTarget(), command.getValue());
            return "boolean " + command.getValue() + " = " + method;
        }
        return "";
    }
}

