/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide.format;

import com.kms.katalon.selenium.ide.format.Formatter;
import com.kms.katalon.selenium.ide.model.Command;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VerifyAndAssertFormatter
implements Formatter {
    private String action;

    public VerifyAndAssertFormatter(String action) {
        this.action = action;
    }

    @Override
    public String format(Command command) {
        String formatted = "";
        try {
            formatted = this.checked(command);
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.notChecked(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.whether(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.notWhether(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.notPresent(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.present(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.normal(command);
            }
        }
        catch (Exception exception) {
            formatted = String.format("Method %s is not found", command.getCommand());
        }
        return String.valueOf(formatted) + "\n";
    }

    public String normal(Command command) throws Exception {
        StringBuffer formatted = new StringBuffer();
        Pattern pattern = Pattern.compile("(" + this.action + ")(.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String suffixMethodName = matcher.group(2);
            String actionMethod = this.getActionMethod(suffixMethodName, command.getTarget(), command.getValue());
            String condition = this.conditionWithMatchingOrNot(suffixMethodName, command.getTarget(), command.getValue());
            formatted.append(String.valueOf(actionMethod) + "(" + condition + ")");
            String wait = this.getWaitIfHas(matcher.group(2));
            if (StringUtils.isNotBlank((CharSequence)wait)) {
                formatted.append(wait);
            }
        }
        return formatted.toString();
    }

    public String getActionMethod(String commandTail, String target, String value) {
        if (this.isMatching(this.getPattern(commandTail, target, value))) {
            return commandTail.startsWith("Not") ? String.valueOf(this.action) + "False" : String.valueOf(this.action) + "True";
        }
        return commandTail.startsWith("Not") ? String.valueOf(this.action) + "NotEquals" : String.valueOf(this.action) + "Equals";
    }

    public String notPresent(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(" + this.action + ")(.*?)(Not)(Present)");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolMethod(matcher.group(2), command.getTarget());
            return String.valueOf(this.action) + "False(" + method + ")";
        }
        return "";
    }

    public String present(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(" + this.action + ")(.*?)(Present)");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolMethod(matcher.group(2), command.getTarget());
            return String.valueOf(this.action) + "True(" + method + ")";
        }
        return "";
    }

    public String checked(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(" + this.action + ")(Checked|Editable|Ordered|Visible|SomethingSelected)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolCheckedMethod(matcher.group(2), command.getTarget());
            return String.valueOf(this.action) + "True(" + method + ")";
        }
        return "";
    }

    public String notChecked(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(" + this.action + ")(Not)(Checked|Editable|Ordered|Visible|SomethingSelected)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolCheckedMethod(matcher.group(3), command.getTarget());
            return String.valueOf(this.action) + "False(" + method + ")";
        }
        return "";
    }

    public String whether(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(" + this.action + ")(Whether.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolWhetherMethod(matcher.group(2), command.getTarget(), command.getValue());
            return String.valueOf(this.action) + "True(" + method + ")";
        }
        return "";
    }

    public String notWhether(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(" + this.action + ")(Not)(Whether.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolWhetherMethod(matcher.group(3), command.getTarget(), command.getValue());
            return String.valueOf(this.action) + "False(" + method + ")";
        }
        return "";
    }
}

