/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.editors;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.impl.components.SettingOptionsThread;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MirrorEditor
extends Composite {
    private static final String RESOURCES_TEMPLATE_EDITOR = "resources/template/editor";
    private static final String DARK_THEME_CSS = "darcula";
    private Browser browser;
    private boolean documentReady = false;
    private DocumentReadyHandler documentReadyHandler;
    private File templateFile;
    private Collection<EditorChangeListener> listeners = new LinkedList<EditorChangeListener>();
    private static final Map<String, String> TEXT_MODE_COLLECTION = new HashMap<String, String>();

    static {
        TEXT_MODE_COLLECTION.put(TextContentType.TEXT.getText(), "text/plain");
        TEXT_MODE_COLLECTION.put(TextContentType.JSON.getText(), "application/ld+json");
        TEXT_MODE_COLLECTION.put(TextContentType.XML.getText(), "application/xml");
        TEXT_MODE_COLLECTION.put(TextContentType.HTML.getText(), "text/html");
        TEXT_MODE_COLLECTION.put(TextContentType.JAVASCRIPT.getText(), "application/javascript");
    }

    public MirrorEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        this.browser = new Browser((Composite)this, 0);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.setJavascriptEnabled(true);
        this.templateFile = this.initHTMLTemplateFile();
        try {
            this.browser.setUrl(this.templateFile.toURI().toURL().toString());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        final boolean isDarkTheme = ComponentBundleActivator.isDarkTheme((Display)this.getDisplay());
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                MirrorEditor.this.documentReady = true;
                MirrorEditor.this.onDocumentReady();
                if (isDarkTheme) {
                    MirrorEditor.this.browser.evaluate(String.format("editor.setOption(\"theme\", \"%s\");", MirrorEditor.DARK_THEME_CSS));
                }
                MirrorEditor.this.browser.evaluate("document.addEventListener('contextmenu', function(e) { e.preventDefault();});");
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    private File initHTMLTemplateFile() {
        File templateFile = null;
        try {
            File codeMirrorTempFolder = new File(this.getConfigurationFolder(), "resources/template/editor/codemirror");
            if (!codeMirrorTempFolder.exists() || ArrayUtils.isEmpty((Object[])codeMirrorTempFolder.listFiles())) {
                codeMirrorTempFolder.mkdirs();
                File bundleLocation = FileLocator.getBundleFile((Bundle)FrameworkUtil.getBundle(MirrorEditor.class));
                if (bundleLocation.isDirectory()) {
                    FileUtils.copyDirectory((File)new File(bundleLocation, RESOURCES_TEMPLATE_EDITOR), (File)codeMirrorTempFolder.getParentFile());
                } else {
                    FileUtils.copyDirectory((File)new File(this.getConfigurationFolder(), RESOURCES_TEMPLATE_EDITOR), (File)codeMirrorTempFolder.getParentFile());
                }
            }
            templateFile = new File(codeMirrorTempFolder, String.format("template_%d.html", System.currentTimeMillis()));
            FileUtils.copyFile((File)new File(codeMirrorTempFolder, "template.html"), (File)templateFile);
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog(ComposerComponentsImplMessageConstants.PA_MSG_UNABLE_TO_OPEN_BODY_EDITOR, e.getMessage(), ExceptionsUtil.getMessageForThrowable((Throwable)e));
        }
        return templateFile;
    }

    private File getConfigurationFolder() {
        try {
            return new File(FileLocator.resolve((URL)Platform.getConfigurationLocation().getURL()).getFile());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    public void setEditable(boolean editable) {
        String command = MessageFormat.format("editor.setOption(\"{0}\", {1});", "readOnly", !editable);
        if (this.documentReady) {
            this.browser.evaluate(command);
        } else {
            new SettingOptionsThread(this.browser, command).start();
        }
    }

    public void setText(String text) {
        String setTextCommand = String.format("editor.setValue(\"%s\");", StringEscapeUtils.escapeEcmaScript((String)text));
        if (this.documentReady) {
            this.browser.evaluate(setTextCommand);
        } else {
            new SettingOptionsThread(this.browser, setTextCommand).start();
        }
    }

    public void setHintText(String text) {
        String setTextCommand = String.format("document.getElementById(\"lineHint\").innerHTML=\"%s\";", StringEscapeUtils.escapeEcmaScript((String)text));
        if (this.documentReady) {
            this.browser.evaluate(setTextCommand);
        } else {
            new SettingOptionsThread(this.browser, setTextCommand).start();
        }
    }

    public void wrapLine(boolean wrapped) {
        this.browser.evaluate(MessageFormat.format("editor.setOption(\"{0}\", {1});", "lineWrapping", wrapped));
    }

    public Object evaluate(String script) {
        return this.browser.evaluate(script);
    }

    public void registerDocumentHandler(DocumentReadyHandler handler) {
        this.documentReadyHandler = handler;
    }

    public void changeMode(String text) {
        String textType = TEXT_MODE_COLLECTION.keySet().stream().filter(key -> text.toLowerCase().startsWith(key.toLowerCase())).findFirst().orElse(TextContentType.TEXT.getText());
        String mode = TEXT_MODE_COLLECTION.get(textType);
        String command = MessageFormat.format("changeMode(editor, \"{0}\");", mode);
        if (this.documentReady) {
            this.browser.evaluate(command);
        } else {
            new SettingOptionsThread(this.browser, command).start();
        }
    }

    public void beautify() {
        String command = String.format("format(editor); editor.focus(); editor.setCursor({line: 0, ch: 0});", new Object[0]);
        if (this.documentReady) {
            this.browser.evaluate(command);
        } else {
            new SettingOptionsThread(this.browser, command).start();
        }
    }

    public String getText() {
        String command = "return editor.getValue();";
        return this.browser.evaluate(command).toString();
    }

    private void onDocumentReady() {
        if (this.documentReadyHandler != null) {
            this.documentReadyHandler.onDocumentReady();
        }
        new BrowserFunction(this.browser, "handleEditorChanged"){

            public Object function(Object[] objects) {
                MirrorEditor.this.notifyListeners(24, new Event());
                return null;
            }
        };
        new BrowserFunction(this.browser, "handleMouseOverChanged"){

            public Object function(Object[] objects) {
                Iterator<EditorChangeListener> iterator = MirrorEditor.this.listeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().handleEditorEvent("handleMouseOverChanged", objects);
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "handleGenerateVerificationEvent"){

            public Object function(Object[] objects) {
                Iterator<EditorChangeListener> iterator = MirrorEditor.this.listeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().handleEditorEvent("handleGenerateVerificationEvent", objects);
                }
                return null;
            }
        };
        this.addDisposeListener(e -> {
            if (this.templateFile != null && this.templateFile.exists()) {
                this.templateFile.delete();
            }
        });
    }

    public void addEventListener(EditorChangeListener l) {
        this.listeners.add(l);
    }

    public static interface EditorChangeListener {
        public void handleEditorEvent(String var1, Object[] var2);
    }
}

