/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.editors;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import java.nio.file.FileSystems;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SingleFileSelectionDialogCellEditor
extends CellEditor {
    private Text txtFilePath;
    private Button btnChooseFile;
    private Composite editor;
    private boolean fileDialogOpened = false;
    private String buttonLabel;

    public SingleFileSelectionDialogCellEditor(Composite parent) {
        this(parent, null);
    }

    public SingleFileSelectionDialogCellEditor(Composite parent, String label) {
        super(parent, 0);
        this.buttonLabel = label;
        this.btnChooseFile.setText(this.getButtonName());
    }

    private String getButtonName() {
        return StringUtils.defaultString((String)this.buttonLabel, (String)StringConstants.BTN_CHOOSE_A_FILE);
    }

    protected Control createControl(Composite parent) {
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setLayout((Layout)new FileSelectionCellLayout());
        this.editor.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (!SingleFileSelectionDialogCellEditor.this.fileDialogOpened) {
                    SingleFileSelectionDialogCellEditor.this.focusLost();
                }
            }
        });
        this.txtFilePath = new Text(this.editor, this.getStyle());
        this.txtFilePath.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SingleFileSelectionDialogCellEditor.this.keyReleaseOccured(e);
                if (SingleFileSelectionDialogCellEditor.this.getControl() == null || SingleFileSelectionDialogCellEditor.this.getControl().isDisposed()) {
                    return;
                }
            }
        });
        this.btnChooseFile = new Button(this.editor, 1024);
        this.btnChooseFile.setText(this.getButtonName());
        this.btnChooseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SingleFileSelectionDialogCellEditor.this.fileDialogOpened = true;
                Object newValue = SingleFileSelectionDialogCellEditor.this.openDialogBox((Control)SingleFileSelectionDialogCellEditor.this.editor);
                SingleFileSelectionDialogCellEditor.this.fileDialogOpened = false;
                if (newValue != null) {
                    boolean newValidState = SingleFileSelectionDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        SingleFileSelectionDialogCellEditor.this.markDirty();
                        SingleFileSelectionDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        SingleFileSelectionDialogCellEditor.this.setErrorMessage(MessageFormat.format(SingleFileSelectionDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    SingleFileSelectionDialogCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Object oldValue = this.doGetValue();
        FileDialog fileDialog = new FileDialog(cellEditorWindow.getShell(), 4);
        String firstFile = fileDialog.open();
        if (firstFile != null) {
            String filterPath = fileDialog.getFilterPath();
            String fileName = fileDialog.getFileName();
            String filePath = String.format("%s%s%s", filterPath, FileSystems.getDefault().getSeparator(), fileName);
            return filePath;
        }
        return oldValue;
    }

    protected Object doGetValue() {
        return this.txtFilePath.getText();
    }

    protected void doSetFocus() {
        if (this.txtFilePath != null) {
            this.txtFilePath.selectAll();
            this.txtFilePath.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.txtFilePath.setText(text);
    }

    private class FileSelectionCellLayout
    extends Layout {
        private FileSelectionCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = SingleFileSelectionDialogCellEditor.this.btnChooseFile.computeSize(-1, -1, force);
            if (SingleFileSelectionDialogCellEditor.this.txtFilePath != null) {
                SingleFileSelectionDialogCellEditor.this.txtFilePath.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            SingleFileSelectionDialogCellEditor.this.btnChooseFile.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = SingleFileSelectionDialogCellEditor.this.txtFilePath.computeSize(-1, -1, force);
            Point buttonSize = SingleFileSelectionDialogCellEditor.this.btnChooseFile.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

