/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.helpers;

import com.kms.katalon.composer.components.constants.ComponentConstants;
import com.kms.katalon.composer.components.constants.ComponentSize;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentRole;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DialogBuilder<DialogType extends Dialog> {
    protected Shell shell;
    protected String title;
    protected String message;
    protected Image image;
    protected ComponentSize size = ComponentSize.MEDIUM;
    private ComponentBuilder.CompositeBuilderProvider containerBuilderProvider;
    private ComponentUtil.WidgetProvider contentProvider;
    private ComponentBuilder.CompositeBuilderProvider buttonBarBuilderProvider;
    private List<ComponentBuilder.ButtonBuilderProvider> buttonBuilderProviders = new ArrayList<ComponentBuilder.ButtonBuilderProvider>();

    public DialogBuilder() {
        this(Display.getCurrent().getActiveShell());
    }

    public DialogBuilder(Shell shell) {
        this.shell = shell;
    }

    public static <DialogType extends Dialog> DialogBuilder<DialogType> create() {
        return DialogBuilder.create(Display.getCurrent().getActiveShell());
    }

    public static <DialogType extends Dialog> DialogBuilder<DialogType> create(Shell shell) {
        DialogBuilder<DialogType> builder = new DialogBuilder<DialogType>(shell);
        return builder;
    }

    public DialogBuilder<DialogType> title(String title) {
        this.title = title;
        return this;
    }

    public DialogBuilder<DialogType> message(String message) {
        this.message = message;
        return this;
    }

    public DialogBuilder<DialogType> image(Image image) {
        this.image = image;
        return this;
    }

    public DialogBuilder<DialogType> error() {
        this.image(ComponentUtil.getSWTImage((int)1));
        this.title(GlobalMessageConstants.ERROR_TITLE);
        return this;
    }

    public DialogBuilder<DialogType> warning() {
        this.image(ComponentUtil.getSWTImage((int)8));
        this.title(GlobalMessageConstants.WARN_TITLE);
        return this;
    }

    public DialogBuilder<DialogType> info() {
        this.image(ComponentUtil.getSWTImage((int)2));
        this.title(GlobalMessageConstants.INFO_TITLE);
        return this;
    }

    public DialogBuilder<DialogType> size(ComponentSize size) {
        this.size = size;
        return this;
    }

    public DialogBuilder<DialogType> container(ComponentBuilder.CompositeBuilderProvider containerBuilderProvider) {
        this.containerBuilderProvider = containerBuilderProvider;
        return this;
    }

    public DialogBuilder<DialogType> content(ComponentUtil.WidgetProvider contentProvider) {
        this.contentProvider = contentProvider;
        return this;
    }

    public DialogBuilder<DialogType> buttonBar(ComponentBuilder.CompositeBuilderProvider buttonBarBuilderProvider) {
        this.buttonBarBuilderProvider = buttonBarBuilderProvider;
        return this;
    }

    public DialogBuilder<DialogType> button(ComponentBuilder.ButtonBuilderProvider buttonBuilderProvider) {
        this.buttonBuilderProviders.add(buttonBuilderProvider);
        return this;
    }

    public void open() {
        DialogType dialog = this.build();
        dialog.open();
    }

    protected Control createDialogContents(Composite parent) {
        Composite container = this.createContainer(parent);
        this.createContent(container);
        Composite buttonBar = this.createButtonBar(container);
        this.createButtons(buttonBar);
        return container;
    }

    protected Composite createContainer(Composite parent) {
        ComponentBuilder containerBuilder = ComponentBuilder.gridContainer((Composite)parent).fill().margin(10, 12);
        if (this.size != null) {
            containerBuilder.width(ComponentUtil.getSize((ComponentSize)this.size, (Map)ComponentConstants.DIALOG_SIZE_MAP));
        }
        if (this.containerBuilderProvider != null) {
            this.containerBuilderProvider.build(containerBuilder);
        }
        return (Composite)containerBuilder.build();
    }

    protected void createContent(Composite parent) {
        boolean hasImage = this.image != null;
        Composite contentContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)(hasImage ? 2 : 1)).fill().gridHorizontalSpacing(10).build();
        if (hasImage) {
            ComponentBuilder.label((Composite)contentContainer).image(this.image).build();
        }
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            ComponentBuilder.label((Composite)contentContainer).text(this.message).fillHorizontal().build();
        }
        if (this.contentProvider != null) {
            this.contentProvider.render(contentContainer);
        }
    }

    protected Composite createButtonBar(Composite parent) {
        Composite buttonBarWrapper = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().marginTop(10).build();
        ComponentBuilder.separator((Composite)buttonBarWrapper).build();
        int numButtons = this.getValidButtonBuilderProviders().size();
        ComponentBuilder buttonBarBuilder = ComponentBuilder.gridContainer((Composite)buttonBarWrapper, (int)numButtons).right().gridHorizontalSpacing(2);
        if (this.buttonBarBuilderProvider != null) {
            this.buttonBarBuilderProvider.build(buttonBarBuilder);
        }
        Composite buttonBar = (Composite)buttonBarBuilder.build();
        return buttonBar;
    }

    protected void createButtons(Composite parent) {
        this.getValidButtonBuilderProviders().stream().forEachOrdered(buttonBuilderProviderI -> {
            ComponentBuilder buttonBuilderI = ComponentBuilder.button((Composite)parent);
            buttonBuilderProviderI.build(buttonBuilderI);
            Button button = (Button)buttonBuilderI.build();
            if (ComponentUtil.hasRole((Control)button, (ComponentRole[])new ComponentRole[]{ComponentRole.DEFAULT_BUTTON})) {
                DialogUtil.setDefaultButton((Button)button);
            }
            if (ComponentUtil.hasRole((Control)button, (ComponentRole[])new ComponentRole[]{ComponentRole.CLOSE_BUTTON})) {
                ComponentEventUtil.onClick((Widget)button, event -> {
                    Dialog dialog = (Dialog)button.getShell().getData();
                    dialog.close();
                });
            }
        });
    }

    private List<ComponentBuilder.ButtonBuilderProvider> getValidButtonBuilderProviders() {
        return this.buttonBuilderProviders.stream().filter(buttonBuilderProviderI -> buttonBuilderProviderI != null).collect(Collectors.toList());
    }

    public DialogType build() {
        return (DialogType)new Dialog(this.shell){

            protected Control createContents(Composite parent) {
                return DialogBuilder.this.createDialogContents(parent);
            }

            protected void setShellStyle(int newShellStyle) {
                super.setShellStyle(newShellStyle | 0x8000 | 0x20 | 0x40 | 0x10);
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(DialogBuilder.this.title);
            }
        };
    }
}

