/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.installer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;

public class CustomTailer
extends Tailer {
    private static final int DEFAULT_DELAY_MILLIS = 1000;
    private static final String RAF_MODE = "r";
    private static final int DEFAULT_BUFSIZE = 4096;
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private final byte[] inbuf;
    private final Charset charset;
    private final boolean end;
    private final TailerListener listener;
    private final boolean reOpen;
    private RandomAccessFile reader = null;
    private long position = 0L;
    private long lastModified = 0L;

    public CustomTailer(File file, TailerListener listener) {
        this(file, listener, 1000L);
    }

    public CustomTailer(File file, TailerListener listener, long delayMillis) {
        this(file, listener, delayMillis, false);
    }

    public CustomTailer(File file, TailerListener listener, long delayMillis, boolean end) {
        this(file, listener, delayMillis, end, 4096);
    }

    public CustomTailer(File file, TailerListener listener, long delayMillis, boolean end, boolean reOpen) {
        this(file, listener, delayMillis, end, reOpen, 4096);
    }

    public CustomTailer(File file, TailerListener listener, long delayMillis, boolean end, int bufSize) {
        this(file, listener, delayMillis, end, false, bufSize);
    }

    public CustomTailer(File file, TailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        this(file, DEFAULT_CHARSET, listener, delayMillis, end, reOpen, bufSize);
    }

    public CustomTailer(File file, Charset charset, TailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        super(file, listener, delayMillis, end, bufSize);
        this.listener = listener;
        listener.init((Tailer)this);
        this.end = end;
        this.reOpen = reOpen;
        this.inbuf = new byte[bufSize];
        this.charset = charset;
    }

    public static Tailer create(File file, TailerListener listener, long delayMillis, boolean end, int bufSize) {
        return CustomTailer.create(file, listener, delayMillis, end, false, bufSize);
    }

    public static Tailer create(File file, TailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        return CustomTailer.create(file, DEFAULT_CHARSET, listener, delayMillis, end, reOpen, bufSize);
    }

    public static Tailer create(File file, Charset charset, TailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        CustomTailer tailer = new CustomTailer(file, charset, listener, delayMillis, end, reOpen, bufSize);
        Thread thread = new Thread((Runnable)((Object)tailer));
        thread.setDaemon(true);
        thread.start();
        return tailer;
    }

    public static Tailer create(File file, TailerListener listener, long delayMillis, boolean end) {
        return CustomTailer.create(file, listener, delayMillis, end, 4096);
    }

    public static Tailer create(File file, TailerListener listener, long delayMillis, boolean end, boolean reOpen) {
        return CustomTailer.create(file, listener, delayMillis, end, reOpen, 4096);
    }

    public static Tailer create(File file, TailerListener listener, long delayMillis) {
        return CustomTailer.create(file, listener, delayMillis, false);
    }

    public static Tailer create(File file, TailerListener listener) {
        return CustomTailer.create(file, listener, 1000L, false);
    }

    public boolean getRun() {
        return !Thread.currentThread().isInterrupted();
    }

    public void run() {
        File file = this.getFile();
        try {
            try {
                this.openFile();
                if (this.end) {
                    this.position = file.length();
                    this.seek(this.position);
                }
                while (this.getRun()) {
                    if (this.reader == null) {
                        this.openFile();
                    }
                    boolean isModified = FileUtils.isFileNewer((File)file, (long)this.lastModified);
                    long length = file.length();
                    if (this.position > length) {
                        this.listener.fileRotated();
                        try {
                            Throwable throwable = null;
                            Object var6_7 = null;
                            try (RandomAccessFile save = this.reader;){
                                this.reader = new RandomAccessFile(file, RAF_MODE);
                                this.seek(this.position);
                                this.checkFile(save);
                                this.position = 0L;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.listener.fileNotFound();
                            Thread.sleep(this.getDelay());
                        }
                        continue;
                    }
                    if (this.position < length) {
                        this.seek(this.position);
                        this.checkFile(this.reader);
                        this.lastModified = file.lastModified();
                    } else if (isModified) {
                        if (length == 0L) {
                            this.position = 0L;
                        }
                        this.seek(this.position);
                        this.checkFile(this.reader);
                        this.lastModified = file.lastModified();
                    }
                    if (this.reOpen) {
                        this.closeFile();
                    }
                    try {
                        Thread.sleep(this.getDelay());
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            catch (IOException | InterruptedException error) {
                this.listener.handle(error);
                Thread.currentThread().interrupt();
                this.closeFile();
            }
        }
        finally {
            this.closeFile();
        }
    }

    private void openFile() throws InterruptedException {
        File file = this.getFile();
        while (this.getRun() && this.reader == null) {
            try {
                this.reader = new RandomAccessFile(file, RAF_MODE);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.listener.fileNotFound();
            }
            if (this.reader != null) continue;
            Thread.sleep(this.getDelay());
        }
    }

    private void closeFile() {
        if (this.reader != null) {
            try {
                try {
                    this.reader.close();
                }
                catch (IOException error) {
                    this.listener.handle((Exception)error);
                    this.reader = null;
                }
            }
            finally {
                this.reader = null;
            }
        }
    }

    private void reOpenFile() throws InterruptedException {
        this.closeFile();
        this.openFile();
    }

    private void seek(long position) throws InterruptedException {
        while (this.getRun()) {
            try {
                this.reader.seek(position);
                break;
            }
            catch (IOException iOException) {
                Thread.sleep(this.getDelay());
                this.reOpenFile();
            }
        }
    }

    private void checkFile(RandomAccessFile reader) throws InterruptedException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream lineBuf = new ByteArrayOutputStream(64);){
            int num;
            long pos;
            long rePos = pos = reader.getFilePointer();
            boolean seenCR = false;
            while ((num = reader.read(this.inbuf)) != -1) {
                int i = 0;
                while (i < num) {
                    byte ch = this.inbuf[i];
                    switch (ch) {
                        case 10: {
                            seenCR = false;
                            this.listener.handle(new String(lineBuf.toByteArray(), this.charset));
                            lineBuf.reset();
                            rePos = pos + (long)i + 1L;
                            break;
                        }
                        case 13: {
                            if (seenCR) {
                                lineBuf.write(13);
                            }
                            seenCR = true;
                            break;
                        }
                        default: {
                            if (seenCR) {
                                seenCR = false;
                                this.listener.handle(new String(lineBuf.toByteArray(), this.charset));
                                lineBuf.reset();
                                rePos = pos + (long)i + 1L;
                            }
                            lineBuf.write(ch);
                        }
                    }
                    ++i;
                }
                pos = reader.getFilePointer();
            }
            reader.seek(rePos);
            this.position = reader.getFilePointer();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

