/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.overlay;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.impl.overlay.Popover;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.StyleContext;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GuidingPopover
extends Popover {
    private boolean useNextButton = false;
    private String nextButtonText = null;
    private int numSteps;
    private int curStepIndex;
    private String title;
    private String description;
    private BeforeCloseConfirmation beforeClose;
    private int marginLeftXButton;

    public GuidingPopover(Shell parent, String title, String description, Widget target) {
        this(parent, title, description, target, 0);
    }

    public GuidingPopover(Shell parent, String title, String description, Widget target, int style) {
        super(parent, target, style, 17408, true);
        this.title = title;
        this.description = description;
    }

    @Override
    protected void createContent(Composite parent) {
        StyleContext.begin();
        StyleContext.setBackground((Color)ColorUtil.getColor((String)"#0C60DF"));
        StyleContext.setColor((Color)ColorUtil.getTextWhiteColor());
        ComponentBuilder.fromGrid((Composite)parent).margin(0).gridVerticalSpacing(0).minWidth(ComponentUtil.applyZoom((int)250)).build();
        ComponentUtil.getGridLayout((Composite)parent).numColumns = 1;
        int offset = this.isUseCaret() ? 8 : 0;
        int padding = 0;
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(padding + offset, padding, padding, padding + offset).fill().build();
        boolean hasTitle = StringUtils.isNotBlank((String)this.title);
        boolean hasDescription = StringUtils.isNotBlank((String)this.description);
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().margin(5, this.marginLeftXButton, hasTitle ? 10 : 0, 30).build();
        Composite titleContainer = (Composite)ComponentBuilder.gridContainer((Composite)header).marginTop(hasTitle ? 15 : 0).marginRight(50).fillHorizontal().build();
        ComponentBuilder.label((Composite)titleContainer).text(this.title).font(FontUtil.H4).fillHorizontal().left().build();
        ComponentBuilder.canvas((Composite)header).text("\u00d7").primaryButton().background(ColorUtil.getColor((String)"#0C60DF")).color(ColorUtil.PRIMARY_ACTIVE_COLOR).autoSize(20, 20).font(FontUtil.H2).top().onClick(event -> {
            this.setReturnCode(12);
            if (this.getBeforeClose() != null && !this.getBeforeClose().call()) {
                return;
            }
            this.close();
        }).build();
        Composite content = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)(this.useNextButton ? 2 : 1)).fillHorizontal().build();
        if (hasDescription || this.useNextButton) {
            ComponentUtil.setMargin((Composite)content, (int)0, (int)30, (int)20, (int)30);
        }
        ComponentBuilder.label((Composite)content).text(this.description).font(FontUtil.H5).fill().build();
        if (this.useNextButton) {
            boolean useCustomButtonText = StringUtils.isNotBlank((String)this.nextButtonText);
            String defaultNextButtonText = this.curStepIndex == this.numSteps - 1 ? "Clap!" : "Next";
            ComponentBuilder.canvas((Composite)content).text(StringUtils.defaultString((String)this.nextButtonText, (String)defaultNextButtonText)).font(FontUtil.H4).primaryButton().autoSize(useCustomButtonText ? 120 : 50, 25).right().bottom().noFillHorizontal().onClick(event -> this.close()).build();
        }
        Composite footer = (Composite)ComponentBuilder.gridContainer((Composite)container).colSpan(2).fillHorizontal().marginTop(0).build();
        Color progressBackground = ColorUtil.getColor((String)"#3E86F1");
        Color progressColor = ColorUtil.getColor((String)"#DCE3FF");
        ComponentBuilder.canvas((Composite)footer).fillHorizontal().autoHeight(5).onPaint((event, gc, control) -> {
            Rectangle controlArea = control.getBounds();
            gc.setBackground(progressBackground);
            gc.fillRectangle(0, 0, controlArea.width, controlArea.height);
            gc.setBackground(progressColor);
            gc.fillRectangle(0, 0, (int)Math.round((double)controlArea.width * (double)(this.curStepIndex + 1) / (double)this.numSteps), controlArea.height);
            gc.dispose();
        }).build();
        container.pack();
        Point size = container.getSize();
        if (size.x > 450) {
            ComponentUtil.setChildrenWidth((Composite)container, (int)450);
        } else if (ComponentBundleActivator.isDarkTheme((Display)Display.getCurrent())) {
            ComponentUtil.setChildrenWidth((Composite)container, (int)size.x);
        }
        StyleContext.end();
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setNumSteps(int numSteps) {
        this.numSteps = numSteps;
    }

    public int getCurStepIndex() {
        return this.curStepIndex;
    }

    public void setCurStepIndex(int curStepIndex) {
        this.curStepIndex = curStepIndex;
    }

    public boolean isUseNextButton() {
        return this.useNextButton;
    }

    public void setUseNextButton(boolean useNextButton) {
        this.useNextButton = useNextButton;
    }

    public void setNextButtonText(String nextButtonText) {
        this.nextButtonText = nextButtonText;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BeforeCloseConfirmation getBeforeClose() {
        return this.beforeClose;
    }

    public void setBeforeClose(BeforeCloseConfirmation beforeClose) {
        this.beforeClose = beforeClose;
    }

    public int getMarginLeftXButton() {
        return this.marginLeftXButton;
    }

    public void setMarginLeftXButton(int marginLeftXButton) {
        this.marginLeftXButton = marginLeftXButton;
    }

    public static interface BeforeCloseConfirmation {
        public boolean call();
    }
}

