/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.overlay;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class HighlightArea {
    private HighlightAreaProvider highlightAreaProvider;
    private Set<Widget> controls;
    private boolean highlight;
    private boolean focus;
    private boolean blocked;
    private String text;
    private Shell focusShell;
    private Shell contentShell;
    private int focusWeight = 3;
    private int focusSpacing = 1;
    private int contentSpacing = 3;
    private List<Listener> onTargetChangeListeners = new ArrayList<Listener>();
    private Listener targetPaintListener;
    private Rectangle cachedTargetArea;
    private boolean ignoreFocusRegion = false;

    public HighlightArea(Widget control, String text, boolean highlight, boolean focus, boolean blocked) {
        this(HighlightArea.wrapItem(control), text, highlight, focus, blocked);
    }

    private static Set<Widget> wrapItem(Widget control) {
        HashSet<Widget> controls = new HashSet<Widget>();
        controls.add(control);
        return controls;
    }

    public HighlightArea(Set<Widget> controls, String text, boolean highlight, boolean focus, boolean blocked) {
        this.controls = controls;
        this.text = text;
        this.highlight = highlight;
        this.focus = focus;
        this.blocked = blocked;
    }

    public void attach(Shell overlay) {
        this.focusShell = new Shell(overlay, 8);
        this.focusShell.setBackground(ColorUtil.PRIMARY_COLOR);
        this.focusShell.setForeground(ColorUtil.getTextWhiteColor());
        this.focusShell.setBackgroundMode(1);
        this.focusShell.setAlpha(1);
        this.focusShell.open();
        this.focusShell.setVisible(false);
        this.contentShell = new Shell(overlay, 8);
        this.contentShell.setBackground(ColorUtil.getColor((String)"#3e3e5a"));
        this.contentShell.setForeground(ColorUtil.getTextWhiteColor());
        this.contentShell.setBackgroundMode(2);
        this.contentShell.setAlpha(1);
        this.contentShell.open();
        this.contentShell.setVisible(false);
        ComponentBuilder.fromGrid((Composite)this.contentShell).build();
        if (StringUtils.isNotBlank((CharSequence)this.text)) {
            ComponentBuilder.label((Composite)this.contentShell).text(this.text).color(ColorUtil.getTextWhiteColor()).font(FontUtil.H4_BOLD).margin(5, 0).middle().center().build();
        }
        this.contentShell.pack();
        this.focusShell.setBackground(ColorUtil.PRIMARY_COLOR);
        this.contentShell.setBackground(ColorUtil.getColor((String)"#3e3e5a"));
        this.targetPaintListener = event -> {
            Widget target = this.getFirstControl();
            Rectangle targetArea = ComponentUtil.getScreenArea((Widget)target, null);
            if (targetArea != null && !targetArea.equals((Object)this.cachedTargetArea)) {
                this.notifyTargetChange();
            }
        };
        Control parent = (Control)ControlUtil.getParent((Widget)this.getFirstControl());
        parent.addListener(9, this.targetPaintListener);
    }

    public Region computeRegion(Region baseRegion) {
        Widget target = this.getFirstControl();
        Shell overlayParentShell = this.focusShell.getParent().getParent().getShell();
        Rectangle controlArea = this.highlightAreaProvider != null ? this.highlightAreaProvider.compute(target, overlayParentShell) : ComponentUtil.getScreenArea((Widget)target, (Control)overlayParentShell);
        Region controlRegion = ComponentUtil.createRectangleRegion((Rectangle)controlArea);
        if (controlRegion != null) {
            baseRegion.subtract(controlRegion);
            controlRegion.dispose();
        }
        return baseRegion;
    }

    public void renderFocusRegion() {
        Rectangle controlArea;
        if (this.ignoreFocusRegion) {
            return;
        }
        Widget control = this.getFirstControl();
        this.cachedTargetArea = controlArea = this.highlightAreaProvider != null ? this.highlightAreaProvider.compute(control, null) : ComponentUtil.getScreenArea((Widget)control, null);
        if (controlArea == null) {
            return;
        }
        boolean hasContent = StringUtils.isNotBlank((CharSequence)this.text);
        int focusWeightX2 = this.focusWeight * 2;
        int focusSpacingX2 = this.focusSpacing * 2;
        int contentHeight = hasContent ? this.contentShell.computeSize((int)-1, (int)-1).y : 0;
        Rectangle contentArea = new Rectangle(0, 0, 0, 0);
        if (hasContent) {
            contentArea.x = controlArea.x;
            contentArea.y = controlArea.y + controlArea.height + this.contentSpacing;
            contentArea.width = controlArea.width;
            contentArea.height = contentHeight;
        }
        if (hasContent) {
            this.contentShell.setBounds(contentArea);
            Region contentRegion = new Region();
            contentRegion.add(ComponentUtil.createRectangleRegion((int)0, (int)0, (int)contentArea.width, (int)contentArea.height));
            Region oldContentRegion = this.contentShell.getRegion();
            this.contentShell.setRegion(contentRegion);
            ControlUtil.dispose((Resource)oldContentRegion);
            ControlUtil.dispose((Resource)contentRegion);
        }
        Rectangle outterFocusRect = new Rectangle(0, 0, 0, 0);
        outterFocusRect.x = controlArea.x - this.focusWeight - this.focusSpacing;
        outterFocusRect.y = controlArea.y - this.focusWeight - this.focusSpacing;
        outterFocusRect.width = controlArea.width + focusWeightX2 + focusSpacingX2;
        outterFocusRect.height = controlArea.height + focusWeightX2 + focusSpacingX2 + contentArea.height;
        Rectangle innerFocusRect = new Rectangle(0, 0, 0, 0);
        innerFocusRect.x = outterFocusRect.x + this.focusWeight;
        innerFocusRect.y = outterFocusRect.y + this.focusWeight;
        innerFocusRect.width = controlArea.width + focusSpacingX2;
        innerFocusRect.height = controlArea.height + focusSpacingX2 + contentArea.height;
        if (hasContent) {
            outterFocusRect.height += this.contentSpacing;
            innerFocusRect.height += this.contentSpacing;
        }
        this.focusShell.setBounds(outterFocusRect);
        Region outerRegion = ComponentUtil.createRectangleRegion((int)0, (int)0, (int)outterFocusRect.width, (int)outterFocusRect.height);
        Region innerRegion = ComponentUtil.createRectangleRegion((int)this.focusWeight, (int)this.focusWeight, (int)innerFocusRect.width, (int)innerFocusRect.height);
        Region region = new Region();
        if (outerRegion != null) {
            region.add(outerRegion);
        }
        if (innerRegion != null) {
            region.subtract(innerRegion);
        }
        Region oldFocusRegRion = this.focusShell.getRegion();
        this.focusShell.setRegion(region);
        ControlUtil.dispose((Resource)oldFocusRegRion);
        ControlUtil.dispose((Resource)innerRegion);
        ControlUtil.dispose((Resource)outerRegion);
        ControlUtil.dispose((Resource)region);
        if (this.focus && !this.focusShell.isVisible()) {
            this.focusShell.setVisible(true);
        }
        if (hasContent && !this.contentShell.isVisible()) {
            this.contentShell.setVisible(true);
        }
    }

    public void onTargetChange(Listener listener) {
        this.onTargetChangeListeners.add(listener);
    }

    public void notifyTargetChange() {
        this.onTargetChangeListeners.forEach(listenerI -> {
            Event event = new Event();
            event.widget = this.getFirstControl();
            listenerI.handleEvent(event);
        });
    }

    public void highlight() {
        int flashingSpeed = 200;
        UITimeUtil.setInterval(timer -> {
            if (this.isDisposed()) {
                timer.cancel();
                return;
            }
            Color curBackground = this.focusShell.getBackground();
            if (curBackground.equals((Object)ColorUtil.PRIMARY_COLOR)) {
                this.focusShell.setBackground(ColorUtil.getColor((String)"#48d6a8"));
            } else {
                this.focusShell.setBackground(ColorUtil.PRIMARY_COLOR);
            }
            this.focusShell.redraw();
        }, (long)flashingSpeed, (long)(flashingSpeed * 6 + flashingSpeed / 2));
    }

    public void setAlpha(int alpha) {
        this.setFocusAlpha(alpha);
        this.setContentAlpha(alpha);
    }

    public void setFocusAlpha(int alpha) {
        if (!ControlUtil.isDisposed((Widget)this.focusShell)) {
            this.focusShell.setAlpha(alpha);
        }
    }

    public void setContentAlpha(int alpha) {
        if (!ControlUtil.isDisposed((Widget)this.contentShell)) {
            this.contentShell.setAlpha(alpha);
        }
    }

    public Set<Widget> getControls() {
        return this.controls;
    }

    public void setControls(Set<Widget> controls) {
        this.controls = controls;
    }

    public Widget getFirstControl() {
        return this.controls.iterator().next();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Shell getFocusShell() {
        return this.focusShell;
    }

    public void setFocusShell(Shell focusShell) {
        this.focusShell = focusShell;
    }

    public Shell getContentShell() {
        return this.contentShell;
    }

    public void setContentShell(Shell contentShell) {
        this.contentShell = contentShell;
    }

    public boolean getVisible() {
        return this.focusShell.getVisible();
    }

    public void setVisible(boolean visible) {
        this.focusShell.setVisible(visible);
        this.contentShell.setVisible(visible);
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void dispose() {
        this.focusShell.dispose();
        this.contentShell.dispose();
        Control parent = (Control)ControlUtil.getParent((Widget)this.getFirstControl());
        if (!ControlUtil.isDisposed((Widget)parent)) {
            parent.removeListener(9, this.targetPaintListener);
        }
    }

    public boolean isDisposed() {
        return ControlUtil.isDisposed((Widget)this.focusShell) || ControlUtil.isDisposed((Widget)this.contentShell);
    }

    public void setIgnoreFocusRegion(boolean ignoreFocusRegion) {
        this.ignoreFocusRegion = ignoreFocusRegion;
    }

    public HighlightAreaProvider getHighlightAreaProvider() {
        return this.highlightAreaProvider;
    }

    public void setHighlightAreaProvider(HighlightAreaProvider highlightAreaProvider) {
        this.highlightAreaProvider = highlightAreaProvider;
    }

    public static interface HighlightAreaProvider {
        public Rectangle compute(Widget var1, Shell var2);
    }
}

