/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.overlay;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class OverlayShell
extends Shell {
    protected static final Rectangle ZERO_BOUNDS = new Rectangle(0, 0, 0, 0);
    protected static final int DEFAULT_ALPHA = 1;
    protected static final Color DEFAULT_BACKGROUND = ColorUtil.BLUE_DARK_COLOR;
    protected int menuHeight;
    protected Shell menuOverlayShell;
    protected DisposeListener disposeListener;
    protected PaintListener paintListener;
    protected Listener boundsListener;
    protected Control target;
    protected boolean showing;

    protected void checkSubclass() {
    }

    public OverlayShell(Control target) {
        this(target, 0);
    }

    public OverlayShell(Control target, int style) {
        super(target.getShell(), style | 8 | 0x40000000);
        this.menuOverlayShell = new Shell(target.getShell(), style | 8 | 0x40000000);
        this.target = target;
        this.setBackground(DEFAULT_BACKGROUND);
        this.setBackgroundMode(1);
        this.showing = false;
        this.setAlpha(1);
        super.open();
        this.menuOverlayShell.open();
        this.setVisible(this.showing);
        int targetTrimbarHeight = target.getShell().computeTrim((int)0, (int)0, (int)0, (int)0).height;
        int baseTrimbarHeight = new Shell((Shell)target.getShell(), (int)1264).computeTrim((int)0, (int)0, (int)0, (int)0).height;
        this.menuHeight = Math.max(targetTrimbarHeight - baseTrimbarHeight, 0);
    }

    protected void attachToParent() {
        this.boundsListener = event -> this.reposition();
        this.paintListener = event -> this.reposition();
        this.disposeListener = event -> this.dispose();
        this.target.addListener(11, this.boundsListener);
        this.target.addListener(10, this.boundsListener);
        this.target.addPaintListener(this.paintListener);
        this.target.addDisposeListener(this.disposeListener);
    }

    public void open() {
        if (this.showing) {
            return;
        }
        this.reposition();
        this.setVisible(true);
        this.attachToParent();
        this.showing = true;
    }

    public void close() {
        if (!this.showing) {
            return;
        }
        this.showing = false;
        super.close();
    }

    public void dispose() {
        this.detachFromParent();
        if (!ControlUtil.isDisposed((Widget)this.menuOverlayShell)) {
            this.menuOverlayShell.dispose();
        }
        super.dispose();
    }

    protected void detachFromParent() {
        if (!this.target.isDisposed()) {
            this.target.removeListener(11, this.boundsListener);
            this.target.removeListener(10, this.boundsListener);
            this.target.removePaintListener(this.paintListener);
            this.target.removeDisposeListener(this.disposeListener);
        }
    }

    protected void reposition() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.target.isVisible()) {
            this.setBounds(ZERO_BOUNDS);
            return;
        }
        Rectangle targetArea = ComponentUtil.getScreenArea((Widget)this.target);
        this.setBounds(targetArea);
    }

    protected boolean isShowing() {
        return this.showing;
    }

    public boolean setParent(Composite parent) {
        if (this.isDisposed()) {
            return false;
        }
        if (!ControlUtil.isDisposed((Widget)this.menuOverlayShell)) {
            this.menuOverlayShell.setParent(parent);
        }
        return super.setParent(parent);
    }

    public void setAlpha(int alpha) {
        if (this.isDisposed()) {
            return;
        }
        if (!ControlUtil.isDisposed((Widget)this.menuOverlayShell)) {
            this.menuOverlayShell.setAlpha(alpha);
        }
        super.setAlpha(alpha);
    }

    public void setVisible(boolean visible) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.menuOverlayShell.isDisposed()) {
            this.menuOverlayShell.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.menuOverlayShell.isDisposed()) {
            this.menuOverlayShell.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Rectangle(x, y, width, height));
    }

    public void setBounds(Rectangle rect) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.menuOverlayShell.isDisposed()) {
            this.menuOverlayShell.setBounds(new Rectangle(rect.x, rect.y - this.menuHeight, rect.width, this.menuHeight));
        }
        super.setBounds(rect);
    }

    public void setRegion(Region region) {
        Region oldRegion = super.getRegion();
        super.setRegion(region);
        ControlUtil.dispose((Resource)oldRegion);
    }

    public void addListener(int eventType, Listener listener) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.menuOverlayShell.isDisposed()) {
            this.menuOverlayShell.addListener(eventType, listener);
        }
        super.addListener(eventType, listener);
    }

    public void addControlListener(ControlListener listener) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.menuOverlayShell.isDisposed()) {
            this.menuOverlayShell.addControlListener(listener);
        }
        super.addControlListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.menuOverlayShell.isDisposed()) {
            this.menuOverlayShell.addMouseListener(listener);
        }
        super.addMouseListener(listener);
    }
}

