/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.util.ArrayList;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;

public class EntityProcessingUtil {
    public static FolderEntity moveFolder(FolderEntity folder, FolderEntity targetFolder) throws Exception {
        ArrayList<String> oldDescendantEntityIds = new ArrayList<String>();
        for (Object descendantEntity : FolderController.getInstance().getAllDescentdantEntities(folder)) {
            if (descendantEntity instanceof FolderEntity) continue;
            oldDescendantEntityIds.add(((FileEntity)descendantEntity).getId());
        }
        if (targetFolder != null && folder != null && folder.getFolderType() == targetFolder.getFolderType()) {
            ArrayList<FileEntity> allDescendantEntites = new ArrayList<FileEntity>();
            for (Object descendantEntity : FolderController.getInstance().getAllDescentdantEntities(folder)) {
                if (descendantEntity instanceof FolderEntity) continue;
                allDescendantEntites.add((FileEntity)descendantEntity);
            }
            FolderEntity movedFolder = FolderController.getInstance().moveFolder(folder, targetFolder);
            String eventTopic = null;
            switch (folder.getFolderType()) {
                case TESTCASE: {
                    eventTopic = "TESTCASE/UPDATED";
                    break;
                }
                case DATAFILE: {
                    eventTopic = "TESTDATA/UPDATE";
                    break;
                }
                case TESTSUITE: {
                    eventTopic = "TESTSUITE/UPDATED";
                    break;
                }
                case WEBELEMENT: {
                    eventTopic = "TESTOBJECT/UPDATED";
                    break;
                }
                case CHECKPOINT: {
                    eventTopic = "CHECKPOINT/UPDATED";
                    break;
                }
            }
            if (eventTopic != null) {
                int i = 0;
                while (i < allDescendantEntites.size()) {
                    FileEntity entity = (FileEntity)allDescendantEntites.get(i);
                    String oldEntityId = (String)oldDescendantEntityIds.get(i);
                    EventBrokerSingleton.getInstance().getEventBroker().post(eventTopic, (Object)new Object[]{oldEntityId, entity});
                    ++i;
                }
            }
            if (movedFolder != null) {
                return movedFolder;
            }
        }
        return null;
    }

    public static TestCaseEntity moveTestCase(TestCaseEntity testCase, FolderEntity targetFolder) throws Exception {
        if (testCase != null) {
            TestCaseController testCaseController = TestCaseController.getInstance();
            String oldPk = testCase.getId();
            String oldIdForDisplay = testCase.getIdForDisplay();
            String newPk = (testCase = testCaseController.moveTestCase(testCase, targetFolder)).getId();
            if (!oldPk.equals(newPk)) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, testCase.getIdForDisplay()});
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/UPDATED", (Object)new Object[]{oldPk, testCase});
                return testCase;
            }
        }
        return null;
    }

    public static TestSuiteEntity moveTestSuite(TestSuiteEntity testSuite, FolderEntity targetFolder) throws Exception {
        if (testSuite != null) {
            TestSuiteController testSuiteController = TestSuiteController.getInstance();
            String oldPk = testSuite.getId();
            String oldIdForDisplay = testSuite.getIdForDisplay();
            String newPk = (testSuite = testSuiteController.moveTestSuite(testSuite, targetFolder)).getId();
            if (!oldPk.equals(newPk)) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, testSuite.getIdForDisplay()});
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTSUITE/UPDATED", (Object)new Object[]{oldPk, testSuite});
                return testSuite;
            }
        }
        return null;
    }

    public static DataFileEntity moveTestData(DataFileEntity dataFile, FolderEntity targetFolder) throws Exception {
        if (dataFile != null) {
            TestDataController testDataController = TestDataController.getInstance();
            String oldPk = dataFile.getId();
            String oldIdForDisplay = dataFile.getIdForDisplay();
            String newPk = (dataFile = testDataController.moveDataFile(dataFile, targetFolder)).getId();
            if (!oldPk.equals(newPk)) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, dataFile.getIdForDisplay()});
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTDATA/UPDATE", (Object)new Object[]{oldPk, dataFile});
                return dataFile;
            }
        }
        return null;
    }

    public static WebElementEntity moveTestObject(WebElementEntity webElement, FolderEntity targetFolder) throws Exception {
        if (webElement != null) {
            ObjectRepositoryController objectRepositoryController = ObjectRepositoryController.getInstance();
            String oldPk = webElement.getId();
            String oldIdForDisplay = webElement.getIdForDisplay();
            String newPk = (webElement = objectRepositoryController.moveWebElement(webElement, targetFolder)).getId();
            if (!oldPk.equals(newPk)) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, webElement.getIdForDisplay()});
                EventBrokerSingleton.getInstance().getEventBroker().post("TESTOBJECT/UPDATED", (Object)new Object[]{oldPk, webElement});
                return webElement;
            }
        }
        return null;
    }

    public static TestSuiteCollectionEntity moveTestSuiteCollection(TestSuiteCollectionEntity testSuiteCollection, FolderEntity targetFolder) throws Exception {
        if (testSuiteCollection == null || targetFolder == null) {
            return null;
        }
        TestSuiteCollectionController testSuiteCollectionController = TestSuiteCollectionController.getInstance();
        String oldPk = testSuiteCollection.getId();
        String oldIdForDisplay = testSuiteCollection.getIdForDisplay();
        String newPk = (testSuiteCollection = testSuiteCollectionController.moveTestSuiteCollection(testSuiteCollection, targetFolder)).getId();
        if (!ObjectUtils.equals((Object)oldPk, (Object)newPk)) {
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            eventBroker.post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, testSuiteCollection.getIdForDisplay()});
            eventBroker.post("TEST_SUITE_COLLECTION/UPDATED", (Object)new Object[]{oldPk, testSuiteCollection});
            return testSuiteCollection;
        }
        return null;
    }

    public static CheckpointEntity moveCheckpoint(CheckpointEntity checkpoint, FolderEntity targetFolder) throws Exception {
        if (checkpoint == null || targetFolder == null) {
            return null;
        }
        String oldId = checkpoint.getId();
        String oldIdForDisplay = checkpoint.getIdForDisplay();
        checkpoint = CheckpointController.getInstance().move(checkpoint, targetFolder);
        if (StringUtils.equals((String)oldId, (String)checkpoint.getId())) {
            return null;
        }
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, checkpoint.getIdForDisplay()});
        eventBroker.post("CHECKPOINT/UPDATED", (Object)new Object[]{oldId, checkpoint});
        return checkpoint;
    }
}

