/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ResourcesUtil {
    public static String getFileContent(Class<?> clazz, String filePath) {
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(clazz), (IPath)new Path(filePath), null);
        try {
            return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    public static byte[] readResource(InputStream inputStream, boolean gzip) throws IOException {
        int read;
        if (inputStream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FilterOutputStream outputStream = gzip ? new GZIPOutputStream(byteArrayOutputStream) : new DataOutputStream(byteArrayOutputStream);
        byte[] tmp = new byte[4096];
        while ((read = inputStream.read(tmp)) >= 0) {
            ((OutputStream)outputStream).write(tmp, 0, read);
        }
        ((OutputStream)outputStream).flush();
        ((OutputStream)outputStream).close();
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

