/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.IncludeTreeRootEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ProfileRootTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestListenerFolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestListenerTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestOpsFolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestOpsTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.UserFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestListenerController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.file.TestListenerEntity;
import com.kms.katalon.entity.file.UserFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.setting.ExplorerSettingStore;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;

public class TreeEntityUtil {
    public static ITreeEntity[] getChildren(FolderTreeEntity folderTreeEntity) throws Exception {
        if (folderTreeEntity.getObject() instanceof FolderEntity) {
            return TreeEntityUtil.getChildren(folderTreeEntity, folderTreeEntity.getObject());
        }
        return new ITreeEntity[0];
    }

    public static ITreeEntity[] getChildren(FolderTreeEntity folderTreeEntity, FolderEntity folder) throws Exception {
        FileEntity[] childrenEntities = FolderController.getInstance().getChildren(folder).toArray(new FileEntity[0]);
        ArrayList<AbstractTreeEntity> treeEntities = new ArrayList<AbstractTreeEntity>();
        if (childrenEntities != null) {
            int i = 0;
            while (i < childrenEntities.length) {
                if (childrenEntities[i] instanceof FolderEntity) {
                    treeEntities.add(new FolderTreeEntity((FolderEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof TestCaseEntity) {
                    treeEntities.add(new TestCaseTreeEntity((TestCaseEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof TestSuiteEntity) {
                    treeEntities.add(new TestSuiteTreeEntity((TestSuiteEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof DataFileEntity) {
                    treeEntities.add(new TestDataTreeEntity((DataFileEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof WebElementEntity) {
                    treeEntities.add(new WebElementTreeEntity((WebElementEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof WindowsElementEntity) {
                    treeEntities.add(new WindowsElementTreeEntity((WindowsElementEntity)childrenEntities[i], folderTreeEntity));
                } else if (childrenEntities[i] instanceof ReportEntity) {
                    treeEntities.add(new ReportTreeEntity((ReportEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof TestSuiteCollectionEntity) {
                    treeEntities.add(new TestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)childrenEntities[i], folderTreeEntity));
                } else if (childrenEntities[i] instanceof ReportCollectionEntity) {
                    treeEntities.add(new ReportCollectionTreeEntity((ReportCollectionEntity)childrenEntities[i], folderTreeEntity));
                } else if (childrenEntities[i] instanceof CheckpointEntity) {
                    treeEntities.add(new CheckpointTreeEntity((CheckpointEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof SystemFileEntity) {
                    treeEntities.add(new SystemFileTreeEntity((SystemFileEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof ExecutionProfileEntity) {
                    treeEntities.add(new ProfileTreeEntity((ExecutionProfileEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                } else if (childrenEntities[i] instanceof UserFileEntity) {
                    treeEntities.add(new UserFileTreeEntity((UserFileEntity)childrenEntities[i], (ITreeEntity)folderTreeEntity));
                }
                ++i;
            }
        }
        return treeEntities.toArray(new ITreeEntity[0]);
    }

    public static FolderTreeEntity getFolderTreeEntity(FolderEntity folderEntity) {
        if (folderEntity == null) {
            return null;
        }
        if (folderEntity.getParentFolder() == null) {
            return new FolderTreeEntity(folderEntity, null);
        }
        return new FolderTreeEntity(folderEntity, (ITreeEntity)TreeEntityUtil.getFolderTreeEntity(folderEntity.getParentFolder()));
    }

    public static FolderTreeEntity createSelectedTreeEntityHierachy(FolderEntity folderEntity, FolderEntity rootFolder) {
        if (folderEntity == null || folderEntity.equals((Object)rootFolder)) {
            return new FolderTreeEntity(rootFolder, null);
        }
        return new FolderTreeEntity(folderEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(folderEntity.getParentFolder(), rootFolder));
    }

    public static FolderTreeEntity getTestCaseFolderTreeEntity(ProjectEntity project) throws Exception {
        FolderEntity testCaseRoot = FolderController.getInstance().getTestCaseRoot(project);
        return new FolderTreeEntity(testCaseRoot, null);
    }

    public static FolderTreeEntity getWebElementFolderTreeEntity(FolderEntity folderEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity webElementRoot = FolderController.getInstance().getObjectRepositoryRoot(projectEntity);
        return new FolderTreeEntity(folderEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(folderEntity.getParentFolder(), webElementRoot));
    }

    public static FolderTreeEntity getWindowsElementFolderTreeEntity(FolderEntity folderEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity webElementRoot = FolderController.getInstance().getObjectRepositoryRoot(projectEntity);
        return new FolderTreeEntity(folderEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(folderEntity.getParentFolder(), webElementRoot));
    }

    public static TestCaseTreeEntity getTestCaseTreeEntity(TestCaseEntity testCaseEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity testCaseRootFolder = FolderController.getInstance().getTestCaseRoot(projectEntity);
        return new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(testCaseEntity.getParentFolder(), testCaseRootFolder));
    }

    public static WebElementTreeEntity getWebElementTreeEntity(WebElementEntity testObjectEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity testCaseRootFolder = FolderController.getInstance().getObjectRepositoryRoot(projectEntity);
        return new WebElementTreeEntity(testObjectEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(testObjectEntity.getParentFolder(), testCaseRootFolder));
    }

    public static TestDataTreeEntity getTestDataTreeEntity(DataFileEntity testDataEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity testCaseRootFolder = FolderController.getInstance().getTestDataRoot(projectEntity);
        return new TestDataTreeEntity(testDataEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(testDataEntity.getParentFolder(), testCaseRootFolder));
    }

    public static TestSuiteTreeEntity getTestSuiteTreeEntity(TestSuiteEntity testSuiteEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity testCaseRootFolder = FolderController.getInstance().getTestSuiteRoot(projectEntity);
        return new TestSuiteTreeEntity(testSuiteEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(testSuiteEntity.getParentFolder(), testCaseRootFolder));
    }

    public static ReportTreeEntity getReportTreeEntity(ReportEntity reportEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity testCaseRootFolder = FolderController.getInstance().getReportRoot(projectEntity);
        return new ReportTreeEntity(reportEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(reportEntity.getParentFolder(), testCaseRootFolder));
    }

    public static ReportCollectionTreeEntity getReportCollectionTreeEntity(ReportCollectionEntity reportCollectionEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity reportRootFolder = FolderController.getInstance().getReportRoot(projectEntity);
        return new ReportCollectionTreeEntity(reportCollectionEntity, TreeEntityUtil.createSelectedTreeEntityHierachy(reportCollectionEntity.getParentFolder(), reportRootFolder));
    }

    public static CheckpointTreeEntity getCheckpointTreeEntity(CheckpointEntity checkpointEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity checkpointRootFolder = FolderController.getInstance().getCheckpointRoot(projectEntity);
        return new CheckpointTreeEntity(checkpointEntity, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(checkpointEntity.getParentFolder(), checkpointRootFolder));
    }

    public static PackageTreeEntity getPackageTreeEntity(String packageRelativeLocation, ProjectEntity projectEntity) throws Exception {
        IPackageFragment packageFragment = GroovyUtil.getPackageFragmentFromLocation((String)packageRelativeLocation, (boolean)false, (ProjectEntity)projectEntity);
        if (packageFragment != null && packageFragment.exists()) {
            return new PackageTreeEntity(packageFragment, null);
        }
        return null;
    }

    public static KeywordTreeEntity getKeywordTreeEntity(String keywordRelativeLocation, ProjectEntity projectEntity) throws Exception {
        ICompilationUnit keywordFile;
        String packageLocation = StringUtils.substringBeforeLast((String)keywordRelativeLocation, (String)"/");
        String keywordName = StringUtils.substringAfterLast((String)keywordRelativeLocation, (String)"/");
        PackageTreeEntity packageTreeEntity = TreeEntityUtil.getPackageTreeEntity(packageLocation, projectEntity);
        if (packageTreeEntity != null && (keywordFile = ((IPackageFragment)packageTreeEntity.getObject()).getCompilationUnit(keywordName)) != null && keywordFile.exists()) {
            return new KeywordTreeEntity(keywordFile, packageTreeEntity);
        }
        return null;
    }

    public static TestSuiteCollectionTreeEntity getTestSuiteCollectionTreeEntity(TestSuiteCollectionEntity testSuiteCollectionEntity, ProjectEntity projectEntity) throws Exception {
        FolderEntity testSuiteRootFolder = FolderController.getInstance().getTestSuiteRoot(projectEntity);
        return new TestSuiteCollectionTreeEntity(testSuiteCollectionEntity, TreeEntityUtil.createSelectedTreeEntityHierachy(testSuiteCollectionEntity.getParentFolder(), testSuiteRootFolder));
    }

    public static ProfileTreeEntity getProfileTreeEntity(ExecutionProfileEntity profile, FolderEntity parent) {
        return new ProfileTreeEntity(profile, (ITreeEntity)new ProfileRootTreeEntity(parent, null));
    }

    public static TestListenerTreeEntity getTestListenerTreeEntity(TestListenerEntity testListener, FolderEntity parent) {
        return new TestListenerTreeEntity(testListener, new TestListenerFolderTreeEntity(parent, null));
    }

    public static SystemFileTreeEntity getSystemFileTreeEntity(SystemFileEntity systemFile, FolderEntity parent) {
        if (parent != null) {
            return new SystemFileTreeEntity(systemFile, (ITreeEntity)TreeEntityUtil.getFolderTreeEntity(parent));
        }
        return new SystemFileTreeEntity(systemFile, null);
    }

    public static WindowsElementTreeEntity getWindowsElementTreeEntity(WindowsElementEntity windowsElement, FolderEntity parent) {
        return new WindowsElementTreeEntity(windowsElement, new FolderTreeEntity(parent, null));
    }

    public static String getReadableKeywordName(String keywordMethodName) {
        if (keywordMethodName == null) {
            return keywordMethodName;
        }
        if ("uncheck".equals(keywordMethodName)) {
            return "Un-check";
        }
        if ("waitForJQueryLoad".equals(keywordMethodName)) {
            return "Wait For jQuery Load";
        }
        if ("executeJavaScript".equals(keywordMethodName)) {
            return "Execute JavaScript";
        }
        String readableName = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)StringUtils.capitalize((String)keywordMethodName)), (String)" ");
        if (readableName.contains("Test NG")) {
            return readableName.replace("Test NG", "TestNG");
        }
        if (readableName.contains("J Unit")) {
            return readableName.replace("J Unit", "JUnit");
        }
        return readableName;
    }

    public static List<String> getTreeEntityIds(Object[] entities) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        if (entities == null) {
            return ids;
        }
        if (entities.length == 0) {
            return ids;
        }
        Object[] objectArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ITreeEntity) {
                ITreeEntity treeEntity = (ITreeEntity)o;
                Object entity = treeEntity.getObject();
                String id = entity instanceof FileEntity ? ((FileEntity)entity).getIdForDisplay() : (entity instanceof IPackageFragment ? GroovyStringUtil.getKeywordsRelativeLocation((IPath)((IPackageFragment)entity).getPath()) : GroovyStringUtil.getKeywordsRelativeLocation((IPath)((ICompilationUnit)entity).getPath()));
                ids.add(id);
            }
            ++n2;
        }
        return ids;
    }

    public static List<ITreeEntity> getExpandedTreeEntitiesFromIds(List<String> ids) throws Exception {
        ArrayList<ITreeEntity> treeEntities = new ArrayList<ITreeEntity>();
        if (ids == null || ids.isEmpty()) {
            return treeEntities;
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        for (String id : ids) {
            FolderEntity folder;
            if (!StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_TEST_CASE) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_OBJECT_REPOSITORY) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_DATA_FILE) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_TEST_SUITE) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_REPORT) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_KEYWORD) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_CHECKPOINT) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_PROFILES) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_TEST_LISTENER) && !StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_INCLUDE) || (folder = FolderController.getInstance().getFolderByDisplayId(project, id)) == null) continue;
            FolderEntity rootFolder = null;
            if (FolderEntity.FolderType.TESTCASE.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getTestCaseRoot(project);
            } else if (FolderEntity.FolderType.WEBELEMENT.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getObjectRepositoryRoot(project);
            } else if (FolderEntity.FolderType.DATAFILE.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getTestDataRoot(project);
            } else if (FolderEntity.FolderType.TESTSUITE.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getTestSuiteRoot(project);
            } else if (FolderEntity.FolderType.KEYWORD.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getKeywordRoot(project);
            } else if (FolderEntity.FolderType.REPORT.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getReportRoot(project);
            } else if (FolderEntity.FolderType.CHECKPOINT.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getCheckpointRoot(project);
            } else if (FolderEntity.FolderType.PROFILE.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getProfileRoot(project);
            } else if (FolderEntity.FolderType.TESTLISTENER.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getTestListenerRoot(project);
            } else if (FolderEntity.FolderType.INCLUDE.equals((Object)folder.getFolderType())) {
                rootFolder = FolderController.getInstance().getIncludeRoot(project);
            }
            if (rootFolder == null) continue;
            treeEntities.add(TreeEntityUtil.createSelectedTreeEntityHierachy(folder, rootFolder));
        }
        return treeEntities;
    }

    public static List<ITreeEntity> getOpenedTreeEntitiesFromIds(List<String> ids) throws Exception {
        ArrayList<ITreeEntity> treeEntities = new ArrayList<ITreeEntity>();
        if (ids == null || ids.isEmpty()) {
            return treeEntities;
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        for (String id : ids) {
            ExecutionProfileEntity profile;
            CheckpointEntity cp;
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_TEST_CASE)) {
                TestCaseEntity tc = TestCaseController.getInstance().getTestCaseByDisplayId(id);
                if (tc == null) continue;
                treeEntities.add(TreeEntityUtil.getTestCaseTreeEntity(tc, project));
                continue;
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_OBJECT_REPOSITORY)) {
                WindowsElementEntity windowsElement;
                WebElementEntity to = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(id);
                if (to != null) {
                    treeEntities.add(TreeEntityUtil.getWebElementTreeEntity(to, project));
                }
                if ((windowsElement = WindowsElementController.getInstance().getWindowsElementByDisplayId(id)) == null) continue;
                treeEntities.add(TreeEntityUtil.getWindowsElementTreeEntity(windowsElement, windowsElement.getParentFolder()));
                continue;
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_DATA_FILE)) {
                DataFileEntity td = TestDataController.getInstance().getTestDataByDisplayId(id);
                if (td == null) continue;
                treeEntities.add(TreeEntityUtil.getTestDataTreeEntity(td, project));
                continue;
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_TEST_SUITE)) {
                TestSuiteEntity ts = TestSuiteController.getInstance().getTestSuiteByDisplayId(id, project);
                if (ts != null) {
                    treeEntities.add(TreeEntityUtil.getTestSuiteTreeEntity(ts, project));
                    continue;
                }
                TestSuiteCollectionEntity tsc = TestSuiteCollectionController.getInstance().getTestRunByDisplayId(id);
                if (tsc == null) continue;
                treeEntities.add(TreeEntityUtil.getTestSuiteCollectionTreeEntity(tsc, project));
                continue;
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_REPORT)) {
                String reportCollectionPath = String.valueOf(project.getFolderLocation()) + File.separator + id + ".rp";
                if (new File(reportCollectionPath).exists()) {
                    ReportCollectionEntity reportCollectionEntity = ReportController.getInstance().getReportCollection(reportCollectionPath);
                    if (reportCollectionEntity == null) continue;
                    treeEntities.add(TreeEntityUtil.getReportCollectionTreeEntity(reportCollectionEntity, project));
                    continue;
                }
                ReportEntity rp = ReportController.getInstance().getReportEntityByDisplayId(id, project);
                if (rp == null) continue;
                treeEntities.add(TreeEntityUtil.getReportTreeEntity(rp, project));
                continue;
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_KEYWORD)) {
                treeEntities.add(TreeEntityUtil.getKeywordTreeEntity(id, project));
                continue;
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_CHECKPOINT) && (cp = CheckpointController.getInstance().getByDisplayedId(id)) != null) {
                treeEntities.add(TreeEntityUtil.getCheckpointTreeEntity(cp, project));
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_PROFILES) && (profile = GlobalVariableController.getInstance().getExecutionProfile(id.replaceFirst(String.valueOf(StringConstants.ROOT_FOLDER_NAME_PROFILES) + "/", ""), project)) != null) {
                treeEntities.add(TreeEntityUtil.getProfileTreeEntity(profile, FolderController.getInstance().getProfileRoot(project)));
            }
            if (StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_TEST_LISTENER)) {
                FolderEntity rootTestListenerFolder = FolderController.getInstance().getTestListenerRoot(project);
                String testListenerName = id.replaceFirst(String.valueOf(StringConstants.ROOT_FOLDER_NAME_TEST_LISTENER) + "/", "");
                TestListenerEntity testListenerEntity = TestListenerController.getInstance().getTestListener(testListenerName, rootTestListenerFolder);
                if (testListenerEntity != null) {
                    treeEntities.add(TreeEntityUtil.getTestListenerTreeEntity(testListenerEntity, rootTestListenerFolder));
                }
            }
            if (!StringUtils.startsWith((String)id, (String)StringConstants.ROOT_FOLDER_NAME_INCLUDE)) continue;
            SystemFileEntity systemFileEntity = SystemFileController.getInstance().getSystemFile(new File(project.getFolderLocation(), id).getAbsolutePath(), project);
            treeEntities.add(TreeEntityUtil.getSystemFileTreeEntity(systemFileEntity, systemFileEntity.getParentFolder()));
        }
        return treeEntities;
    }

    private static List<ITreeEntity> filterShowedEntities(List<ITreeEntity> rootEntities, ProjectEntity project) throws Exception {
        ExplorerSettingStore store = new ExplorerSettingStore(project);
        ArrayList<ITreeEntity> filteredEntities = new ArrayList<ITreeEntity>();
        if (!rootEntities.isEmpty()) {
            for (ITreeEntity entity : rootEntities) {
                if (!store.isItemShow(entity.getText())) continue;
                filteredEntities.add(entity);
            }
        }
        return filteredEntities;
    }

    public static List<ITreeEntity> getTreeEntities(ProjectEntity project, boolean shouldGetAll) throws Exception {
        List<ITreeEntity> treeEntities = new ArrayList<ITreeEntity>();
        if (project == null) {
            return treeEntities;
        }
        FolderController folderController = FolderController.getInstance();
        treeEntities.add(new ProfileRootTreeEntity(folderController.getProfileRoot(project), null));
        treeEntities.add(new FolderTreeEntity(folderController.getTestCaseRoot(project), null));
        treeEntities.add(new FolderTreeEntity(folderController.getObjectRepositoryRoot(project), null));
        treeEntities.add(new FolderTreeEntity(folderController.getTestSuiteRoot(project), null));
        treeEntities.add(new FolderTreeEntity(folderController.getTestDataRoot(project), null));
        treeEntities.add(new FolderTreeEntity(folderController.getCheckpointRoot(project), null));
        treeEntities.add(new FolderTreeEntity(folderController.getKeywordRoot(project), null));
        treeEntities.add(new TestListenerFolderTreeEntity(folderController.getTestListenerRoot(project), null));
        treeEntities.add(new FolderTreeEntity(folderController.getReportRoot(project), null));
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        if (analyticsSettingStore.isIntegrationEnabled()) {
            TestOpsFolderTreeEntity testOpsFolder = new TestOpsFolderTreeEntity(null);
            testOpsFolder.addChild(new TestOpsTreeEntity(StringConstants.TREE_TESTOPS_EXECUTION, TestOpsTreeEntity.TestOpsAction.OPEN_EXECUTION, ImageConstants.IMG_16_TESTOPS_EXECUTIONS, testOpsFolder));
            testOpsFolder.addChild(new TestOpsTreeEntity(StringConstants.TREE_TESTOPS_PLANS, TestOpsTreeEntity.TestOpsAction.OPEN_PLAN, ImageConstants.IMG_16_TESTOPS_PLAN, testOpsFolder));
            testOpsFolder.addChild(new TestOpsTreeEntity(StringConstants.TREE_TESTOPS_RELEASES, TestOpsTreeEntity.TestOpsAction.OPEN_RELEASE, ImageConstants.IMG_16_TESTOPS_RELEASES, testOpsFolder));
            treeEntities.add(testOpsFolder);
        }
        treeEntities.add(new IncludeTreeRootEntity(folderController.getIncludeRoot(project)));
        List fileEntities = folderController.getRootUserFilesOrFolders(project);
        for (FileEntity fileEntity : fileEntities) {
            if (fileEntity instanceof FolderEntity) {
                treeEntities.add(new FolderTreeEntity((FolderEntity)fileEntity, null));
                continue;
            }
            if (!(fileEntity instanceof UserFileEntity)) continue;
            treeEntities.add(new UserFileTreeEntity((UserFileEntity)fileEntity, null));
        }
        if (!shouldGetAll) {
            treeEntities = TreeEntityUtil.filterShowedEntities(treeEntities, project);
        }
        return treeEntities;
    }

    public static boolean isValidTreeEntitySelectionType(Object[] selection, String typeName) {
        try {
            return selection != null && selection.length > 0 && StringUtils.equals((String)typeName, (String)((ITreeEntity)selection[0]).getTypeName());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }
}

