/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.StyledString;

public class KatalonContextUtil {
    private static final String CUSTOM_KEYWORDS_CLASS_NODE_PREFIX = "CustomKeywords.";
    private static KeywordController keywordController = KeywordController.getInstance();

    private KatalonContextUtil() {
    }

    public static boolean isCustomKeywordCompletionClassNode(ContentAssistContext context) {
        if (context.getPerceivedCompletionNode() instanceof ClassExpression) {
            String className = ((ClassExpression)context.getPerceivedCompletionNode()).getType().getName();
            if (className == null) {
                return false;
            }
            if ("CustomKeywords".equals(className)) {
                return true;
            }
        }
        return CUSTOM_KEYWORDS_CLASS_NODE_PREFIX.equals(StringUtils.defaultString((String)context.fullCompletionExpression).trim());
    }

    public static boolean isBuiltinKeywordCompletionClassNode(ContentAssistContext context) {
        return KatalonContextUtil.getBuiltInKeywordCompletionClassNode(context) != null;
    }

    public static KeywordClass getBuiltInKeywordCompletionClassNode(ContentAssistContext context) {
        String className = null;
        className = context.getPerceivedCompletionNode() instanceof ClassExpression ? ((ClassExpression)context.getPerceivedCompletionNode()).getType().getName() : StringUtils.substringBeforeLast((String)StringUtils.defaultString((String)context.fullCompletionExpression), (String)".").trim();
        if (className == null) {
            return null;
        }
        return keywordController.getBuiltInKeywordClassByName(className);
    }

    public static TestCaseEntity isTestCaseScriptContext(ContentAssistContext context) {
        if (context == null || context.unit == null || !(context.unit.getResource() instanceof IFile)) {
            return null;
        }
        String scriptFilePath = ((IFile)context.unit.getResource()).getRawLocation().toString();
        if (!GroovyUtil.isScriptFile((String)scriptFilePath, (ProjectEntity)ProjectController.getInstance().getCurrentProject())) {
            return null;
        }
        try {
            return TestCaseController.getInstance().getTestCaseByScriptFilePath(scriptFilePath);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    public static List<String> getTestCaseVariableStrings(TestCaseEntity testCaseEntity) {
        if (testCaseEntity == null) {
            return Collections.emptyList();
        }
        ArrayList<String> testCaseVariableStrings = new ArrayList<String>();
        for (VariableEntity variableEntity : testCaseEntity.getVariables()) {
            testCaseVariableStrings.add(variableEntity.getName());
        }
        return testCaseVariableStrings;
    }

    public static boolean isKeywordMethodNode(MethodNode methodNode) {
        try {
            return keywordController.getBuiltInKeywordByName(methodNode.getDeclaringClass().getName(), methodNode.getName(), KatalonContextUtil.getAstParameterTypes(methodNode.getParameters())) != null;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            return false;
        }
    }

    public static StyledString getKatalonSignature() {
        return new StyledString(" (Katalon)", StyledString.DECORATIONS_STYLER);
    }

    public static StyledString getClassSignature(KeywordClass keywordClass) {
        if (keywordClass == null) {
            return new StyledString();
        }
        return new StyledString(" \t - " + keywordClass.getType().getName(), StyledString.QUALIFIER_STYLER);
    }

    public static String[] getAstParameterTypes(Parameter[] params) {
        if (params == null) {
            return new String[0];
        }
        String[] paramTypes = new String[params.length];
        int i = 0;
        while (i < paramTypes.length) {
            try {
                Class clazz = ClassUtils.getClass((String)params[i].getType().getName());
                paramTypes[i] = clazz.isPrimitive() ? ClassUtils.primitiveToWrapper((Class)clazz).getName() : clazz.getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                paramTypes[i] = params[i].getType().getName();
            }
            ++i;
        }
        return paramTypes;
    }
}

