/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.component;

import com.kms.katalon.composer.components.adapter.CComboContentAdapter;
import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.integration.azure.model.AzureStatus;
import com.kms.katalon.integration.azure.setting.ExecutionStatusMapping;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AzureStatusEditingSupport
extends EditingSupport {
    private TableViewer viewer;

    public AzureStatusEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        String[] items = AzureStatus.getStringValues();
        return new AzureStatusCellEditor(element, items);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof ExecutionStatusMapping) {
            return ((ExecutionStatusMapping)element).getAzureStatus();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        ExecutionStatusMapping statusMapping;
        String status;
        if (element == null || value == null) {
            return;
        }
        if (element instanceof ExecutionStatusMapping && value instanceof String && !value.equals(status = (statusMapping = (ExecutionStatusMapping)element).getAzureStatus())) {
            statusMapping.setAzureStatus((String)value);
            this.viewer.update((Object)statusMapping, null);
        }
    }

    private class AzureStatusCellEditor
    extends StringComboBoxCellEditor {
        private Object element;

        public AzureStatusCellEditor(final Object element, String[] items) {
            super((Composite)AzureStatusEditingSupport.this.viewer.getTable(), items);
            this.element = element;
            final CCombo combo = (CCombo)this.getControl();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String text = combo.getText();
                    AzureStatusEditingSupport.this.setValue(element, text);
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = combo.getText();
                    AzureStatusEditingSupport.this.setValue(element, text);
                }
            });
        }

        public AutoCompleteField getAutoCompleteField(String[] newItems) {
            return new AutoCompleteField(this.getControl(), (IControlContentAdapter)new AzureStatusComboContentAdapter(), newItems);
        }

        private class AzureStatusComboContentAdapter
        extends CComboContentAdapter {
            private AzureStatusComboContentAdapter() {
            }

            public void setControlContents(Control control, String text, int cursorPosition) {
                super.setControlContents(control, text, cursorPosition);
                AzureStatusEditingSupport.this.setValue(AzureStatusCellEditor.this.element, text);
            }
        }
    }
}

