/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.preference.composite;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.azure.component.AzureTestConfigurationEditingSupport;
import com.kms.katalon.composer.integration.azure.component.ExecutionOSEditingSupport;
import com.kms.katalon.composer.integration.azure.component.ExecutionPlatformEditingSupport;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.integration.azure.model.AzureTestConfigurationRef;
import com.kms.katalon.integration.azure.model.AzureTestConfigurationsRef;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TestConfigurationMappingComposite
extends Composite {
    private TableViewer tvMain;
    private Table tMain;
    private AzureTestConfigurationsRef azureTestConfigSuggestions = null;
    private List<TestConfigurationMapping> mappingList;
    private AzureTestConfigurationEditingSupport testConfigurationEditingSupport;

    public TestConfigurationMappingComposite(Composite parent) {
        super(parent, 2048);
        GridData ldTableComposite = new GridData(4, 4, true, false);
        ldTableComposite.heightHint = 100;
        this.setLayoutData(ldTableComposite);
        this.setLayout((Layout)new GridLayout());
        this.createContents(this);
    }

    private void createContents(Composite parent) {
        Composite toolbar = this.createToolbar(parent);
        Composite table = this.createTable(parent);
        toolbar.moveAbove((Control)table);
    }

    private Composite createToolbar(Composite parent) {
        Composite compositeToolbar = new Composite(parent.getParent(), 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddVariable = new ToolItem(toolBar, 0);
        tltmAddVariable.setText("Add");
        tltmAddVariable.setImage(ImageManager.getImage((String)"add_16.png"));
        Menu addMenu = new Menu((Control)tltmAddVariable.getParent().getShell());
        tltmAddVariable.setData((Object)addMenu);
        tltmAddVariable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int defaultTestConfigId = 0;
                if (TestConfigurationMappingComposite.this.azureTestConfigSuggestions != null && TestConfigurationMappingComposite.this.azureTestConfigSuggestions.getCount() > 0) {
                    AzureTestConfigurationRef defaultTestConfig = TestConfigurationMappingComposite.this.azureTestConfigSuggestions.getValue()[0];
                    defaultTestConfigId = defaultTestConfig.getId();
                }
                TestConfigurationMapping defaultMapping = new TestConfigurationMapping("--Any--", "--Any--", defaultTestConfigId);
                TestConfigurationMappingComposite.this.mappingList.add(defaultMapping);
                TestConfigurationMappingComposite.this.tvMain.refresh();
            }
        });
        ToolItem tltmRemoveVariable = new ToolItem(toolBar, 0);
        tltmRemoveVariable.setText("Remove");
        tltmRemoveVariable.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmRemoveVariable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TestConfigurationMappingComposite.this.tMain == null) {
                    return;
                }
                TestConfigurationMappingComposite.this.tMain.setRedraw(false);
                IStructuredSelection selection = (IStructuredSelection)TestConfigurationMappingComposite.this.tvMain.getSelection();
                for (TestConfigurationMapping selectedObject : selection) {
                    TestConfigurationMappingComposite.this.tvMain.remove((Object)selectedObject);
                    TestConfigurationMappingComposite.this.mappingList.remove(selectedObject);
                }
                TestConfigurationMappingComposite.this.tMain.setRedraw(true);
                if (OSUtil.isMacBigSurOrLater()) {
                    TestConfigurationMappingComposite.this.tMain.redraw();
                }
            }
        });
        return compositeToolbar;
    }

    private Composite createTable(Composite parent) {
        this.tvMain = new TableViewer(parent, 67586);
        this.tvMain.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tMain = this.tvMain.getTable();
        this.tMain.setHeaderVisible(true);
        this.tMain.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.tMain.getDisplay()));
        TableViewerColumn cvExecutionOS = new TableViewerColumn(this.tvMain, 16384);
        TableColumn cExecutionOS = cvExecutionOS.getColumn();
        cExecutionOS.setText(StringConstants.COLUMN_EXECUTION_OS);
        cvExecutionOS.setEditingSupport((EditingSupport)new ExecutionOSEditingSupport(this.tvMain));
        TableViewerColumn cvExecutionPlatform = new TableViewerColumn(this.tvMain, 0);
        TableColumn cExecutionPlatform = cvExecutionPlatform.getColumn();
        cExecutionPlatform.setText(StringConstants.COLUMN_EXECUTION_PLATFORM);
        cvExecutionPlatform.setEditingSupport((EditingSupport)new ExecutionPlatformEditingSupport(this.tvMain));
        TableViewerColumn cvTestConfiguration = new TableViewerColumn(this.tvMain, 16384);
        TableColumn cTestConfiguration = cvTestConfiguration.getColumn();
        cTestConfiguration.setText(StringConstants.COLUMN_TEST_CONFIGURATION);
        this.testConfigurationEditingSupport = new AzureTestConfigurationEditingSupport(this.tvMain);
        cvTestConfiguration.setEditingSupport((EditingSupport)this.testConfigurationEditingSupport);
        this.tvMain.setLabelProvider((IBaseLabelProvider)new TestConfigurationMappingTableLabelProvider());
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)cExecutionOS, (ColumnLayoutData)new ColumnWeightData(10, 25));
        tableColumnLayout.setColumnData((Widget)cExecutionPlatform, (ColumnLayoutData)new ColumnWeightData(11, 25));
        tableColumnLayout.setColumnData((Widget)cTestConfiguration, (ColumnLayoutData)new ColumnWeightData(14, 25));
        parent.setLayout((Layout)tableColumnLayout);
        return parent;
    }

    public void setInput(List<TestConfigurationMapping> mappingList, AzureTestConfigurationsRef testConfigurationSuggestions) {
        this.updateTestConfigurationSuggestions(testConfigurationSuggestions);
        this.mappingList = mappingList;
        this.tvMain.setInput(mappingList);
        this.updateTableViewer();
    }

    public void updateTestConfigurationSuggestions(AzureTestConfigurationsRef testConfigurationSuggestions) {
        this.azureTestConfigSuggestions = testConfigurationSuggestions;
        this.testConfigurationEditingSupport.updateSuggestions(this.azureTestConfigSuggestions);
    }

    public List<TestConfigurationMapping> getInput() {
        return this.mappingList;
    }

    private void updateTableViewer() {
        if (this.tvMain != null) {
            this.tvMain.refresh();
        }
    }

    private class TestConfigurationMappingTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COLUMN_EXECUTION_OS_IDX = 0;
        private static final int COLUMN_EXECUTION_PLATFORM_IDX = 1;
        private static final int COLUMN_TEST_CONFIGURATION_IDX = 2;

        private TestConfigurationMappingTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex < 0 || columnIndex > 2) {
                return "";
            }
            if (!(element instanceof TestConfigurationMapping)) {
                return "";
            }
            TestConfigurationMapping node = (TestConfigurationMapping)element;
            switch (columnIndex) {
                case 0: {
                    return node.getOs();
                }
                case 1: {
                    return node.getPlatform();
                }
                case 2: {
                    if (TestConfigurationMappingComposite.this.azureTestConfigSuggestions == null || TestConfigurationMappingComposite.this.azureTestConfigSuggestions.getCount() <= 0) {
                        return "";
                    }
                    int testConfigId = node.getAzureTestConfigurationId();
                    AzureTestConfigurationRef testConfig = TestConfigurationMappingComposite.this.azureTestConfigSuggestions.findById(testConfigId);
                    if (testConfig == null) {
                        testConfig = TestConfigurationMappingComposite.this.azureTestConfigSuggestions.getValue()[0];
                        node.setAzureTestConfigurationId(testConfig.getId());
                    }
                    return testConfig.getName();
                }
            }
            return "";
        }
    }
}

