/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.procyon.decompiler;

import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.DeobfuscationUtilities;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.LineNumberFormatter;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.TypeDecompilationResults;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.procyon.decompiler.NoRetryMetadataSystem;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.UnicodeUtil;

public class ProcyonDecompiler
implements IDecompiler {
    private String source = "";
    private long time;
    private long start;
    private String log = "";

    public void decompile(String root, String packege, String className) {
        File classFile;
        block21: {
            TypeDefinition resolvedType;
            this.start = System.currentTimeMillis();
            this.log = "";
            this.source = "";
            File workingDir = new File(String.valueOf(root) + "/" + packege);
            String classPathStr = new File(workingDir, className).getAbsolutePath();
            boolean includeLineNumbers = false;
            boolean stretchLines = false;
            if (ClassUtil.isDebug()) {
                includeLineNumbers = true;
                stretchLines = true;
            }
            DecompilationOptions decompilationOptions = new DecompilationOptions();
            DecompilerSettings settings = DecompilerSettings.javaDefaults();
            settings.setTypeLoader((ITypeLoader)new InputTypeLoader());
            settings.setForceExplicitImports(true);
            decompilationOptions.setSettings(settings);
            decompilationOptions.setFullDecompilation(true);
            NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(decompilationOptions.getSettings().getTypeLoader());
            metadataSystem.setEagerMethodLoadingEnabled(false);
            TypeReference type = metadataSystem.lookupType(classPathStr);
            if (type == null || (resolvedType = type.resolve()) == null) {
                System.err.printf("!!! ERROR: Failed to load class %s.\n", classPathStr);
                return;
            }
            DeobfuscationUtilities.processType((TypeDefinition)resolvedType);
            String property = "java.io.tmpdir";
            String tempDir = System.getProperty(property);
            classFile = new File(tempDir, String.valueOf(System.currentTimeMillis()) + className);
            Writer writer = null;
            try {
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
                    PlainTextOutput output = new PlainTextOutput(writer);
                    output.setUnicodeOutputEnabled(decompilationOptions.getSettings().isUnicodeOutputEnabled());
                    TypeDecompilationResults results = decompilationOptions.getSettings().getLanguage().decompileType(resolvedType, (ITextOutput)output, decompilationOptions);
                    writer.flush();
                    writer.close();
                    writer = null;
                    List lineNumberPositions = results.getLineNumberPositions();
                    if (includeLineNumbers || stretchLines) {
                        EnumSet<LineNumberFormatter.LineNumberOption> lineNumberOptions = EnumSet.noneOf(LineNumberFormatter.LineNumberOption.class);
                        if (includeLineNumbers) {
                            lineNumberOptions.add(LineNumberFormatter.LineNumberOption.LEADING_COMMENTS);
                        }
                        if (stretchLines) {
                            lineNumberOptions.add(LineNumberFormatter.LineNumberOption.STRETCHED);
                        }
                        LineNumberFormatter lineFormatter = new LineNumberFormatter(classFile, lineNumberPositions, lineNumberOptions);
                        lineFormatter.reformatFile();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.source = UnicodeUtil.decode((String)FileUtil.getContent((File)classFile));
        classFile.delete();
        Pattern wp = Pattern.compile("/\\*.+?\\*/", 32);
        Matcher m = wp.matcher(this.source);
        while (m.find()) {
            if (m.group().matches("/\\*\\s*\\d*\\s*\\*/")) continue;
            String group = m.group();
            group = group.replace("/*", "");
            group = group.replace("*/", "");
            group = group.replace("*", "");
            if (this.log.length() > 0) {
                this.log = String.valueOf(this.log) + "\n";
            }
            this.log = String.valueOf(this.log) + group;
            this.source = this.source.replace(m.group(), "");
        }
        this.time = System.currentTimeMillis() - this.start;
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        this.start = System.currentTimeMillis();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract((String)archivePath, (String)packege, (String)className, (boolean)true, (String)workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
                FileUtil.deltree((File)workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree((File)workingDir);
        }
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public List getExceptions() {
        return Collections.EMPTY_LIST;
    }

    public String getLog() {
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return "Procyon";
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return true;
    }

    public boolean supportDebug() {
        return true;
    }
}

