/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt;

import cucumber.eclipse.steps.integration.IStepListener;
import cucumber.eclipse.steps.integration.Step;
import cucumber.eclipse.steps.integration.StepsChangedEvent;
import cucumber.eclipse.steps.jdt.CucumberAnnotation;
import cucumber.eclipse.steps.jdt.JavaParser;
import cucumber.eclipse.steps.jdt.MethodDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class StepDefinitions
extends MethodDefinition {
    public static volatile StepDefinitions INSTANCE;
    private final Pattern cukeAnnotationMatcher = Pattern.compile("cucumber\\.api\\.java\\.([a-z_]+)\\.(.*)$");
    private static final String CUCUMBER_API_JAVA = "cucumber.api.java.";
    private static final String CUCUMBER_API_JAVA8 = "cucumber.api.java8.";
    public String JAVA_PROJECT = "org.eclipse.jdt.core.javanature";
    public int JAVA_SOURCE = 1;
    public int JAVA_JAR_BINARY = 2;
    public String COMMA = ",";
    protected static List<IStepListener> listeners;

    static {
        listeners = new ArrayList<IStepListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StepDefinitions getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<StepDefinitions> clazz = StepDefinitions.class;
        synchronized (StepDefinitions.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new StepDefinitions();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public List<Step> getCukeSteps(IJavaProject javaProject, ICompilationUnit iCompUnit, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        IImportDeclaration[] allimports;
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList<CucumberAnnotation> importedAnnotations = new ArrayList<CucumberAnnotation>();
        IImportDeclaration[] iImportDeclarationArray = allimports = iCompUnit.getImports();
        int n = allimports.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration decl = iImportDeclarationArray[n2];
            Matcher m = this.cukeAnnotationMatcher.matcher(decl.getElementName());
            if (m.find()) {
                if ("*".equals(m.group(2))) {
                    importedAnnotations.addAll(this.getAllAnnotationsInPackage(javaProject, CUCUMBER_API_JAVA + m.group(1), m.group(1)));
                } else {
                    importedAnnotations.add(new CucumberAnnotation(m.group(2), m.group(1)));
                }
            }
            if (decl.getElementName().matches("cucumber\\.api\\.java8\\.(.*)")) {
                String importDeclaration = decl.getElementName();
                this.setJava8CukeLang(importDeclaration);
            }
            ++n2;
        }
        List<MethodDeclaration> methodDeclList = null;
        JavaParser javaParser = null;
        IType[] iTypeArray = iCompUnit.getTypes();
        int n3 = iTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            IType t = iTypeArray[n4];
            IType[] iTypeArray2 = t.newTypeHierarchy(progressMonitor).getAllInterfaces();
            int n6 = iTypeArray2.length;
            int n7 = 0;
            while (n7 < n6) {
                IType ifType = iTypeArray2[n7];
                if (ifType.isInterface() && ifType.getFullyQualifiedName().startsWith(CUCUMBER_API_JAVA8)) {
                    String[] superInterfaceNames;
                    String[] stringArray = superInterfaceNames = ifType.getSuperInterfaceNames();
                    int n8 = superInterfaceNames.length;
                    n5 = 0;
                    while (n5 < n8) {
                        String superIfName = stringArray[n5];
                        if (superIfName.endsWith(".LambdaGlueBase")) {
                            String lang = ifType.getElementName().toLowerCase();
                            if (javaParser == null) {
                                javaParser = new JavaParser(iCompUnit, progressMonitor);
                            }
                            if (methodDeclList == null) {
                                methodDeclList = javaParser.getAllMethods();
                            }
                            HashSet<String> keyWords = new HashSet<String>();
                            IMethod[] iMethodArray = ifType.getMethods();
                            int n9 = iMethodArray.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                IMethod method = iMethodArray[n10];
                                keyWords.add(method.getElementName());
                                ++n10;
                            }
                            ArrayList<MethodDefinition> methodDefList = new ArrayList<MethodDefinition>();
                            for (MethodDeclaration method : methodDeclList) {
                                List statementList;
                                if (!this.isCukeLambdaExpr(method, keyWords) || (statementList = method.getBody().statements()).isEmpty()) continue;
                                MethodDefinition definition = new MethodDefinition(method.getName(), method.getReturnType2(), statementList);
                                methodDefList.add(definition);
                                definition.setJava8CukeLang(lang);
                            }
                            for (MethodDefinition method : methodDefList) {
                                for (Statement statement : method.getMethodBodyList()) {
                                    Step step = new Step();
                                    step.setSource(iCompUnit.getResource());
                                    try {
                                        String lambdaStep = method.getLambdaStep(statement, keyWords);
                                        if (lambdaStep == null) continue;
                                        step.setText(lambdaStep);
                                        step.setLineNumber(javaParser.getLineNumber(statement));
                                        step.setLang(method.getCukeLang());
                                        steps.add(step);
                                    }
                                    catch (PatternSyntaxException e) {
                                        System.out.println(e);
                                    }
                                }
                            }
                        }
                        ++n5;
                    }
                }
                ++n7;
            }
            iTypeArray2 = t.getMethods();
            n6 = iTypeArray2.length;
            n7 = 0;
            while (n7 < n6) {
                IType method = iTypeArray2[n7];
                IAnnotation[] iAnnotationArray = method.getAnnotations();
                n5 = iAnnotationArray.length;
                int n11 = 0;
                while (n11 < n5) {
                    IAnnotation annotation = iAnnotationArray[n11];
                    CucumberAnnotation cukeAnnotation = this.getCukeAnnotation(importedAnnotations, annotation);
                    if (cukeAnnotation != null) {
                        Step step = new Step();
                        step.setSource(method.getResource());
                        step.setText(this.getAnnotationText(annotation));
                        step.setLineNumber(this.getLineNumber(iCompUnit, annotation));
                        step.setLang(cukeAnnotation.getLang());
                        steps.add(step);
                    }
                    ++n11;
                }
                ++n7;
            }
            ++n4;
        }
        return steps;
    }

    public List<Step> getCukeSteps(IPackageFragment javaPackage, IClassFile classFile) throws JavaModelException, CoreException {
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList<CucumberAnnotation> importedAnnotations = new ArrayList<CucumberAnnotation>();
        IJavaElement[] iJavaElementArray = classFile.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement instanceof IType) {
                IMethod[] methods;
                IMethod[] iMethodArray = methods = ((IType)javaElement).getMethods();
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    IAnnotation[] iAnnotationArray = method.getAnnotations();
                    int n5 = iAnnotationArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAnnotation annotation = iAnnotationArray[n6];
                        CucumberAnnotation cukeAnnotation = this.getCukeAnnotation(importedAnnotations, annotation);
                        if (cukeAnnotation != null) {
                            Step step = new Step();
                            step.setText(this.getAnnotationText(annotation));
                            step.setSourceName(classFile.getElementName());
                            step.setPackageName(javaPackage.getElementName());
                            step.setLang(cukeAnnotation.getLang());
                            steps.add(step);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return steps;
    }

    public int getLineNumber(ICompilationUnit compUnit, IAnnotation annotation) throws JavaModelException {
        Document document = new Document(compUnit.getBuffer().getContents());
        try {
            return document.getLineOfOffset(annotation.getSourceRange().getOffset()) + 1;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public List<CucumberAnnotation> getAllAnnotationsInPackage(IJavaProject javaProject, String packageFrag, final String lang) throws CoreException, JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((String)packageFrag, (int)2, (int)32768, (int)0);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProject.getPackageFragments());
        final ArrayList<CucumberAnnotation> annotations = new ArrayList<CucumberAnnotation>();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                try {
                    if (match.getAccuracy() == 0) {
                        IPackageFragment frag = (IPackageFragment)match.getElement();
                        IClassFile[] iClassFileArray = frag.getClassFiles();
                        int n = iClassFileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClassFile cls = iClassFileArray[n2];
                            IType t = cls.findPrimaryType();
                            if (t.isAnnotation()) {
                                annotations.add(new CucumberAnnotation(t.getElementName(), lang));
                            }
                            ++n2;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        };
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        return annotations;
    }

    public CucumberAnnotation getCukeAnnotation(List<CucumberAnnotation> importedAnnotations, IAnnotation annotation) throws JavaModelException {
        Matcher m = this.cukeAnnotationMatcher.matcher(annotation.getElementName());
        if (m.find()) {
            return new CucumberAnnotation(m.group(2), m.group(1));
        }
        for (CucumberAnnotation cuke : importedAnnotations) {
            if (!cuke.getAnnotation().equals(annotation.getElementName())) continue;
            return cuke;
        }
        return null;
    }

    public String getAnnotationText(IAnnotation annotation) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair mvp = iMemberValuePairArray[n2];
            if (mvp.getValueKind() == 9) {
                return (String)mvp.getValue();
            }
            ++n2;
        }
        return "";
    }

    public static List<IJavaProject> getRequiredJavaProjects(IJavaProject javaProject) throws CoreException {
        List<String> requiredProjectNames = Arrays.asList(javaProject.getRequiredProjectNames());
        ArrayList<IJavaProject> requiredProjects = new ArrayList<IJavaProject>();
        for (String requiredProjectName : requiredProjectNames) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredProjectName);
            if (!project.isNatureEnabled("org.eclipse.jdt.core.javanature")) continue;
            requiredProjects.add(JavaCore.create((IProject)project));
        }
        return requiredProjects;
    }

    public void scanJavaProjectForStepDefinitions(IJavaProject projectToScan, Collection<Step> collectedSteps, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        IPackageFragment[] packages;
        IPackageFragment[] iPackageFragmentArray = packages = projectToScan.getPackageFragments();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment javaPackage = iPackageFragmentArray[n2];
            if (javaPackage.getKind() == 1) {
                ICompilationUnit[] iCompilationUnitArray = javaPackage.getCompilationUnits();
                int n3 = iCompilationUnitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit compUnit = iCompilationUnitArray[n4];
                    collectedSteps.addAll(this.getCukeSteps(projectToScan, compUnit, progressMonitor));
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void removeStepListener(IStepListener listener) {
        listeners.remove(listener);
    }

    public void notifyListeners(StepsChangedEvent event) {
        for (IStepListener listener : listeners) {
            listener.onStepsChanged(event);
        }
    }
}

