/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.kobiton.dialog;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerIntegrationKobitonMessageConstants;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerKobitonStringConstants;
import com.kms.katalon.integration.kobiton.entity.KobitonApiKey;
import com.kms.katalon.integration.kobiton.entity.KobitonLoginInfo;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KobitonAuthenticationDialog
extends Dialog {
    private static final String SEPARATE_LINK = "|";
    private static final Character PASSWORD_CHAR_MASK = Character.valueOf('\u25cf');
    private Button btnOk;
    private Button btnClear;
    private Text txtUsername;
    private Text txtPassword;
    private Label lblError;

    public KobitonAuthenticationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.marginRight = 10;
        glContainer.marginTop = 10;
        glContainer.marginLeft = 10;
        glContainer.marginWidth = 0;
        glContainer.marginHeight = 0;
        glContainer.horizontalSpacing = 0;
        glContainer.verticalSpacing = 0;
        container.setLayout((Layout)glContainer);
        Label lblUsername = new Label(container, 0);
        GridData gdLblUsername = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblUsername.widthHint = 73;
        lblUsername.setLayoutData((Object)gdLblUsername);
        lblUsername.setText(ComposerIntegrationKobitonMessageConstants.LBL_DLG_AUTHENTICATE_USERNAME);
        this.txtUsername = new Text(container, 2048);
        GridData gdTxtUserName = new GridData(16384, 0x1000000, true, true, 1, 1);
        gdTxtUserName.widthHint = 356;
        gdTxtUserName.heightHint = 22;
        this.txtUsername.setLayoutData((Object)gdTxtUserName);
        Composite compSeparate = new Composite(container, 0);
        GridData gdCompSeparate = new GridData(16384, 0x1000000, false, false, 2, 1);
        gdCompSeparate.heightHint = 5;
        compSeparate.setLayoutData((Object)gdCompSeparate);
        Label lblPassword = new Label(container, 0);
        lblPassword.setText(ComposerIntegrationKobitonMessageConstants.LBL_DLG_AUTHENTICATE_PASSWORD);
        this.txtPassword = new Text(container, 2048);
        GridData gdTxtPassword = new GridData(16384, 1024, true, false, 1, 1);
        gdTxtPassword.widthHint = 356;
        gdTxtPassword.heightHint = 22;
        this.txtPassword.setLayoutData((Object)gdTxtPassword);
        this.txtPassword.setEchoChar(PASSWORD_CHAR_MASK.charValue());
        this.lblError = new Label(container, 0);
        this.lblError.setAlignment(0x1000000);
        GridData gdLblError = new GridData(16384, 0x1000000, false, false, 2, 1);
        gdLblError.verticalIndent = 5;
        gdLblError.widthHint = 432;
        gdLblError.heightHint = 22;
        this.lblError.setLayoutData((Object)gdLblError);
        this.lblError.setForeground(Display.getCurrent().getSystemColor(3));
        Composite composite = new Composite(container, 0);
        GridData gdComposite = new GridData(131072, 0x1000000, true, false, 2, 1);
        composite.setLayoutData((Object)gdComposite);
        composite.setLayout((Layout)new GridLayout(9, false));
        this.btnClear = new Button(composite, 0);
        GridData gdBtnClear = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdBtnClear.heightHint = 26;
        gdBtnClear.widthHint = 62;
        this.btnClear.setLayoutData((Object)gdBtnClear);
        this.btnClear.setText(ComposerKobitonStringConstants.CLEAR);
        this.btnOk = new Button(composite, 0);
        GridData gdBtnActivate = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdBtnActivate.heightHint = 26;
        gdBtnActivate.widthHint = 72;
        this.btnOk.setLayoutData((Object)gdBtnActivate);
        this.btnOk.setText(ComposerKobitonStringConstants.OK);
        Link linkForgotPass = new Link(composite, 0);
        linkForgotPass.setText(ComposerIntegrationKobitonMessageConstants.LBL_LINK_DLG_AUTHENTICATE_FORGOT_PASSWORD);
        Label lblVertialSeparate = new Label(composite, 0);
        lblVertialSeparate.setText(SEPARATE_LINK);
        Link linkRegister = new Link(composite, 0);
        linkRegister.setText(ComposerIntegrationKobitonMessageConstants.LBL_LINK_DLG_AUTHENTICATE_REGISTER);
        KobitonAuthenticateDialogKeyAdapter keyAdapter = new KobitonAuthenticateDialogKeyAdapter();
        this.txtUsername.addKeyListener((KeyListener)keyAdapter);
        this.txtPassword.addKeyListener((KeyListener)keyAdapter);
        KobitonAuthenticateDialogTextChanged textChangedListener = new KobitonAuthenticateDialogTextChanged();
        this.txtUsername.addModifyListener((ModifyListener)textChangedListener);
        this.txtPassword.addModifyListener((ModifyListener)textChangedListener);
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KobitonAuthenticationDialog.this.txtPassword.setText("");
                KobitonAuthenticationDialog.this.txtUsername.setText("");
            }
        });
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KobitonAuthenticationDialog.this.processLogin();
            }
        });
        SelectionAdapter linkSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Program.launch((String)e.text);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        };
        linkForgotPass.addSelectionListener((SelectionListener)linkSelectionListener);
        linkRegister.addSelectionListener((SelectionListener)linkSelectionListener);
        this.enableOKButton();
        return container;
    }

    private boolean isFullFillAuthenticateInfo() {
        return this.txtUsername.getText().trim().length() > 0 && this.txtPassword.getText().trim().length() > 0;
    }

    protected void processLogin() {
        if (!this.isFullFillAuthenticateInfo()) {
            return;
        }
        this.lblError.setForeground(Display.getCurrent().getSystemColor(2));
        this.lblError.setText(ComposerIntegrationKobitonMessageConstants.MSG_DLG_AUTHENTICATE_LOGIN_TO_KOBITON);
        final String userName = this.txtUsername.getText();
        final String password = this.txtPassword.getText();
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_RETRIEVING_KEYS, 2);
                            monitor.subTask(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER);
                            KobitonLoginInfo loginInfo = KobitonApiProvider.login((String)userName, (String)password);
                            KobitonPreferencesProvider.saveKobitonUserName((String)loginInfo.getUser().getUsername());
                            KobitonPreferencesProvider.saveKobitonPassword((String)password);
                            KobitonPreferencesProvider.saveKobitonToken((String)loginInfo.getToken());
                            monitor.worked(1);
                            monitor.subTask(ComposerIntegrationKobitonMessageConstants.MSG_DLG_PRG_GETTING_KEYS);
                            List apiKeys = KobitonApiProvider.getApiKeyList((String)loginInfo.getToken());
                            if (!apiKeys.isEmpty()) {
                                KobitonPreferencesProvider.saveKobitonApiKey((String)((KobitonApiKey)apiKeys.get(0)).getKey());
                            }
                            monitor.worked(1);
                        }
                        catch (KobitonApiException | IOException | URISyntaxException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            this.setReturnCode(0);
            this.close();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof KobitonApiException) {
                this.lblError.setText(String.valueOf(ComposerKobitonStringConstants.ERROR) + ": " + cause.getMessage());
                this.lblError.setForeground(Display.getDefault().getSystemColor(3));
            } else {
                LoggerSingleton.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void enableOKButton() {
        boolean enable = this.isFullFillAuthenticateInfo();
        this.lblError.setText(this.isFullFillAuthenticateInfo() ? "" : ComposerIntegrationKobitonMessageConstants.MSG_INFO_DLG_AUTHENTICATE_ENTER_USERNAME_PASSWORD);
        this.btnOk.setEnabled(enable);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerIntegrationKobitonMessageConstants.TITLE_DLG_AUTHENTICATE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
        parent.getShell().setDefaultButton(this.btnOk);
    }

    private class KobitonAuthenticateDialogKeyAdapter
    extends KeyAdapter {
        private KobitonAuthenticateDialogKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r' || e.character == '\u1000050') {
                KobitonAuthenticationDialog.this.processLogin();
            }
        }
    }

    private class KobitonAuthenticateDialogTextChanged
    implements ModifyListener {
        private KobitonAuthenticateDialogTextChanged() {
        }

        public void modifyText(ModifyEvent e) {
            KobitonAuthenticationDialog.this.enableOKButton();
        }
    }
}

