/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.kobiton.dialog;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerIntegrationKobitonMessageConstants;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerKobitonStringConstants;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class KobitonDeviceDialog
extends TitleAreaDialog {
    private Combo cbbDevices;
    private List<KobitonDevice> devicesList = new ArrayList<KobitonDevice>();
    private KobitonDevice selectedDevice;

    public KobitonDeviceDialog(Shell shell) {
        super(shell);
    }

    public KobitonDeviceDialog(Shell shell, KobitonDevice selectedDevice) {
        super(shell);
        this.selectedDevice = selectedDevice;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(area, 0);
        innerComposite.setLayoutData((Object)new GridData(1808));
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        glContainer.marginTop = 20;
        glContainer.marginLeft = 10;
        glContainer.marginRight = 10;
        innerComposite.setLayout((Layout)glContainer);
        Label lblDeviceName = new Label(innerComposite, 0);
        lblDeviceName.setText(ComposerIntegrationKobitonMessageConstants.LBL_DLG_DEVICE_NAME);
        this.cbbDevices = new Combo(innerComposite, 4);
        this.cbbDevices.setLayoutData((Object)new GridData(768));
        Link lnkUpdateDeviceList = new Link(innerComposite, 0);
        lnkUpdateDeviceList.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        lnkUpdateDeviceList.setText(ComposerIntegrationKobitonMessageConstants.LNK_DLG_UPDATE_FAVORITE_DEVICES);
        lnkUpdateDeviceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Program.launch((String)e.text);
                }
                catch (IllegalArgumentException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.addListeners();
        this.setTitle(ComposerIntegrationKobitonMessageConstants.TITLE_DLG_FAVORITE_DEVICES);
        this.setMessage(ComposerIntegrationKobitonMessageConstants.MSG_DLG_FAVORITE_DEVICES, 1);
        this.setInput();
        return area;
    }

    private void addListeners() {
        this.cbbDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KobitonDeviceDialog.this.selectedDevice = KobitonDeviceDialog.this.devicesList.get(KobitonDeviceDialog.this.cbbDevices.getSelectionIndex());
            }
        });
    }

    protected void setInput() {
        Optional<KobitonDevice> deviceOpt;
        this.loadDeviceList();
        this.cbbDevices.setItems(this.getDeviceFullNames());
        if (this.devicesList.size() == 0) {
            this.selectedDevice = null;
            return;
        }
        int index = 0;
        if (this.selectedDevice != null && (deviceOpt = this.devicesList.stream().filter(device -> device.getId() == this.selectedDevice.getId()).findFirst()).isPresent()) {
            index = this.devicesList.indexOf(deviceOpt.get());
        }
        this.selectedDevice = this.devicesList.get(index);
        this.cbbDevices.select(index);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerIntegrationKobitonMessageConstants.TITLE_WINDOW_DLG_FAVORITE_DEVICES);
    }

    private void loadDeviceList() {
        this.devicesList.clear();
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(ComposerIntegrationKobitonMessageConstants.JOB_LOADING_DEVICE_LIST, 1);
                            KobitonDeviceDialog.this.devicesList.addAll(KobitonApiProvider.getKobitonFavoriteDevices((String)KobitonPreferencesProvider.getKobitonToken()));
                            Collections.sort(KobitonDeviceDialog.this.devicesList, new Comparator<KobitonDevice>(){

                                @Override
                                public int compare(KobitonDevice device_1, KobitonDevice device_2) {
                                    return device_1.getDisplayString().compareToIgnoreCase(device_2.getDisplayString());
                                }
                            });
                            monitor.worked(1);
                        }
                        catch (KobitonApiException | IOException | URISyntaxException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof KobitonApiException) {
                MessageDialog.openError((Shell)this.getShell(), (String)ComposerKobitonStringConstants.ERROR, (String)cause.getMessage());
                this.close();
            } else {
                LoggerSingleton.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private String[] getDeviceFullNames() {
        String[] fullNames = new String[this.devicesList.size()];
        int i = 0;
        while (i < this.devicesList.size()) {
            fullNames[i] = this.devicesList.get(i).getDisplayString();
            ++i;
        }
        return fullNames;
    }

    public KobitonDevice getSelectedDevice() {
        return this.selectedDevice;
    }
}

