/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.kobiton.menu;

import com.kms.katalon.composer.execution.menu.AbstractExecutionMenuContribution;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerIntegrationKobitonMessageConstants;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.session.RemoteMobileExecutionSession;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;

public class KobitonExecutionDynamicContribution
extends AbstractExecutionMenuContribution {
    private static final String KOBITON_ICON_URI = ImageManager.getImageURLString((String)"kobiton_16.png");
    private static final String KOBITON_EXECUTION_COMMAND_ID = "com.kms.katalon.composer.integration.kobiton.execution.command.kobiton";

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        if (!KobitonPreferencesProvider.isKobitonIntegrationAvailable()) {
            return;
        }
        List<ExecutionSession> exisingDrivers = this.getAllAvailableKobitonSession(this.getDriverTypeName());
        if (exisingDrivers.isEmpty()) {
            this.aboutToShowDefault(items);
        } else {
            this.aboutToShowWithExisting(items, exisingDrivers);
        }
    }

    public List<ExecutionSession> getAllAvailableKobitonSession(String driverTypeName) {
        ArrayList<ExecutionSession> executionSessions = new ArrayList<ExecutionSession>();
        for (ExecutionSession executionSession : ExecutionSessionSocketServer.getInstance().getAllExecutionSession()) {
            if (!(executionSession instanceof RemoteMobileExecutionSession) || !driverTypeName.equals(((RemoteMobileExecutionSession)executionSession).getRemoteType()) || !executionSession.isAvailable()) continue;
            executionSessions.add(executionSession);
        }
        return executionSessions;
    }

    protected String getIconUri() {
        return KOBITON_ICON_URI;
    }

    protected String getMenuLabel() {
        return ComposerIntegrationKobitonMessageConstants.LBL_MENU_EXECUTION_KOBITON;
    }

    protected String getCommandId() {
        return KOBITON_EXECUTION_COMMAND_ID;
    }

    protected String getDriverTypeName() {
        return WebUIDriverType.KOBITON_WEB_DRIVER.getName();
    }
}

