/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityHandler;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.dialog.TestObjectReferencesDialog;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class DeleteTestObjectHandler
extends AbstractDeleteReferredEntityHandler {
    protected ObjectRepositoryController toController = ObjectRepositoryController.getInstance();

    public Class<? extends ITreeEntity> entityType() {
        return WebElementTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (treeEntity == null || !(treeEntity instanceof WebElementTreeEntity)) {
                return false;
            }
            monitor.beginTask(MessageFormat.format(ComposerObjectRepositoryMessageConstants.HAND_DELETE_OBJECT_TASK_NAME, treeEntity.getTypeName(), treeEntity.getText()), 1);
            WebElementEntity webElement = (WebElementEntity)treeEntity.getObject();
            String testObjectId = webElement.getIdForDisplay();
            List affectedTestCaseScripts = TestArtifactScriptRefactor.createForTestObjectEntity((String)testObjectId).findReferrersInTestCaseScripts(ProjectController.getInstance().getCurrentProject());
            if (this.performDeleteTestObject(webElement, Collections.emptyList(), affectedTestCaseScripts)) {
                this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)testObjectId);
                return true;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ComposerObjectRepositoryMessageConstants.HAND_ERROR_MSG_UNABLE_TO_DEL_TEST_OBJ);
        }
        finally {
            monitor.done();
        }
        return false;
    }

    protected boolean performDeleteTestObject(final WebElementEntity webElement, final List<Object> elementsWillBeDeleted, final List<IFile> affectedTestCaseScripts) {
        this.isDeleted = false;
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    List testObjectReferences = DeleteTestObjectHandler.this.toController.getTestObjectReferences(webElement, ProjectController.getInstance().getCurrentProject());
                    ArrayList<FileEntity> fileEntities = new ArrayList<FileEntity>();
                    for (WebElementEntity testObject : testObjectReferences) {
                        if (elementsWillBeDeleted.contains(testObject)) continue;
                        fileEntities.add((FileEntity)testObject);
                    }
                    fileEntities.addAll(TestCaseEntityUtil.getTestCaseEntities((List)affectedTestCaseScripts));
                    if (!fileEntities.isEmpty()) {
                        String testObjectIdForDisplay = webElement.getIdForDisplay();
                        if (DeleteTestObjectHandler.this.isDefaultResponse()) {
                            TestObjectReferencesDialog dialog = new TestObjectReferencesDialog(Display.getCurrent().getActiveShell(), testObjectIdForDisplay, fileEntities, DeleteTestObjectHandler.this.needYesNoToAllButtons());
                            DeleteTestObjectHandler.this.setResponse(dialog.open());
                        }
                        if (DeleteTestObjectHandler.this.isCancelResponse()) {
                            return;
                        }
                        if (DeleteTestObjectHandler.this.isYesResponse()) {
                            DeleteTestObjectHandler.this.removeReferencesInTestObjects(testObjectReferences);
                            TestArtifactScriptRefactor.createForTestObjectEntity((String)testObjectIdForDisplay).removeReferences(affectedTestCaseScripts);
                        }
                    }
                    EntityPartUtil.closePart((IEntity)webElement);
                    DeleteTestObjectHandler.this.toController.deleteWebElement(webElement);
                    if (!DeleteTestObjectHandler.this.isYesNoToAllResponse()) {
                        DeleteTestObjectHandler.this.resetResponse();
                    }
                    DeleteTestObjectHandler.this.isDeleted = true;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        return this.isDeleted;
    }

    private void removeReferencesInTestObjects(List<WebElementEntity> affectedTestObjects) throws Exception {
        for (WebElementEntity testObject : affectedTestObjects) {
            WebElementPropertyEntity refElement = this.toController.getRefElementProperty(testObject);
            testObject.getWebElementProperties().remove(refElement);
            this.toController.updateTestObject(testObject);
            this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{testObject.getId(), testObject});
        }
    }
}

