/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.part;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.view.ObjectPropertyView;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.text.MessageFormat;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestObjectPart
extends CPart
implements EventHandler,
IComposerPartEvent {
    private static boolean isConfirmationDialogShowed = false;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    protected MDirtyable dirtyable;
    @Inject
    private EPartService partService;
    private MPart mPart;
    private ObjectPropertyView objPropertyView;
    private WebElementEntity originalTestObject;

    @PostConstruct
    public void createComposite(Composite parent, MPart part) {
        this.mPart = part;
        new HelpToolBarForMPart(this.mPart, DocumentationMessageConstants.TEST_OBJECT_WEB_UI);
        parent.setLayout((Layout)new FillLayout());
        this.objPropertyView = new ObjectPropertyView(this.eventBroker, this.dirtyable, this);
        this.objPropertyView.createMainPage(parent);
        this.changeOriginalTestObject((WebElementEntity)part.getObject());
        this.initialize(this.mPart, this.partService);
        this.registerListeners();
    }

    private void changeOriginalTestObject(WebElementEntity testObject) {
        this.originalTestObject = testObject;
        this.objPropertyView.changeOriginalTestObject(this.originalTestObject);
    }

    private void registerListeners() {
        this.eventBroker.subscribe("TESTOBJECT/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("TESTOBJECT/UPDATED")) {
            String elementId;
            Object object = event.getProperty("org.eclipse.e4.data");
            if (object != null && object instanceof Object[] && (elementId = EntityPartUtil.getTestObjectPartId((String)((String)((Object[])object)[0]))).equalsIgnoreCase(this.mPart.getElementId())) {
                WebElementEntity webElement = (WebElementEntity)((Object[])object)[1];
                this.updateTestObjectPart(webElement);
                this.changeOriginalTestObject(webElement);
            }
        } else if (event.getTopic().equals("EXPLORER/REFRESH_SELECTED_ITEM")) {
            try {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof ITreeEntity) {
                    FolderEntity folder;
                    if (object instanceof WebElementTreeEntity) {
                        WebElementTreeEntity testObjectTreeEntity = (WebElementTreeEntity)object;
                        WebElementEntity testObject = (WebElementEntity)testObjectTreeEntity.getObject();
                        if (testObject != null && testObject.getId().equals(this.originalTestObject.getId())) {
                            if (ObjectRepositoryController.getInstance().getWebElement(testObject.getId()) != null) {
                                if (!this.dirtyable.isDirty()) {
                                    this.changeOriginalTestObject(testObject);
                                }
                            } else {
                                this.dispose();
                            }
                        } else if (ObjectRepositoryController.getInstance().getWebElement(this.originalTestObject.getId()) == null) {
                            this.dispose();
                        }
                    } else if (object instanceof FolderTreeEntity && (folder = (FolderEntity)((ITreeEntity)object).getObject()) != null && FolderController.getInstance().isFolderAncestorOfEntity(folder, (IEntity)this.originalTestObject) && ObjectRepositoryController.getInstance().getWebElement(this.originalTestObject.getId()) == null) {
                        this.dispose();
                    }
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    public void dispose() {
        this.eventBroker.unsubscribe((EventHandler)this);
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.mPart);
    }

    private void updateTestObjectPart(WebElementEntity webElement) {
        this.mPart.setLabel(webElement.getName());
        this.mPart.setElementId(EntityPartUtil.getTestObjectPartId((String)webElement.getId()));
    }

    @Persist
    public void save() {
        this.objPropertyView.save();
        Trackings.trackEditObject((String)"testObject", (String)"WEB");
    }

    @Focus
    private void onFocused() {
        try {
            if (this.originalTestObject != null) {
                WebElementEntity srcWebElement = ObjectRepositoryController.getInstance().getWebElement(this.originalTestObject.getId());
                if (srcWebElement != null) {
                    if (!srcWebElement.equals((Object)this.originalTestObject) && !isConfirmationDialogShowed) {
                        isConfirmationDialogShowed = true;
                        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)ComposerObjectRepositoryMessageConstants.PA_CONFIRM_TITLE_FILE_CHANGED, (String)MessageFormat.format(ComposerObjectRepositoryMessageConstants.PA_CONFIRM_MSG_RELOAD_FILE, this.originalTestObject.getLocation()))) {
                            this.changeOriginalTestObject(srcWebElement);
                            this.dirtyable.setDirty(false);
                        }
                        isConfirmationDialogShowed = false;
                    }
                } else {
                    FolderTreeEntity parentTreeEntity = this.getParentFolderTreeEntity(this.originalTestObject.getParentFolder(), FolderController.getInstance().getObjectRepositoryRoot(this.originalTestObject.getProject()));
                    if (parentTreeEntity != null) {
                        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
                    }
                    this.dispose();
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private FolderTreeEntity getParentFolderTreeEntity(FolderEntity folderEntity, FolderEntity rootFolder) {
        if (folderEntity == null || folderEntity.equals((Object)rootFolder)) {
            return null;
        }
        return new FolderTreeEntity(folderEntity, (ITreeEntity)this.getParentFolderTreeEntity(folderEntity.getParentFolder(), rootFolder));
    }

    public WebElementEntity getTestObject() {
        return this.originalTestObject;
    }

    public String getEntityId() {
        return this.getTestObject().getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.mPart == null || this.originalTestObject == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.equals((String)this.mPart.getElementId(), (String)part.getElementId())) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.originalTestObject);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof WebElementEntity)) {
            return;
        }
        WebElementEntity updatedEntity = (WebElementEntity)eventData;
        if (!StringUtils.equals((String)updatedEntity.getIdForDisplay(), (String)this.getEntityId())) {
            return;
        }
        this.originalTestObject.setTag(updatedEntity.getTag());
        this.originalTestObject.setDescription(updatedEntity.getDescription());
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
        this.objPropertyView.preDestroy();
        this.eventBroker.unsubscribe((EventHandler)this);
        this.dispose();
    }
}

