/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.view;

import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.impl.control.CMenu;
import com.kms.katalon.composer.components.impl.control.HotkeyActiveListener;
import com.kms.katalon.composer.components.impl.control.ImageButton;
import com.kms.katalon.composer.components.impl.dialogs.AddTestObjectPropertyDialog;
import com.kms.katalon.composer.components.impl.dialogs.AddTestObjectXpathDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.handler.ObjectPropertyHandler;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.constant.ImageConstants;
import com.kms.katalon.composer.objectrepository.part.TestObjectPart;
import com.kms.katalon.composer.objectrepository.provider.IsSelectedColumnLabelProvider;
import com.kms.katalon.composer.objectrepository.provider.ObjectPropetiesTableViewer;
import com.kms.katalon.composer.objectrepository.provider.ObjectXpathsTableViewer;
import com.kms.katalon.composer.objectrepository.provider.ParentObjectViewerFilter;
import com.kms.katalon.composer.objectrepository.support.PropertyConditionEditingSupport;
import com.kms.katalon.composer.objectrepository.support.PropertyNameEditingSupport;
import com.kms.katalon.composer.objectrepository.support.PropertySelectedEditingSupport;
import com.kms.katalon.composer.objectrepository.support.PropertyValueEditingSupport;
import com.kms.katalon.composer.objectrepository.support.XpathValueEditingSupport;
import com.kms.katalon.composer.objectrepository.view.ObjectPropertyTableRow;
import com.kms.katalon.composer.objectrepository.view.ObjectXpathTableRow;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.dal.exception.DuplicatedFileNameException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ObjectPropertyView
implements EventHandler {
    private static final String RADIO_LBL_ATTRIBUTES = ObjectspyMessageConstants.DIA_RADIO_LABEL_ATTRIBUTES;
    private static final String RADIO_LBL_CSS = ObjectspyMessageConstants.DIA_RADIO_LABEL_CSS;
    private static final String RADIO_LBL_XPATH = ObjectspyMessageConstants.DIA_RADIO_LABEL_XPATH;
    private static final String RADIO_LBL_IMAGE = ObjectspyMessageConstants.DIA_RADIO_LABEL_IMAGE;
    private static final String RADIO_LBL_SMART_LOCATOR = ObjectspyMessageConstants.DIA_RADIO_LABEL_SMART_LOCATOR;
    private static final String LBL_SELECTION_METHOD = ObjectspyMessageConstants.DIA_LBL_OBJECT_SELECTION_METHOD;
    private static final String LBL_SELECTOR_EDITOR = ObjectspyMessageConstants.LBL_DLG_SELECTOR_EDITOR;
    private static final String HK_ADD = "M1+N";
    private static final String HK_DEL = "Delete";
    private static final String[] FILTER_NAMES = new String[]{"Image Files (*.gif,*.png,*.jpg)"};
    private static final String[] FILTER_EXTS = new String[]{"*.gif; *.png; *.jpg"};
    private ToolItem propertyToolItemAdd;
    private ToolItem propertyToolItemDelete;
    private ToolItem propertyToolItemClear;
    private ToolItem xpathToolItemAdd;
    private ToolItem xpathToolItemDelete;
    private ToolItem xpathToolItemClear;
    private ObjectPropetiesTableViewer propertyTableViewer;
    private ObjectXpathsTableViewer xpathTableViewer;
    private ImageButton btnExpandIframeSetting;
    private TableColumn trclmnColumnSelected;
    private Text txtImage;
    private FormText txtParentObject;
    private FormText txtParentShadowRoot;
    private Button btnBrowseImage;
    private Button chkUseRelative;
    private IEventBroker eventBroker;
    private MDirtyable dirtyable;
    private WebElementEntity originalTestObject;
    private WebElementEntity cloneTestObject;
    private boolean isSettingsExpanded = true;
    private Label lblSettings;
    private Composite propertyTableComposite;
    private Composite xpathTableComposite;
    private Button btnBrowseParentObj;
    private Button btnBrowseParentShadowRoot;
    private Button rdoUseParentObject;
    private Button rdoShadowRootParent;
    private Button rdoNoParent;
    private Composite compositeParentObject;
    private Composite compositeShadowRootParent;
    private Composite compositeSettingsDetails;
    private Composite compositeSettings;
    private ObjectViewPropertyToolListener propertyToolItemListener;
    private ObjectViewXpathToolListener xpathToolItemListener;
    private String parentObjectId = null;
    private boolean isParentObjectShadowRoot = false;
    private TestObjectPart testObjectPart;
    private Composite selectorEditorComposite;
    private StyledText txtSelectorEditor;
    private Composite imageEditorComposite;
    private Button radioAttributes;
    private Button radioXpath;
    private Button radioCss;
    private Button radioImage;
    private Button radioSmart;
    private Listener layoutParentObjectCompositeListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            ObjectPropertyView.this.layoutParentObjectComposite();
        }
    };

    public ObjectPropertyView(IEventBroker eventBroker, MDirtyable dt, TestObjectPart testObjectPart) {
        this.eventBroker = eventBroker;
        this.dirtyable = dt;
        this.propertyToolItemListener = new ObjectViewPropertyToolListener();
        this.xpathToolItemListener = new ObjectViewXpathToolListener();
        this.testObjectPart = testObjectPart;
        eventBroker.subscribe("OBJECT/UPDATE_DIRTY", (EventHandler)this);
        eventBroker.subscribe("OBJECT/UPDATE_IS_SELECTED_COLUMN_HEADER", (EventHandler)this);
        eventBroker.subscribe("TESTOBJECT/UPDATED", (EventHandler)this);
    }

    protected void layoutParentObjectComposite() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                ObjectPropertyView.this.isSettingsExpanded = !ObjectPropertyView.this.isSettingsExpanded;
                ObjectPropertyView.this.compositeSettingsDetails.setVisible(ObjectPropertyView.this.isSettingsExpanded);
                if (!ObjectPropertyView.this.isSettingsExpanded) {
                    ((GridData)ObjectPropertyView.this.compositeSettingsDetails.getLayoutData()).exclude = true;
                    ObjectPropertyView.this.compositeSettings.setSize(ObjectPropertyView.this.compositeSettings.getSize().x, ObjectPropertyView.this.compositeSettings.getSize().y - ObjectPropertyView.this.compositeSettingsDetails.getSize().y);
                } else {
                    ((GridData)ObjectPropertyView.this.compositeSettingsDetails.getLayoutData()).exclude = false;
                }
                ObjectPropertyView.this.compositeSettings.layout(true, true);
                ObjectPropertyView.this.compositeSettings.getParent().layout();
                ObjectPropertyView.this.redrawBtnExpandParentObject();
            }
        });
    }

    private void createPropertyTableToolbar(Composite parent) {
        Composite compositeTableToolBar = new Composite(parent, 0);
        compositeTableToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeTableToolBar.setLayout((Layout)new FillLayout(256));
        ToolBar tableToolbar = new ToolBar(compositeTableToolBar, 0x820000);
        tableToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.propertyToolItemAdd = new ToolItem(tableToolbar, 0);
        this.propertyToolItemAdd.setText(GlobalMessageConstants.ADD);
        this.propertyToolItemAdd.setToolTipText(ComposerObjectRepositoryMessageConstants.VIEW_ITEM_TIP_ADD_NEW_PROPERTY);
        this.propertyToolItemAdd.setImage(ImageConstants.IMG_16_ADD);
        this.propertyToolItemDelete = new ToolItem(tableToolbar, 0);
        this.propertyToolItemDelete.setText(GlobalMessageConstants.DELETE);
        this.propertyToolItemDelete.setToolTipText(GlobalMessageConstants.DELETE);
        this.propertyToolItemDelete.setImage(ImageConstants.IMG_16_REMOVE);
        this.propertyToolItemClear = new ToolItem(tableToolbar, 0);
        this.propertyToolItemClear.setText(GlobalMessageConstants.CLEAR);
        this.propertyToolItemClear.setToolTipText(GlobalMessageConstants.CLEAR);
        this.propertyToolItemClear.setImage(ImageConstants.IMG_16_CLEAR);
    }

    private void createXpathTableToolbar(Composite parent) {
        Composite compositeTableToolBar = new Composite(parent, 0);
        compositeTableToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeTableToolBar.setLayout((Layout)new FillLayout(256));
        ToolBar tableToolbar = new ToolBar(compositeTableToolBar, 0x820000);
        this.xpathToolItemAdd = new ToolItem(tableToolbar, 0);
        this.xpathToolItemAdd.setText(GlobalMessageConstants.ADD);
        this.xpathToolItemAdd.setToolTipText(ComposerObjectRepositoryMessageConstants.VIEW_ITEM_TIP_ADD_NEW_PROPERTY);
        this.xpathToolItemAdd.setImage(ImageConstants.IMG_16_ADD);
        this.xpathToolItemDelete = new ToolItem(tableToolbar, 0);
        this.xpathToolItemDelete.setText(GlobalMessageConstants.DELETE);
        this.xpathToolItemDelete.setToolTipText(GlobalMessageConstants.DELETE);
        this.xpathToolItemDelete.setImage(ImageConstants.IMG_16_REMOVE);
        this.xpathToolItemClear = new ToolItem(tableToolbar, 0);
        this.xpathToolItemClear.setText(GlobalMessageConstants.CLEAR);
        this.xpathToolItemClear.setToolTipText(GlobalMessageConstants.CLEAR);
        this.xpathToolItemClear.setImage(ImageConstants.IMG_16_CLEAR);
    }

    private void createSelectionMethodComposite(Composite parent) {
        Composite selectionMethodComposite = new Composite(parent, 0);
        selectionMethodComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout glSelectionMethodComp = new GridLayout(3, false);
        glSelectionMethodComp.marginHeight = 0;
        glSelectionMethodComp.marginWidth = 0;
        selectionMethodComposite.setLayout((Layout)glSelectionMethodComp);
        Label lblSelectionMethod = new Label(selectionMethodComposite, 0);
        lblSelectionMethod.setText(LBL_SELECTION_METHOD);
        lblSelectionMethod.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label lblSelectionMethodHelp = new Label(selectionMethodComposite, 0);
        lblSelectionMethodHelp.setImage(ImageConstants.IMG_16_HELP);
        lblSelectionMethodHelp.setCursor(Display.getDefault().getSystemCursor(21));
        lblSelectionMethodHelp.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblSelectionMethodHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Program.launch((String)ComposerObjectRepositoryMessageConstants.VIEW_HELP_SELECTION_METHOD_DOC_URL);
            }
        });
        Composite radioSelectionComposite = new Composite(selectionMethodComposite, 0);
        radioSelectionComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glRadioSelection = new GridLayout(5, false);
        glRadioSelection.marginHeight = 0;
        glRadioSelection.marginWidth = 0;
        glRadioSelection.marginLeft = 10;
        radioSelectionComposite.setLayout((Layout)glRadioSelection);
        this.radioXpath = new Button(radioSelectionComposite, 16);
        this.radioXpath.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.radioXpath.setText(RADIO_LBL_XPATH);
        this.radioAttributes = new Button(radioSelectionComposite, 16);
        this.radioAttributes.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.radioAttributes.setText(RADIO_LBL_ATTRIBUTES);
        this.radioCss = new Button(radioSelectionComposite, 16);
        this.radioCss.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.radioCss.setText(RADIO_LBL_CSS);
        this.radioImage = new Button(radioSelectionComposite, 16);
        this.radioImage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.radioImage.setText(RADIO_LBL_IMAGE);
        this.radioSmart = new Button(radioSelectionComposite, 16);
        this.radioSmart.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.radioSmart.setText(RADIO_LBL_SMART_LOCATOR);
        if (LicenseUtil.isFreeLicense()) {
            this.radioSmart.setVisible(false);
        }
    }

    private void createPropertyTableDetails(Composite parent) {
        Composite compositeTableDetails = new Composite(parent, 0);
        compositeTableDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeTableDetails = new GridLayout(1, false);
        glCompositeTableDetails.marginWidth = 0;
        glCompositeTableDetails.marginHeight = 0;
        compositeTableDetails.setLayout((Layout)glCompositeTableDetails);
        this.propertyTableViewer = new ObjectPropetiesTableViewer(compositeTableDetails, 67586, this.eventBroker);
        Table table = this.propertyTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        GridData gridDataTable = new GridData(4, 4, true, true, 3, 1);
        table.setLayoutData((Object)gridDataTable);
        TableViewerColumn treeViewerColumnName = new TableViewerColumn((TableViewer)this.propertyTableViewer, 0);
        TableColumn trclmnColumnName = treeViewerColumnName.getColumn();
        trclmnColumnName.setText(GlobalMessageConstants.NAME);
        trclmnColumnName.setWidth(100);
        treeViewerColumnName.setEditingSupport((EditingSupport)new PropertyNameEditingSupport(this.propertyTableViewer, this.eventBroker, this.testObjectPart));
        treeViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getName();
            }
        });
        TableViewerColumn treeViewerColumnCondition = new TableViewerColumn((TableViewer)this.propertyTableViewer, 0);
        TableColumn trclmnColumnCondition = treeViewerColumnCondition.getColumn();
        trclmnColumnCondition.setText(ComposerObjectRepositoryMessageConstants.VIEW_COL_MATCH_COND);
        trclmnColumnCondition.setWidth(150);
        treeViewerColumnCondition.setEditingSupport((EditingSupport)new PropertyConditionEditingSupport(this.propertyTableViewer, this.eventBroker, this.testObjectPart));
        treeViewerColumnCondition.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getMatchCondition();
            }
        });
        TableViewerColumn treeViewerColumnValue = new TableViewerColumn((TableViewer)this.propertyTableViewer, 0);
        TableColumn trclmnColumnValue = treeViewerColumnValue.getColumn();
        trclmnColumnValue.setText(GlobalMessageConstants.VALUE);
        trclmnColumnValue.setWidth(350);
        treeViewerColumnValue.setEditingSupport((EditingSupport)new PropertyValueEditingSupport(this.propertyTableViewer, this.eventBroker, this.testObjectPart));
        treeViewerColumnValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getValue();
            }
        });
        TableViewerColumn treeViewerColumnSelected = new TableViewerColumn((TableViewer)this.propertyTableViewer, 0);
        treeViewerColumnSelected.setEditingSupport((EditingSupport)new PropertySelectedEditingSupport(this.propertyTableViewer, this.eventBroker, this.testObjectPart));
        treeViewerColumnSelected.setLabelProvider((CellLabelProvider)new IsSelectedColumnLabelProvider());
        this.trclmnColumnSelected = treeViewerColumnSelected.getColumn();
        this.trclmnColumnSelected.setText(ComposerObjectRepositoryMessageConstants.VIEW_COL_CHKBOX);
        this.trclmnColumnSelected.setWidth(150);
        this.propertyTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    private void createXpathsTableDetails(Composite parent) {
        Composite xpathCompositeTableDetails = new Composite(parent, 0);
        xpathCompositeTableDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeTableDetails = new GridLayout(1, false);
        glCompositeTableDetails.marginWidth = 0;
        glCompositeTableDetails.marginHeight = 0;
        xpathCompositeTableDetails.setLayout((Layout)glCompositeTableDetails);
        this.xpathTableViewer = new ObjectXpathsTableViewer(xpathCompositeTableDetails, 67586, this.eventBroker);
        Table table = this.xpathTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        GridData gridDataTable = new GridData(4, 4, true, true, 1, 1);
        table.setLayoutData((Object)gridDataTable);
        TableViewerColumn treeViewerColumnName = new TableViewerColumn((TableViewer)this.xpathTableViewer, 0);
        TableColumn trclmnColumnName = treeViewerColumnName.getColumn();
        trclmnColumnName.setText(GlobalMessageConstants.NAME);
        trclmnColumnName.setWidth(100);
        treeViewerColumnName.setEditingSupport((EditingSupport)new PropertyNameEditingSupport(this.xpathTableViewer, this.eventBroker, this.testObjectPart));
        treeViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementXpathEntity)element).getName();
            }
        });
        TableViewerColumn treeViewerColumnValue = new TableViewerColumn((TableViewer)this.xpathTableViewer, 0);
        TableColumn trclmnColumnValue = treeViewerColumnValue.getColumn();
        trclmnColumnValue.setText(GlobalMessageConstants.VALUE);
        trclmnColumnValue.setWidth(500);
        treeViewerColumnValue.setEditingSupport((EditingSupport)new XpathValueEditingSupport(this.xpathTableViewer, this.eventBroker, this.testObjectPart));
        treeViewerColumnValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementXpathEntity)element).getValue();
            }
        });
        this.xpathTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    private void createPropertyTableMenu() {
        Table table = this.propertyTableViewer.getTable();
        CMenu menu = new CMenu((Control)table, (HotkeyActiveListener)this.propertyToolItemListener);
        table.setMenu((Menu)menu);
        menu.createMenuItem(GlobalMessageConstants.ADD, HK_ADD);
        menu.createMenuItem(GlobalMessageConstants.DELETE, HK_DEL, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ObjectPropertyView.this.isPropertyTableAbleToDelete();
            }
        });
        new MenuItem((Menu)menu, 2);
        menu.createMenuItem(GlobalMessageConstants.CLEAR, null, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ObjectPropertyView.this.isPropertyTableAbleToClear();
            }
        });
    }

    private void createXpathTableMenu() {
        Table table = this.xpathTableViewer.getTable();
        CMenu menu = new CMenu((Control)table, (HotkeyActiveListener)this.xpathToolItemListener);
        table.setMenu((Menu)menu);
        menu.createMenuItem(GlobalMessageConstants.ADD, HK_ADD);
        menu.createMenuItem(GlobalMessageConstants.DELETE, HK_DEL, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ObjectPropertyView.this.isXpathTableAbleToDelete();
            }
        });
        new MenuItem((Menu)menu, 2);
        menu.createMenuItem(GlobalMessageConstants.CLEAR, null, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ObjectPropertyView.this.isXpathTableAbleToClear();
            }
        });
    }

    private Composite createTestObjectDetailsComposite(Composite parent) {
        Composite compositeObjectDetails = new Composite(parent, 0);
        compositeObjectDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glCompositeObjectDetails = new GridLayout(1, false);
        glCompositeObjectDetails.verticalSpacing = 15;
        glCompositeObjectDetails.marginHeight = 5;
        glCompositeObjectDetails.marginWidth = 10;
        compositeObjectDetails.setLayout((Layout)glCompositeObjectDetails);
        this.createSettingsComposite(compositeObjectDetails);
        this.createSelectionMethodComposite(compositeObjectDetails);
        Composite compositeTableHeader = new Composite(compositeObjectDetails, 0);
        compositeTableHeader.setLayoutData((Object)new GridData(4, 4, true, false));
        compositeTableHeader.setLayout((Layout)new FillLayout(256));
        this.createSelectorEditor(compositeObjectDetails);
        this.createObjectPropertiesComposite(compositeObjectDetails);
        this.createObjectXpathsComposite(compositeObjectDetails);
        this.createImageEditorComposite(compositeObjectDetails);
        return compositeObjectDetails;
    }

    private void createObjectPropertiesComposite(Composite parent) {
        this.propertyTableComposite = new Composite(parent, 0);
        this.propertyTableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glCompositeTable = new GridLayout();
        glCompositeTable.marginWidth = 0;
        glCompositeTable.marginHeight = 0;
        this.propertyTableComposite.setLayout((Layout)glCompositeTable);
        Label lblObjectProperties = new Label(this.propertyTableComposite, 0);
        lblObjectProperties.setText(ComposerObjectRepositoryMessageConstants.VIEW_LBL_OBJ_PROPERTIES);
        ControlUtils.setFontToBeBold((Control)lblObjectProperties);
        this.createPropertyTableToolbar(this.propertyTableComposite);
        this.createPropertyTableDetails(this.propertyTableComposite);
        this.createPropertyTableMenu();
    }

    private void createObjectXpathsComposite(Composite parent) {
        this.xpathTableComposite = new Composite(parent, 0);
        this.xpathTableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glCompositeTable = new GridLayout();
        glCompositeTable.marginWidth = 0;
        glCompositeTable.marginHeight = 0;
        this.xpathTableComposite.setLayout((Layout)glCompositeTable);
        Label lblObjectXpaths = new Label(this.xpathTableComposite, 0);
        lblObjectXpaths.setText(ComposerObjectRepositoryMessageConstants.VIEW_LBL_OBJ_XPATHS);
        ControlUtils.setFontToBeBold((Control)lblObjectXpaths);
        this.createXpathsTableDetails(this.xpathTableComposite);
        this.createXpathTableMenu();
    }

    private void createSelectorEditor(Composite parent) {
        this.selectorEditorComposite = new Composite(parent, 0);
        this.selectorEditorComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.selectorEditorComposite.setLayout((Layout)layout);
        Label lblSelectorEditor = new Label(this.selectorEditorComposite, 0);
        lblSelectorEditor.setText(LBL_SELECTOR_EDITOR);
        ControlUtils.setFontToBeBold((Control)lblSelectorEditor);
        lblSelectorEditor.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtSelectorEditor = new StyledText(this.selectorEditorComposite, 2624);
        GridData gdSelectorEditor = new GridData(4, 4, true, false);
        gdSelectorEditor.heightHint = 100;
        this.txtSelectorEditor.setLayoutData((Object)gdSelectorEditor);
    }

    private void createImageEditorComposite(Composite parent) {
        this.imageEditorComposite = new Composite(parent, 0);
        this.imageEditorComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        GridLayout glImageLocatorComposite = new GridLayout(3, false);
        glImageLocatorComposite.marginHeight = 0;
        glImageLocatorComposite.marginWidth = 0;
        this.imageEditorComposite.setLayout((Layout)glImageLocatorComposite);
        new Label(this.imageEditorComposite, 0);
        this.chkUseRelative = new Button(this.imageEditorComposite, 32);
        this.chkUseRelative.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.chkUseRelative.setText(ComposerObjectRepositoryMessageConstants.VIEW_CHKBOX_LBL_USE_RELATIVE_PATH);
        Label lbImageInput = new Label(this.imageEditorComposite, 0);
        lbImageInput.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lbImageInput.setText(GlobalMessageConstants.PATH);
        this.txtImage = new Text(this.imageEditorComposite, 2056);
        GridData gdImage = new GridData(4, 4, true, false, 1, 1);
        gdImage.widthHint = 335;
        this.txtImage.setLayoutData((Object)gdImage);
        this.txtImage.setEditable(true);
        this.btnBrowseImage = new Button(this.imageEditorComposite, 0x800000);
        this.btnBrowseImage.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnBrowseImage.setText(GlobalMessageConstants.BROWSE);
        this.btnBrowseImage.setToolTipText(ComposerObjectRepositoryMessageConstants.VIEW_BTN_TIP_BROWSE);
    }

    private void createSettingsComposite(Composite parent) {
        this.compositeSettings = new Composite(parent, 0);
        GridLayout glCompositeParentObject = new GridLayout(1, true);
        glCompositeParentObject.horizontalSpacing = 40;
        glCompositeParentObject.marginWidth = 0;
        glCompositeParentObject.marginHeight = 0;
        this.compositeSettings.setLayout((Layout)glCompositeParentObject);
        this.compositeSettings.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite compositeSettingsHeader = new Composite(this.compositeSettings, 0);
        GridData gd_compositeParentObjectHeader = new GridData(4, 128, true, false, 1, 1);
        compositeSettingsHeader.setLayoutData((Object)gd_compositeParentObjectHeader);
        GridLayout glCompositeParentObjectHeader = new GridLayout(2, false);
        glCompositeParentObjectHeader.marginHeight = 0;
        glCompositeParentObjectHeader.marginWidth = 0;
        compositeSettingsHeader.setLayout((Layout)glCompositeParentObjectHeader);
        compositeSettingsHeader.setCursor(compositeSettingsHeader.getDisplay().getSystemCursor(21));
        this.btnExpandIframeSetting = new ImageButton(compositeSettingsHeader, 8);
        this.btnExpandIframeSetting.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.redrawBtnExpandParentObject();
        this.lblSettings = new Label(compositeSettingsHeader, 0);
        this.lblSettings.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblSettings.setText(ComposerObjectRepositoryMessageConstants.VIEW_LBL_SETTINGS);
        ControlUtils.setFontToBeBold((Control)this.lblSettings);
        this.compositeSettingsDetails = new Composite(this.compositeSettings, 0);
        this.compositeSettingsDetails.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeParentObjectDetails = new GridLayout(2, true);
        glCompositeParentObjectDetails.marginWidth = 35;
        glCompositeParentObjectDetails.marginHeight = 0;
        glCompositeParentObjectDetails.verticalSpacing = 10;
        glCompositeParentObjectDetails.horizontalSpacing = 40;
        this.compositeSettingsDetails.setLayout((Layout)glCompositeParentObjectDetails);
        Composite compositeSettingsLeft = new Composite(this.compositeSettingsDetails, 0);
        compositeSettingsLeft.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        compositeSettingsLeft.setLayout((Layout)new GridLayout(1, false));
        Group haveParentGroup = new Group(compositeSettingsLeft, 0);
        haveParentGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        haveParentGroup.setLayout((Layout)new GridLayout(2, false));
        haveParentGroup.setText(ComposerObjectRepositoryMessageConstants.GRP_HAVE_PARENT_OBJECT);
        this.createCompositeNoParentObject((Composite)haveParentGroup);
        this.createCompositeParentObject((Composite)haveParentGroup);
        this.createCompositeShadowRootParent((Composite)haveParentGroup);
        Composite compositeSettingsRight = new Composite(this.compositeSettingsDetails, 0);
        compositeSettingsRight.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        compositeSettingsRight.setLayout((Layout)new GridLayout(3, false));
    }

    private void createCompositeShadowRootParent(Composite compositeSettingsLeft) {
        this.rdoShadowRootParent = new Button(compositeSettingsLeft, 16);
        this.rdoShadowRootParent.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.rdoShadowRootParent.setText(ComposerObjectRepositoryMessageConstants.RDO_SHADOW_ROOT_PARENT);
        this.compositeShadowRootParent = new Composite(compositeSettingsLeft, 0);
        GridLayout glCompositeParentObject = new GridLayout(2, false);
        glCompositeParentObject.marginHeight = 0;
        glCompositeParentObject.marginWidth = 0;
        this.compositeShadowRootParent.setLayout((Layout)glCompositeParentObject);
        this.compositeShadowRootParent.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtParentShadowRoot = new FormText(this.compositeShadowRootParent, 2048);
        this.txtParentShadowRoot.setWhitespaceNormalized(false);
        GridData gdTxtParentObject = new GridData(4, 4, true, true, 1, 1);
        gdTxtParentObject.heightHint = 20;
        this.txtParentShadowRoot.setLayoutData((Object)gdTxtParentObject);
        this.btnBrowseParentShadowRoot = new Button(this.compositeShadowRootParent, 0x800000);
        this.btnBrowseParentShadowRoot.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.btnBrowseParentShadowRoot.setText(GlobalMessageConstants.BROWSE);
    }

    private void createCompositeNoParentObject(Composite parentComposite) {
        this.rdoNoParent = new Button(parentComposite, 16);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        layoutData.heightHint = 20;
        this.rdoNoParent.setLayoutData((Object)layoutData);
        this.rdoNoParent.setText(ComposerObjectRepositoryMessageConstants.RDO_NO_PARENT);
    }

    private void createCompositeParentObject(Composite parentComposite) {
        this.rdoUseParentObject = new Button(parentComposite, 16);
        this.rdoUseParentObject.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.rdoUseParentObject.setText(ComposerObjectRepositoryMessageConstants.VIEW_LBL_USE_IFRAME);
        this.compositeParentObject = new Composite(parentComposite, 0);
        GridLayout glCompositeParentObject = new GridLayout(2, false);
        glCompositeParentObject.marginHeight = 0;
        glCompositeParentObject.marginWidth = 0;
        this.compositeParentObject.setLayout((Layout)glCompositeParentObject);
        this.compositeParentObject.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtParentObject = new FormText(this.compositeParentObject, 2048);
        this.txtParentObject.setWhitespaceNormalized(false);
        GridData gdTxtParentObject = new GridData(4, 4, true, true, 1, 1);
        gdTxtParentObject.heightHint = 20;
        this.txtParentObject.setLayoutData((Object)gdTxtParentObject);
        this.btnBrowseParentObj = new Button(this.compositeParentObject, 0x800000);
        this.btnBrowseParentObj.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.btnBrowseParentObj.setText(GlobalMessageConstants.BROWSE);
    }

    private void hookControlSelectListerners() {
        this.btnExpandIframeSetting.addListener(3, this.layoutParentObjectCompositeListener);
        this.lblSettings.addListener(3, this.layoutParentObjectCompositeListener);
        this.txtImage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ObjectPropertyView.this.cloneTestObject != null) {
                    ObjectPropertyView.this.cloneTestObject.setImagePath(ObjectPropertyView.this.txtImage.getText());
                    ObjectPropertyView.this.setDirty(true);
                }
            }
        });
        this.chkUseRelative.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new CheckImageRelativePathOperation());
            }
        });
        this.propertyToolItemClear.addSelectionListener((SelectionListener)this.propertyToolItemListener);
        this.propertyToolItemDelete.addSelectionListener((SelectionListener)this.propertyToolItemListener);
        this.propertyToolItemAdd.addSelectionListener((SelectionListener)this.propertyToolItemListener);
        this.trclmnColumnSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.propertyTableViewer.setSelectedAll();
                ObjectPropertyView.this.onWebElementPropertyChanged();
                ObjectPropertyView.this.setDirty(true);
            }
        });
        this.btnBrowseImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String projectFolder = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                FileDialog dialog = new FileDialog(ObjectPropertyView.this.btnBrowseImage.getShell());
                dialog.setFilterNames(FILTER_NAMES);
                dialog.setFilterExtensions(FILTER_EXTS);
                dialog.setFilterPath(projectFolder);
                String absolutePath = dialog.open();
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ChangeImagePathOperation(absolutePath));
            }
        });
        this.btnBrowseParentObj.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.performSelectParentObject();
            }
        });
        this.btnBrowseParentShadowRoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.performSelectParentObject();
            }
        });
        this.rdoUseParentObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new CheckUseParentObjectOperation());
            }
        });
        this.rdoNoParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new CheckNoParentObjectOperation());
            }
        });
        this.rdoShadowRootParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new CheckUseParentShadowRootObjectOperation());
            }
        });
        HyperlinkAdapter hyperLinkListener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectPropertyView.this.openParentTestObject(e.getLabel());
            }
        };
        this.txtParentObject.addHyperlinkListener((IHyperlinkListener)hyperLinkListener);
        this.txtParentShadowRoot.addHyperlinkListener((IHyperlinkListener)hyperLinkListener);
        this.radioAttributes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ChangeSelectorMethodOperation(WebElementSelectorMethod.BASIC));
                ObjectPropertyView.this.setDirty(true);
            }
        });
        this.radioCss.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ChangeSelectorMethodOperation(WebElementSelectorMethod.CSS));
                ObjectPropertyView.this.setDirty(true);
            }
        });
        this.radioXpath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ChangeSelectorMethodOperation(WebElementSelectorMethod.XPATH));
                ObjectPropertyView.this.setDirty(true);
            }
        });
        this.radioImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ChangeSelectorMethodOperation(WebElementSelectorMethod.IMAGE));
                ObjectPropertyView.this.setDirty(true);
            }
        });
        this.radioSmart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ChangeSelectorMethodOperation(WebElementSelectorMethod.SMART_LOCATOR));
                ObjectPropertyView.this.setDirty(true);
            }
        });
        this.txtSelectorEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String selector = ((StyledText)e.getSource()).getText();
                ObjectPropertyView.this.getCloneTestObject().setSelectorValue(ObjectPropertyView.this.getCloneTestObject().getGenericSelectorMethod(), selector);
                ObjectPropertyView.this.setDirty(true);
            }
        });
    }

    private void onWebElementPropertyChanged() {
        if (this.txtSelectorEditor.isDisposed()) {
            return;
        }
        if (this.cloneTestObject == null) {
            this.disableSelectorEditor();
            return;
        }
        WebElementSelectorMethod selectorMethod = this.cloneTestObject.getGenericSelectorMethod();
        switch (selectorMethod) {
            case BASIC: {
                TestObject testObject = this.buildTestObject(this.cloneTestObject);
                String textToSet = WebUiCommonHelper.getSelectorValue((TestObject)testObject);
                textToSet = textToSet == null ? "" : textToSet;
                this.enableSelectorEditor(textToSet, false);
                return;
            }
        }
    }

    private void onWebElementXpathChanged() {
        if (this.txtSelectorEditor.isDisposed()) {
            return;
        }
        if (this.cloneTestObject == null) {
            this.disableSelectorEditor();
            return;
        }
        WebElementSelectorMethod selectorMethod = this.cloneTestObject.getGenericSelectorMethod();
        switch (selectorMethod) {
            case XPATH: {
                TestObject testObject = this.buildTestObject(this.cloneTestObject);
                String textToSet = WebUiCommonHelper.getSelectorValue((TestObject)testObject);
                textToSet = textToSet == null ? "" : textToSet;
                this.enableSelectorEditor(textToSet, true);
                break;
            }
        }
    }

    private void onWebElementCSSChanged() {
        if (this.txtSelectorEditor.isDisposed()) {
            return;
        }
        if (this.cloneTestObject == null) {
            this.disableSelectorEditor();
            return;
        }
        WebElementSelectorMethod selectorMethod = this.cloneTestObject.getGenericSelectorMethod();
        switch (selectorMethod) {
            case CSS: {
                TestObject testObject = this.buildTestObject(this.cloneTestObject);
                String textToSet = WebUiCommonHelper.getSelectorValue((TestObject)testObject);
                textToSet = textToSet == null ? "" : textToSet;
                this.enableSelectorEditor(textToSet, true);
                break;
            }
        }
    }

    private void onWebElementImageChanged() {
        if (this.cloneTestObject == null) {
            return;
        }
        WebElementSelectorMethod selectorMethod = this.cloneTestObject.getGenericSelectorMethod();
        if (selectorMethod == WebElementSelectorMethod.IMAGE) {
            TestObject testObject = this.buildTestObject(this.cloneTestObject);
            this.txtImage.setText(StringUtils.defaultString((String)testObject.getImagePath()));
        }
    }

    private void onWebElementSmartLocatorChanged() {
        if (this.txtSelectorEditor.isDisposed()) {
            return;
        }
        if (this.cloneTestObject == null) {
            this.disableSelectorEditor();
            return;
        }
        WebElementSelectorMethod selectorMethod = this.cloneTestObject.getGenericSelectorMethod();
        switch (selectorMethod) {
            case SMART_LOCATOR: {
                TestObject testObject = this.buildTestObject(this.cloneTestObject);
                String textToSet = WebUiCommonHelper.getSelectorValue((TestObject)testObject);
                textToSet = textToSet == null ? "" : textToSet;
                this.enableSelectorEditor(textToSet, true);
                break;
            }
        }
    }

    private void onWebElementDefault() {
        if (this.txtSelectorEditor.isDisposed()) {
            return;
        }
        if (this.cloneTestObject == null) {
            this.disableSelectorEditor();
            return;
        }
        TestObject testObject = this.buildTestObject(this.cloneTestObject);
        String textToSet = WebUiCommonHelper.getSelectorValue((TestObject)testObject, (SelectorMethod)SelectorMethod.XPATH);
        textToSet = textToSet == null ? "" : textToSet;
        this.enableSelectorEditor(textToSet, true);
    }

    private void enableSelectorEditor() {
        this.enableSelectorEditor("", true);
    }

    private void enableSelectorEditor(String initText, boolean editable) {
        this.txtSelectorEditor.setEnabled(true);
        this.txtSelectorEditor.setEditable(editable);
        this.txtSelectorEditor.setText(initText);
        this.txtSelectorEditor.setBackground(editable ? ColorUtil.getWhiteBackgroundColor() : ColorUtil.getDisabledItemBackgroundColor());
    }

    private void disableSelectorEditor() {
        this.txtSelectorEditor.setEnabled(false);
        this.txtSelectorEditor.setEditable(false);
        this.txtSelectorEditor.setBackground(ColorUtil.getDisabledItemBackgroundColor());
        this.txtSelectorEditor.setText("");
    }

    private void setDirty(boolean isDirty) {
        this.dirtyable.setDirty(isDirty);
    }

    private void performSelectParentObject() {
        try {
            Object selectedObject;
            ITreeEntity treeEntity;
            WebElementEntity currentParentWebElement;
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject == null) {
                return;
            }
            EntityProvider entityProvider = new EntityProvider();
            TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(null, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new ParentObjectViewerFilter(entityProvider, this.originalTestObject));
            FolderEntity objectRepoRootFolder = FolderController.getInstance().getObjectRepositoryRoot(currentProject);
            dialog.setAllowMultiple(false);
            dialog.setTitle(ComposerObjectRepositoryMessageConstants.VIEW_TEST_OBJECT_BROWSE);
            dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)objectRepoRootFolder));
            String currentParentObjectId = this.getParentObjectId();
            if (!StringUtils.isBlank((String)currentParentObjectId) && (currentParentWebElement = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(currentParentObjectId)) != null) {
                dialog.setInitialSelection((Object)new WebElementTreeEntity(currentParentWebElement, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)currentParentWebElement.getParentFolder(), (FolderEntity)objectRepoRootFolder)));
            }
            if (dialog.open() == 0 && (treeEntity = (ITreeEntity)(selectedObject = dialog.getResult()[0])).getObject() instanceof WebElementEntity) {
                WebElementEntity parentObject = (WebElementEntity)treeEntity.getObject();
                String parentObjectId = parentObject.getIdForDisplay();
                this.testObjectPart.executeOperation((IUndoableOperation)new ChangeParentTestObjectOperation(parentObjectId));
                this.setDirty(true);
            }
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void createControlGroup(Composite parent) {
        ScrolledComposite mainComposite = new ScrolledComposite(parent, 768);
        GridLayout glMainComposite = new GridLayout(1, false);
        glMainComposite.verticalSpacing = 10;
        mainComposite.setLayout((Layout)glMainComposite);
        Composite testObjectDetailsComposite = this.createTestObjectDetailsComposite((Composite)mainComposite);
        mainComposite.setContent((Control)testObjectDetailsComposite);
        mainComposite.setExpandVertical(true);
        mainComposite.setExpandHorizontal(true);
        this.hookControlSelectListerners();
    }

    private void redrawBtnExpandParentObject() {
        this.btnExpandIframeSetting.getParent().setRedraw(false);
        if (this.isSettingsExpanded) {
            this.btnExpandIframeSetting.setImage(ImageConstants.IMG_16_ARROW_DOWN);
        } else {
            this.btnExpandIframeSetting.setImage(ImageConstants.IMG_16_ARROW);
        }
        this.btnExpandIframeSetting.getParent().setRedraw(true);
    }

    public Composite createMainPage(Composite theParent) {
        Composite mainPage = new Composite(theParent, 0);
        mainPage.setLayout((Layout)new FillLayout());
        SashForm sash = new SashForm(mainPage, 256);
        this.createControlGroup((Composite)sash);
        return mainPage;
    }

    public void changeOriginalTestObject(WebElementEntity object) {
        this.originalTestObject = object;
        this.cloneTestObject = this.originalTestObject.clone();
        this.loadTestObject();
        this.dirtyable.setDirty(!ObjectPropertyHandler.verifyObjectProperties((Object)this.propertyTableViewer.getInput(), (List)this.propertyTableViewer.getInput()));
    }

    private void loadTestObject() {
        try {
            if (this.cloneTestObject.getImagePath() != null) {
                this.txtImage.setText(this.cloneTestObject.getImagePath());
            }
            this.chkUseRelative.setSelection(this.cloneTestObject.getUseRalativeImagePath());
            ArrayList<WebElementPropertyEntity> webElementProperties = new ArrayList<WebElementPropertyEntity>();
            WebElementPropertyEntity parentObjectProperty = null;
            WebElementPropertyEntity isParentShadowRootProperty = null;
            for (WebElementPropertyEntity webElementProperty : this.cloneTestObject.getWebElementProperties()) {
                if ("ref_element".equals(webElementProperty.getName())) {
                    parentObjectProperty = webElementProperty;
                    continue;
                }
                if ("ref_element_is_shadow_root".equals(webElementProperty.getName())) {
                    isParentShadowRootProperty = webElementProperty;
                    continue;
                }
                webElementProperties.add(webElementProperty);
            }
            ArrayList<WebElementXpathEntity> webElementXpaths = new ArrayList<WebElementXpathEntity>();
            for (WebElementXpathEntity webElementXpath : this.cloneTestObject.getWebElementXpaths()) {
                webElementXpaths.add(webElementXpath);
            }
            this.setParentObjectId(parentObjectProperty != null && parentObjectProperty.getIsSelected() != false ? parentObjectProperty.getValue() : null);
            this.setParentObjectShadowRoot(isParentShadowRootProperty != null && isParentShadowRootProperty.getIsSelected() != false);
            this.refreshParentObjectComposites();
            this.propertyTableViewer.setInput(webElementProperties);
            this.propertyTableViewer.refresh();
            this.xpathTableViewer.setInput(webElementXpaths);
            this.xpathTableViewer.refresh();
            this.refreshLocatorMethod();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ComposerObjectRepositoryMessageConstants.VIEW_ERROR_MSG_FAILED_TO_LOAD_OBJ_REPOSITORY);
        }
    }

    private void refreshParentObjectComposites() {
        this.refreshParentObjectComposite(this.rdoUseParentObject, ParentObjectType.PARENT_IFRAME, this.compositeParentObject);
        this.refreshParentObjectComposite(this.rdoShadowRootParent, ParentObjectType.PARENT_SHADOW_ROOT, this.compositeShadowRootParent);
        this.refreshParentObjectComposite(this.rdoNoParent, ParentObjectType.NO_PARENT, null);
        ParentObjectType currentParentObjectType = this.getParentObjectType();
        switch (currentParentObjectType) {
            case PARENT_IFRAME: {
                this.setLinkIdToFormText(this.getParentObjectId(), this.txtParentObject);
                this.clearFormText(this.txtParentShadowRoot);
                break;
            }
            case PARENT_SHADOW_ROOT: {
                this.clearFormText(this.txtParentObject);
                this.setLinkIdToFormText(this.getParentObjectId(), this.txtParentShadowRoot);
                break;
            }
            case NO_PARENT: {
                this.clearFormText(this.txtParentObject);
                this.clearFormText(this.txtParentShadowRoot);
            }
        }
    }

    private void refreshLocatorMethod() {
        WebElementSelectorMethod selectorMethod = this.cloneTestObject.getGenericSelectorMethod();
        this.radioAttributes.setSelection(selectorMethod == WebElementSelectorMethod.BASIC);
        this.radioCss.setSelection(selectorMethod == WebElementSelectorMethod.CSS);
        this.radioXpath.setSelection(selectorMethod == WebElementSelectorMethod.XPATH);
        this.radioImage.setSelection(selectorMethod == WebElementSelectorMethod.IMAGE);
        this.radioSmart.setSelection(selectorMethod == WebElementSelectorMethod.SMART_LOCATOR);
        this.onWebElementPropertyChanged();
        this.onWebElementXpathChanged();
        this.onWebElementCSSChanged();
        this.onWebElementImageChanged();
        this.onWebElementSmartLocatorChanged();
        this.showComposite(this.imageEditorComposite, selectorMethod == WebElementSelectorMethod.IMAGE);
        this.showComposite(this.selectorEditorComposite, selectorMethod != WebElementSelectorMethod.IMAGE);
        this.showComposite(this.propertyTableComposite, selectorMethod == WebElementSelectorMethod.BASIC);
        this.showComposite(this.xpathTableComposite, selectorMethod == WebElementSelectorMethod.XPATH);
        if (selectorMethod == WebElementSelectorMethod.SMART_LOCATOR && LicenseUtil.isFreeLicense()) {
            this.radioXpath.setSelection(true);
            this.showComposite(this.xpathTableComposite, true);
            this.onWebElementDefault();
        }
    }

    private void refreshParentObjectComposite(Button rdoButton, ParentObjectType parentObjectType, Composite composite) {
        ParentObjectType currentParentObjectType = this.getParentObjectType();
        rdoButton.setSelection(parentObjectType == currentParentObjectType);
        if (composite == null) {
            return;
        }
        ControlUtils.recursiveSetEnabled((Control)composite, (parentObjectType == currentParentObjectType ? 1 : 0) != 0);
    }

    public void save() {
        if (this.propertyTableViewer.isCellEditorActive()) {
            this.propertyTableViewer.getTable().forceFocus();
        }
        if (this.xpathTableViewer.isCellEditorActive()) {
            this.xpathTableViewer.getTable().forceFocus();
        }
        if (!ObjectPropertyHandler.verifyObjectProperties((Object)this.propertyTableViewer.getInput(), (List)this.propertyTableViewer.getInput())) {
            return;
        }
        List webElementProperties = this.cloneTestObject.getWebElementProperties();
        webElementProperties.clear();
        webElementProperties.addAll(this.propertyTableViewer.getInput());
        List webElementXpaths = this.cloneTestObject.getWebElementXpaths();
        webElementXpaths.clear();
        webElementXpaths.addAll(this.xpathTableViewer.getInput());
        ParentObjectType parentObjectType = this.getParentObjectType();
        switch (parentObjectType) {
            case PARENT_IFRAME: {
                if (StringUtils.isBlank((String)this.getParentObjectId())) break;
                this.addElementProperty(webElementProperties, "ref_element", this.getParentObjectId());
                this.removeElementProperty(webElementProperties, "ref_element_is_shadow_root");
                break;
            }
            case PARENT_SHADOW_ROOT: {
                if (StringUtils.isBlank((String)this.getParentObjectId())) break;
                this.addElementProperty(webElementProperties, "ref_element", this.getParentObjectId());
                this.addElementProperty(webElementProperties, "ref_element_is_shadow_root", "true");
                break;
            }
            case NO_PARENT: {
                this.removeElementProperty(webElementProperties, "ref_element");
                this.removeElementProperty(webElementProperties, "ref_element_is_shadow_root");
                break;
            }
        }
        WebElementEntity temp = new WebElementEntity();
        this.copyObjectCharacteristics(this.originalTestObject, temp);
        try {
            String pk = this.originalTestObject.getId();
            String oldIdForDisplay = this.originalTestObject.getIdForDisplay();
            this.copyObjectCharacteristics(this.cloneTestObject, this.originalTestObject);
            ObjectRepositoryController.getInstance().updateTestObject(this.originalTestObject);
            this.changeOriginalTestObject(this.originalTestObject);
            if (!StringUtils.equalsIgnoreCase((String)temp.getName(), (String)this.originalTestObject.getName())) {
                this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, this.originalTestObject.getIdForDisplay()});
            }
            this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{pk, this.originalTestObject});
            WebElementTreeEntity testObjectTreeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)this.originalTestObject, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testObjectTreeEntity);
            this.dirtyable.setDirty(false);
        }
        catch (DuplicatedFileNameException dupplicatedEx) {
            this.copyObjectCharacteristics(temp, this.originalTestObject);
            MessageDialog.openWarning(null, (String)GlobalMessageConstants.WARN, (String)MessageFormat.format(ComposerObjectRepositoryMessageConstants.VIEW_ERROR_REASON_OBJ_EXISTED, dupplicatedEx.getMessage()));
        }
        catch (Exception ex) {
            this.copyObjectCharacteristics(temp, this.originalTestObject);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerObjectRepositoryMessageConstants.VIEW_ERROR_MSG_UNABLE_TO_SAVE_TEST_OBJ, (String)ex.toString());
        }
    }

    private void addElementProperty(List<WebElementPropertyEntity> webElementProperties, String propertyName, String propertyValue) {
        Optional<WebElementPropertyEntity> elementProperty = webElementProperties.parallelStream().filter(webElementProperty -> webElementProperty.getName().equals(propertyName)).findAny();
        if (elementProperty.isPresent()) {
            elementProperty.get().setIsSelected(Boolean.valueOf(true));
            return;
        }
        webElementProperties.add(new WebElementPropertyEntity(propertyName, propertyValue, true));
    }

    private void removeElementProperty(List<WebElementPropertyEntity> webElementProperties, String propertyName) {
        webElementProperties.parallelStream().filter(webElementProperty -> webElementProperty.getName().equals(propertyName)).findAny().ifPresent(elementProperty -> {
            boolean bl = webElementProperties.remove(elementProperty);
        });
    }

    private void copyObjectCharacteristics(WebElementEntity src, WebElementEntity des) {
        des.setName(src.getName());
        des.setParentFolder(src.getParentFolder());
        des.setProject(src.getProject());
        des.setDescription(src.getDescription());
        des.getWebElementProperties().clear();
        des.getWebElementProperties().addAll(src.getWebElementProperties());
        des.getWebElementXpaths().clear();
        des.getWebElementXpaths().addAll(src.getWebElementXpaths());
        des.setImagePath(src.getImagePath());
        des.setUseRalativeImagePath(src.getUseRalativeImagePath());
        des.setSelectorMethod(src.getGenericSelectorMethod());
        des.setSelectorCollection(new HashMap(src.getSelectorCollection()));
        des.setSmartLocatorEnabled(src.isSmartLocatorEnabled());
        des.setSmartLocatorCollection(new HashMap(src.getSmartLocatorCollection()));
    }

    private WebElementEntity getCloneTestObject() {
        return this.cloneTestObject;
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    /*
     * Unable to fully structure code
     */
    public void handleEvent(Event event) {
        topic = event.getTopic();
        object = event.getProperty("org.eclipse.e4.data");
        var4_4 = topic;
        tmp = -1;
        switch (var4_4.hashCode()) {
            case -826004351: {
                if (var4_4.equals("OBJECT/UPDATE_IS_SELECTED_COLUMN_HEADER")) {
                    tmp = 1;
                }
                break;
            }
            case 754869981: {
                if (var4_4.equals("TESTOBJECT/UPDATED")) {
                    tmp = 2;
                }
                break;
            }
            case 1243634060: {
                if (var4_4.equals("OBJECT/UPDATE_DIRTY")) {
                    tmp = 3;
                }
                break;
            }
        }
        switch (tmp) {
            case 3: {
                if (object == null || !(object instanceof TableViewer)) ** GOTO lbl33
                if (!object.equals((Object)this.propertyTableViewer)) ** GOTO lbl30
                this.onWebElementPropertyChanged();
                this.dirtyable.setDirty(true);
                ** GOTO lbl33
lbl30:
                // 1 sources

                if (object.equals((Object)this.xpathTableViewer)) {
                    this.onWebElementXpathChanged();
                    this.dirtyable.setDirty(true);
                }
            }
lbl33:
            // 6 sources

            case 1: {
                if (object != null && object instanceof TableViewer && !this.trclmnColumnSelected.isDisposed() && object.equals((Object)this.propertyTableViewer)) {
                    isSelectedAll = this.propertyTableViewer.getIsSelectedAll();
                    isSelectedColumnImageHeader = isSelectedAll != false ? ImageConstants.IMG_16_CHECKBOX_CHECKED : ImageConstants.IMG_16_CHECKBOX_UNCHECKED;
                    this.trclmnColumnSelected.setImage(isSelectedColumnImageHeader);
                }
            }
            case 2: {
                if (object == null || !(object instanceof Object[]) || !(oldTestObjectRelativeId = (testObjectId = (String)(objects = (Object[])object)[0]).replace(String.valueOf(projectFolderId = ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator, GlobalMessageConstants.EMPTY).replace(WebElementEntity.getWebElementFileExtension(), GlobalMessageConstants.EMPTY).replace(File.separator, "/")).equals(this.getParentObjectId())) break;
                this.loadTestObject();
                this.dirtyable.setDirty(false);
            }
        }
    }

    private WebElementPropertyEntity openAddPropertyDialog() {
        Shell shell = Display.getCurrent().getActiveShell();
        AddTestObjectPropertyDialog dialog = new AddTestObjectPropertyDialog(shell);
        int code = dialog.open();
        if (code == 0) {
            String propName = dialog.getName();
            String propVal = dialog.getValue();
            String condition = dialog.getCondition();
            WebElementPropertyEntity prop = new WebElementPropertyEntity();
            prop.setName(propName);
            prop.setValue(propVal);
            prop.setMatchCondition(condition);
            prop.setIsSelected(Boolean.valueOf(false));
            return prop;
        }
        return null;
    }

    private WebElementXpathEntity openAddXpathDialog() {
        Shell shell = Display.getCurrent().getActiveShell();
        AddTestObjectXpathDialog dialog = new AddTestObjectXpathDialog(shell);
        int code = dialog.open();
        if (code == 0) {
            String propVal = dialog.getXpath();
            WebElementXpathEntity prop = new WebElementXpathEntity();
            prop.setValue(propVal);
            prop.setIsSelected(Boolean.valueOf(false));
            return prop;
        }
        return null;
    }

    private boolean addProperty(WebElementPropertyEntity prop) {
        if (prop == null) {
            return false;
        }
        this.propertyTableViewer.addRow(prop);
        this.refreshTestObjectProperties();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean addXpath(WebElementXpathEntity xpath) {
        if (xpath == null) {
            return false;
        }
        this.xpathTableViewer.addRow(xpath);
        this.refreshTestObjectXpaths();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean addPropertiesWithPosition(List<ObjectPropertyTableRow> props) {
        if (props == null || props.isEmpty()) {
            return false;
        }
        this.propertyTableViewer.addRowsWithPosition(props);
        this.refreshTestObjectProperties();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean addXpathsWithPosition(List<ObjectXpathTableRow> xpaths) {
        if (xpaths == null || xpaths.isEmpty()) {
            return false;
        }
        this.xpathTableViewer.addRowsWithPosition(xpaths);
        this.refreshTestObjectXpaths();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean addProperties(List<WebElementPropertyEntity> props) {
        if (props == null || props.isEmpty()) {
            return false;
        }
        this.propertyTableViewer.addRows(props);
        this.refreshTestObjectProperties();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean addXpaths(List<WebElementXpathEntity> xpaths) {
        if (xpaths == null || xpaths.isEmpty()) {
            return false;
        }
        this.xpathTableViewer.addRows(xpaths);
        this.refreshTestObjectXpaths();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean removeProperty(WebElementPropertyEntity prop) {
        if (prop == null) {
            return false;
        }
        this.propertyTableViewer.deleteRow(prop);
        this.refreshTestObjectProperties();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean removeXpath(WebElementXpathEntity xpath) {
        if (xpath == null) {
            return false;
        }
        this.xpathTableViewer.deleteRow(xpath);
        this.refreshTestObjectXpaths();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean removeProperties(List<WebElementPropertyEntity> props) {
        if (props == null || props.isEmpty()) {
            return false;
        }
        this.propertyTableViewer.deleteRows(props);
        this.refreshTestObjectProperties();
        this.dirtyable.setDirty(true);
        return true;
    }

    private boolean removeXpaths(List<WebElementXpathEntity> xpaths) {
        if (xpaths == null || xpaths.isEmpty()) {
            return false;
        }
        this.xpathTableViewer.deleteRows(xpaths);
        this.refreshTestObjectProperties();
        this.dirtyable.setDirty(true);
        return true;
    }

    public boolean isPropertyTableAbleToDelete() {
        return this.propertyTableViewer.getTable().getSelection().length > 0;
    }

    public boolean isPropertyTableAbleToClear() {
        return this.propertyTableViewer.getInput() != null && this.propertyTableViewer.getInput().size() > 0;
    }

    public boolean isXpathTableAbleToDelete() {
        return this.xpathTableViewer.getTable().getSelection().length > 0;
    }

    public boolean isXpathTableAbleToClear() {
        return this.xpathTableViewer.getInput() != null && this.xpathTableViewer.getInput().size() > 0;
    }

    private void openParentTestObject(String currentParentObjectId) {
        WebElementEntity currentParentWebElement = this.getTestObjectPk(currentParentObjectId);
        if (currentParentWebElement == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerObjectRepositoryMessageConstants.HAND_ERROR_MSG_TEST_OBJECT_NOT_EXIST);
            return;
        }
        this.eventBroker.send("TESTOBJECT/OPEN", (Object)currentParentWebElement);
    }

    private WebElementEntity getTestObjectPk(String currentParentObjectId) {
        try {
            if (StringUtils.isNotBlank((String)currentParentObjectId)) {
                return ObjectRepositoryController.getInstance().getWebElementByDisplayPk(currentParentObjectId);
            }
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
        return null;
    }

    private void refreshTestObjectProperties() {
        List webElementProperties = this.cloneTestObject.getWebElementProperties();
        webElementProperties.clear();
        webElementProperties.addAll(this.propertyTableViewer.getInput());
        if (OSUtil.isMacBigSurOrLater()) {
            this.propertyTableViewer.getTable().redraw();
        }
    }

    private void refreshTestObjectXpaths() {
        List webElementXpaths = this.cloneTestObject.getWebElementXpaths();
        webElementXpaths.clear();
        webElementXpaths.addAll(this.xpathTableViewer.getInput());
        if (OSUtil.isMacBigSurOrLater()) {
            this.xpathTableViewer.getTable().redraw();
        }
    }

    private void setParentObjectId(String parentObjectId) {
        this.parentObjectId = parentObjectId;
    }

    private void setLinkIdToFormText(String parentObjectId, FormText txtInput) {
        if (parentObjectId == null) {
            return;
        }
        txtInput.setText("<form><p><a>" + parentObjectId + "</a></p></form>", true, false);
    }

    private void clearFormText(FormText txtInput) {
        if (txtInput == null || txtInput.isDisposed()) {
            return;
        }
        txtInput.setText("", false, false);
    }

    private String getParentObjectId() {
        return this.parentObjectId;
    }

    private boolean isParentObjectShadowRoot() {
        return this.isParentObjectShadowRoot;
    }

    private void setParentObjectShadowRoot(boolean isParentObjectShadowRoot) {
        this.isParentObjectShadowRoot = isParentObjectShadowRoot;
    }

    private ParentObjectType getParentObjectType() {
        if (this.getParentObjectId() != null && this.isParentObjectShadowRoot()) {
            return ParentObjectType.PARENT_SHADOW_ROOT;
        }
        if (this.getParentObjectId() != null) {
            return ParentObjectType.PARENT_IFRAME;
        }
        return ParentObjectType.NO_PARENT;
    }

    private List<WebElementPropertyEntity> getPropertyListFromRows(List<ObjectPropertyTableRow> objectPropertyRows) {
        ArrayList<WebElementPropertyEntity> propertyEntities = new ArrayList<WebElementPropertyEntity>();
        for (ObjectPropertyTableRow row : objectPropertyRows) {
            propertyEntities.add(row.getWebElementPropertyEntity());
        }
        return propertyEntities;
    }

    private List<WebElementXpathEntity> getXpathListFromRows(List<ObjectXpathTableRow> objectXpathRows) {
        ArrayList<WebElementXpathEntity> xpathEntities = new ArrayList<WebElementXpathEntity>();
        for (ObjectXpathTableRow row : objectXpathRows) {
            xpathEntities.add(row.getWebElementXpathEntity());
        }
        return xpathEntities;
    }

    private TestObject buildTestObject(WebElementEntity webElement) {
        TestObject testObject = new TestObject();
        try {
            String parentFrameId = webElement.getPropertyValue("ref_element");
            if (!parentFrameId.isEmpty()) {
                WebElementEntity webElementEntity = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(parentFrameId);
                TestObject parent = this.buildTestObject(webElementEntity);
                testObject.setParentObject(parent);
            }
            webElement.getWebElementProperties().forEach(prop -> testObject.addProperty(prop.getName(), ConditionType.fromValue((String)prop.getMatchCondition()), prop.getValue(), prop.getIsSelected().booleanValue()));
            webElement.getWebElementXpaths().forEach(prop -> testObject.addXpath(prop.getName(), ConditionType.fromValue((String)prop.getMatchCondition()), prop.getValue(), prop.getIsSelected().booleanValue()));
            testObject.setSelectorMethod(SelectorMethod.valueOf((String)webElement.getGenericSelectorMethod().name()));
            testObject.setImagePath(webElement.getImagePath());
            if (webElement.getSelectorCollection() != null && !webElement.getSelectorCollection().isEmpty()) {
                for (Map.Entry entry : webElement.getSelectorCollection().entrySet()) {
                    if (entry == null) continue;
                    testObject.setSelectorValue(SelectorMethod.valueOf((String)((WebElementSelectorMethod)entry.getKey()).name()), (String)entry.getValue());
                }
            }
            if (webElement.getSmartLocatorCollection() != null && !webElement.getSmartLocatorCollection().isEmpty()) {
                HashMap<SelectorMethod, String> hashMap = new HashMap<SelectorMethod, String>();
                for (Map.Entry entry : webElement.getSmartLocatorCollection().entrySet()) {
                    if (entry == null) continue;
                    hashMap.put(SelectorMethod.valueOf((String)((WebElementSelectorMethod)entry.getKey()).name()), (String)entry.getValue());
                }
                testObject.setSmartSelectorCollection(hashMap);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return testObject;
    }

    private void showComposite(Composite composite, boolean isVisible) {
        composite.setVisible(isVisible);
        ((GridData)composite.getLayoutData()).exclude = !isVisible;
        composite.getParent().layout();
    }

    private class AddPropertyOperation
    extends AbstractOperation {
        WebElementPropertyEntity property;

        public AddPropertyOperation() {
            super(AddXpathOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.property = ObjectPropertyView.this.openAddPropertyDialog();
            if (ObjectPropertyView.this.addProperty(this.property)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.addProperty(this.property)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.removeProperty(this.property)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private class AddXpathOperation
    extends AbstractOperation {
        WebElementXpathEntity xpath;

        public AddXpathOperation() {
            super(AddXpathOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.xpath = ObjectPropertyView.this.openAddXpathDialog();
            if (ObjectPropertyView.this.addXpath(this.xpath)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.addXpath(this.xpath)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.removeXpath(this.xpath)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private class ChangeImagePathOperation
    extends AbstractOperation {
        String oldImagePath;
        String newImagePath;

        public ChangeImagePathOperation(String value) {
            super(ChangeImagePathOperation.class.getName());
            this.oldImagePath = ObjectPropertyView.this.txtImage.getText();
            this.newImagePath = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetImagePath(this.newImagePath);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetImagePath(this.newImagePath);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetImagePath(this.oldImagePath);
        }

        public IStatus doSetImagePath(String path) {
            if (path == null) {
                return Status.CANCEL_STATUS;
            }
            if (ObjectPropertyView.this.chkUseRelative.getSelection()) {
                String relPath = PathUtil.absoluteToRelativePath((String)path, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
                ObjectPropertyView.this.txtImage.setText(relPath);
            } else {
                ObjectPropertyView.this.txtImage.setText(path);
            }
            ObjectPropertyView.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class ChangeParentTestObjectOperation
    extends AbstractOperation {
        String oldParentId;
        String newParentId;

        public ChangeParentTestObjectOperation(String value) {
            super(ChangeParentTestObjectOperation.class.getName());
            this.oldParentId = ObjectPropertyView.this.getParentObjectId();
            this.newParentId = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectId(this.newParentId);
            ObjectPropertyView.this.refreshParentObjectComposites();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectId(this.newParentId);
            ObjectPropertyView.this.refreshParentObjectComposites();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectId(this.oldParentId);
            ObjectPropertyView.this.refreshParentObjectComposites();
            return Status.OK_STATUS;
        }
    }

    private class ChangeSelectorMethodOperation
    extends AbstractOperation {
        WebElementSelectorMethod oldMethod;
        WebElementSelectorMethod newMethod;

        public ChangeSelectorMethodOperation(WebElementSelectorMethod method) {
            super(ChangeSelectorMethodOperation.class.getName());
            this.oldMethod = ObjectPropertyView.this.getCloneTestObject() == null ? null : ObjectPropertyView.this.getCloneTestObject().getGenericSelectorMethod();
            this.newMethod = method;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.getCloneTestObject().setSelectorMethod(this.newMethod);
            ObjectPropertyView.this.refreshLocatorMethod();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.getCloneTestObject().setSelectorMethod(this.oldMethod);
            ObjectPropertyView.this.refreshLocatorMethod();
            return Status.OK_STATUS;
        }
    }

    private class CheckImageRelativePathOperation
    extends AbstractOperation {
        boolean value;

        public CheckImageRelativePathOperation() {
            super(CheckImageRelativePathOperation.class.getName());
            this.value = ObjectPropertyView.this.chkUseRelative.getSelection();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doCheckImageRelativePath(this.value);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doCheckImageRelativePath(this.value);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doCheckImageRelativePath(!this.value);
        }

        public IStatus doCheckImageRelativePath(boolean value) {
            try {
                if (ObjectPropertyView.this.txtImage.getText() != null && !ObjectPropertyView.this.txtImage.getText().trim().equals("")) {
                    ObjectPropertyView.this.cloneTestObject.setUseRalativeImagePath(value);
                    String projectFolder = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                    String thePath = ObjectPropertyView.this.txtImage.getText();
                    if (value) {
                        String relPath = PathUtil.absoluteToRelativePath((String)thePath, (String)projectFolder);
                        ObjectPropertyView.this.txtImage.setText(relPath);
                    } else {
                        ObjectPropertyView.this.txtImage.setText(PathUtil.relativeToAbsolutePath((String)thePath, (String)projectFolder));
                    }
                    File file = new File(value ? String.valueOf(projectFolder) + File.separator + ObjectPropertyView.this.txtImage.getText() : ObjectPropertyView.this.txtImage.getText());
                    if (!file.exists() || !file.isFile()) {
                        MessageDialog.openWarning(null, (String)GlobalMessageConstants.WARN, (String)ComposerObjectRepositoryMessageConstants.VIEW_WARN_FILE_NOT_FOUND);
                    }
                }
                ObjectPropertyView.this.chkUseRelative.setSelection(value);
                ObjectPropertyView.this.dirtyable.setDirty(true);
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                return Status.CANCEL_STATUS;
            }
        }
    }

    private class CheckNoParentObjectOperation
    extends AbstractOperation {
        private String parentObjectId;
        private boolean isParentShadowRoot;

        public CheckNoParentObjectOperation() {
            super(CheckNoParentObjectOperation.class.getName());
            this.parentObjectId = null;
            this.isParentShadowRoot = false;
            this.parentObjectId = ObjectPropertyView.this.getParentObjectId();
            this.isParentShadowRoot = ObjectPropertyView.this.isParentObjectShadowRoot();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectId(null);
            ObjectPropertyView.this.setParentObjectShadowRoot(false);
            ObjectPropertyView.this.refreshParentObjectComposites();
            ObjectPropertyView.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectId(null);
            ObjectPropertyView.this.setParentObjectShadowRoot(false);
            ObjectPropertyView.this.refreshParentObjectComposites();
            ObjectPropertyView.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectId(this.parentObjectId);
            ObjectPropertyView.this.setParentObjectShadowRoot(this.isParentShadowRoot);
            ObjectPropertyView.this.refreshParentObjectComposites();
            ObjectPropertyView.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class CheckUseParentObjectOperation
    extends AbstractOperation {
        private boolean isParentShadowRoot;
        private String parentObjectId;

        public CheckUseParentObjectOperation() {
            super(CheckUseParentObjectOperation.class.getName());
            this.isParentShadowRoot = false;
            this.parentObjectId = null;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ParentObjectType parentObjectType = ObjectPropertyView.this.getParentObjectType();
            if (parentObjectType == ParentObjectType.PARENT_IFRAME) {
                return Status.CANCEL_STATUS;
            }
            this.isParentShadowRoot = ObjectPropertyView.this.isParentObjectShadowRoot();
            this.parentObjectId = ObjectPropertyView.this.getParentObjectId();
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.parentObjectId == null) {
                ObjectPropertyView.this.setParentObjectId("");
            }
            ObjectPropertyView.this.setParentObjectShadowRoot(false);
            ObjectPropertyView.this.refreshParentObjectComposites();
            ObjectPropertyView.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectId(this.parentObjectId);
            ObjectPropertyView.this.setParentObjectShadowRoot(this.isParentShadowRoot);
            ObjectPropertyView.this.refreshParentObjectComposites();
            ObjectPropertyView.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class CheckUseParentShadowRootObjectOperation
    extends AbstractOperation {
        private boolean isParentShadowRoot;
        private String parentObjectId;

        public CheckUseParentShadowRootObjectOperation() {
            super(CheckUseParentShadowRootObjectOperation.class.getName());
            this.isParentShadowRoot = false;
            this.parentObjectId = null;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ParentObjectType parentObjectType = ObjectPropertyView.this.getParentObjectType();
            if (parentObjectType == ParentObjectType.PARENT_SHADOW_ROOT) {
                return Status.CANCEL_STATUS;
            }
            this.isParentShadowRoot = ObjectPropertyView.this.isParentObjectShadowRoot();
            this.parentObjectId = ObjectPropertyView.this.getParentObjectId();
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.parentObjectId == null) {
                ObjectPropertyView.this.setParentObjectId("");
            }
            ObjectPropertyView.this.setParentObjectShadowRoot(true);
            ObjectPropertyView.this.refreshParentObjectComposites();
            ObjectPropertyView.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.setParentObjectShadowRoot(this.isParentShadowRoot);
            ObjectPropertyView.this.setParentObjectId(this.parentObjectId);
            ObjectPropertyView.this.refreshParentObjectComposites();
            ObjectPropertyView.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class ClearPropertyOperation
    extends AbstractOperation {
        List<WebElementPropertyEntity> properties;

        public ClearPropertyOperation() {
            super(ClearXpathOperation.class.getName());
            this.properties = new ArrayList<WebElementPropertyEntity>();
            int i = 0;
            while (i < ObjectPropertyView.this.propertyTableViewer.getInput().size()) {
                this.properties.add((WebElementPropertyEntity)ObjectPropertyView.this.propertyTableViewer.getInput().get(i));
                ++i;
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.properties.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            ObjectPropertyView.this.propertyTableViewer.clear();
            if (OSUtil.isMacBigSurOrLater()) {
                ObjectPropertyView.this.propertyTableViewer.getTable().redraw();
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.propertyTableViewer.clear();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.addProperties(this.properties)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private class ClearXpathOperation
    extends AbstractOperation {
        List<WebElementXpathEntity> xpaths;

        public ClearXpathOperation() {
            super(ClearXpathOperation.class.getName());
            this.xpaths = new ArrayList<WebElementXpathEntity>();
            int i = 0;
            while (i < ObjectPropertyView.this.propertyTableViewer.getInput().size()) {
                this.xpaths.add((WebElementXpathEntity)ObjectPropertyView.this.xpathTableViewer.getInput().get(i));
                ++i;
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.xpaths.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            ObjectPropertyView.this.xpathTableViewer.clear();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ObjectPropertyView.this.propertyTableViewer.clear();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.addXpaths(this.xpaths)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private class ObjectViewPropertyToolListener
    extends SelectionAdapter
    implements HotkeyActiveListener {
        private ObjectViewPropertyToolListener() {
        }

        public void executeAction(String actionId) {
            if (actionId == null) {
                return;
            }
            switch (PropertyActionID.parse(actionId)) {
                case ADD: {
                    ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new AddPropertyOperation());
                    break;
                }
                case DELETE: {
                    ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new RemovePropertyOperation(((IStructuredSelection)ObjectPropertyView.this.propertyTableViewer.getSelection()).toList()));
                    break;
                }
                case CLEAR: {
                    ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ClearPropertyOperation());
                }
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (!(widget instanceof ToolItem)) {
                return;
            }
            this.executeAction(((ToolItem)widget).getText());
        }
    }

    private class ObjectViewXpathToolListener
    extends SelectionAdapter
    implements HotkeyActiveListener {
        private ObjectViewXpathToolListener() {
        }

        public void executeAction(String actionId) {
            if (actionId == null) {
                return;
            }
            switch (XpathActionID.parse(actionId)) {
                case ADD: {
                    ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new AddXpathOperation());
                    break;
                }
                case DELETE: {
                    ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new RemoveXpathOperation(((IStructuredSelection)ObjectPropertyView.this.xpathTableViewer.getSelection()).toList()));
                    break;
                }
                case CLEAR: {
                    ObjectPropertyView.this.testObjectPart.executeOperation((IUndoableOperation)new ClearXpathOperation());
                }
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (!(widget instanceof ToolItem)) {
                return;
            }
            this.executeAction(((ToolItem)widget).getText());
        }
    }

    private static enum ParentObjectType {
        NO_PARENT,
        PARENT_IFRAME,
        PARENT_SHADOW_ROOT;

    }

    public static enum PropertyActionID {
        ADD(GlobalMessageConstants.ADD),
        DELETE(GlobalMessageConstants.DELETE),
        CLEAR(GlobalMessageConstants.CLEAR);

        private final String id;

        private PropertyActionID(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static PropertyActionID parse(String id) {
            if (id == null) {
                return null;
            }
            PropertyActionID[] propertyActionIDArray = PropertyActionID.values();
            int n = propertyActionIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyActionID actionId = propertyActionIDArray[n2];
                if (actionId.getId().equals(id)) {
                    return actionId;
                }
                ++n2;
            }
            return null;
        }
    }

    private class RemovePropertyOperation
    extends AbstractOperation {
        private List<ObjectPropertyTableRow> objectPropertyRows;

        public RemovePropertyOperation(List<WebElementPropertyEntity> properties) {
            super(RemoveXpathOperation.class.getName());
            this.objectPropertyRows = new ArrayList<ObjectPropertyTableRow>();
            for (WebElementPropertyEntity entity : properties) {
                this.objectPropertyRows.add(new ObjectPropertyTableRow(entity, ObjectPropertyView.this.propertyTableViewer.getInput().indexOf(entity)));
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.removeProperties(ObjectPropertyView.this.getPropertyListFromRows(this.objectPropertyRows))) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.removeProperties(ObjectPropertyView.this.getPropertyListFromRows(this.objectPropertyRows))) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.addPropertiesWithPosition(this.objectPropertyRows)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private class RemoveXpathOperation
    extends AbstractOperation {
        private List<ObjectXpathTableRow> objectXpathTableRows;

        public RemoveXpathOperation(List<WebElementXpathEntity> properties) {
            super(RemoveXpathOperation.class.getName());
            this.objectXpathTableRows = new ArrayList<ObjectXpathTableRow>();
            for (WebElementXpathEntity entity : properties) {
                this.objectXpathTableRows.add(new ObjectXpathTableRow(entity, ObjectPropertyView.this.xpathTableViewer.getInput().indexOf(entity)));
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.removeXpaths(ObjectPropertyView.this.getXpathListFromRows(this.objectXpathTableRows))) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.removeXpaths(ObjectPropertyView.this.getXpathListFromRows(this.objectXpathTableRows))) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (ObjectPropertyView.this.addXpathsWithPosition(this.objectXpathTableRows)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    public static enum XpathActionID {
        ADD(GlobalMessageConstants.ADD),
        DELETE(GlobalMessageConstants.DELETE),
        CLEAR(GlobalMessageConstants.CLEAR);

        private final String id;

        private XpathActionID(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static XpathActionID parse(String id) {
            if (id == null) {
                return null;
            }
            XpathActionID[] xpathActionIDArray = XpathActionID.values();
            int n = xpathActionIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                XpathActionID actionId = xpathActionIDArray[n2];
                if (actionId.getId().equals(id)) {
                    return actionId;
                }
                ++n2;
            }
            return null;
        }
    }
}

