/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.editors.DocumentUtil;
import cucumber.eclipse.editor.editors.StepMatcher;
import cucumber.eclipse.editor.markers.IMarkerManager;
import cucumber.eclipse.editor.steps.IStepProvider;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class GherkinErrorMarker
implements Formatter {
    private final IMarkerManager markerManager;
    private final IFile file;
    private final IDocument document;
    private Set<cucumber.eclipse.steps.integration.Step> foundSteps = null;
    private boolean inScenarioOutline = false;
    private List<Step> scenarioOutlineSteps;

    public GherkinErrorMarker(IStepProvider stepProvider, IMarkerManager markerManager, IFile inputfile, IDocument doc) {
        this.markerManager = markerManager;
        this.file = inputfile;
        this.document = doc;
        this.foundSteps = stepProvider.getStepsInEncompassingProject();
    }

    public void removeExistingMarkers() {
        this.markerManager.removeAll("cucumber.eclipse.editor.editors.Editor.lexingerror", this.file);
        this.markerManager.removeAll("cucumber.eclipse.editor.editors.Editor.syntaxerror", this.file);
        this.markerManager.removeAll("cucumber.eclipse.editor.editors.Editor.unmatchedsteperror", this.file);
    }

    public void background(Background arg0) {
    }

    public void close() {
    }

    public void done() {
    }

    public void eof() {
    }

    public void examples(Examples examples) {
        ExamplesTableRow examplesHeader = (ExamplesTableRow)examples.getRows().get(0);
        int i = 1;
        while (i < examples.getRows().size()) {
            ExamplesTableRow currentExample = (ExamplesTableRow)examples.getRows().get(i);
            this.matchScenarioOutlineExample(examplesHeader, currentExample);
            ++i;
        }
    }

    public void feature(Feature arg0) {
    }

    public void scenario(Scenario arg0) {
        this.inScenarioOutline = false;
    }

    public void scenarioOutline(ScenarioOutline arg0) {
        this.inScenarioOutline = true;
        this.scenarioOutlineSteps = new ArrayList<Step>();
    }

    public void step(Step stepLine) {
        if (!this.inScenarioOutline) {
            this.validateStep(stepLine);
        } else {
            this.scenarioOutlineSteps.add(stepLine);
        }
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        StringBuffer buf = new StringBuffer("Syntax Error: Expected one of ");
        for (String ev : legalEvents) {
            buf.append(ev);
            buf.append(", ");
        }
        buf.replace(buf.length() - 3, buf.length(), " but got ");
        buf.append(event);
        try {
            this.markerManager.add("cucumber.eclipse.editor.editors.Editor.syntaxerror", this.file, 2, buf.toString(), line, this.document.getLineOffset(line - 1), this.document.getLineOffset(line - 1) + this.document.getLineLength(line - 1));
        }
        catch (BadLocationException badLocationException) {}
    }

    public void uri(String arg0) {
    }

    private Map<String, String> getExampleVariablesMap(ExamplesTableRow header, ExamplesTableRow values) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < header.getCells().size()) {
            result.put((String)header.getCells().get(i), (String)values.getCells().get(i));
            ++i;
        }
        return result;
    }

    private void matchScenarioOutlineExample(ExamplesTableRow header, ExamplesTableRow example) {
        Map<String, String> exampleVariablesMap = this.getExampleVariablesMap(header, example);
        for (Step scenarioOutlineStepLine : this.scenarioOutlineSteps) {
            this.validateStep(scenarioOutlineStepLine, exampleVariablesMap, example.getLine());
        }
    }

    private String getResolvedStepStringForExample(Step stepLine, Map<String, String> examplesLineMap) {
        String stepString = String.valueOf(stepLine.getKeyword()) + stepLine.getName();
        if (examplesLineMap != null) {
            for (Map.Entry<String, String> examplesLineEntry : examplesLineMap.entrySet()) {
                stepString = stepString.replace("<" + examplesLineEntry.getKey() + ">", examplesLineEntry.getValue());
            }
        }
        return stepString;
    }

    public void validateStep(Step stepLine) {
        this.validateStep(stepLine, null, -1);
    }

    public void validateStep(Step stepLine, Map<String, String> examplesLineMap, int currentLine) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean("cucumber.eclipse.editor.check_step_definitions")) {
            if ("".equals(stepLine.getName())) {
                try {
                    this.markMissingStepName(this.file, this.document, stepLine);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                return;
            }
            String stepString = this.getResolvedStepStringForExample(stepLine, examplesLineMap);
            cucumber.eclipse.steps.integration.Step step = new StepMatcher().matchSteps(DocumentUtil.getDocumentLanguage(this.document), this.foundSteps, stepString);
            step = new StepMatcher().matchSteps(DocumentUtil.getDocumentLanguage(this.document), this.foundSteps, stepString);
            if (step == null) {
                try {
                    this.markUnmatchedStep(this.file, this.document, stepLine, this.inScenarioOutline ? currentLine : -1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void markMissingStepName(IFile featureFile, IDocument doc, Step stepLine) throws BadLocationException {
        int line = stepLine.getLine() - 1;
        IRegion lineRegion = doc.getLineInformation(line);
        this.markerManager.add("cucumber.eclipse.editor.editors.Editor.syntaxerror", featureFile, 1, "No step name.", line, lineRegion.getOffset(), lineRegion.getOffset() + lineRegion.getLength());
    }

    private void markUnmatchedStep(IFile featureFile, IDocument doc, Step stepLine, int exampleLine) throws BadLocationException {
        FindReplaceDocumentAdapter find = new FindReplaceDocumentAdapter(doc);
        IRegion region = find.find(doc.getLineOffset(stepLine.getLine() - 1), stepLine.getName(), true, true, false, false);
        String warningMessage = String.format("Step '%s' does not have a matching glue code%s", stepLine.getName(), this.inScenarioOutline ? " for example on line " + exampleLine : "");
        this.markerManager.add("cucumber.eclipse.editor.editors.Editor.unmatchedsteperror", featureFile, 1, warningMessage, stepLine.getLine(), region.getOffset(), region.getOffset() + region.getLength());
    }

    public void endOfScenarioLifeCycle(Scenario arg0) {
    }

    public void startOfScenarioLifeCycle(Scenario arg0) {
    }
}

