/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.editors.DocumentUtil;
import cucumber.eclipse.editor.editors.Editor;
import cucumber.eclipse.editor.editors.PopupMenuFindStepFormatter;
import cucumber.eclipse.editor.editors.StepMatcher;
import cucumber.eclipse.editor.markers.MarkerManager;
import cucumber.eclipse.steps.integration.Step;
import cucumber.eclipse.steps.integration.StepsChangedEvent;
import cucumber.eclipse.steps.jdt.StepDefinitions;
import gherkin.formatter.Formatter;
import gherkin.lexer.LexingError;
import gherkin.parser.Parser;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PopupMenuFindStepHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (!(editorPart instanceof Editor)) {
            return null;
        }
        StepDefinitions defs = StepDefinitions.getInstance();
        if (defs != null) {
            defs.notifyListeners(new StepsChangedEvent());
        }
        Editor editor = (Editor)editorPart;
        Set<Step> steps = editor.getStepProvider().getStepsInEncompassingProject();
        IDocumentProvider docProvider = editor.getDocumentProvider();
        List<String> selectedLineResolvedSteps = this.resolveSelectedLineStep(editorPart);
        String language = DocumentUtil.getDocumentLanguage(docProvider.getDocument((Object)editorPart.getEditorInput()));
        for (String variant : selectedLineResolvedSteps) {
            Step matchedStep = new StepMatcher().matchSteps(language, steps, variant);
            try {
                if (matchedStep == null) continue;
                this.openEditor(matchedStep);
                break;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void openEditor(Step step) throws CoreException {
        IResource file = step.getSource();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("lineNumber", step.getLineNumber());
        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
        marker.setAttributes(map);
        IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
        marker.delete();
    }

    private List<String> resolveSelectedLineStep(IEditorPart editorPart) {
        ITextEditor editor = (ITextEditor)editorPart;
        TextSelection selection = (TextSelection)editor.getSelectionProvider().getSelection();
        int currentLineNumber = selection.getStartLine() + 1;
        IDocument document = editor.getDocumentProvider().getDocument((Object)editorPart.getEditorInput());
        IFileEditorInput fileEditorInput = (IFileEditorInput)editorPart.getEditorInput();
        IFile featureFile = fileEditorInput.getFile();
        MarkerManager markerManager = new MarkerManager();
        PopupMenuFindStepFormatter findStepFormatter = new PopupMenuFindStepFormatter(currentLineNumber);
        Parser p = new Parser((Formatter)findStepFormatter, false);
        try {
            p.parse(document.get(), "", Integer.valueOf(0));
        }
        catch (LexingError l) {
            markerManager.add("cucumber.eclipse.editor.editors.Editor.lexingerror", featureFile, 2, l.getLocalizedMessage(), 1, 0, 0);
        }
        return findStepFormatter.getResolvedStepNames();
    }
}

