/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.snippet;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.snippet.IStepGeneratorProvider;
import cucumber.eclipse.steps.integration.IStepGenerator;
import gherkin.formatter.model.Step;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SnippetApplicator {
    private final IStepGeneratorProvider generatorProvider;

    public SnippetApplicator(IStepGeneratorProvider generatorProvider) {
        this.generatorProvider = generatorProvider;
    }

    public void generateSnippet(Step step, IFile stepFile) {
        try {
            IStepGenerator generator = this.generatorProvider.getStepGenerator(stepFile);
            ITextEditor editor = SnippetApplicator.openEditor(stepFile);
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            TextEdit edit = generator.createStepSnippet(step, document);
            edit.apply(document);
            editor.selectAndReveal(edit.getRegion().getOffset(), edit.getRegion().getLength());
        }
        catch (PartInitException exception) {
            SnippetApplicator.logException(step, stepFile, (Exception)((Object)exception));
        }
        catch (BadLocationException exception) {
            SnippetApplicator.logException(step, stepFile, (Exception)((Object)exception));
        }
        catch (IOException exception) {
            SnippetApplicator.logException(step, stepFile, exception);
        }
        catch (CoreException exception) {
            SnippetApplicator.logException(step, stepFile, (Exception)((Object)exception));
        }
    }

    private static void logException(Step step, IFile stepFile, Exception exception) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", String.format("Couldn't generate snippet %s for %s", step.getName(), stepFile), (Throwable)exception));
    }

    private static ITextEditor openEditor(IFile stepFile) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(stepFile.getName());
        ITextEditor editor = (ITextEditor)page.openEditor((IEditorInput)new FileEditorInput(stepFile), desc.getId());
        return editor;
    }
}

