/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.steps;

import cucumber.eclipse.editor.steps.IStepProvider;
import cucumber.eclipse.editor.util.ExtensionRegistryUtil;
import cucumber.eclipse.steps.integration.IStepDefinitions;
import cucumber.eclipse.steps.integration.IStepListener;
import cucumber.eclipse.steps.integration.Step;
import cucumber.eclipse.steps.integration.StepsChangedEvent;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class ExtensionRegistryStepProvider
implements IStepProvider,
IStepListener {
    private AtomicReference<Set<Step>> steps = new AtomicReference(Collections.emptySet());
    private List<IStepDefinitions> stepDefinitions = ExtensionRegistryUtil.getIntegrationExtensionsOfType(IStepDefinitions.class);
    private List<IStepListener> listeners = new CopyOnWriteArrayList<IStepListener>();
    private IFile file;

    public ExtensionRegistryStepProvider(IFile file) {
        this.file = file;
        this.addStepListener(this);
    }

    @Override
    public void addStepListener(IStepListener listener) {
        this.listeners.add(listener);
        for (IStepDefinitions stepDef : this.stepDefinitions) {
            stepDef.addStepListener(listener);
        }
    }

    @Override
    public Set<Step> getStepsInEncompassingProject() {
        return this.steps.get();
    }

    public void reload() {
        Job job = new Job("Scanning for step definitions"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        Set<Step> set = ExtensionRegistryStepProvider.this.getSteps(monitor);
                        ExtensionRegistryStepProvider.this.steps.set(set);
                        for (IStepListener listener : ExtensionRegistryStepProvider.this.listeners) {
                            if (listener == ExtensionRegistryStepProvider.this) continue;
                            listener.onStepsChanged(new StepsChangedEvent());
                        }
                    }
                    catch (CoreException e) {
                        return new Status(4, "cucumber.eclipse.editor", "reloading step definitions failed (" + (Object)((Object)e) + ")", (Throwable)e);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public Set<Step> getSteps(IProgressMonitor progressMonitor) throws CoreException {
        LinkedHashSet<Step> newSteps = new LinkedHashSet<Step>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Reloading steps", (int)this.stepDefinitions.size());
        try {
            for (IStepDefinitions stepDef : this.stepDefinitions) {
                newSteps.addAll(stepDef.getSteps(this.file, (IProgressMonitor)subMonitor.newChild(1)));
                if (!subMonitor.isCanceled()) continue;
                Set<Step> set = Collections.emptySet();
                return set;
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
        return newSteps;
    }

    @Override
    public void removeStepListener(IStepListener listener) {
        this.listeners.remove(listener);
        for (IStepDefinitions stepDef : this.stepDefinitions) {
            stepDef.removeStepListener(listener);
        }
    }

    public void onStepsChanged(StepsChangedEvent event) {
        this.reload();
    }
}

