/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.steps.jdt;

import cucumber.eclipse.editor.preferences.CucumberUserSettingsPage;
import cucumber.eclipse.steps.integration.IStepDefinitions;
import cucumber.eclipse.steps.integration.IStepListener;
import cucumber.eclipse.steps.integration.Step;
import cucumber.eclipse.steps.integration.StepsChangedEvent;
import cucumber.eclipse.steps.jdt.StepDefinitions;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JDTStepDefinitions
extends StepDefinitions
implements IStepDefinitions {
    private CucumberUserSettingsPage userSettingsPage = new CucumberUserSettingsPage();

    public Set<Step> getSteps(IFile featurefile, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        LinkedHashSet<Step> steps = new LinkedHashSet<Step>();
        try {
            LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
            IProject project = featurefile.getProject();
            projects.add(project);
            projects.addAll(Arrays.asList(project.getReferencedProjects()));
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)projects.size());
            for (IProject projectToScan : projects) {
                this.scanProject(projectToScan, featurefile, steps, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
        return steps;
    }

    private void scanProject(IProject project, IFile featurefile, Set<Step> steps, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        try {
            String externalPackageName = this.userSettingsPage.getPackageName();
            String[] extPackages = externalPackageName.trim().split(this.COMMA);
            boolean onlyPackages = this.userSettingsPage.getOnlyPackages();
            String onlySpeficicPackagesValue = this.userSettingsPage.getOnlySpecificPackage().trim();
            boolean onlySpeficicPackages = onlySpeficicPackagesValue.length() != 0;
            String featurefilePackage = featurefile.getParent().getFullPath().toString();
            if (project.isNatureEnabled(this.JAVA_PROJECT)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPackageFragment[] packages = javaProject.getPackageFragments();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)packages.length);
                IPackageFragment[] iPackageFragmentArray = packages;
                int n = packages.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment javaPackage = iPackageFragmentArray[n2];
                    if (javaPackage.getKind() == this.JAVA_SOURCE) {
                        subMonitor.subTask("Scanning " + javaPackage.getPath().toString());
                        if (!(onlyPackages && !featurefilePackage.startsWith(javaPackage.getPath().toString()) || onlySpeficicPackages && !javaPackage.getElementName().startsWith(onlySpeficicPackagesValue))) {
                            this.collectCukeStepsFromSource(javaProject, javaPackage, steps, progressMonitor);
                        }
                    }
                    if (javaPackage.getKind() == this.JAVA_JAR_BINARY && !externalPackageName.equals("")) {
                        subMonitor.subTask("Scanning package " + javaPackage.getElementName());
                        String[] stringArray = extPackages;
                        int n3 = extPackages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String extPackageName = stringArray[n4];
                            if (javaPackage.getElementName().equals(extPackageName.trim()) || javaPackage.getElementName().startsWith(extPackageName.trim())) {
                                this.collectCukeStepsFromJar(javaPackage, steps);
                            }
                            ++n4;
                        }
                    }
                    subMonitor.worked(1);
                    ++n2;
                }
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public void collectCukeStepsFromSource(IJavaProject javaProject, IPackageFragment javaPackage, Set<Step> steps, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        ICompilationUnit[] iCompilationUnitArray = javaPackage.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit iCompUnit = iCompilationUnitArray[n2];
            steps.addAll(this.getCukeSteps(javaProject, iCompUnit, progressMonitor));
            ++n2;
        }
    }

    public void collectCukeStepsFromJar(IPackageFragment javaPackage, Set<Step> steps) throws JavaModelException, CoreException {
        IClassFile[] classFiles;
        IClassFile[] iClassFileArray = classFiles = javaPackage.getClassFiles();
        int n = classFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IClassFile classFile = iClassFileArray[n2];
            steps.addAll(this.getCukeSteps(javaPackage, classFile));
            ++n2;
        }
    }

    public void addStepListener(IStepListener listener) {
        StepDefinitions.listeners.add(listener);
    }

    public void removeStepListener(IStepListener listener) {
        StepDefinitions.listeners.remove(listener);
    }

    public void notifyListeners(StepsChangedEvent event) {
        for (IStepListener listener : listeners) {
            listener.onStepsChanged(event);
        }
    }
}

