/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import cucumber.api.Argument;
import cucumber.api.HookTestStep;
import cucumber.api.HookType;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.formatter.TestSourcesModel;
import gherkin.ast.Background;
import gherkin.ast.DocString;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.Step;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.deps.net.iharder.Base64;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;

public class CucumberReporter
implements Formatter {
    private String currentFeatureFile;
    private Map<String, Object> currentFeatureMap;
    private List<Map<String, Object>> featureMaps = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> currentElementsList;
    private Map<String, Object> currentElementMap;
    private Map<String, Object> currentTestCaseMap;
    private List<Map<String, Object>> currentStepsList;
    private Map<String, Object> currentStepOrHookMap;
    private Map<String, Object> currentBeforeStepHookList = new HashMap<String, Object>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final NiceAppendable out;
    private final TestSourcesModel testSources = new TestSourcesModel();
    private static final KeywordLogger logger = KeywordLogger.getInstance(CucumberReporter.class);
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            CucumberReporter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            CucumberReporter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            CucumberReporter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            CucumberReporter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            CucumberReporter.this.finishReport();
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        public void receive(WriteEvent event) {
            CucumberReporter.this.handleWrite(event);
        }
    };
    private EventHandler<EmbedEvent> embedEventhandler = new EventHandler<EmbedEvent>(){

        public void receive(EmbedEvent event) {
            CucumberReporter.this.handleEmbed(event);
        }
    };

    public CucumberReporter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, (EventHandler)new EventHandler<TestCaseFinished>(){

            public void receive(TestCaseFinished event) {
                TestCase testCase = event.testCase;
                String name = CucumberReporter.this.getTestCaseName(testCase);
                Result result = event.result;
                CucumberReporter.this.logResult(name, result);
                logger.endTest(name, new HashMap());
            }
        });
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.testCase.getUri())) {
            this.currentFeatureFile = event.testCase.getUri();
            this.currentFeatureMap = this.createFeatureMap(event.testCase);
            this.featureMaps.add(this.currentFeatureMap);
            this.currentElementsList = (List)this.currentFeatureMap.get("elements");
        }
        this.currentTestCaseMap = this.createTestCase(event.testCase);
        String uuid = UUID.randomUUID().toString();
        String bddTestrunUUIDPropName = "BDD_TESTRUN_UUID";
        this.currentTestCaseMap.put(bddTestrunUUIDPropName, uuid);
        String name = this.getTestCaseName(event.testCase);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(bddTestrunUUIDPropName, uuid);
        if (this.currentFeatureMap != null && this.currentFeatureMap.get("name") != null) {
            attributes.put("BDD_FEATURE_NAME", this.currentFeatureMap.get("name").toString());
        }
        if (this.currentTestCaseMap.get("line") != null) {
            attributes.put("BDD_TESTCASE_LINE", this.currentTestCaseMap.get("line").toString());
        }
        if (this.currentTestCaseMap.get("name") != null) {
            attributes.put("BDD_TESTCASE_NAME", this.currentTestCaseMap.get("name").toString());
        }
        if (this.currentTestCaseMap.get("name") != null) {
            attributes.put("BDD_TESTCASE_DESCRIPTION", this.currentTestCaseMap.get("description").toString());
        }
        if (this.currentTestCaseMap.get("name") != null) {
            attributes.put("BDD_TESTCASE_TYPE", this.currentTestCaseMap.get("type").toString());
        }
        logger.startTest(name, attributes, new Stack());
        if (this.testSources.hasBackground(this.currentFeatureFile, event.testCase.getLine())) {
            this.currentElementMap = this.createBackground(event.testCase);
            if (this.currentElementMap != null) {
                this.currentElementMap.put(bddTestrunUUIDPropName, uuid);
            }
            this.currentElementsList.add(this.currentElementMap);
        } else {
            this.currentElementMap = this.currentTestCaseMap;
        }
        this.currentElementsList.add(this.currentTestCaseMap);
        this.currentStepsList = (List)this.currentElementMap.get("steps");
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
            if (this.isFirstStepAfterBackground(testStep)) {
                this.currentElementMap = this.currentTestCaseMap;
                this.currentStepsList = (List)this.currentElementMap.get("steps");
            }
            this.currentStepOrHookMap = this.createTestStep(testStep);
            if (this.currentBeforeStepHookList.containsKey(HookType.Before.toString())) {
                this.currentStepOrHookMap.put(HookType.Before.toString(), this.currentBeforeStepHookList.get(HookType.Before.toString()));
                this.currentBeforeStepHookList.clear();
            }
            String uuid = UUID.randomUUID().toString();
            String bddStepUUIDPropName = "BDD_STEP_UUID";
            this.currentStepOrHookMap.put(bddStepUUIDPropName, uuid);
            String stepText = testStep.getStepText();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(bddStepUUIDPropName, uuid);
            if (this.currentStepOrHookMap.get("line") != null) {
                attributes.put("BDD_STEP_LINE", this.currentStepOrHookMap.get("line").toString());
            }
            if (this.currentStepOrHookMap.get("line") != null) {
                attributes.put("BDD_STEP_NAME", this.currentStepOrHookMap.get("name").toString());
            }
            if (this.currentStepOrHookMap.get("line") != null) {
                attributes.put("BDD_STEP_KEYWORD", this.currentStepOrHookMap.get("keyword").toString());
            }
            logger.startKeyword(stepText, attributes, null);
            this.currentStepsList.add(this.currentStepOrHookMap);
        } else if (event.testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)event.testStep;
            this.currentStepOrHookMap = this.createHookStep(hookTestStep);
            this.addHookStepToTestCaseMap(this.currentStepOrHookMap, hookTestStep.getHookType());
        } else {
            throw new IllegalStateException();
        }
    }

    private void handleWrite(WriteEvent event) {
        this.addOutputToHookMap(event.text);
    }

    private void handleEmbed(EmbedEvent event) {
        this.addEmbeddingToHookMap(event.data, event.mimeType);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        this.currentStepOrHookMap.put("match", this.createMatchMap(event.testStep, event.result));
        this.currentStepOrHookMap.put("result", this.createResultMap(event.result));
        if (event.testStep instanceof PickleStepTestStep) {
            String stepText = ((PickleStepTestStep)event.testStep).getStepText();
            Result result = event.result;
            this.logResult(stepText, result);
            Map r = (Map)this.currentStepOrHookMap.get("result");
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (r.get("status") != null) {
                attributes.put("BDD_STEP_STATUS", r.get("status").toString());
            }
            if (r.get("error_message") != null) {
                attributes.put("BDD_STEP_ERROR_MESSAGE", r.get("error_message").toString());
            }
            if (r.get("duration") != null) {
                attributes.put("BDD_STEP_DURATION", r.get("duration").toString());
            }
            logger.endKeyword(stepText, attributes, null);
        }
    }

    private void finishReport() {
        this.out.append((CharSequence)this.gson.toJson(this.featureMaps));
        this.out.close();
    }

    private Map<String, Object> createFeatureMap(TestCase testCase) {
        HashMap<String, Object> featureMap = new HashMap<String, Object>();
        featureMap.put("uri", testCase.getUri());
        featureMap.put("elements", new ArrayList());
        Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            featureMap.put("keyword", feature.getKeyword());
            featureMap.put("name", feature.getName());
            featureMap.put("description", feature.getDescription() != null ? feature.getDescription() : "");
            featureMap.put("line", feature.getLocation().getLine());
            featureMap.put("id", TestSourcesModel.convertToId((String)feature.getName()));
            featureMap.put("tags", feature.getTags());
        }
        return featureMap;
    }

    private Map<String, Object> createTestCase(TestCase testCase) {
        HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
        testCaseMap.put("name", testCase.getName());
        testCaseMap.put("line", testCase.getLine());
        testCaseMap.put("type", "scenario");
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            testCaseMap.put("id", TestSourcesModel.calculateId((TestSourcesModel.AstNode)astNode));
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
            testCaseMap.put("keyword", scenarioDefinition.getKeyword());
            testCaseMap.put("description", scenarioDefinition.getDescription() != null ? scenarioDefinition.getDescription() : "");
        }
        testCaseMap.put("steps", new ArrayList());
        if (!testCase.getTags().isEmpty()) {
            ArrayList tagList = new ArrayList();
            for (PickleTag tag : testCase.getTags()) {
                HashMap<String, String> tagMap = new HashMap<String, String>();
                tagMap.put("name", tag.getName());
                tagList.add(tagMap);
            }
            testCaseMap.put("tags", tagList);
        }
        return testCaseMap;
    }

    private Map<String, Object> createBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Background background = TestSourcesModel.getBackgroundForTestCase((TestSourcesModel.AstNode)astNode);
            HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
            testCaseMap.put("name", background.getName());
            testCaseMap.put("line", background.getLocation().getLine());
            testCaseMap.put("type", "background");
            testCaseMap.put("keyword", background.getKeyword());
            testCaseMap.put("description", background.getDescription() != null ? background.getDescription() : "");
            testCaseMap.put("steps", new ArrayList());
            return testCaseMap;
        }
        return null;
    }

    private boolean isFirstStepAfterBackground(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        return astNode != null && this.currentElementMap != this.currentTestCaseMap && !TestSourcesModel.isBackgroundStep((TestSourcesModel.AstNode)astNode);
    }

    private Map<String, Object> createTestStep(PickleStepTestStep testStep) {
        HashMap<String, Object> stepMap = new HashMap<String, Object>();
        stepMap.put("name", testStep.getStepText());
        stepMap.put("line", testStep.getStepLine());
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (!testStep.getStepArgument().isEmpty()) {
            gherkin.pickles.Argument argument = (gherkin.pickles.Argument)testStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                stepMap.put("doc_string", this.createDocStringMap(argument, astNode));
            } else if (argument instanceof PickleTable) {
                stepMap.put("rows", this.createDataTableList(argument));
            }
        }
        String keyword = "";
        if (astNode != null) {
            Step step = (Step)astNode.node;
            keyword = step.getKeyword();
            stepMap.put("keyword", keyword);
        }
        return stepMap;
    }

    private Map<String, Object> createDocStringMap(gherkin.pickles.Argument argument, TestSourcesModel.AstNode astNode) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        PickleString docString = (PickleString)argument;
        docStringMap.put("value", docString.getContent());
        docStringMap.put("line", docString.getLocation().getLine());
        if (astNode != null) {
            docStringMap.put("content_type", ((DocString)((Step)astNode.node).getArgument()).getContentType());
        }
        return docStringMap;
    }

    private List<Map<String, Object>> createDataTableList(gherkin.pickles.Argument argument) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (PickleRow row : ((PickleTable)argument).getRows()) {
            HashMap<String, List<String>> rowMap = new HashMap<String, List<String>>();
            rowMap.put("cells", this.createCellList(row));
            rowList.add(rowMap);
        }
        return rowList;
    }

    private List<String> createCellList(PickleRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private Map<String, Object> createHookStep(HookTestStep hookTestStep) {
        return new HashMap<String, Object>();
    }

    private void addHookStepToTestCaseMap(Map<String, Object> currentStepOrHookMap, HookType hookType) {
        String hookName = hookType.toString().contains("after") ? "after" : "before";
        Map<String, Object> mapToAddTo = switch (hookType) {
            case HookType.Before -> this.currentTestCaseMap;
            case HookType.After -> this.currentTestCaseMap;
            case HookType.BeforeStep -> this.currentBeforeStepHookList;
            case HookType.AfterStep -> this.currentStepsList.get(this.currentStepsList.size() - 1);
            default -> this.currentTestCaseMap;
        };
        if (!mapToAddTo.containsKey(hookName)) {
            mapToAddTo.put(hookName, new ArrayList());
        }
        ((List)mapToAddTo.get(hookName)).add(currentStepOrHookMap);
    }

    private void addOutputToHookMap(String text) {
        if (!this.currentStepOrHookMap.containsKey("output")) {
            this.currentStepOrHookMap.put("output", new ArrayList());
        }
        ((List)this.currentStepOrHookMap.get("output")).add(text);
    }

    private void addEmbeddingToHookMap(byte[] data, String mimeType) {
        if (!this.currentStepOrHookMap.containsKey("embeddings")) {
            this.currentStepOrHookMap.put("embeddings", new ArrayList());
        }
        Map<String, Object> embedMap = this.createEmbeddingMap(data, mimeType);
        ((List)this.currentStepOrHookMap.get("embeddings")).add(embedMap);
    }

    private Map<String, Object> createEmbeddingMap(byte[] data, String mimeType) {
        HashMap<String, Object> embedMap = new HashMap<String, Object>();
        embedMap.put("mime_type", mimeType);
        embedMap.put("data", Base64.encodeBytes((byte[])data));
        return embedMap;
    }

    private Map<String, Object> createMatchMap(TestStep step, Result result) {
        PickleStepTestStep testStep;
        HashMap<String, Object> matchMap = new HashMap<String, Object>();
        if (step instanceof PickleStepTestStep && !(testStep = (PickleStepTestStep)step).getDefinitionArgument().isEmpty()) {
            ArrayList argumentList = new ArrayList();
            for (Argument argument : testStep.getDefinitionArgument()) {
                HashMap<String, Object> argumentMap = new HashMap<String, Object>();
                if (argument.getValue() != null) {
                    argumentMap.put("val", argument.getValue());
                    argumentMap.put("offset", argument.getStart());
                }
                argumentList.add(argumentMap);
            }
            matchMap.put("arguments", argumentList);
        }
        if (!result.is(Result.Type.UNDEFINED)) {
            matchMap.put("location", step.getCodeLocation());
        }
        return matchMap;
    }

    private Map<String, Object> createResultMap(Result result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("status", result.getStatus().lowerCaseName());
        if (result.getErrorMessage() != null) {
            resultMap.put("error_message", result.getErrorMessage());
        }
        if (result.getDuration() != null && result.getDuration() != 0L) {
            resultMap.put("duration", result.getDuration());
        }
        return resultMap;
    }

    private void logResult(String name, Result result) {
        Result.Type status = result.getStatus();
        if (Result.Type.PASSED.equals((Object)status)) {
            logger.logPassed(name);
        } else {
            Throwable t = result.getError();
            if (t == null) {
                LogLevel level = Result.Type.FAILED.equals((Object)status) ? LogLevel.FAILED : LogLevel.NOT_RUN;
                logger.logMessage(level, name);
            } else {
                String stackTraceForThrowable = ExceptionsUtil.getStackTraceForThrowable((Throwable)t);
                String message = MessageFormat.format(StringConstants.MAIN_LOG_MSG_FAILED_BECAUSE_OF, name, stackTraceForThrowable);
                this.logError(t, message);
            }
        }
    }

    private void logError(Throwable t, String message) {
        logger.logMessage(ErrorCollector.fromError((Throwable)t), message, t);
    }

    private String getTestCaseName(TestCase testCase) {
        String name = "SCENARIO " + testCase.getName();
        return name;
    }
}

