/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.DatabaseConnectionAbstractDialog;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.entity.checkpoint.DatabaseCheckpointSourceInfo;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Shell;

public class EditCheckpointDatabaseDialog
extends DatabaseConnectionAbstractDialog {
    private DatabaseCheckpointSourceInfo sourceInfo;

    public EditCheckpointDatabaseDialog(Shell parentShell, DatabaseCheckpointSourceInfo sourceInfo) {
        super(parentShell);
        this.sourceInfo = sourceInfo;
    }

    public DatabaseCheckpointSourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    protected void setInput() {
        this.chkGlobalDBSetting.setSelection(this.sourceInfo.isUsingGlobalDBSetting().booleanValue());
        this.chkSecureUserPassword.setSelection(this.sourceInfo.isSecureUserAccount().booleanValue());
        this.enableCustomDBConnection(this.sourceInfo.isUsingGlobalDBSetting() == false);
        this.txtUser.setText(StringUtils.defaultString((String)this.sourceInfo.getUser()));
        String plainPassword = Base64.decode((String)this.sourceInfo.getPassword());
        if (plainPassword != null) {
            this.txtPassword.setText(plainPassword);
        }
        this.txtConnectionURL.setText(this.sourceInfo.getSourceUrl());
        this.txtQuery.setText(this.sourceInfo.getQuery());
        this.txtDriverClassName.setText(StringUtils.defaultString((String)this.sourceInfo.getDriverClassName()));
        this.initialInputConnectionProperies(this.sourceInfo.getConnectionProperties());
    }

    protected void updateChanges() {
        if (!this.isChanged()) {
            return;
        }
        this.sourceInfo.setUsingGlobalDBSetting(Boolean.valueOf(this.chkGlobalDBSetting.getSelection()));
        this.sourceInfo.setSecureUserAccount(Boolean.valueOf(this.chkSecureUserPassword.getSelection()));
        this.sourceInfo.setUser(StringUtils.trimToEmpty((String)this.txtUser.getText()));
        this.sourceInfo.setPassword(Base64.encode((String)this.txtPassword.getText()));
        this.sourceInfo.setSourceUrl(StringUtils.trimToEmpty((String)this.txtConnectionURL.getText()));
        this.sourceInfo.setQuery(StringUtils.trimToEmpty((String)this.txtQuery.getText()));
        this.sourceInfo.setDriverClassName(StringUtils.trimToEmpty((String)this.txtDriverClassName.getText()));
        this.updateConnectionProperties();
    }

    protected void updateConnectionProperties() {
        this.DBConnectionProperties.setConnectionProperty(this.connectionPropertyTable.getListConnectionPropeties());
        this.sourceInfo.setConnectionProperties(this.DBConnectionProperties);
    }
}

